//================================================================
//                Copyright (c) 2001 Systronix
//                     All Rights Reserved
//================================================================

// This program runs on a host that is on the same network as the SaJe.

// It receives TCP packets from the SaJe and echoes them back.
// The "ThreadedEchoServer" class  spawns a distinct "echo thread"
// (ThreadedEchoHandler) for each Socket connection

// This program has been largely adapted from the Sun java tutorials and
// The Java Class Libraries, volume 1.

import java.net.ServerSocket;
import java.net.Socket;

public class ThreadedEchoServer  {

  private static int portNumber = 8188;

  //Main method

  public static void main(String[] args) {

    System.out.println("aJile Systems Threaded TCP Echo Server Example");

    try {

      // create a new server socket on host
      ServerSocket s = new ServerSocket(8188);

      System.out.println("Opened new ServerSocket on port " + portNumber);

      // Start a new thread (echoHandler) for each new socket connection
      for (int i = 1;;) {

        try {
          Socket incoming = s.accept();
          int socketPort  = incoming.getPort();

          System.out.println("Created new socket on port " + socketPort);

          new ThreadedEchoHandler(incoming, i).start();

          System.out.println("Starting thread number " + i + " to handle messages" );

          i++;
        } catch (Exception e) {
          System.out.println("Caught exception " + e + "while creating socket or starting thread");
        }
      }
    }
    catch (Exception e) {
      System.out.println("Caught exception " + e + " when trying to create new ServerSocket");
    }
  }

  private Socket incoming;
  private int counter;

}
