//================================================================
//                Copyright (c) 2001 Systronix
//                     All Rights Reserved
//================================================================

// This program runs on a host that is on the same network as the aJ-104
// and communicates with the SaJe.

// It receives TCP packets from the SaJe and echoes them back.
// A distinct "echo thread" is created for each Socket connection
// The "ThreadedEchoHandler" class represents the thread that is created.

// This program has been largely adapted from the Sun java tutorials and
// The Java Class Libraries, volume 1.

import java.io.*;
import java.net.*;

public class ThreadedEchoHandler extends Thread {

  private Socket incoming;
  private int counter;

  private static final int reportingInterval = 1;
  private static final byte SENTINEL_VALUE = -1;

  public ThreadedEchoHandler(Socket i, int c) {
    incoming = i;
    counter = c;
  }

  public void run() {

    int messageCount = 0;

    try {
      // set up the input and output streams
      InputStream in = incoming.getInputStream();
      OutputStream out = incoming.getOutputStream();

      incoming.setTcpNoDelay(true);

      boolean done = false;
      byte[] inbuf = new byte[1024];

      int numBytes;
      boolean sentinelFound = false;

      while ((numBytes = in.read(inbuf)) != -1) {

        // Don't print a message every time

        if (messageCount % reportingInterval == 0) {
            System.out.println("Received message number " + messageCount);
        }

        // Look for a sentinel value while inspecting the buffer; if
        // it's found, then note the sentinel

        for (int i=0; i<numBytes; i++) {

          //System.out.println("Read byte number " + i + " with value " + inbuf[i]);

          if (inbuf[i] == SENTINEL_VALUE) {
            sentinelFound = true;
          }
        }

        if (messageCount % reportingInterval == 0) {
            System.out.println("Sending message number " + messageCount);
        }

        out.write(inbuf, 0, numBytes);

        messageCount++;

        if (sentinelFound) {
            System.out.println("Detected sentinel byte");
            break;
        }

      }   // forever

      System.out.println("Closing connection to socket number " + counter + " after " + messageCount + " messages");
      //incoming.shutdownOutput();  // J2SE 1.3
      //incoming.shutdownInput();   // J2SE 1.3
      incoming.close();

      System.out.println("Closing streams");

      out.flush();
      out.close();
      in.close();


    }
    catch (Exception e) {
      System.out.println("Caught exception "+ e + " when processing socket number " + counter);
    }
  }
}

