//================================================================
//                Copyright (c) 2001 Systronix
//                     All Rights Reserved
//================================================================

import java.io.IOException;
import java.util.Vector;

import EthernetWraparoundTest;

 /**
  * Main driver class for the installation test
  */
public class App {

  private String hostIP;
  private String hostPort;

  /** Main entry point for the installation test.
    *
    */
  public static void main(String[] args) {

    long startTime = System.currentTimeMillis();

    App app = new App();

    app.run();

    long totalTime = System.currentTimeMillis() - startTime;

    System.out.print("Installation test completed; elapsed time: ");
    System.out.print(totalTime);
    System.out.println(" ms");
  }

  /** Constructor. It will create instances of each test and set them up in
    * a vector to be run.
    */
  public App() {

    // Get the host IP address of the server from the system properties

    hostIP = System.getProperty("reflector.ip.address");

    if (hostIP == null || hostIP.equals("")) {
      System.out.println("Failed to get host IP address from properties");
    }

    // Get the host port number of the datagram echo server from the system properties

    hostPort = System.getProperty("reflector.port.number");

    int hostPortNum = 0;

    if (hostPort == null || hostPort.equals("")) {
      System.out.println("Failed to get host socket port number from properties");

      try {
        hostPortNum = Integer.parseInt(hostPort);
      } catch (Exception ex) {
        System.out.println("Host socket port number is not a valid number");
      }
    }

  }

  /**
   * Cycles through each of the registered tests.
  */
  public void run () {

    boolean success = true;         // overall test status

    System.out.println("------------------------------------------------------");
    System.out.println(" Systronix aJile Java euroboard (SaJe) Installation Test");
    System.out.println("------------------------------------------------------");

    // Ethernet test, wrapping around data sent to echo server running
    // on a host.  Boolean argument to constructor controls verbosity.

    EthernetWraparoundTest etherTest = new EthernetWraparoundTest(false);

    boolean etherPassed = false;

    try {
      etherPassed = etherTest.run(hostIP, hostPort, 20);
    } catch (IOException ioe) {
      System.out.println("Caught exception during Ethernet test");
    }

    if (etherPassed) {
      System.out.println("  Ethernet wraparound test passed");
    } else {
      System.out.println("  Ethernet wraparound test failed");
    }

    success &= etherPassed;

    System.out.println("------------------------------------------------------");

  } // run method

} // SerialWraparoundTest class
