/**
 * Title:        Read temp from a DS1920 or 1820<p>
 * Description:  Program to show a simple read of temperature from a
 * OneWire family 10 device. This includes the DS1920 iButton and DS1820 chip.
 * Written for TINI's external 1Wire net on serial1 using a DS2480, but could be
 * modified for other adapters. I'll try using the 9097 com port adapter for the
 * PC when I get a chance.<p>
 * Copyright:    Copyright (c) B Boyes<p>
 * Company:      Systronix<p>
 * @author B Boyes
 * @version 1.0
 */

import java.util.*;
import java.io.*;
import com.dalsemi.onewire.OneWireAccessProvider;
import com.dalsemi.onewire.*;
import com.dalsemi.onewire.adapter.*;
import com.dalsemi.onewire.container.*;
import com.dalsemi.onewire.container.OneWireContainer10;
import com.dalsemi.system.BitPort;

/** Simple class to find the first family code 10 device and read its temp.
 */
public class Read1 {

  static DSPortAdapter pa;    // the port adapter
  static OneWireContainer10 scratch10;  // reference to the container we'll create
  static byte [] state10;     // holds the state of the device accessed through container
  static long mSecLast;   // static so we can track time between conversions
  static long mSec;       // current time
  static long startTime;


  /** Constructor -- no use yet
   */
  public Read1() {
  }

  /** Call the 1-Wire methods from here.
   * wait some time between temp conversions
   * call the garbage collector between temp conversions
   * In future could read command line to get sample interval
   */
  public static void main(String[] args){
    Read1 readtemp = new Read1();
    boolean flag = true;

    startTime = System.currentTimeMillis();
    waitWhile (500L);

    System.out.println ("\nTest Program to Read DS1820/1920 Rev 2000 Dec 03 bab Systronix");
    System.out.println ("\nOutput is elapsed msec, msec since last sample, temp in C and F");

    while (flag) {
      waitWhile (2000L);          // wait 2 seconds
      System.gc();                // call the garbage collector outside our main loop
      flag = Read1.findDevice();
    }
    System.out.println ("Attempt to read temperature device failed!");

  } // end of main

  /** See if there is any family 10 device and if so read its temp.
   * The first device found is read.
   */
  public static boolean findDevice () {
  boolean status = true;

  try {
    pa = OneWireAccessProvider.getDefaultAdapter();
  }
  catch (OneWireException e) {
    System.out.print("Can't find 1Wire adapter " + e);
    // need to bail out if no adapter -- how?
    return false;
  }

  pa.targetFamily(0x10);     // Search only for the DS1920 family code.
  double tempC = 0;
  double tempF = 0;
  long elapsedTime;

  long delta = 0;

  try {
    pa.beginExclusive(true);
    scratch10 = (OneWireContainer10) pa.getFirstDeviceContainer();
    if (null==scratch10 ) {
      System.out.println("Could not find device 10");
      status = false;
    }
    // else System.out.println("Found " + scratch10.getName());
    state10 = scratch10.readDevice();
    scratch10.doTemperatureConvert (state10);
    //scratch10.writeDevice(state10);
    state10 = scratch10.readDevice();
    pa.endExclusive();

    tempC = scratch10.getTemperature(state10);
    tempF = scratch10.convertToFahrenheit(tempC);
    mSecLast = mSec;  // save last conversion time
    mSec = System.currentTimeMillis();  // new current time
    delta = mSec - mSecLast;
    elapsedTime = mSec-startTime;
    System.out.println(elapsedTime + "/" + delta + ": temp= " + tempC + " C / " + tempF + " F" );
  }
  catch (OneWireException e) {
    System.out.println("getFirstDevice exception " + e);
  }
  return status;
  } // end findDevice

  /** wait howLong number of milliseconds
   */
  public static void waitWhile (long howLong) {
    try { Thread.sleep(howLong); }
    catch (InterruptedException e) {
    System.out.println("waitWhile error " + e);
    }
  } // end waitWhile

} // end class Read1
