// LapFrame: Class for manipulating a LMP Control frame
//
// Copyright (c) 2000, The-Box Development
// Written by Jac Kersing <j.kersing@the-box.com>
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are met:
// 
// Redistributions of source code must retain the above copyright notice, this 
// list of conditions and the following disclaimer.
// 
// Redistributions in binary form must reproduce the above copyright notice, 
// this list of conditions and the following disclaimer in the documentation 
// and/or other materials provided with the distribution.
//
// All advertising materials mentioning features or use of this software must 
// display the following acknowledgement: 
// 
// This product includes software developed by The-Box Development.
// 
// The name of The-Box Development may not be used to endorse or promote 
// products derived from this software without specific prior written 
// permission. 
//
// THIS SOFTWARE IS PROVIDED BY THE-BOX DEVELOPMENT ``AS IS'' AND ANY EXPRESS 
// OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
// NO EVENT SHALL THE-BOX DEVELOPMENT BE LIABLE FOR ANY DIRECT, INDIRECT, 
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
//


package nl.tbdev.IR;

// N.B. The frame is supposed to have a LAP header at all times!
// (so all offsets are off by 2)
public class LmpControlFrame extends LmpFrame {
	// this constructor only stores a pointer to the original data
	// keep this in mind (do not modify the data or something unpredictable
	// might happen!
	public LmpControlFrame(byte[] iframe) {
		super(iframe);
	}

	public LmpControlFrame(int size) {
		super(size+2);
	}

	public LmpControlFrame(byte dlsap, byte slsap, byte opcode, boolean abit,
							     byte[] parms) {
		super(3 + parms.length);
		frame[2] = (byte) (0x80 | dlsap);
		frame[3] = slsap;
		frame[4] = (byte) ((abit ? 0x80 : 0x00) | opcode);
		for (int i=0; i < parms.length; i++) {
			frame[5 + i] = parms[i];
		}
	}
}
// vi: ts=3 sw=3 ai
