// LapXIDFrame : Implements a XID type of LAP frame.
//
// Copyright (c) 2000, The-Box Development
// Written by Jac Kersing <j.kersing@the-box.com>
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are met:
// 
// Redistributions of source code must retain the above copyright notice, this 
// list of conditions and the following disclaimer.
// 
// Redistributions in binary form must reproduce the above copyright notice, 
// this list of conditions and the following disclaimer in the documentation 
// and/or other materials provided with the distribution.
//
// All advertising materials mentioning features or use of this software must 
// display the following acknowledgement: 
// 
// This product includes software developed by The-Box Development.
// 
// The name of The-Box Development may not be used to endorse or promote 
// products derived from this software without specific prior written 
// permission. 
//
// THIS SOFTWARE IS PROVIDED BY THE-BOX DEVELOPMENT ``AS IS'' AND ANY EXPRESS 
// OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
// NO EVENT SHALL THE-BOX DEVELOPMENT BE LIABLE FOR ANY DIRECT, INDIRECT, 
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
//


package nl.tbdev.IR;
import nl.tbdev.IR.LapFrame;

public class LapXIDFrame extends LapFrame {
	public LapXIDFrame(byte[] frame) {
		super(frame);
	}

	public LapXIDFrame(LapFrame frame) {
		super(frame.getFrame());
	}

	// when creating a new frame the size of the additional info must be known
	public LapXIDFrame(boolean response, int additionalSize) {
		super(14 + additionalSize);
		if (response) {
			frame[0] = (byte) 0xfe;
			frame[1] = XIDr;
		} else {
			System.out.println("This is a primary operation. Not implemented");
		}
		// protocol version
		frame[2] = (byte) 0x01;
		// frame[3-10] are addresses, filled with method call
		// frame[11] is number of slots, done later
		// frame[12] is slot, set later
		// IrLap version:
		frame[13] = 0x00;
	}

	public byte[] getOrigAddressByte() {
		byte[] addr = new byte[4];
		addr[0] = frame[3];
		addr[1] = frame[4];
		addr[2] = frame[5];
		addr[3] = frame[6];
		return addr;
	}

	public int getOrigAddressInt() {
		return ((frame[3] << 24) & 0xff000000) | ((frame[4] << 16) & 0xff0000) | 
				 ((frame[5] << 8) & 0xff00) | (frame[6] & 0xff);
	}

	public byte[] getDestAddressByte() {
		byte[] addr = new byte[4];
		addr[0] = frame[7];
		addr[1] = frame[8];
		addr[2] = frame[9];
		addr[3] = frame[10];
		return addr;
	}

	public int getDestAddressInt() {
		return ((frame[7] << 24) & 0xff000000) | ((frame[8] << 16) & 0xff0000) | 
				 ((frame[9] << 8) & 0xff00) | (frame[10] & 0xff);
	}

	public void setOrigAddress(byte[] addr) {
		frame[3] = addr[0];
		frame[4] = addr[1];
		frame[5] = addr[2];
		frame[6] = addr[3];
	}

	public void setOrigAddress(int addr) {
		frame[3] = (byte) ((addr >> 24) & 0xff);
		frame[4] = (byte) ((addr >> 16) & 0xff);
		frame[5] = (byte) ((addr >> 8) & 0xff);
		frame[6] = (byte) (addr & 0xff);
	}

	public void setDestAddress(byte[] addr) {
		frame[7] = addr[0];
		frame[8] = addr[1];
		frame[9] = addr[2];
		frame[10] = addr[3];
	}

	public void setMaxSlot(int slots) {
		byte val = (byte) (frame[11] & 0xfc);
		switch (slots) {
			case 1:
						// nothing to be done;
						break;
			case 6:
						val |= (byte) 0x01;
						break;
			case 8:
						val |= (byte) 0x02;
						break;
			case 16:
						val |= (byte) 0x03;
		}
		frame[11] = val;
	}

	public void setAddressConflict(boolean value) {
		if (value) {
			frame[11] |= (byte) 0x04;
		} else {
			frame[11] &= 0xfb;
		}
	}

	public void setSlot(int slot) {
		frame[12] = (byte) (slot & 0xff);
	}

	public void setInfo(byte[] info) {
		for (int i = 0; i < info.length; i++) {
			frame[14+i] = info[i];
		}
	}
}

// vi: sw=3 ts=3 ai
