// LapIFrame : Implements a Information type of LAP frame.
//
// Copyright (c) 2000, The-Box Development
// Written by Jac Kersing <j.kersing@the-box.com>
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are met:
// 
// Redistributions of source code must retain the above copyright notice, this 
// list of conditions and the following disclaimer.
// 
// Redistributions in binary form must reproduce the above copyright notice, 
// this list of conditions and the following disclaimer in the documentation 
// and/or other materials provided with the distribution.
//
// All advertising materials mentioning features or use of this software must 
// display the following acknowledgement: 
// 
// This product includes software developed by The-Box Development.
// 
// The name of The-Box Development may not be used to endorse or promote 
// products derived from this software without specific prior written 
// permission. 
//
// THIS SOFTWARE IS PROVIDED BY THE-BOX DEVELOPMENT ``AS IS'' AND ANY EXPRESS 
// OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
// NO EVENT SHALL THE-BOX DEVELOPMENT BE LIABLE FOR ANY DIRECT, INDIRECT, 
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
//


package nl.tbdev.IR;
import nl.tbdev.IR.LapFrame;

public class LapIFrame extends LapFrame {
	public LapIFrame(byte[] frame) {
		super(frame);
	}

	public LapIFrame(LapFrame frame) {
		super(frame.getFrame());
	}

	public LapIFrame(byte addr, int nr, int ns, int size) {
		super(2 + size);
		frame[0] = (byte) ((addr << 1) & 0xfe);
		frame[1] = (byte) ( ((nr << 5) & 0xe0) | 0x10 | ((ns << 1) & 0x0e) );
	}

	public void setAddr(byte addr) {
		frame[0] = (byte) ((addr << 1) & 0xfe);
	}
	
	public void setNrNs(int nr, int ns) {
		frame[1] = (byte) ( ((nr << 5) & 0xe0) | 0x10 | ((ns << 1) & 0x0e) );
	}
		
	public byte getNr() {
		return (byte) ((frame[1] >> 5 ) & 0x07);
	}

	public byte getNs() {
		return (byte) ((frame[1] >> 1) & 0x07);
	}

	public byte[] getData() {
		byte[] retval = new byte[frame.length -2];

		for (int i=2; i < frame.length; i++) {
			retval[i-2] = frame[i];
		}
		return retval;
	}

	public void setData(byte[] data) {
		if (data.length > (frame.length - 2)) {
			// this is bound to fail, so just return for now.
			// might throw an Exception later
			return;
		}
		for (int i = 0; i < data.length; i++) {
			frame[i+2] = data[i];
		}
	}

	public void copyData(byte[] data) {
		if (data.length > frame.length) {
			// this is bound to fail, so just return for now.
			// might throw an Exception later
			return;
		}
		for (int i = 2; i < data.length; i++) {
			frame[i] = data[i];
		}
	}

}

// vi: sw=3 ts=3 ai
