// Lap.java - miminal implementation of IrDA LAP
//
// Copyright (c) 2000, The-Box Development
// Written by Jac Kersing <j.kersing@the-box.com>
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are met:
// 
// Redistributions of source code must retain the above copyright notice, this 
// list of conditions and the following disclaimer.
// 
// Redistributions in binary form must reproduce the above copyright notice, 
// this list of conditions and the following disclaimer in the documentation 
// and/or other materials provided with the distribution.
//
// All advertising materials mentioning features or use of this software must 
// display the following acknowledgement: 
// 
// This product includes software developed by The-Box Development.
// 
// The name of The-Box Development may not be used to endorse or promote 
// products derived from this software without specific prior written 
// permission. 
//
// THIS SOFTWARE IS PROVIDED BY THE-BOX DEVELOPMENT ``AS IS'' AND ANY EXPRESS 
// OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
// NO EVENT SHALL THE-BOX DEVELOPMENT BE LIABLE FOR ANY DIRECT, INDIRECT, 
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
//


package nl.tbdev.IR;
import nl.tbdev.IR.LapFrame;

public class Lap {
	final static char[] digit = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

	/***
	 * DisplayFrame - Display a frame at LAP layer
	 */
	public static void DisplayFrame(byte[] frame, boolean verbose) {
		LapFrame lf = new LapFrame(frame);

		System.out.println("FRAME INFORMATION");
		System.out.println("Address: " + lf.getAddress() );;
		if (lf.isControl()) {
			System.out.println("Control frame");
		} else {
			System.out.println("Response frame");
		}
		if (lf.isPoll()) {
			System.out.println("Poll/Final set");
		}
		if (lf.isUnnumbered()) {
			if (lf.isControl()) {
				switch (lf.unnumberedControl()) {
					case LapFrame.SNRMc:
							System.out.println("Unnumbered: SNRM command");
							break;
					case LapFrame.DISCc:
							System.out.println("Unnumbered: DISC command");
							break;
					case LapFrame.XIDc:
							System.out.println("Unnumbered: XID command");
							if (verbose) {
								DisplayXidFrame(frame);
							}
							break;
					case LapFrame.UIDc:
							System.out.println("Unnumbered: UID command");
							break;
					default:
							System.out.println("Unknown command: "+lf.unnumberedControl());
							break;
				}
			} else {
				switch (lf.unnumberedResponse()) {
					case LapFrame.RNRMr:
							System.out.println("Unnumbered: RNRM response");
							break;
					case LapFrame.UAr:
							System.out.println("Unnumbered: UA response");
							break;
					case LapFrame.FRMRr:
							System.out.println("Unnumbered: FRMR response");
							break;
					case LapFrame.DMr:
							System.out.println("Unnumbered: DM response");
							break;
					case LapFrame.RDr:
							System.out.println("Unnumbered: RD response");
							break;
					case LapFrame.UIr:
							System.out.println("Unnumbered: UI response");
							break;
					case LapFrame.XIDr:
							System.out.println("Unnumbered: XID response");
							if (verbose) {
								DisplayXidFrame(frame);
							}
							break;
					case LapFrame.TEST:
							System.out.println("Unnumbered: TEST response");
							break;
					default:
							System.out.println("Unknown response: "+lf.unnumberedResponse());
							break;
				}
			}
		}
		if (lf.isSupervisory()) {
			switch (lf.unnumberedControl()) {
				case LapFrame.RR:
					System.out.println("Supervisory: RR command/response");
					break;
				case LapFrame.RNR:
					System.out.println("Supervisory: RNR command/response");
					break;
				case LapFrame.REJ:
					System.out.println("Supervisory: REJ command/response");
					break;
				case LapFrame.SREJ:
					System.out.println("Supervisory: SREJ command/response");
					break;
			}
		}
		if (lf.isInformation()) {
			System.out.println("Information Frame");
		}
	}

	public static void DisplayXidFrame(byte[] frame) {
		System.out.println("   XID Information:");
		if ((frame[1] & 0xfe) == 0xfe) {
			System.out.println("   Broadcast");
		}
		if (frame[2] == 0x01) {
			System.out.println("   Format identifier: Discovery XID");
			System.out.println("   Discovery flags:");
			int slots = (frame[11] & 0x03);
			System.out.println("     " + ((slots == 0) ? "1 slot" :
				(slots == 1) ? "6 slots" : (slots == 2) ? "8 slots" : "16 slots"));
			if ((frame[11] & 0x4) == 0x4) {
				System.out.println("     generate new device address");
			}
		} else {
			System.out.println("   Format identifier: Unknown");
		}
		System.out.println("   Source Address: " + hex(frame[3]) +
			hex(frame[4]) + hex(frame[5]) + hex(frame[6]));
		System.out.println("   Destination Address: " + hex(frame[7]) +
			hex(frame[8]) + hex(frame[9]) + hex(frame[10]));
		System.out.println("   Slot number: " + frame[12]);
		System.out.println("   IrLap version: " + frame[13]);
		if (frame[12] == (byte) 0xff) {
			System.out.println("   Discovery Info: " + new String(frame,14,frame.length-14));
		}
	}	

	public static byte[] SendXidReply(byte[] frame, int rnd) {
		byte[] nfrm = new byte[22];

		nfrm[0] = (byte) 0xfe;
		nfrm[1] = (byte) 0xbf;
		nfrm[2] = (byte) 0x01;
		// copy address
		nfrm[3] = (byte) ((rnd >> 24) & 0xff);
		nfrm[4] = (byte) ((rnd >> 16) & 0xff);
		nfrm[5] = (byte) ((rnd >> 8) & 0xff);
		nfrm[6] = (byte) (rnd & 0xff);
		nfrm[7] = frame[3];
		nfrm[8] = frame[4];
		nfrm[9] = frame[5];
		nfrm[10] = frame[6];
		nfrm[11] = frame[11];
		nfrm[12] = frame[12];
		nfrm[13] = (byte) 0x00;
		nfrm[14] = (byte) 0x82;
		nfrm[15] = (byte) 0x20;
		nfrm[16] = (byte) 0x0;
		nfrm[17] = (byte) 'L';
		nfrm[18] = (byte) 'i';
		nfrm[19] = (byte) 'n';
		nfrm[20] = (byte) 'u';
		nfrm[21] = (byte) 'x';
		return nfrm;
	}

	private static String hex(byte b) {
		return "" + digit[(b >> 4)&0x0f] + digit[b&0x0f];
	}
}

// vi: sw=3 ts=3 ai
