// IrClient.java - IrDA client
//
// Copyright (c) 2000, The-Box Development
// Written by Jac Kersing <j.kersing@the-box.com>
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are met:
// 
// Redistributions of source code must retain the above copyright notice, this 
// list of conditions and the following disclaimer.
// 
// Redistributions in binary form must reproduce the above copyright notice, 
// this list of conditions and the following disclaimer in the documentation 
// and/or other materials provided with the distribution.
//
// All advertising materials mentioning features or use of this software must 
// display the following acknowledgement: 
// 
// This product includes software developed by The-Box Development.
// 
// The name of The-Box Development may not be used to endorse or promote 
// products derived from this software without specific prior written 
// permission. 
//
// THIS SOFTWARE IS PROVIDED BY THE-BOX DEVELOPMENT ``AS IS'' AND ANY EXPRESS 
// OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
// NO EVENT SHALL THE-BOX DEVELOPMENT BE LIABLE FOR ANY DIRECT, INDIRECT, 
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
//


package nl.tbdev.IR;

public class IrClient extends Thread {
	// change the next two lines for use on TINI
	private SerialPc ser;
	//private SerialTini ser;
	private LmMux mux;
	private IasStore store;
	private IasServer server;
	private LmpStation station;
	private byte newLsap;

	public IrClient(String port) {
		// change the next two lines for use on TINI
		// ser = new SerialTini();
		ser = new SerialPc(port);
		mux = new LmMux();
		store = new IasStore();
		store.createClass("Device");
		store.registerAttr("Device","DeviceName","JavaIR");
		byte[] attr = { (byte) 0x01, (byte) 0x00, (byte) 0x00 };
		store.registerAttr("Device","IrLMPSupport", attr);
		server = new IasServer(store);
		LmpConnection conn = new LmpConnection(server);
		mux.register((byte) 0, conn);
		station = new LmpStation(ser, mux);
		newLsap = (byte) 2;
	}

	public void run() {
		station.run();
	}

	public IasStore getStore() {
		return store;
	}

	public LmMux getMux() {
		return mux;
	}

	public void muxRegister(byte lsap, LmpConnection conn) {
		mux.register(lsap, conn);
	}

	public void iasCreateClass(String name) {
		store.createClass(name);
	}

	public void iasRegisterAttr(String cls, String name, Object attr) {
		if (store.lookupClass(cls) == null) {
			store.createClass(cls);
		}
		store.registerAttr(cls, name, attr);
	}

	public synchronized byte getLsap() {
		byte lsap = newLsap;
		if (newLsap > 126) {
			// this is going to be a problem, ignore it now
		}
		newLsap++;
		return lsap;
	}
}
// vi: ts=3 sw=3 ai
