// IasStore.java - Information Access Service
//
// Copyright (c) 2000, The-Box Development
// Written by Jac Kersing <j.kersing@the-box.com>
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are met:
// 
// Redistributions of source code must retain the above copyright notice, this 
// list of conditions and the following disclaimer.
// 
// Redistributions in binary form must reproduce the above copyright notice, 
// this list of conditions and the following disclaimer in the documentation 
// and/or other materials provided with the distribution.
//
// All advertising materials mentioning features or use of this software must 
// display the following acknowledgement: 
// 
// This product includes software developed by The-Box Development.
// 
// The name of The-Box Development may not be used to endorse or promote 
// products derived from this software without specific prior written 
// permission. 
//
// THIS SOFTWARE IS PROVIDED BY THE-BOX DEVELOPMENT ``AS IS'' AND ANY EXPRESS 
// OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
// NO EVENT SHALL THE-BOX DEVELOPMENT BE LIABLE FOR ANY DIRECT, INDIRECT, 
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
//


package nl.tbdev.IR;
import java.util.Hashtable;

public class IasStore {
	private Hashtable classes;

	public IasStore() {
		super();
		classes = new Hashtable();
	}

	public void registerClass(String name, Hashtable attr) {
		classes.put(name, attr);
	}

	public void createClass(String name) {
		Hashtable attr = new Hashtable();
		classes.put(name, attr);
	}

	public Hashtable lookupClass(String name) {
		return (Hashtable) classes.get(name);
	}

	public void registerAttr(String cName, String aName, Object value) {
		Hashtable cls = lookupClass(cName);
		if (cls == null) {
			// should throw exception here. To-Be-Done
			return;
		}
		cls.put(aName, value);
	}

	public Object lookupAttr(String cName, String aName) {
		Hashtable cls = lookupClass(cName);
		if (cls == null) {
			return null;
		}
		return cls.get(aName);
	}
}
// vi: ts=3 sw=3 ai
