// IasServer.java - Information Access Service
//
// Copyright (c) 2000, The-Box Development
// Written by Jac Kersing <j.kersing@the-box.com>
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are met:
// 
// Redistributions of source code must retain the above copyright notice, this 
// list of conditions and the following disclaimer.
// 
// Redistributions in binary form must reproduce the above copyright notice, 
// this list of conditions and the following disclaimer in the documentation 
// and/or other materials provided with the distribution.
//
// All advertising materials mentioning features or use of this software must 
// display the following acknowledgement: 
// 
// This product includes software developed by The-Box Development.
// 
// The name of The-Box Development may not be used to endorse or promote 
// products derived from this software without specific prior written 
// permission. 
//
// THIS SOFTWARE IS PROVIDED BY THE-BOX DEVELOPMENT ``AS IS'' AND ANY EXPRESS 
// OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
// NO EVENT SHALL THE-BOX DEVELOPMENT BE LIABLE FOR ANY DIRECT, INDIRECT, 
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
//


package nl.tbdev.IR;
import nl.tbdev.IR.IasStore;

public class IasServer implements ClientCallbackInterface {
	private IasStore store;

	public IasServer(IasStore iStore) {
		super();
		store = iStore;
	}

	public boolean clientCallbackConnect() {
		return true;
	}
	public void clientCallbackConfirm() {
	}

	public void clientCallbackDisconnect() {
	}

	public void clientCallbackData(LmpConnection conn, byte rLsap, byte[] data) {
		IapFrame f = new IapFrame(data);
		if (f.isAck()) {
			return;
		}
		if (f.opcode() == IapFrame.LMGETVALUEBYCLASS) {
			String cls = f.getClassName();
			Object result = store.lookupClass(cls);
			if (result == null) {
				byte[] rData = new byte[2];
				rData[0] = (byte) 0x84;
				rData[1] = 1;
				conn.dataRequest((byte) 0, rLsap, rData);
				return;
			}
			result = store.lookupAttr(
				cls,
				f.getAttrName());
			if (result == null) {
				byte[] rData = new byte[2];
				rData[0] = (byte) 0x84;
				rData[1] = 2;
				conn.dataRequest((byte) 0, rLsap, rData);
				return;
			}
			if ( result instanceof Integer ) {
				int val = ((Integer) result).intValue();
				byte[] rData = new byte[11];
				rData[0] = (byte) 0x84;
				rData[1] = 0;
				rData[2] = 0;
				rData[3] = 1;
				rData[4] = 0;
				rData[5] = 0;
				rData[6] = 1;
				rData[7] = (byte) ((val >> 24) & 0xff);
				rData[8] = (byte) ((val >> 16) & 0xff);
				rData[9] = (byte) ((val >> 8) & 0xff);
				rData[10] = (byte) (val & 0xff);
				conn.dataRequest((byte) 0, rLsap, rData);
				return;
			}
			if ( result instanceof byte[] ) {
				byte[] val = (byte [])result;
				int len = val.length;
				byte[] rData = new byte[9 + len];
				rData[0] = (byte) 0x84;
				rData[1] = 0;
				rData[2] = 0;
				rData[3] = 1;
				rData[4] = 0;
				rData[5] = 0;
				rData[6] = 2;
				rData[7] = (byte) ((len >> 8) & 0xff);
				rData[8] = (byte) (len & 0xff);
				for (int i = 0; i < len; i++) {
					rData[i+9] = val[i];
				}
				conn.dataRequest((byte) 0, rLsap, rData);
				return;
			}
			if ( result instanceof String ) {
				String val = (String) result;
				byte[] str = val.getBytes();
				int len = str.length;
				byte[] rData = new byte[9 + len];
				rData[0] = (byte) 0x84;
				rData[1] = 0;
				rData[2] = 0;
				rData[3] = 1;
				rData[4] = 0;
				rData[5] = 0;
				rData[6] = 3;
				rData[7] = 0;
				rData[8] = (byte) len;
				for (int i = 0; i < len; i++) {
					rData[9+i] = str[i];
				}
				conn.dataRequest((byte) 0, rLsap, rData);
				return;
			}
		}
	}
}
// vi: ts=3 sw=3 ai
