// IapFrame: Class for manipulating an IAP frame.
//
// Copyright (c) 2000, The-Box Development
// Written by Jac Kersing <j.kersing@the-box.com>
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are met:
// 
// Redistributions of source code must retain the above copyright notice, this 
// list of conditions and the following disclaimer.
// 
// Redistributions in binary form must reproduce the above copyright notice, 
// this list of conditions and the following disclaimer in the documentation 
// and/or other materials provided with the distribution.
//
// All advertising materials mentioning features or use of this software must 
// display the following acknowledgement: 
// 
// This product includes software developed by The-Box Development.
// 
// The name of The-Box Development may not be used to endorse or promote 
// products derived from this software without specific prior written 
// permission. 
//
// THIS SOFTWARE IS PROVIDED BY THE-BOX DEVELOPMENT ``AS IS'' AND ANY EXPRESS 
// OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
// NO EVENT SHALL THE-BOX DEVELOPMENT BE LIABLE FOR ANY DIRECT, INDIRECT, 
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
//


package nl.tbdev.IR;

public class IapFrame {
	byte[] frame;

	// this constructor only stores a pointer to the original data
	// keep this in mind (do not modify the data or something unpredictable
	// might happen!
	public IapFrame(byte[] iframe) {
		super();
		frame = iframe;
	}

	public IapFrame(int size) {
		super();
		frame = new byte[size];
	}

	// Is the the final frame?
	public boolean isLast() {
		return (frame[0] & 0x80) == 0x80;
	}

	public boolean isAck() {
		return (frame[0] & 0x40) == 0x40;
	}

	public void setLast() {
		frame[0] |= 0x80;
	}

	public void setAck() {
		frame[0] |= 0x40;
	}

	public final static byte LMGETVALUEBYCLASS = 0x04;

	public byte opcode() {
		return (byte) (frame[0] & 0x3f);
	}

	// return the class
	public String getClassName() {
		int len = frame[1];
		return new String(frame, 2, len);
	}

	public String getAttrName() {
		int len = frame[1];
		int start = 3+len;
		len = frame[start-1];
		return new String(frame, start, len);
	}

	public byte[] getFrame() {
		return frame;
	}
}

// vi: ts=3 sw=3 ai
