// TiniTemp.java - Serve temperature for IrDA
//
// Copyright (c) 2000, The-Box Development
// Written by Jac Kersing <j.kersing@the-box.com>
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are met:
// 
// Redistributions of source code must retain the above copyright notice, this 
// list of conditions and the following disclaimer.
// 
// Redistributions in binary form must reproduce the above copyright notice, 
// this list of conditions and the following disclaimer in the documentation 
// and/or other materials provided with the distribution.
//
// All advertising materials mentioning features or use of this software must 
// display the following acknowledgement: 
// 
// This product includes software developed by The-Box Development.
// 
// The name of The-Box Development may not be used to endorse or promote 
// products derived from this software without specific prior written 
// permission. 
//
// THIS SOFTWARE IS PROVIDED BY THE-BOX DEVELOPMENT ``AS IS'' AND ANY EXPRESS 
// OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
// NO EVENT SHALL THE-BOX DEVELOPMENT BE LIABLE FOR ANY DIRECT, INDIRECT, 
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
//

import nl.tbdev.IR.IrClient;
import nl.tbdev.IR.LmpConnection;
import nl.tbdev.IR.ClientCallbackInterface;
import nl.tbdev.IR.Display;

class TiniTemp {
	public static void main(String[] argv) {
		IrClient client = new IrClient("serial0");
		client.start();

		TempClient temp = new TempClient();
		LmpConnection conn = new LmpConnection(temp);
		client.muxRegister((byte) 10, conn);
		Integer lsap = new Integer(10);
		client.iasRegisterAttr("Temperature","lsap",(Object) lsap);

		GetTemp ibutton = new GetTemp();

		while (true) {
			temp.temperature = ibutton.read();
			try {
				Thread.sleep(10000);
			} catch (Exception e) {}
		}
	}
}

class TempClient implements ClientCallbackInterface {
	String temperature = "----";

	public boolean clientCallbackConnect() {
		System.out.println("IrDA connection request");
		return true;
	}

	public void clientCallbackConfirm() {
	}

	public void clientCallbackData(LmpConnection conn, 
		byte rlsap, byte[] data) {
		System.out.println("IrDA data received, "+data.length+" bytes, command="
			+Display.hex(data[0]));
		// process data...
		if (data[0] == 0x01) {
			int len = temperature.length();
			byte[] resp = new byte[ 6 ];
			byte[] str = temperature.getBytes();
			for( int i = 0; i < 5; i++) {
				resp[i] = str[i];
			}
			resp[5] = (byte) 0x00;
			conn.dataRequest((byte) 10, rlsap, resp);
		}
	}

	public void clientCallbackDisconnect() {
		System.out.println("IrDA disconnect");
	}
}
// vi: sw=3 ts=3 ai
