;-----------------------------------------------------------------------------
;	DS1820.ASM
;	HSM/550 test program
;
; (C) Copyright 1999 Systronix, Inc All Rights Reserved
;	Systronix, Inc. Salt Lake City, Utah, USA
;	TEL: 801-534-1017  FAX:801-534-1019
;	www.systronix.com  email: support@systronix.com
;	COMPLETE SYSTEMS for RAPID PROTOTYPING
;
; DESCRIPTION ---------------------------------------------------------------- 
;
; Reads the DS1820 on HSM/550
;
; Note: this file is provided for illustrative purposes. We have not included
; the support file "ibutton_asm.inc", which will be available for purchase
; from Systronix. iButton support is relatively complex and expensive to develop,
; therefore we are not giving it away. We have included the HEX file which will
; run at 33 MHz and demonstrates the output of this project.
;
; REVISION HISTORY -----------------------------------------------------------
;  
;
; 99 Jun 18 bab	Removing C550 EQUs from ASM file, use controller def instead
; 99 Jun 08 bab	Cleanup and support for newline1 and newline0, all newlines
;		(CR-LF pairs) must now be explicit.            
; 99 Jun 07 bab	Rev 0.4 using 550_io.inc to modularize the serial output routines.
; 99 May 25 bab adding ti1 clear check to putch, adapting to 33 MHz esp the 
; ibutton include file
; 99 Apr 27 bab	start, based on dac_550 program

;
; NOTES AND COMMENTS ---------------------------------------------------------
;
;
;-----------------------------------------------------------------------------
; Baud Rate
;
; For reliable communication the actual baud rate should be within +/- 3% of
; the ideal.
;
; Both the UARTs and Timers have different modes, so don't confuse the UART
; mode with the baud rate generator Timer mode. For our loader, we use UART1
; so that UART0 is left untouched. UART mode 1 is a 10-bit asynch mode
; compatible with RS232 systems. Mode 3 is used for multi-processor
; communication. UART modes 1 and 3 use identical baud rate generation.
;
; UART1 in mode 1 must use Timer1 as a baud rate generator. This is most
; easily done by placing Timer1 in its mode 2, 8-bit auto-reload mode.
; In this mode, when T1 overflows it automatically reloads with the value
; stored in TH1. TL1 does the actual counting. This mode requires no MCU
; overhead since it reloads automatically.
;
; UART Mode 1 and 3 baud rate for UART1 is
; 	baud = (2^SMOD / 32) * Timer1_overflow
; where Timer1 overflow = xtal / ( T1DIV * (256-TH1) )
; T1DIV controlled by T1M bit (CKCON.4), is 12(T1M=0) or 4 (T1M=1)
;
; With Timer1 in 8-bit autoreload mode, solving for TH1:
;	TH1 = 256 - ( (2^SMOD/32) * ( xtal / T1DIV * baud) )
;
; Setting SMOD effectively doubles the baud rate for a given TH1.
; The values below assume T1DIV = 4, and SMOD=1
;		--xtal-	-baud- 	-TH1-  	-error-
;		11.0592	57600	FDH	0
;			19200	F7H	0
;			 9600	EEH	0
;			
;		14.7456	115K	FEH	-0.17%
;			57600	FCH	0
;			38400	FAH	0
;			19200	F4H	0
;			 9600	E8H	0
;
;		22.1184	115K	FDH	-0.17%
;			57600	FAH	0
;			38400	F7H	0
;			19200	EEH	0
;			 9600	DCH	0
;
;	25.0000	38400	F6		-1.7%
;			19200	ECH	-1.7%
;			 9600	D7H	0.76
;
;	33.0000	115K	FCH		-11% forget it
;			57600	F7H	0.54
;			38400	F3H	-3.19% marginal
;			19200	E5H	0.54
;			 9600	CAH	0.54
;
; change the baud rate here in this equate

;baud_rate       equ     0E5H 		; 33.0000, 19200
;baud_rate       equ     0F4H 		; 14.7456 19200
baud_rate       equ     0EEH 		; 11.0592, 9600 or 22.1184 19200

;-----------------------------------------------------------------------------
;       ascii equates 
;-----------------------------------------------------------------------------
ctrlc   equ	003h               	; control c
bs      equ	008h               	; back space 
tab     equ	009h              	; horizontal tab, ^i 
lf      equ	00ah			; line feed
cr      equ	00dh			; carriage return
xon     equ	011h            	; rs232 protocol ^q
xoff    equ	013h			; rs232 protocol ^s
spa     equ	020h			; space
colon   equ	03ah			; ':'
amp	equ	040h			; '@
ques	equ	03fh			; '?'
slash	equ	02fh			; '/'
del	equ	07fh             	; delete character 

 
;------------------------------------------------------------------
;	Internal DATA used by program

tmp     	equ		0DH			; temp used: putbyt
tmp2		equ		0EH			; used to write to sbx  


;------------------------------------------------------------------
; Reset Vector
;------------------------------------------------------------------
	org	0h			; reset vector
	ajmp	start

					; can org other interrupt vectors here

start:
	mov	SP, #10H		; above data we're using
	orl	wdcon, #080H		; Turn on the SMOD bit for serial port 1
        mov	scon1, #050h            ; serial mode 1, 8 data, 1 start,stop
        mov 	tmod, #021h             ; timers 0-16 bit; 1-8 bit reload
        mov	th1,  #baud_rate	; from baud rate calculation
        orl	ckcon, #010H		; set T1M so T1DIV is 4 instead of 12
        mov 	tcon, #050h             ; timer on

        mov	scon, #050h
        orl	pcon, #80h		; set SMOD bit for 

sl_init:
        clr	a
	mov	ie,a			;Disable all interrupts.
	mov	eie, a			; c550 extended interrupts
        clr	ti_1		     	;Clear ri1, ti1 just to be safe.
        clr	ri_1
        clr	ri_0
        clr	ti_0

	mov	a, #1			; select uart1
  	mov	dptr,#dow_test		; uart1 message	
	lcall	putstr			; send it

	mov	a, #0			; select uart0
  	mov	dptr,#dow_test		; uart1 message	
	lcall	putstr			; send it  	
 
	mov		tmp2, #0      
	lcall	DOW_INIT   
	
main_loop:
	cpl	P1.0   
	
	lcall	DOW_RESET			; check for presence
	mov	a, #1				; select uart1
	mov	dptr,#msg_present
	lcall	putstr
	mov	dptr, #DOW_PRESENT
	movx	a, @dptr			; fetch the value
	lcall	putbyt1				; output it
	mov	a, #20h			
	lcall	putch1     
	                               
	mov	a, #1				; select uart1
	mov	dptr,#msg_short
	lcall	putstr
	mov	dptr, #DOW_SHORT
	movx	a, @dptr			; fetch the value
	lcall	putbyt1				; output it
	lcall	newline1		
	
	
	lcall	DOW_READ_ROM 
	mov	b, #8 
	mov	a, #1				; select uart1
	mov	dptr,#msg_rom
	lcall	putstr

	mov	dptr, #DOW_ROM 		; point to the array we read from DOW device
	mov	a, #20h				; space			
	lcall	putch1	
dow_rom2:	
	movx	a, @dptr			; fetch the value
	lcall	putbyt1				; output it
	mov	a, #20h				; space			
	lcall	putch1 
	inc	dptr				; point to next value
	djnz	B, dow_rom2			; do it 8 times then we're done
	mov	a, #cr
	lcall	newline1
	
	lcall	DOW_RESET
	lcall	DOW_SKIP_ROM
	lcall	DOW_CONVERT_TEMP

	lcall	DOW_RESET
	lcall	DOW_SKIP_ROM
	lcall	DOW_READ_SCRATCH

	mov	b, #9 
	mov	a, #1				; select uart1
	mov	dptr,#msg_scratch
	lcall	putstr
 
	mov	dptr, #DOW_SCRATCH 		; point to the array we read from DOW device
dow_scratch2:	
	mov	a, #20h				; space			
	lcall	putch1
	movx	a, @dptr			; fetch the value
	lcall	putbyt1				; output it
	mov	a, #20h				; space			
	lcall	putch1 
	inc	dptr				; point to next value
	djnz	B, dow_scratch2		; do it 8 times then we're done
	mov	a, #cr
	lcall	newline1
	 

	mov	a, #1				; select uart1
	mov	dptr,#msg_temp
	lcall	putstr

	mov	dptr, #DOW_SCRATCH
	movx	a, @dptr			; fetch the temperature value lsb
	mov	b, #2
	div	ab				; yes it could have been a rr instead

	mov	r4, a				; make a copy
	lcall	putbyt1				; output it

	mov	a, #20h 
	lcall	putch1                                                        
                      
	; the temp lsb can be 0 to ff over all possible temps
	; it's 0-99 decimal only over a limited range                      
 	mov	a, r4				; binary temp value
 	lcall	HEX_TO_BCD			; convert to BCD (OK iff 0-99 decimal)                                                     
	lcall	putbyt1	

	lcall	newline1	
	lcall	newline1	
	
	ljmp	main_loop			; repeat forever
	
; what is this stuff? I jumped ahead of it
; starting to add support for SBX1 LCD it appears

	mov	dptr, #0fc05h			; sbx connector lcd strobe write
	mov	a, tmp2 
	lcall	putbyt1				; output it
	mov	a, #20h 
	lcall	putch1	

	mov	a, tmp2 			; get back value we want to change		
	xrl	a, #09h				; complement the lcd bl and grn led bits 
	mov	tmp2, a
	movx	@dptr, a			; write to the sbx 
	
	lcall	putbyt1				; output it
	mov	a, #cr 
	lcall	putch1	
	mov	a, #cr
	lcall	putch1
	 	
	ljmp	main_loop			; repeat forever

       
;------------------------------------------------------------------
;   data definitions
;------------------------------------------------------------------

dow_test:	db   cr, lf, lf, 'DOW Test Rev 0.5 bab', cr, lf, 0

msg_present:	db	'DOW presence=', 0   

msg_short:	db	'DOW short=', 0   

msg_rom:	db	'DEV LSB---SER#----MSB CRC', cr, lf
		db 	'--- -- -- -- -- -- -- ---', cr, lf, 0    
				
msg_scratch:	db	'  TEMP   LIMITS         CNT CNT    ', cr, lf
		db	'LSB MSB  TH  TL RES RES REM DEG CRC', cr, lf
		db	'--- --- --- --- --- --- --- --- ---', cr, lf, 0
				
msg_temp:	db	'temperature (hex) deg C=', 0



	incl	"..\ibutton_asm.inc"  
	INCL	"..\550_io.inc"


	END

