;-----------------------------------------------------------------------------
;	DS1284.ASM
;	HSM/550 program to test the DS1284 embedded clock & calendar chip
;
; Supports DS87C550 HighSpeed Micro on HSM/550 Development Board
;
; (C) Copyright 1999 Systronix, Inc All Rights Reserved
;               Systronix, Inc. Salt Lake City, Utah, USA
;               TEL: 801-534-1017  FAX:801-534-1019
;		www.systronix.com  email: support@systronix.com
;		COMPLETE SYSTEMS for RAPID PROTOTYPING
;
; DESCRIPTION ----------------------------------------------------------------
;
; 
;
; REVISION HISTORY ----------------------------------------------------------- 
;               
; The revision string below is output to the uarts
; 99 Jun 21	[wsk]	Rev change because of changes in DS1284.inc which see.
;
; 99 Jun 17 bab	Commenting out SFR and BIT EQUs to use the controller definition
;		in the controller.cfg file
; 99 Jun 08 bab	Start
;
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
;
;-----------------------------------------------------------------------------
; Baud Rate
;
; For reliable communication the actual baud rate should be within +/- 3% of
; the ideal.
;
; Both the UARTs and Timers have different modes, so don't confuse the UART
; mode with the baud rate generator Timer mode. For our loader, we use UART1
; so that UART0 is left untouched. UART mode 1 is a 10-bit asynch mode
; compatible with RS232 systems. Mode 3 is used for multi-processor
; communication. UART modes 1 and 3 use identical baud rate generation.
;
; UART1 in mode 1 must use Timer1 as a baud rate generator. This is most
; easily done by placing Timer1 in its mode 2, 8-bit auto-reload mode.
; In this mode, when T1 overflows it automatically reloads with the value
; stored in TH1. TL1 does the actual counting. This mode requires no MCU
; overhead since it reloads automatically.
;
; UART Mode 1 and 3 baud rate for UART1 is
; 	baud = (2^SMOD / 32) * Timer1_overflow
; where Timer1 overflow = xtal / ( T1DIV * (256-TH1) )
; T1DIV controlled by T1M bit (CKCON.4), is 12(T1M=0) or 4 (T1M=1)
;
; With Timer1 in 8-bit autoreload mode, solving for TH1:
;	TH1 = 256 - ( (2^SMOD/32) * ( xtal / T1DIV * baud) )
;
; Setting SMOD effectively doubles the baud rate for a given TH1.
; The values below assume T1DIV = 4, and SMOD=1
;		--xtal-	-baud- 	-TH1-  	-error-
;		11.0592	57600	FDH	0
;			19200	F7H	0
;			 9600	EEH	0
;			
;		14.7456	115K	FEH	-0.17%
;			57600	FCH	0
;			38400	FAH	0
;			19200	F4H	0
;			 9600	E8H	0
;
;		22.1184	115K	FDH	-0.17%
;			57600	FAH	0
;			38400	F7H	0
;			19200	EEH	0
;			 9600	DCH	0
;
;	25.0000	38400	F6		-1.7%
;			19200	ECH	-1.7%
;			 9600	D7H	0.76
;
;	33.0000	115K	FCH		-11% forget it
;			57600	F7H	0.54
;			38400	F3H	-3.19% marginal
;			19200	E5H	0.54
;			 9600	CAH	0.54
;
; change the baud rate here in this equate

;baud_rate       equ     0E5H 		; 33.0000, 19200
;baud_rate       equ     0F4H 		; 14.7456 19200
baud_rate       equ     0EEH 		; 11.0592, 9600 or 22.1184 19200

;-----------------------------------------------------------------------------
;       ascii equates 
;-----------------------------------------------------------------------------
ctrlc   equ	003h               	; control c
bs      equ	008h               	; back space 
tab     equ	009h              	; horizontal tab, ^i 
lf      equ	00ah			; line feed
cr      equ	00dh			; carriage return
xon     equ	011h            	; rs232 protocol ^q
xoff    equ	013h			; rs232 protocol ^s
spa     equ	020h			; space
colon   equ	03ah			; ':'
amp	equ	040h			; '@
ques	equ	03fh			; '?'
slash	equ	02fh			; '/'
del	equ	07fh             	; delete character  
comma	equ	02Ch			; ',' 
point	equ	02eh			; dec point

 
;------------------------------------------------------------------
;	Internal DATA used by program

tmp     	equ	0DH	; temp used: putbyt

;------------------------------------------------------------------
; Reset Vector
;------------------------------------------------------------------
	org	0h			; reset vector
	ajmp	start

					; can org other interrupt vectors here

start:
	mov	SP, #10H		; above internal data we're using
	orl	wdcon, #080H		; Turn on the SMOD bit for serial port 1
        mov     scon1, #050h            ; serial mode 1, 8 data, 1 start,stop
        mov     tmod, #021h             ; timers 0-16 bit; 1-8 bit reload
        mov	th1,  #baud_rate	; from baud rate calculation
        orl	ckcon, #010H		; set T1M so T1DIV is 4 instead of 12
        mov     tcon, #050h             ; timer on

        mov	scon, #050h
        orl	pcon, #80h		; set SMOD bit
sl_init:
        clr	a
	mov	ie,a			;Disable all interrupts.
	mov	eie, a			; c550 extended interrupts
        clr	ti_1		     	;Clear ri_1, ti_1 just to be safe.
        clr	ri_1
        clr	ri
        clr	ti

	mov	a, #1			; select uart1
  	mov	dptr,#banner		; uart1 message	
	lcall	putstr			; send it
	mov	a, #1			; select uart1
  	mov	dptr,#revision		; uart1 message	
	lcall	putstr			; send it
	
	
	mov	a, #0			; select uart0
  	mov	dptr,#banner		; uart1 message	
	lcall	putstr			; send it
	mov	a, #0			; select uart
  	mov	dptr,#revision		; uart1 message	
	lcall	putstr  
	
	;sjmp	sl_init

;------------------------------------------------------------------
;	MAIN_LOOP
; 


	; set stretch cycles to 4
	mov	a, ckcon
	setb	acc.2			; set md2:1:0 for 1:0:0 = 4
	mov	ckcon, a		; store the new stretch value

	lcall	ECC_CLR			; clear all but command reg
	lcall	ECC_INIT 

	
main_loop:
	mov	dptr, #time_since
	lcall	putstr
    
    	; note the ecc regs are already in BCD format so we can just
    	; call the putbyt routine without any hex to bcd conversion
	mov	dptr, #ECC_HOUR
	movx	a, @dptr		; get it  
	lcall	putbyt1

	mov	a, #colon		; separator
	lcall	putch1


	mov	dptr, #ECC_MIN
	movx	a, @dptr		; get it  
	lcall	putbyt1

	mov	a, #colon		; separator
	lcall	putch1

	mov	dptr, #ECC_SEC
	movx	a, @dptr		; get it  
	lcall	putbyt1 
	
	mov	a, #point		; separator
	lcall	putch1

	mov	dptr, #ECC_HSEC
	movx	a, @dptr		; get it  
	lcall	putbyt1  
	
	mov	a, #cr
	lcall	putch1	 	

	sjmp	main_loop

 
 
       

;------------------------------------------------------------------
;   data definitions
;------------------------------------------------------------------

banner:		db   	cr, lf
		db	'----- HSM/550 TEST PROGRAM TO ACCESS DS1284 CLOCK & CALENDAR -----', cr, lf, 0

revision:	db	'                    Revision 0.4 99 Jun 08 bab'
		db	cr, lf, 0  
		
time_since:	db	'Uptime: ', 0


	INCL	"..\550_io.inc" 
	INCL	"..\ds1284.inc"
	


	END

