;-----------------------------------------------------------------------------
;	DS1284.INC
;
; (C) Copyright 1999 Systronix, Inc All Rights Reserved
;               Systronix, Inc. Salt Lake City, Utah, USA
;               TEL: 801-534-1017  FAX:801-534-1019
;		www.systronix.com  email: support@systronix.com
;		COMPLETE SYSTEMS for RAPID PROTOTYPING    

;
; DESCRIPTION ----------------------------------------------------------------
;
; Include file for the DS1284 Embedded Clock & Calendar (ECC) used in HSM/550
; This is much simpler than the one intended for BASIC use, ALC_1284.INC.
; These are just basic routines to read/write the registers, you are 
; responsible for cross-checking bits such as 12/24 and making sure the time
; also makes sense.
;
; REVISION HISTORY ----------------------------------------------------------- 
;
; 99 Jun 21 [wsk]	Corrected square wave & osc enable bit definitions.
;
; 99 Jun 08 bab	Start
;
;
;
; NOTES AND COMMENTS ---------------------------------------------------------

; DS1284 ECC Addresses

ECC_ADR			equ	0FE00h		; DS1284 at FEXX (base address)
ECC_HSEC		equ	ECC_ADR+0	; msb: .1 sec, lsb: .01 sec
ECC_SEC			equ	ECC_ADR+1	; msb: 10 sec, lsb: 1 sec
ECC_MIN			equ	ECC_ADR+2	; 10 min : min
ECC_MIN_ALRM		equ	ECC_ADR+3	; 10 min : min   
ECC_HOUR		equ	ECC_ADR+4
ECC_HOUR_ALRM		equ	ECC_ADR+5
ECC_DAY			equ	ECC_ADR+6
ECC_DAY_ALRM		equ	ECC_ADR+7
ECC_DATE		equ	ECC_ADR+8
ECC_MONTH		equ	ECC_ADR+9
ECC_YEAR		equ	ECC_ADR+0ah
ECC_CMD                 equ	ECC_ADR+0bh 	; command register
ECC_WD_HSEC             equ	ECC_ADR+0ch 	; countdown alarm .1 sec : .01 sec
ECC_WD_SEC              equ	ECC_ADR+0dh     ; 10 sec : sec
ECC_USER		equ	ECC_ADR+0eh	; user NVRAM OE-3F

;-----------------------------------------------------------------------------
;	ECC_INIT
; Turn on the TE bit then enable the osc and square wave output

ECC_INIT:  

	mov	dptr, #ECC_CMD		; 
	movx	a, @dptr 		;
	setb	acc.7			; set TE
	movx	@dptr, a		; write new value to ecc
	
	mov	dptr, #ECC_MONTH
	movx	a, @dptr
	clr	acc.7			; enable osc so ecc will run
	clr	acc.6			; enable sq wave output     
	movx	@dptr, a		; write new value to ecc
	
	ret

;-----------------------------------------------------------------------------
;	ECC_CLR
; Clear all registers except command reg, including all user NVRAM.
; The leaves the ECC in 24 hour mode. With TE off so we can't read the time.

ECC_CLR:
	mov	dptr, #ECC_ADR
	
ECC_CLR1:
	clr	a  	                              
	movx	@dptr, a 
	inc	dptr 
	mov	a, dpl
	cjne	a, #0BH, ECC_CLR1	; keep clearing until we aim at cmd reg
	inc	dptr			; jump over command reg

ECC_CLR2: 
	clr	a
	movx	@dptr, a 
	inc	dptr 
	mov	a, dpl
	cjne	a, #040H, ECC_CLR2	; go to end of user NVRAM (3F)
	 	
	ret
