; <PRE>
;-----------------------------------------------------------------------------
; HSM/550 I/O DRIVER INCLUDE FILE FOR LT1451 12-BIT DACs
;
;
; (C) Copyright 1998-1999 Systronix, Inc All Rights Reserved
;	Systronix, Inc. Salt Lake City, Utah, USA
;	TEL: 801-534-1017  FAX:801-534-1019  www.systronix.com
;
; Owners of Systronix products are hereby entitled to use, modify, and copy
; this sample program.  You may incorporate all or part of this program in 
; your own commercial products provided they are not simply copies of 
; Systronix products and do not compete directly with Systronix products.  
;
;
; REVISION HISTORY -----------------------------------------------------------
; 
; 99 Jun 07 bab	Ok for HSM/550 boards
; 99 Feb 27 BAB	Modifying for LMSW2 Rev A hardware. Different pin assignments
;		and a third DAC for LCD contrast.
; 98 Mar 16 BAB	Changes for Rev B ALC boards, in which there are two DACs,
;		separately enabled by Chip Select Register bits.
;		A more clever driver could have shared code with just the
;		DAC0 or DAC1 portions determined by the status of the carry
;		or some other flag bit. This would save a few bytes of code
;		but be a bit slower to execute.
; 98 Feb 07 BAB	Start, adapted from DPB2 version of lt1453.inc
;		With 14.7456 crystal, a sweep from 0 to 4095 takes about 400
;		msec on a 'scope. This is about 100 usec per DAC value, or
;		an update rate of about 10 KHz, in a BASIC loop (example
;		program ALC_DAC.BAS).
;
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
; The LT1453 is a single 12-bit DAC with an on-board 1.22 V reference and a
; full-scale output of 2.5 volts. It operates on a single supply of 2.7-5.0
; volts. It has a Dout pin which is used to cascade multiple devices.
; The LT1451 and 1452 have different reference options.
; All versions have a power on reset
;
; Data on the DIN pin is latched on the rising edge of CLK. CS when low
; enables clocking data into the part. Send the data MSB first.
; When CS is pulled high, data is transfered from the input shift register
; into the DAC.
;
; DIN to CLK setup is 60 nsec min. Hold time is 0 nsec. CLK low and high time
; are both 60 nsec min.
;
;
;
;
; HOW TO USE THIS FILE ------------------------------------------------------
;

; If you want to change the I/O pins used to control the DAC, just change
; the BIT assignments such as _dacdin at the top of the driver here.
;
; Be careful with interrupts! Don't call device drivers from within an
; interrupt and outside that interrupt or the one call will get clobbered
; by the other. I/O drivers are not re-entrant.
;----------------------------------------------------------------------------

	

    
_dacdin		BIT	P4.5	; data to DAC
_dacclk		BIT	P4.7	; dac clock
_daccs0		BIT	P4.4	; dac chip select

dac_write0:

; get the dac data 
	mov	A, dac_datl		; get low byte
	mov	R0, A			; save low byte
	mov	A, dac_dath		; get high byte	
	anl	A, #0FH			; mask off any high bits
	mov	R2, A			; save high byte
	; so dac data is now in R0:R2

; initialize the DAC signals
	clr	_dacclk			; clock low
	clr	_daccs0			; ... DAC_CS is now low	

	mov	A, R2			; high byte of dac data (in low nibble)
	swap	A			; put ms data nibble in high bits
	mov     B, #4			; also provides delay after CS low
dacmsb0:
	clr     _dacclk			; clock low
	RLC	A			; rotate bit into C
	mov	_dacdin, C		; move C to data pin
	setb    _dacclk			; clock high
	djnz    B, dacmsb0		; repeat til upper nibble done

	mov	A, R0			; get LSB of dac data
	mov	B, #8			; # of bits to load
daclsb0:
	clr     _dacclk			; clock low
	RLC	A			; rotate bit into C
	mov	_dacdin, C		; move C to data pin
	setb    _dacclk			; clock high
	djnz    B, daclsb0		; repeat til upper nibble done

; update DAC output
	setb	_daccs0			; ... DAC_CS is now high (disabled)
					; and this loads new data into DAC output
	ret

; END of dac_550.inc