;-----------------------------------------------------------------------------
;	DAC_RAMP.ASM
;	HSM/550 test program
;
; (C) Copyright 1999 Systronix, Inc All Rights Reserved
;               Systronix, Inc. Salt Lake City, Utah, USA
;               TEL: 801-534-1017  FAX:801-534-1019
;		www.systronix.com  email: support@systronix.com
;		COMPLETE SYSTEMS for RAPID PROTOTYPING
;
; DESCRIPTION ----------------------------------------------------------------
;
; Sends a ramp wave on the HSM/550 DAC output
;
; REVISION HISTORY -----------------------------------------------------------
; 
; 99 Jun 18 bab	Removing C550 EQUs from ASM file, use controller def instead
; 99 Jun 07 bab making a RAD51 project, cleanup as official example.
; 99 Apr 12 bab	start, adapting for C550
; 98 May 11 bab	clear P1.0 to test custom hardware
; 97 Jul 10 bab 01	Start
;
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
;
;-----------------------------------------------------------------------------
; Baud Rate
;
; For reliable communication the actual baud rate should be within +/- 3% of
; the ideal.
;
; Both the UARTs and Timers have different modes, so don't confuse the UART
; mode with the baud rate generator Timer mode. For our loader, we use UART1
; so that UART0 is left untouched. UART mode 1 is a 10-bit asynch mode
; compatible with RS232 systems. Mode 3 is used for multi-processor
; communication. UART modes 1 and 3 use identical baud rate generation.
;
; UART1 in mode 1 must use Timer1 as a baud rate generator. This is most
; easily done by placing Timer1 in its mode 2, 8-bit auto-reload mode.
; In this mode, when T1 overflows it automatically reloads with the value
; stored in TH1. TL1 does the actual counting. This mode requires no MCU
; overhead since it reloads automatically.
;
; UART Mode 1 and 3 baud rate for UART1 is
; 	baud = (2^SMOD / 32) * Timer1_overflow
; where Timer1 overflow = xtal / ( T1DIV * (256-TH1) )
; T1DIV controlled by T1M bit (CKCON.4), is 12(T1M=0) or 4 (T1M=1)
;
; With Timer1 in 8-bit autoreload mode, solving for TH1:
;	TH1 = 256 - ( (2^SMOD/32) * ( xtal / T1DIV * baud) )
;
; Setting SMOD effectively doubles the baud rate for a given TH1.
; The values below assume T1DIV = 4, and SMOD=1
;		--xtal-	-baud- 	-TH1-  	-error-
;		11.0592	57600	FDH	0
;			19200	F7H	0
;			 9600	EEH	0
;			
;		14.7456	115K	FEH	-0.17%
;			57600	FCH	0
;			38400	FAH	0
;			19200	F4H	0
;			 9600	E8H	0
;
;		22.1184	115K	FDH	-0.17%
;			57600	FAH	0
;			38400	F7H	0
;			19200	EEH	0
;			 9600	DCH	0
;
;	25.0000	38400	F6		-1.7%
;			19200	ECH	-1.7%
;			 9600	D7H	0.76
;
;	33.0000	115K	FCH		-11% forget it
;			57600	F7H	0.54
;			38400	F3H	-3.19% marginal
;			19200	E5H	0.54
;			 9600	CAH	0.54
;
; change the baud rate here in this equate

baud_rate       equ     0E5H 		; 33.0000, 19200
;baud_rate       equ     0F4H 		; 14.7456 19200
;baud_rate       equ     0EEH 		; 11.0592, 9600 or 22.1184 19200

;-----------------------------------------------------------------------------
;       ascii equates 
;-----------------------------------------------------------------------------
ctrlc   equ	003h               	; control c
bs      equ	008h               	; back space 
tab     equ	009h              	; horizontal tab, ^i 
lf      equ	00ah			; line feed
cr      equ	00dh			; carriage return
xon     equ	011h            	; rs232 protocol ^q
xoff    equ	013h			; rs232 protocol ^s
spa     equ	020h			; space
colon   equ	03ah			; ':'
amp	equ	040h			; '@
ques	equ	03fh			; '?'
slash	equ	02fh			; '/'
del	equ	07fh             	; delete character 

 

;------------------------------------------------------------------
;	Internal DATA used by program

; data data is 12 bits, allowed values are 0-4095 (FFFH)
dac_datl	EQU	09H	; lsb (0-ff)	
dac_dath	EQU	10H	; this is the msb (0-F)



;------------------------------------------------------------------
; Reset Vector
;------------------------------------------------------------------
	org	0h			; reset vector
	ajmp	start

					; can org other interrupt vectors here

start:
	mov	SP, #0AH		; above data we're using
	orl	wdcon, #080H		; Turn on the SMOD bit for serial port 1
        mov     scon1, #050h            ; serial mode 1, 8 data, 1 start,stop
        mov     tmod, #021h             ; timers 0-16 bit; 1-8 bit reload
        mov	th1,  #baud_rate	; from baud rate calculation
        orl	ckcon, #010H		; set T1M so T1DIV is 4 instead of 12
        mov     tcon, #050h             ; timer on

        mov	scon, #050h
        orl	pcon, #80h		; set SMOD bit for 

sl_init:
        clr	a
	mov	ie,a			;Disable all interrupts.
	mov	eie, a			; c550 extended interrupts
        clr	ti_1		     	;Clear ri1, ti1 just to be safe.
        clr	ri_1
        clr	ri_0
        clr	ti_0

        mov	dac_datl, #0		; init dac_data
        mov	dac_dath, #0

	mov	a, #1			; select uart1
  	mov	dptr,#dac_test		; uart1 message	
	lcall	putstr			; send it

	mov	a, #0			; select uart0
  	mov	dptr,#dac_test		; uart1 message	
	lcall	putstr			; send it  	

main_loop:
	cpl	P1.0
	lcall	dac_write0

	inc	dac_datl
	mov	a, dac_datl
	jnz	main_loop		; if acc is 0, lsb overflowed
	inc	dac_dath		; so incr the msb
	
	ljmp	main_loop		; repeat forever





        

;------------------------------------------------------------------
;   data definitions
;------------------------------------------------------------------

dac_test:	db	cr, lf
		db	'DAC Test 99 Jun 08 bab', cr, lf
		db	'Ramps DAC over entire range. Repeats forever.', cr, lf
		db	'This creates a sawtooth wave output.', cr, lf, 0


	INCL	"..\dac_550.inc"  
	INCL	"..\550_io.inc"


	END

