;*****************************************************************************
;
; 32-BIT UNSIGNED INTEGER MATH INCLUDE FILE
;
; Based on Intel's 32-bit math application note. In appreciation to Intel for
; making this code available, Systronix is providing the modified version
; of this file free of charge.
;
; (C) Copyright 1994-1996 Systronix, Inc All Rights Reserved
;               Systronix, Inc. Salt Lake City, Utah, USA
;               TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
;				www.systronix.com	email: support@systronix.com
;
; Owners of Systronix products are hereby entitled to use, modify, and copy
; this sample program.  You may incorporate all or part of this program in 
; your own commercial products provided they are not simply copies of 
; Systronix products and do not compete directly with Systronix products.  
; This program is provided by Systronix free of charge and may not be resold.
;
; This program is intended for those of you who are using the Systronix
; BCI51 Pro BASIC compiler for 8051s and Dallas Semiconductor Soft/Secure
; microcontrollers. This Rapid Development Software works especially well with
; our DPB2 Rapid Development Board.  This card is an easy to use development
; system for the Dallas DS5000/1/2 DS2250/1/2 and -T suffix soft/secure 
; microcontrollers.  If you'd like more information, please call
; or FAX us at the numbers above. Data sheets and photos are also available
; on the Internet at www.systronix.com
;
; REVISION HISTORY -----------------------------------------------------------
;
; 96 Jun 28 bab	1.1 Multiply and divide work properly.
;					Wrote routines to load and save 16-bit values from
;					external data memory, which eases interface to
;					BCI51 BASIC variables.
;
; 96 Jun 27	bab	1.0	Start, based on Intel's application note AB-40 in the
;					1988 Embedded Applications databook, page 2-166.
;					Modified for Systronix A51 assembler.
;
;
; DESCRIPTION ----------------------------------------------------------------
;
; These routines perform 32-bit unsigned integer math. Be sure to read the
; notes on byte ordering and ISTACK START below.
;
; BCI51's largest data type is a 16-bit unsigned integer, 0-65535 (0-0FFFFH).
; BCI51 currently has no 32-bit variables and this file does not add them.
; In order to use these routines with BCI51 variables, arrange your calculation
; so that you can begin and end with 16-bit variables. For many applications this
; is not a limitation.
;
; These routines let you operate on 12- or 16- bit data, perform
; 32-bit calculations with 32-bit intermediate results, and then read back
; any 16 bits of the 32-bit result. With care, the upper 16 bits of the 32-
; bit result will be zero. For example, these routines can perform a
; calculation such as:
;		PULSES = (DISPENSE_X10 * PULSES_100CC) / SCALE
; 	where DISPENSE_X10 can be 0 to 15000,
; 	PULSES_100CC can be 2901 to 14505
; 	SCALE is 1000, and the result PULSES can be 0 to 43515
; These operands and results are all 16-bit but the intermediate result
; must be 32-bit in order to avoid overflow and truncation of the result.
;
; Math Routines: -------------------------------------------------------------
;	LCALL these routines after you have stored both operands in the
;	appropriate registers. Results are all 32 bits.
;
;	Add_16 	adds 16 bits in Add_16byte to the 32-bit OP registers, 
;			result in OP registers
;	Add_32 	adds 32 bits in Add_32byte to the 32-bit OP registers,
;			result in OP registers
;	Sub_16 	subtracts 16 bits in Sub_16byte from the 32-bit OP registers, 
;			result in OP registers
;	Sub_32 	subtracts 32 bits in Sub_32byte from the 32-bit OP registers,
;			result in OP registers
;	Mul_16 	Multiplys 16 bits in Mul_16byte with the 32-bit OP registers, 
;			result in OP and TMP registers
;	Div_16 	Divides the 16 bits in Div_16byte into the 32-bit OP registers, 
;			result in OP and TMP registers
;
; Data Routines: -------------------------------------------------------------
;	LCALL these routines to initialize the operands and retrieve the results.
;	If you are doing a series of 32-bit math, you can leave intermediate
;	results in the OP registers and call other calculation routines with
;	new operands.
;
;	Routines ending in "X" use external data (assy code movx instuctions).
;
;
;	Load_16X	Load 16 bits of BCI51 variable from XDATA into OP register
;				Call this with DPTR pointing at a BCI51 unsigned integer variable
;				This routine performs all needed byte ordering
;	Load_Mul16X	Load 16 bits of BCI51 variable from XDATA into Mul16 register
;				Call this with DPTR pointing at a BCI51 unsigned integer variable
;				This routine performs all needed byte ordering
;	Load_Div16X	Load 16 bits of BCI51 variable from XDATA into Div16 register
;				Call this with DPTR pointing at a BCI51 unsigned integer variable
;				This routine performs all needed byte ordering
;	Load_Sub16X	Load 16 bits of BCI51 variable from XDATA into Sub16 register
;				Call this with DPTR pointing at a BCI51 unsigned integer variable
;				This routine performs all needed byte ordering
;
;	The following Low_16X, Mid_, and High_ routines are used to store 16 bits
;	of the 32-bit OP register into a BCI51 BASIC variable in XDATA memory.
;
;	Low_16X		Return the lower 16 bits of OP registers to DPTR location L:H
; 				Call this with DPTR pointing at a BCI51 unsigned integer variable
;				This routine performs all needed byte ordering
;	Mid_16X		Return the middle 16 bits of OP registers to DPTR location L:H
; 				Call this with DPTR pointing at a BCI51 unsigned integer variable
;				This routine performs all needed byte ordering
;	High_16X	Return the high 16 bits of OP registers to DPTR location L:H
; 				Call this with DPTR pointing at a BCI51 unsigned integer variable
;				This routine performs all needed byte ordering.
;
;	These routines are useful for saving and reusing 32-bit intermediate results.
;	Load_32		Load 32 bits from IRAM location Load_32byte into op registers
;	Save_32		Store 32 bits from op registers into IRAM location Load_32byte
;
;	These are original Intel routines which may not be too useful to BCI51.
;	They have been commented out in the source code.
;	Load_16		Load 16 bits from IRAM location Load_16byte into op registers
;	Low_16		Return the lower 16 bits of OP registers (OP_0:OP_1) in R7:R6 L:H
;	Mid_16		Return the middle 16 bits of OP registers (OP_1:OP_2) in R7:R6 L:H
;	High_16		Return the high 16 bits of OP registers in (OP_2:OP_3) R7:R6 L:H
;
;
; TERMINOLOGY & CONVENTIONS --------------------------------------------------
;
; Byte Ordering:
; The registers Mul_16, etc are stored H:L where Mul_16 is the msb and
; Mul_16+1 holds the lsb. On the other hand, the operation registers
; OP_ and TMP are stored L:H where OP_0 is the lsb and OP_3 is the msb.
; Yes this is confusing and no, it's not my fault.
;
; "XDATA" and "XRAM" refer to external data memory, accessed with a MOVX
; "IRAM" refers to internal data memory, accessed with a MOV
;
;
; DESIRED MODIFICATIONS ------------------------------------------------------
;
; Change the Mul_16byte, Div_, etc and the _32byte to a single Operand_16
; and Operand_32. This would cut down on IRAM use by 10 bytes. Write a
; routine Load_Op16X to load Operand_16 from a BCI51/DPTR variable.
;
; Maybe a BASIC-callable series of routines where 16-bit BASIC values are
; passed. Could use names such as OP16 for an operand. A gosub LOAD16 loads
; OP16 in the opregs. Then setting OP16 to a different value and a gosub
; MUL16 multiplies the opreg value by the current OP16 value, leaving the
; result in the opregs. Then routines such as OP_RD_16L read the 16 low bits
; from the opregs into OP16. OP_WR_16L would write the OP16 value into the
; low 16 bits of the opregs (instead of LOAD16). It would really be nice to
; have BASIC routines supporting passed parameters. Then we could have a
; gosub MUL16(OP1, OP2).
;
; Add an overflow and underflow detection flag.
;
;
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
; This file was created with tab stops every 4 characters
;
;-----------------------------------------------------------------------------

; If this file is accidentally included in line with BASIC code, this BASIC
; GOTO causes execution to safely jump over it.
; To be safe, #include this file after your BASIC "END" statement
GOTO MATH_32_END

;-----------------------------------------------------------------------------
; Internal Data Memory Workspace (30 bytes)
;
; These "opregs" are not the 8051 register bank, just the internal data
; memory of the 8051.
;
; CAUTION: we are changing BCI51's use of ISTACK to allow for 30 bytes of
; internal data ram as 32-bit math workspace! We are assuming that
; the default istack start is 30H, which is true for Dallas soft micros.
; This may not be true for all targets. Compile with the -p option, look
; in the .PRE file and check the default value of istack start before
; increasing it.
;-----------------------------------------------------------------------------

#ASM

; MATH32_REGS must equal the default istack start for your program!
; Then you must also change istack start to its default plus 30 bytes
; This reserves 30 bytes of internal data space for the 32-bit math.
;
MATH32_REGS		EQU	30H							; start of our internal RAM use

Load_16byte 	EQU MATH32_REGS					; 2 bytes stored H:L
Load_32byte 	EQU MATH32_REGS + 2				; 4 bytes stored H:L
Mul_16byte  	EQU MATH32_REGS + 6				; 2 bytes stored H:L
Div_16byte 		EQU MATH32_REGS + 8				; 2 bytes stored H:L
Add_16byte 		EQU MATH32_REGS + 10			; 2 bytes stored H:L
Sub_16byte 		EQU MATH32_REGS + 12			; 2 bytes stored H:L
Add_32byte 		EQU MATH32_REGS + 14			; 4 bytes stored H:L						
Sub_32byte 		EQU MATH32_REGS + 18			; 4 bytes stored H:L

; OP_X is the "op register" for 16- and 32- bit operands
; _0 is the least significant byte, _3 is most significant
OP_0			EQU MATH32_REGS + 22			; lsb of OP
OP_1     		EQU MATH32_REGS + 23
OP_2     		EQU MATH32_REGS + 24
OP_3     		EQU MATH32_REGS + 25			; msb of OP
TMP_0    		EQU MATH32_REGS + 26			; lsb of TMP
TMP_1  			EQU MATH32_REGS + 27
TMP_2   		EQU MATH32_REGS + 28
TMP_3   		EQU MATH32_REGS + 29			; msb of TMP

; Total of 30 bytes are used


;
Load_16X:
	; Load 16 bits from XDATA memory into OP register
	; Load the lower 16 bits of the OP registers with value pointed to by DPTR
	; fill upper two bytes with zeros
	; call this with DPTR pointing at a BCI51 variable in xdata, L:H
	MOVX	A, @DPTR					; get low byte in acc
	MOV		OP_0, A						
	INC		DPTR
	MOVX	A, @DPTR					; get high byte in acc
	MOV		OP_1, A						 						
	MOV     OP_2,#0						; zero out highest bytes
	MOV     OP_3,#0
	RET

Load_Mul16X:
	; Load 16 bits from XDATA memory into Mul16 register H:L
	; call this with DPTR pointing at a BCI51 variable in xdata, L:H
	MOVX	A, @DPTR					; get low byte in acc
	MOV		Mul_16byte+1, A				; get low byte into mul16 regs			
	INC		DPTR
	MOVX	A, @DPTR					; get high byte in acc
	MOV		Mul_16byte, A				; get high byte into mul16 regs		 						
	RET

Load_Div16X:
	; Load 16 bits from XDATA memory into Div16 register H:L
	; call this with DPTR pointing at a BCI51 variable in xdata, L:H
	MOVX	A, @DPTR					; get low byte in acc
	MOV		Div_16byte+1, A				; get low byte into div16 regs			
	INC		DPTR
	MOVX	A, @DPTR					; get high byte in acc
	MOV		Div_16byte, A				; get high byte into div16 regs		 						
	RET

Load_Sub16X:
	; Load 16 bits from XDATA memory into Sub16 register H:L
	; call this with DPTR pointing at a BCI51 variable in xdata, L:H
	MOVX	A, @DPTR					; get low byte in acc
	MOV		Sub_16byte+1, A				; get low byte into Sub16 regs			
	INC		DPTR
	MOVX	A, @DPTR					; get high byte in acc
	MOV		Sub_16byte, A				; get high byte into Sub16 regs		 						
	RET

Load_Add16X:
	; Load 16 bits from XDATA memory into Add16 register H:L
	; call this with DPTR pointing at a BCI51 variable in xdata, L:H
	MOVX	A, @DPTR					; get low byte in acc
	MOV		Add_16byte+1, A				; get low byte into Add16 regs			
	INC		DPTR
	MOVX	A, @DPTR					; get high byte in acc
	MOV		Add_16byte, A				; get high byte into Add16 regs		 						
	RET			

Load_16:
		; Load 16 bits from Load_16byte IRAM location into OP register
        ;Load the lower 16 bits of the OP registers with the value supplied
        MOV     OP_3,#0
        MOV     OP_2,#0
        MOV     OP_1,Load_16byte
        MOV     OP_0,Load_16byte + 1
        RET
 
Load_32:
	;Load all the OP registers with the value supplied in Load_32byte
	MOV     OP_3,Load_32byte
	MOV     OP_2,Load_32byte + 1
	MOV     OP_1,Load_32byte + 2
	MOV     OP_0,Load_32byte + 3
	RET

Save_32:
	;Save 32-bit value from OP egisters to Load_32byte
	MOV     Load_32byte,OP_3
	MOV     Load_32byte + 1,OP_2
	MOV     Load_32byte + 2,OP_1
	MOV     Load_32byte + 3,OP_0
	RET

;Low_16:
;	;Return the lower 16 bits of the OP registers
;	MOV     R6,OP_1
;	MOV     R7,OP_0
;	RET

Low_16X:
	; Return the lower 16 bits of OP registers to DPTR location L:H
	; Call with DPTR pointing at place you want the 16 bits stored
	MOV		A, OP_0
	MOVX	@DPTR, A					; store lsb
	INC		DPTR
	MOV		A, OP_1
	MOVX	@DPTR, A					; store msb
	RET
 
;Mid_16:
;	;Return the middle 16 bits of the OP registers
;	MOV     R6,OP_2
;	MOV     R7,OP_1
;	RET

Mid_16X:
	; Return the middle 16 bits of OP registers to DPTR location L:H
	; Call with DPTR pointing at place you want the 16 bits stored
	MOV		A, OP_1
	MOVX	@DPTR, A					; store lsb
	INC		DPTR
	MOV		A, OP_2
	MOVX	@DPTR, A					; store msb
	RET

;High_16:
;	;Return the high 16 bits of the OP registers
;	MOV     R6,OP_3
;	MOV     R7,OP_2
;	RET

High_16X:
	; Return the high 16 bits of OP registers to DPTR location L:H
	; Call with DPTR pointing at place you want the 16 bits stored
	MOV		A, OP_2
	MOVX	@DPTR, A					; store lsb
	INC		DPTR
	MOV		A, OP_3
	MOVX	@DPTR, A					; store msb
	RET


        
;
Add_16:
        ;Add the 16 bits supplied by the caller to the OP registers
        CLR     C
        MOV     A,OP_0
        ADDC    A,Add_16byte + 1      ;low byte first
        MOV     OP_0,A
        MOV     A,OP_1
        ADDC    A,Add_16byte          ;high byte + carry
        MOV     OP_1,A
        MOV     A,OP_2
        ADDC    A,#0                            ;propagate carry only
        MOV     OP_2,A
        MOV     A,OP_3
        ADDC    A,#0                            ;propagate carry only
        MOV     OP_3,A
        RET
 
 
Add_32:
        ;Add the 32 bits supplied by the caller to the OP registers
        CLR     C
        MOV     A,OP_0
        ADDC    A,Add_32byte + 3      ;lowest byte first
        MOV     OP_0,A
        MOV     A,OP_1
        ADDC    A,Add_32byte + 2      ;mid-lowest byte + carry
        MOV     OP_1,A
        MOV     A,OP_2
        ADDC    A,Add_32byte + 1      ;mid-highest byte + carry
        MOV     OP_2,A
        MOV     A,OP_3
        ADDC    A,Add_32byte          ;highest byte + carry
        MOV     OP_3,A
        RET
;
Sub_16:
	;Subtract the 16 bits supplied by the caller from the OP registers
	CLR     C
	MOV     A,OP_0
	SUBB    A,Sub_16byte + 1			;low byte first
	MOV     OP_0,A
	MOV     A,OP_1
	SUBB    A,Sub_16byte				;high byte + carry
	MOV     OP_1,A
	MOV     A,OP_2
	SUBB    A,#0						;propagate carry only
	MOV     OP_2,A
	MOV     A,OP_3
	SUBB    A,#0						;propagate carry only
	MOV     OP_3,A
	RET
 
 
Sub_32:
        ;Subtract the 32 bits supplied by the caller from the OP registers
        CLR     C
        MOV     A,OP_0
        SUBB    A,Sub_32byte + 3      ;lowest byte first
        MOV     OP_0,A
        MOV     A,OP_1
        SUBB    A,Sub_32byte + 2      ;mid-lowest byte + carry
        MOV     OP_1,A
        MOV     A,OP_2
        SUBB    A,Sub_32byte + 1      ;mid-highest byte + carry
        MOV     OP_2,A
        MOV     A,OP_3
        SUBB    A,Sub_32byte          ;highest byte + carry
        MOV     OP_3,A
        RET
;
Mul_16:
        ;Multiply the 32 bit OP with the 16 value supplied
        MOV     TMP_3,#0        ;clear out upper 16 bits
        MOV     TMP_2,#0
        ;Generate the lowest byte of the result
        MOV     B,OP_0
        MOV     A,Mul_16byte+1
        MUL     AB
        MOV     TMP_0,A         ;low-order result
        MOV     TMP_1,B         ;high_order result
        ;Now generate the next higher order byte
        MOV     B,OP_1
        MOV     A,Mul_16byte+1
        MUL     AB
        ADD     A,TMP_1         ;low-order result
        MOV     TMP_1,A         ; save
        MOV     A,B             ; get high-order result
        ADDC    A,TMP_2         ; include carry from previous operation
        MOV     TMP_2,A         ; save
        JNC     Mul_loop1
        INC     TMP_3           ; propagate carry into TMP_3
Mul_loop1:
        MOV     B,OP_0
        MOV     A,Mul_16byte
        MUL     AB
        ADD     A,TMP_1         ;low-order result
        MOV     TMP_1,A         ; save
        MOV     A,B             ; get high-order result
        ADDC    A,TMP_2         ; include carry from previous operation
        MOV     TMP_2,A         ; save
        JNC     Mul_loop2
        INC     TMP_3           ; propagate carry into TMP_3
Mul_loop2:
        ; Now start working on the 3rd byte
        MOV     B,OP_2
        MOV     A,Mul_16byte+1
        MUL     AB
        ADD     A,TMP_2         ;low-order result
        MOV     TMP_2,A         ; save
        MOV     A,B             ; get high-order result
        ADDC    A,TMP_3         ; include carry from previous operation
        MOV     TMP_3,A         ; save
        ; Now the other half
        MOV     B,OP_1
        MOV     A,Mul_16byte
        MUL     AB
        ADD     A,TMP_2         ;low-order result
        MOV     TMP_2,A         ; save
        MOV     A,B             ; get high-order result
        ADDC    A,TMP_3         ; include carry from previous operation
        MOV     TMP_3,A         ; save
        ; Now finish off the highest order byte
        MOV     B,OP_3
        MOV     A,Mul_16byte+1
        MUL     AB
        ADD     A,TMP_3         ;low-order result
        MOV     TMP_3,A         ; save
        ; Forget about the high-order result, this is only 32 bit math!
        MOV     B,OP_2
        MOV     A,Mul_16byte
        MUL     AB
        ADD     A,TMP_3         ;low-order result
        MOV     TMP_3,A         ; save
        ; Now we are all done, move the TMP values back into OP
        MOV     OP_0,TMP_0
        MOV     OP_1,TMP_1
        MOV     OP_2,TMP_2
        MOV     OP_3,TMP_3
        RET
;
Div_16:
        ;This divides the 32 bit OP register by the value supplied
        MOV     R7,#0
        MOV     R6,#0           ;zero out partial remainder
        MOV     TMP_0,#0
        MOV     TMP_1,#0
        MOV     TMP_2,#0
        MOV     TMP_3,#0
        MOV     R1,Div_16byte ;load divisor
        MOV     R0,Div_16byte+1
        MOV     R5,#32          ;loop count
        ;This begins the loop
Div_loop:
        LCALL	Shift_D         ;shift the dividend and return MSB in C
        MOV     A,R6            ;shift carry into LSB of partial remainder
        RLC     A
        MOV     R6,A
        MOV     A,R7
        RLC     A
        MOV     R7,A
        ;now test to see if R7:R6 >= R1:R0
        CLR     C
        MOV     A,R7            ;subtract R1 from R7 to see if R1 < R7
        SUBB    A,R1            ; A = R7 - R1, carry set if R7 < R1
        JC      Cant_sub
        ;at this point R7>R1 or R7=R1
        JNZ     Can_sub         ;jump if R7>R1
        ;if R7 = R1, test for R6>=R0
        CLR     C
        MOV     A,R6
        SUBB    A,R0            ; A = R6 - R0, carry set if R6 < R0
        JC      Cant_sub
Can_sub:
        ;subtract the divisor from the partial remainder
        CLR     C
        MOV     A,R6
        SUBB    A,R0            ; A = R6 - R0
        MOV     R6,A
        MOV     A,R7
        SUBB    A,R1            ; A = R7 - R1 - Borrow
        MOV     R7,A
        SETB    C               ; shift a 1 into the quotient
        LJMP	Quot
Cant_sub:
        ;shift a 0 into the quotient
        CLR     C
Quot:
        ;shift the carry bit into the quotient
        LCALL  	Shift_Q
        ; Test for competion
        DJNZ    R5,Div_loop
        ; Now we are all done, move the TMP values back into OP
        MOV     OP_0,TMP_0
        MOV     OP_1,TMP_1
        MOV     OP_2,TMP_2
        MOV     OP_3,TMP_3
        RET
;
Shift_D:
        ;shift the dividend one bit to the left and return the MSB in C
        CLR     C
        MOV     A,OP_0
        RLC     A
        MOV     OP_0,A
        MOV     A,OP_1
        RLC     A
        MOV     OP_1,A
        MOV     A,OP_2
        RLC     A
        MOV     OP_2,A
        MOV     A,OP_3
        RLC     A
        MOV     OP_3,A
        RET
 
Shift_Q:
        ;shift the quotent one bit to the left and shift the C into LSB
        MOV     A,TMP_0
        RLC     A
        MOV     TMP_0,A
        MOV     A,TMP_1
        RLC     A
        MOV     TMP_1,A
        MOV     A,TMP_2
        RLC     A
        MOV     TMP_2,A
        MOV     A,TMP_3
        RLC     A
        MOV     TMP_3,A
        RET

#ASM_END

MATH_32_END: