;*****************************************************************************
;
; 32-BIT MATH EXAMPLE
;
;
; (C) Copyright 1994-1996 Systronix, Inc All Rights Reserved
;               Systronix, Inc. Salt Lake City, Utah, USA
;               TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
;				www.systronix.com	email: support@systronix.com
;
; Owners of Systronix products are hereby entitled to use, modify, and copy
; this sample program.  You may incorporate all or part of this program in 
; your own commercial products provided they are not simply copies of 
; Systronix products and do not compete directly with Systronix products.  
; This program is provided by Systronix free of charge and may not be resold.
;
; This program is intended for those of you who are using the Systronix
; BCI51 Pro BASIC compiler for 8051s and Dallas Semiconductor Soft/Secure
; microcontrollers. This Rapid Development Software works especially well with
; our DPB2 Rapid Development Board.  This card is an easy to use development
; system for the Dallas DS5000/1/2 DS2250/1/2 and -T suffix soft/secure 
; microcontrollers.  If you'd like more information, please call
; or FAX us at the numbers above. Data sheets and photos are also available
; on the Internet at www.systronix.com
;
; REVISION HISTORY -----------------------------------------------------------
;
; 96 Sep 05	bab	1.1	Released to our Internet site.
; 96 Aug 30	bab	1.1	Adding other operations
; 96 Jun 27	bab	1.0	Start
;
;
;
; DESCRIPTION ----------------------------------------------------------------
;
; Uses 16-bit unsigned integer variables as input and produces a 16-bit
; unsigned integer result. The intermediate math is 32-bit to provide
; necessary range for partial results. No 32-bit variables are available.
;
; What's in this example:
;
;
;
; DESIRED MODIFICATIONS ------------------------------------------------------
;
;
;
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
; This file was created with tab stops every 4 characters
;
;
;
;-----------------------------------------------------------------------------

#target DS2250T
#console mode=19200
#xtal 11059200

#code start 0H
#data start 6000H


; CAUTION: we are changing istack start here to allow for 32 bytes of
; internal data ram as 32-bit math workspace! We are assuming that
; the default istack start is 30H, which is true for Dallas soft micros.
; This is NOT true for BASIC-52 or possibly other targets.
; 30H + 20H = 50H

#istack start 50H

;-----------------------------------------------------------------------------
; GENERAL PROGRAM VARIABLES
;-----------------------------------------------------------------------------

string REVISION$(8)								; revision level of this code

REVISION$ = "1.1"



;-----------------------------------------------------------------------------
; Voltage Calculation Example
;
; This example uses a 12-bit input value presumably from an ADC such as
; the TLC2543 which Systronix uses and supports.
; If the input value from the ADC is 0-4096, and this really represents 
; 0-10 volts, we'd like to display the value as a voltage in something
; that looks like a decimal form.
; Perhaps the easiest way to do this is to scale 10 volts to 10,000,000.
; This gives us the precision of 10.000000 volts. We are scaling the volts
; by 10E6, or a factor of one million.
; Then we divide 10E6 by 4095 to give us 2442 VOLTS_X1M per ADC bit.
; So to calculate the VOLTS_X1M we multiply the raw ADC input by 
; the variable SCALE. SCALE in our case is 2442, but in the general
; case this might be a calibration value which changes occaissionally.
; This gives us a value of 0-9,999,999 for ADC input of 0-4095.
; To get the whole part of the voltage reading we divide the result 
; by 1,000,000. The value of "whole" is therefore 0-9.
; To get the fractional part we subtract the (whole x 10E6)
; from the scaled value, giving us 0-999,999 and divide the result by 
; 1000. This fractional value therefore has a range of 0-999.
; We can print the value of whole, then a period, then the value of fraction
; so that it looks like: 0.000 to 9.999 volts.
;
; Here are the equations which accomplish the above:
;
; SCALE = 2442
;
; VOLTS_X1M = ADC_RAW * SCALE
; 16x16 mult, 32-bit result
;
; WHOLE = VOLTS_X1M / 1000000
; 32-bit value divided by 32-bits, with 16 bit result
; We may have to do this as two 32/16 divides
;
; FRACT = (VOLTS_X1M - (WHOLE * 1000000) ) / 1000
; (WHOLE * 1000000) is a 16x16 mult, 32-bit result
; 32-bit subtraction, divided by 16 bits, 16-bit result
; Our life is easier if we divide each term of the subtraction by
; 1000 first and then subtract:
; FRACT = VOLTS_X1M/1000 - (WHOLE * 1000)
; Now each term of the subtraction will fit in a 16-bit integer.
; This is simpler than saving and restoring 32-bit intermediate
; results.
;
; Note that VOLTS_X1M is a 32-bit value and is therefore not a BCI51
; BASIC variable. It is stored in a temporary working 32-bit "register".
;
;
;-----------------------------------------------------------------------------


unsigned integer ADC_RAW

unsigned integer WHOLE, FRACT

unsigned integer SCALE, SCALE2

SCALE = 2442						; The ADC reading to voltage factor
SCALE2 = 1000						; scale2 * scale2 = 1 million

; Start up delay needed for the example program...
; This gives the Dallas loader time to switch the PC serial port
; from program to terminal mode before we start sending
; it characters. Take this out if you don't use the Dallas loader.
msec=0
clock1
do : until msec > 500

ONERR ERROR_HANDLER

print
print "32-Bit Math Example - Revision ", REVISION$
print "Tests 16x16 multiply, 32/16 divide and 32-16 subtract"
print

	ADC_RAW = 4095					; start at the maximum value

VOLTAGE_LOOP:

#ASM
	MOV	DPTR, #__ADC_RAW			; put in the math32 op regs
	LCALL	Load_16X				

	MOV	DPTR, #__SCALE				; we store this L:H
	LCALL	Load_Mul16X				; now Mul_16byte holds the value H:L
	LCALL	Mul_16					; 32 bit result in OP and TMP

	; now the value "VOLTS_X1M" is in the 32-bit TMP and OP "registers"
	; save it in Load_32byte for later re-use
	LCALL Save_32

	MOV	DPTR, #__SCALE2				; we store this L:H
	LCALL	Load_Div16X				; now Div_16byte holds the value H:L
	LCALL	Div_16					; 32 bit result in OP and TMP
	LCALL	Div_16

	; now we have divided by scale2 twice, 1000x1000 = 1000000
	; now the OP reg holds the value of WHOLE
	MOV		DPTR, #__WHOLE
	LCALL	Low_16X					; get 16 low bits of result

	MOV		DPTR, #__WHOLE
	LCALL	Load_16X
	
	MOV	DPTR, #__SCALE2				; we store this L:H
	LCALL	Load_Mul16X				; now Mul_16byte holds the value H:L
	LCALL	Mul_16					; 32 bit result in OP and TMP
	; now OP reg has WHOLE x 10000
	mov		DPTR, #__FRACT
	LCALL	Low_16X					; now FRACT holds WHOLE * 1000

	LCALL	Load_32					; get "VOLTS_X1M" back into op registers
	MOV	DPTR, #__SCALE2				; we store this L:H
	LCALL	Load_Div16X				; now Div_16byte holds the value H:L
	LCALL	Div_16					; "VOLTS_X1M"/1000, 32 bit result in OP and TMP	

	mov		DPTR, #__FRACT			; get back WHOLE * 1000
	LCALL	Load_Sub16X				; WHOLE * 1000 in the Sub register
	LCALL	Sub_16					; Do it: VoltsX1000 - WholeX1000, result in OP

	mov		DPTR, #__FRACT
	LCALL	Low_16X					; now FRACT holds the fractional part of voltage	


#ASM_END


	print "ADC raw = ", ADC_RAW, "  Voltage = ", WHOLE, ".",

	; FRACT can be 0-999 in this example, we always want to display 3 digits
	; especially with leading zeros - a FRACT value of 50 is really 050
	; otherwise 8.050 will display incorrectly as 8.50 and 001 as 8.1
	if FRACT < 100 then print "0",
	if FRACT < 10 then print "0",
	print FRACT, " volts"

	IF ADC_RAW > 0 THEN 
		ADC_RAW = ADC_RAW -1
		GOTO VOLTAGE_LOOP
	ELSE
		print "Done"
	ENDIF


END


;-----------------------------------------------------------------------------
;
; RUN-TIME ERROR HANDLER
;
;-----------------------------------------------------------------------------

ERROR_HANDLER:

? "Serious error ", ERRVALUE
? "Add your own code here"

GOTO ERROR_HANDLER

#include "MATH32.INC"


; Note there is a bug in BCI51 which sometimes generates an unrecognized input
; error after a #include if it is the last line in your .BAS file. Adding a comment
; or blank lines or any whitespace such as spaces or tabs works around the problem.