;-----------------------------------------------------------------------------
;
; TEST PROGRAM for DPB2 REVE
;
; SCC2691 UART added in Prototype Area
;
; Supported: DPB2 main RS232 I/O, and added RS232 I/O with 2691 UART,
;	using BCI51 UI and UO instructions
;
; (C) Copyright 1997 Systronix, Inc All Rights Reserved
;	Systronix, Inc. Salt Lake City, Utah, USA
;	TEL: 801-534-1017  FAX:801-534-1019  www.systronix.com
;
; Owners of Systronix products are hereby entitled to use, modify, and copy
; this sample program.  You may incorporate all or part of this program in 
; your own commercial products provided they are not simply copies of 
; Systronix products and do not compete directly with Systronix products.  
; This program is provided by Systronix free of charge and may not be resold.
;
; REVISION HISTORY -----------------------------------------------------------
;
; 98 Apr 08 BAB	Start, modified from old 2691 test program for Iota boards.
;	This version assumes DPB2 and BCI51 Pro
;
; DESCRIPTION & INSTRUCTIONS -------------------------------------------------
;
; This program uses every combination of default serial I/O and user I/O to
; show how this can be done. It's also sort of a worst-case test. If this
; program works on your hardware, most any application program which
; uses UI and UO should too, since it's likely to be less exhaustive than
; this test program. In particular, you will normally switch to UI and UO at
; the same time, and not have one of them active with the other default serial
; I/O active.
;
; Since default serial I/O can be active or not for input and output, and
; so can user I/O, that generates four possibilities:
;	1) default output, default input
;	2) default output, user input
;	3) User output and input
;	4) Default input, user output
;
; These are tested in the above order. <space bar> moves to the next test.
; After the last test, execution returns to the beginning.
;
; CAUTION --------------------------------------------------------------------
;
; Read the comments in the USER2691.SRC file regarding I/O pins used.
; Be sure this use is compatible with other I/O drivers you may be using at
; the same time. This is an example program, it's not intended to be perfect,
; just useful.
;
;-----------------------------------------------------------------------------

#target DS2252T
#code start 0000h
#data start 0000h

#console mode=19200

unsigned integer uc
signed integer x
string str1$[16]


; Give Dallas loader time to switch to terminal emulator
; This prevents the terminal emulator missing our first
; few print chars. 500 msec is enough, 250 msec is not.
;
msec = 0
clock1
do : until (msec > 500)


TOP:

? 
? "UI/UO example program for BCI51 Pro and DPB2 with SCC2691 added"
? "You MUST have USER2691.SRC copied to USER.SRL before you compile,"
? "in order for the 2691 driver to be used in your program."
? "Enter characters to test I/O mode. Space bar moves to next test"

UO1
?
? "Hello on User Output"
UO0

;------------------------------------------------------------------------------
; Default output and input
;
? lf, "Default output and input:"
DO_DI:
	uc=get : if uc=0 then goto DO_DI 
	if uc>=20h then ? chr(uc), spc(1), uc, "D ", : ph0. uc
	if uc<>20H then goto DO_DI

;------------------------------------------------------------------------------
; Default output, user input
;
? lf, "Default output, user input" : ui1
DO_UI:
	uc=get : if uc=0 then goto DO_UI 
	if uc>=20h then ? chr(uc), spc(1), uc, "D ", : ph0. uc
	if uc<>20H then goto DO_UI 
	input "A string and a signed integer ",str1$,x
	: ? "You entered ",str1$,spc(2),x

;------------------------------------------------------------------------------
; User output and input
;
? lf,"User output now active" : uo1 
#ASM
	clr ES	; make sure we can't use normal serial i/o
#ASM_END	

? "Type some chars, <space bar> to stop "
UO_UI1:
	uc=get : if uc=0 then goto UO_UI1 
	if uc >= 20h then ? chr(uc), spc(1), uc, "D ", : ph0. uc
	if uc<>20H then goto UO_UI1

	? : input "Enter a string and a signed integer ",str1$,x
	: ? "You entered ",str1$,spc(2),x

	? cr,lf,"UI off:" : ui0 
#ASM
	setb ES			; re-enable normal serial I/O interrupts
#ASM_END


;------------------------------------------------------------------------------
; Default input, user output
;
? "Default input, user output"

DI_UO:
	uc=get : if uc=0 then goto DI_UO 
	if uc >= 20h then ? chr(uc), spc(1), uc, "D ", : ph0. uc 
	if uc<>20H then goto DI_UO

	? "UO off" : uo0
	goto TOP

END
