;-----------------------------------------------------------------------------
;
; DEMO PROGRAM LCD_20X4
;
; Supported: 20x4 LCD, serial I/O,
; four digital inputs, Dallas Timekeeper parts DS5000T and DS2250T.
; Not for use with DS2251/2 which have a different Timekeeper.
;
; (C) Copyright 1997 Systronix, Inc All Rights Reserved
;               Systronix, Inc. Salt Lake City, Utah, USA
;               TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
;		www.systronix.com	email: support@systronix.com
;		COMPLETE SYSTEMS for RAPID PROTOTYPING
;
;
; REVISION HISTORY -----------------------------------------------------------
;
; 97 Jan 15	BAB	Start
;
; DESIRED MODIFICATIONS ------------------------------------------------------
;
;
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
; Notice that all printing to the LCD or serial port occurs outside all
; interrupt handlers.  If you have print routines interrupting other print
; routines you can expect all sorts of strange-looking output.
;
; This file was created with tab stops every 8 characters
;
;
;
;-----------------------------------------------------------------------------

#target DS2250T
#console mode = 19200
#code start 0h
#data start 6000H
#xtal 11059200

;#check istack off
#check math off
#print complete on  				; keep LCD lines from conflicting
		    				; when print@ing from ONEX1
#control-c on					; we use this in ONERR handler

#include "lcd_e.inc"
	    				

	string REVISION$[4]			; revision code
	
	signed int X

	REVISION$ = "A2"

	; enable real time counter update
	TIME = 0 : MSEC = 0 : CLOCK1
	do : until msec > 500 			
	; give the PC's serial port time to stabilize
	; only needed when using Dallas loader and TE

	print : print "LCD init"
	gosub lcd_init				; initialize lcd and clear it

	gosub lcd_goto_line1
		;12345678901234567890	
	print@	"DEMO LCD_20X4 REV ", REVISION$,
	
	TCON = TCON AND 0F7H			; clear any pending onex

	ONERR error_handler

	unsigned char LCD_WR, LCD_RD, choice

start:
	print
	print "LCD [I]instruction  [A]ddress  [W]rite data  [R]ead data  [H]elp"

	do
		choice = get
	while (choice = 0)

	if ((choice = ASC(i)) or (choice = ASC(I))) then goto INSTR
	if ((choice = ASC(w)) or (choice = ASC(W))) then goto WR	
	if ((choice = ASC(r)) or (choice = ASC(R))) then goto RD
	if ((choice = ASC(a)) or (choice = ASC(A))) then goto ADDR
	if ((choice = ASC(h)) or (choice = ASC(H))) then goto HELP

	print "Please try again, unknown char ", CHR(choice)
	goto start

WR:
	input "Enter data to write to LCD ", LCD_WR
	lcd_dat = LCD_WR
	gosub lcd_write_data
	goto start

	gosub lcd_read_data
	ph0. "Read back ", lcd_dat
	goto start

RD:
	gosub lcd_read_data
	ph0. "Read back ", lcd_dat
	goto start

INSTR:
	input "Enter instr to write to LCD ", LCD_WR
	lcd_dat = LCD_WR
	gosub lcd_ins_write
	ph0. "Wrote ", lcd_dat
	goto start


ADDR:
	gosub lcd_get_dd_pos
	ph0. "Addr counter value read ", lcd_dat
	goto start

HELP:
print "----- HELP -----"
print "Instr 0FH sets display (bit2) on, cursor (bit1) on, blink (bit0) on"
print "Instr 07H sets cursror incr (bit1) and display shift on"
print "Instr 02H returns address counter to 0"
print "Instr 01H clears entire display"
print "Instr 10H moves cursor left  (bit3 1/0 = shift disp / move cursor)"
print "Instr 14H moves cursor right (bit2 1/0 = right / left)"
print "Instr 18H shifts display left"
print "Instr 1CH shifts display right" 
print "Instr w/bits 01XX_XXXB sets CG addr to XX_XXX, then you can wr or rd"
print "Instr w/bit 7 set sends lower bits as DD RAM address"
print "Tip: instr 0FH lets you see the cursor"
print "Tip: data 24H=$, 2AH=*, 0FFH=block, ASCII data works too"
	goto start

END


error_handler:
	ph0.	"Internal Error: ", ERRVALUE

error_loop:
	goto error_loop