;-----------------------------------------------------------------------------
; TLC2543 ADC DRIVER INCLUDE FILE FOR USE WITH DPB2 REV E
;
;
; (C) Copyright 1995 Systronix, Inc All Rights Reserved
;		Systronix, Inc. Salt Lake City, Utah, USA
;		TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
;
; Owners of Systronix products are hereby entitled to use, modify, and copy
; this sample program.  You may incorporate all or part of this program in 
; your own commercial products provided they are not simply copies of 
; Systronix products and do not compete directly with Systronix products.  
; This program is provided by Systronix free of charge and may not be resold.
;
; This program is intended for those of you who have the pleasure of using 
; the new DPB2 REVE board from Systronix/Intellix.  This card is a very
; easy to use development system for the Dallas DS5000/1/2 DS2250/1/2 and -T
; suffix soft microcontrollers.  If you'd like more information, please call
; or FAX us at the numbers above.
;
;
; REVISION HISTORY -----------------------------------------------------------
;
;	95 Jul 13	BAB	1.2 Adding support for array and multi channels
;	95 Jul 11	BAB	Further work, single channel works OK
;	95 Jun 25	BAB	Start, based on ADC_E.INC
;
;
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
; TI TLC2543 is an 11-channel, 12-bit analog to digital converter.
; Data interface is serial (not RS232).
; Conversion time is 10 usec.
;
;
; PROTOTYPE PINS -----
;
; ADC clock 	P0.2		
; ADC Data In 	P0.0
; ADC Data Out	P0.1
; ADC CS	P2.4
;
; To start a conversion, drive CS low.  This enables the clock, data input,
; and data output.  Send an 8-bit data stream to the data input consisting of
; these bits.  All bits are shown in binary format.
;	D7-D4	4-bit analog channel address
;		0000 = AIN0
;		0001 = AIN1
;		 and so on
;		1001 = AIN9
;		1010 = AIN10
;		1011 = (Vref+ - Vref-)/2
;		1100 = Vref-
;		1101 = Vref+
;	D3-D2	2-bit output data length code 
;		(11 = 16 bits, 00 or 10 = 12 bits, 01 = 8 bits)
;		(LSBs are padded or discarded)
;	D1	output MSB or LSB first 
;		(1 = LSB first)
;	D0	unipolar or bipolar select bit
;		(0 = unipolar, 1 = bipolar, data MSB is sign bit)
; Data is clocked in MSB first, and is shifted in on the clock rising edge,
;(this is the opposite of data output).
;
; While this new data shifts in, the previous conversion data is shifted out.
; Sampling of the analog data input begins on the fourth clock falling edge.
; The input is held after the last clock falling edge.  The last clock falling
; edge also takes EOC low and starts the conversion.   Output data is shifted
; out on the clock falling edge (this is the opposite of data input).
;
; Ignore the first conversion data output after power up, since the TLC2543 may 
; not have settled internally.
;
; After the eight bits of data in have been clocked in, the data input should
; be held high until EOC goes high indicating the conversion is complete.  This
; minimizes the effect of external digital noise.
;
;----------------------------------------------------------------------------
; CONVERSION SETUP IS ALWAYS A CONVERSION CYCLE AHEAD OF READ DATA
;
; Note that as we shift in the channel number and config for channel 'n',
; we are shifting out the data from a previous conversion, not the data for
; this conversion of channel 'n'.
;
; To do a 100% fresh conversion of channel 'n', therefore, we need to set up
; for channel n, throw away the read data from this conversion cycle, then
; set up and read again, saving the data from channel 'n'.  On the 2nd 
; conversion cycle it doesn't really matter what the setup data is.
;
;
;----------------------------------------------------------------------------
; TLC2543 ANALOG INPUT IMPEDANCE REQUIREMENTS
;
; The TLC2543 inputs must be driven with a low impedance device.  This is
; necessary to provide the switched-capacitor charging current required 
; during the input sampling time.
;
;
;
; BENCHMARKS ----------------------------------------------------------------
;
;
; With a DS2250 and an 11.0592 MHz crystal:
; 100 usec/channel to convert a single channel (time CS is low)
; 1.42 msec to convert and store all 11 channels (time P2.7 is high)
; 
;
; DESIRED MODIFICATIONS -----------------------------------------------------
;
; * Power down mode
; * Read of calibration data, put in 3-element array 2543_cal
; * Bipolar mode read of all channels
;
; Less important:
; Routine to pass a single channel to convert and do the conversion
; including specifying bipolar or unipolar format.
;
;
;----------------------------------------------------------------------------

    goto tlc2543_inc_end            			; protect against include in program body

    unsigned int DAT_2543[11]				; one 2-byte word per channel

REM READ the serial ADC value into ADC_DAT
get_all_2543:

#ASM

;----------------------------------------------------------------------------
; Change these equates if your hardware bit assignments are different
; This is the only place you need to make the change.
;

DINP_2543	BIT	P0.0
DOUT_2543	BIT	P0.1
CLK_2543	BIT	P0.2
CS_2543		BIT	P2.4


	; init first...
	setb    DOUT_2543				; make sure data out is input
	clr	CLK_2543				; ADC clock low
	setb    CS_2543					; CS high


	; point at the start of the data array
	mov	DPTR, #__DAT_2543			; array

	; ----------------------------------------------
	; Place setup and config values in acc	
	; bits D7-D4 are channel # per table in header above
	; D3,D2 are 00 for 12 bit data out
	; D1 is 0 for MSB of data out first
	; D0 is 0 for unipolar data out format
	; ----------------------------------------------

	
	; convert ch0 and discard prev data
	; we set up the data pointer to point to a 16 bit location
	; and set the channel # in R3 low nibble, other config in high nibble
	; set the F0 flag for one conversion cycle
	mov	R3, #0
	setb	PSW.5					; the F0 flag
	lcall	CHAN_2543_1
	
	; point at the start of the data array, again
	mov	DPTR, #__DAT_2543			; array
	clr	PSW.5					; clear the F0 flag


	; Channel #, start with 0
	; inc, swap nibbles and move to acc
	; for other channels

	setb	P2.7					; watch on 'scope

CHAN_2543:
	inc	R3					; chan # in low nibble

CHAN_2543_1:
	mov	A, R3					; move channel # into acc
	swap	A					; chan # into high nibble
	
	; set acc.0 to enable bipolar output data format, before shifting
	; config data to adc data input					

	push	IE					; disable interrupts
	clr	EA

	; start access...
	clr	CLK_2543				; start with clock low
	clr     CS_2543					; make CS low, start access
	; as soon as CS asserts, data out from previous 
	; sample is available and valid
	mov     R1, #8					; # of bits we will send
							; actually 12 total

get_2543_msb:
	; 1st rlc shifts data input bit from accumulator to the ADC
	; 2nd shifts data output from the ADC into the accumulator
	; so we do 9 rlc and clock rising edges here
	clr	CLK_2543				; clock low, data out is valid
	mov	C, DOUT_2543				; data output port bit to carry
	rlc	A           				; rotate acc data inp msb into carry
							; ... and data out into acc
	mov	DINP_2543, C           			; carry to data input port bit

	setb    CLK_2543        			; clock high, clock in data inp to ADC
	djnz    R1, get_2543_msb			; repeat

	; at this point we've shifted 8 config bits to the ADC 
	; we need to clock out 4 more data bits.  Data output
	; 8 data out bits 11-4 are in the acc
	
	mov	B, A					; copy acc data 11-4 to B reg
	; leave data bits 11-4 in acc, we'll rotate bits 7-4 into 
	; the high nibble, shift in bits 3-0 into low nibble
	; and discard bits 11-8 (that's why we saved a copy in B)
	mov	R1, #4

get_2543_lsb:
	clr	CLK_2543				; clock low, data out is valid
	mov	C, DOUT_2543				; data output port bit to carry
	rlc	A           				; rotate data out into acc
	setb    CLK_2543        			; clock high, clock in data inp to ADC
							; we don't care what data inp is
	djnz    R1, get_2543_lsb			; do it total of 4 times

	clr	CLK_2543				; leave clock low
	setb	CS_2543					; disable CS

	; now the 2543 is performing the next conversion which takes 10 usec max
	; re-enable interrupts
	pop	IE
;	mov	DPTR, #__DAT_2543			; array
							
	movx	@DPTR, A				; store lsb of data
	
	mov	A, B					; get bits 11-4
	swap	A					; bits 11-8 now in low nibble
	anl	A, #00FH				; clear high nibble
	; acc now holds 0000_XXXXB where XXXX are the adc bits 11-8
	inc 	DPTR
	movx	@DPTR, A				; store msb of data

	jnb	F0, $+4					; if 1st throwawy conversion...
	ret						;... ret from here
							; else jump over the ret
					

	; increment channel and loop to convert all channels
	; store result of 11 channels in the array DAT_2543

	inc	DPTR					; point to next array element

	cjne	R3, #11, CHAN_2543			; loop for next channel
	
	clr	P2.7

#ASM_END
	; new conversion takes at least 10 usec
	return

tlc2543_inc_end:					; protect against include in program body
