;-----------------------------------------------------------------------------
;
; TEST PROGRAM for DPB2 REVE
;
; TLC2543 11-channel, 12-bit analog to digital converter
;
; Supported: 4x4 keypad, 20x4 LCD, 8-bit ADC, serial I/O, four relay driver 
; outputs, four digital inputs, Dallas Timekeeper parts DS5000T and DS2250T.
;
; (C) Copyright 1995 Systronix, Inc All Rights Reserved
;		Systronix, Inc. Salt Lake City, Utah, USA
;		TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
;
; Owners of Systronix products are hereby entitled to use, modify, and copy
; this sample program.  You may incorporate all or part of this program in 
; your own commercial products provided they are not simply copies of 
; Systronix products and do not compete directly with Systronix products.  
; This program is provided by Systronix free of charge and may not be resold.
;
; This program is intended for those of you who are accelerating your product
; development with the new DPB2 REVE board from Systronix/Intellix.  DPB2E is
; an easy to use development system for the Dallas DS5000/1/2 DS2250/1/2 (& T
; suffix) soft microcontrollers.  If you'd like more information, please call
; or FAX us at the numbers above.
;
; REVISION HISTORY -----------------------------------------------------------
;
; CAUTION: This is an experimental program and may contain (dare we say it?) 
; bugs.  It is intended to be used for experimentation and development only.
; Do not base mission-critical applications on this code!
;
; 95 Jul 12	BAB	1.2	Adding multiple channels and better LCD
;			display
;
; 95 Jul 12	BAB	1.1, correctly sampling a single channel and displaying
;			on LCD and serial port!
; 95 Jun 25	BAB	Start, to test TLC2543.INC
;
;
; DESIRED MODIFICATIONS ------------------------------------------------------
;
; 
;
;
;
; GENERAL NOTES --------------------------------------------------------------
;
; Notice that all printing to the LCD or serial port occurs outside all
; interrupt handlers.  If you have print routines interrupting other print
; routines you can expect all sorts of strange-looking output.
;
;
;
;
;-----------------------------------------------------------------------------

#target DS2250T
#console mode = 19200
#printer mode = 9600					; this talks to Barney
#code start 0h
#data start 6000H


#check istack off
#check math off
#print complete on  ; keep LCD lines from conflicting
                    ; when print@ing from ONEX1

	int delay_time

	signed int X, loop

	unsigned character ser_key
	unsigned char FIRST, LAST, CNT, Y

	unsigned character temp_uc
	unsigned char time_fresh			; =1 if fresh, 0 if needs update

	unsigned int tmp_2543, min, max, temp_ui
    
	delay_time = 100


start:

	DS_ECC_RUN=1					; run timekeeper
    
	; enable real time counter update
	TIME = 0 : MSEC = 0 : CLOCK1

	ontime 2, timer_tick

	gosub relay_init
	gosub relay_enable

	gosub lcd_init                  		; initialize lcd and clear it

	TCON = TCON AND 0F7H            		; clear any pending onex1
	TCON = TCON OR 040H				; set TCON.2 for falling edge trigger
	ONEX1 keypress_handler

	gosub lcd_clr_display

	gosub delay_1sec

	gosub lcd_rev



	goto menu1

lcd_rev:
	print "DPB2 TLC2543 TEST V1.2"

	gosub lcd_goto_line1
	;	12345678901234567890
	print@ " DPB2 w/TLC2543 1.2 ",

	gosub delay_2sec


menu1:
	gosub lcd_clr_display

	;	12345678901234567890
	gosub lcd_goto_line2
	print@ "Select Test w/RS232 ",

	print : print
	print "Select by number:"
	print "    1 - convert all channels"
	print "    2 - convert channel 0 repeatedly"
	print "    3 - ???"

	gosub get_key_time

	if ser_key = 31H then goto convert_all
	if ser_key = 32H then gosub convert_ch0
	if ser_key = 33H then gosub not_yet

	goto menu1


	;----------------------------------------
	; Future 
	;


	;	12345678901234567890
	gosub lcd_goto_line3
	print@ "TOP KEYS SELECT MENU",

	gosub lcd_goto_line4
	;	12345678901234567890
	print@ "CONF DUMP  ITEM More",

	gosub get_key_time

	gosub lcd_clear_line2
	gosub lcd_clear_line3

	if key_dat = 10H then goto start

	goto menu1

	if key_dat = 07H then gosub not_yet
	if key_dat = 08H then gosub not_yet

	if key_dat = 15H then goto menu1 		; backspace


here:

	goto menu1

	END



;-------------------------------------
;
;-------------------------------------




;-------------------------------------
;	Convert Channel 0
;
; Convert and display channel 0
;-------------------------------------

unsigned char adc_win_cnt, adc_win_lim



convert_ch0:

	min = 4095
	max = 0

	adc_win_cnt = 0					; times we've displayed
	adc_win_lim = 50				; max times before clearing min/max

	print

	gosub lcd_goto_line2
	;	12345678901234567890
	print@ " Convert Channel 0  ",

conv_ch0_1:

	gosub get_all_2543

	if dat_2543(0) > max then max = dat_2543(0)
	if dat_2543(0) < min then min = dat_2543(0)

	ph1. dat_2543(0), 
	print " ", dat_2543(0),
	ph1. spc(2), "min/max: ", min, "<>", max, spc(1), 
	print "spread=", (max-min), " bits    ", cr,

	gosub lcd_goto_line3
	ph1.@  "CH0:", dat_2543(0),
        lcd_ypos = 3
        lcd_xpos = 12
        gosub lcd_goto_xy 
	ph1.@ "min:", min,
	gosub lcd_goto_line4
	print@ "+/-", (max-min)/2, " bits  ",
      	lcd_ypos = 4
        lcd_xpos = 12
        gosub lcd_goto_xy 
	ph1.@ "max:", max,

	gosub update_time_disp

	adc_win_cnt = adc_win_cnt + 1


	if (ADC_WIN_CNT = ADC_WIN_LIM) OR ( (MAX-MIN) > 100 ) THEN
		adc_win_cnt = 0
		MIN = 0FFFH
		MAX = 0
		print
	endif
	

	if get then return				; return with any key
	goto conv_ch0_1					; else repeat



;-------------------------------------
;	Convert all
;
; Convert and display all TLC2543 
; channels.
;
;-------------------------------------

convert_all:

	print : print

	print "Converting all channels:"
	print "--0-- --1-- --2-- --3-- --4-- --5-- --6-- --7-- --8-- --9-- --10- msec"



conv_all_1:

	gosub get_all_2543

	temp_ui = MSEC

	x = 0
	do 
		ph1. dat_2543(x), spc(1),
		x = x+1
	until x = 11					; stop after ch0-10

	IF temp_ui < 100 then print "0",
    	IF temp_ui < 10 then print "0",
    	print temp_ui
;	print cr,


	;	12345678901234567890
	gosub lcd_goto_line1
	ph1.@  spc(1), dat_2543(0), spc(2), dat_2543(1), spc(2), dat_2543(2),

	gosub lcd_goto_line2
	ph1.@  spc(1), dat_2543(3), spc(2), dat_2543(4), spc(2), dat_2543(5),

	gosub lcd_goto_line3
	ph1.@  spc(1), dat_2543(6), spc(2), dat_2543(7), spc(2), dat_2543(8),

	gosub lcd_goto_line4
	ph1.@  spc(1), dat_2543(9), spc(2), dat_2543(10), spc(2), 


	IF temp_ui < 100 then print@ "0",
    	IF temp_ui < 10 then print@ "0",
    	print@ temp_ui,

	if get then return				; return with any key

	goto conv_all_1					; else repeat







;-------------------------------------
;	GET KEY
;
;	exits with keypad press or serial char
;-------------------------------------

get_key:
	key_dat = 0ffH
	do
		ser_key = get
		while ( (key_dat = 0ffh) and (ser_key = 0) )
	return


;-------------------------------------
;	GET KEY TIME
;	update time display while waiting
;	exits with keypad press or serial char
;-------------------------------------

get_key_time:
	key_dat = 0ffH
	do
		if ( (msec <950) AND (time_fresh=0) ) then gosub update_time_disp
		ser_key = get
		while ( (key_dat = 0ffh) and (ser_key = 0) )
	return


;-------------------------------------
;	LCD CLEAR ROUTINES
;-------------------------------------

lcd_clear_line1:
	gosub lcd_goto_line1
	goto clear_line

lcd_clear_line2:
	gosub lcd_goto_line2
	goto clear_line

lcd_clear_line3:
	gosub lcd_goto_line3
	goto clear_line

lcd_clear_line4:
	gosub lcd_goto_line4
	goto clear_line

clear_line:
	;	12345678901234567890
	print@ "                    ",
	return



;-------------------------------------
;	KEYPRESS (ONEX1) HANDLER
;-------------------------------------

REM EX1 handler
keypress_handler:
    	gosub key_get_val               ; key value in key_dat

keypress_off:
    	reti

;-------------------------------------
;	ONTIME HANDLER
;-------------------------------------

REM Ontime handler
    
timer_tick:
	if time=65535 then time=0
	ontime time+1, timer_tick
	gosub update_time
	time_fresh = 0					; time disp needs update
	RETI


;-------------------------------------
;	UPDATE TIME
;-------------------------------------


REM update time on bottom line
update_time:
    	DS_ECC_RD
;    	gosub metronome_1
    	return


;-------------------------------------
;	UPDATE TIME DISPLAY
;
; copying to temp_uc prevents the ontime interrupt from 
; changing a value as we are analyzing it!  We could decide
; it was a 9, print a leading 0, then it rolls to 10 and 
; we print too many characters for the line.
;-------------------------------------

update_time_disp:
   	gosub lcd_goto_line1


;	;	 12345678901234567890
;	print@	"It's the right time!",
;	return

	
	print@ " ",
	temp_uc = DS_MONTH
    	IF temp_uc < 10 then print@ "0",
    	print@ temp_uc, "-",
	temp_uc = DS_DATE
    	IF temp_uc < 10 then print@ "0",
    	print@ temp_uc, "-", DS_YEAR, "  ",
	temp_uc = DS_HOUR
    	IF temp_uc < 10 then print@ "0",
    	print@ temp_uc, ":",
	temp_uc = DS_MIN
    	IF temp_uc < 10 then print@ "0",
    	print@ temp_uc, ":",
	temp_uc = DS_SEC
    	IF temp_uc < 10 then print@ "0",
    	print@ temp_uc,
	
	time_fresh = 1					; we've freshened the display

    	return



        
;-------------------------------------
;	DELAY ROUTINES
;-------------------------------------


REM 100 msec delay
delay_100:
	gosub wait_50_msec
	gosub wait_50_msec
	return

delay_500:
	gosub delay_100
	gosub delay_100
	gosub delay_100
	gosub delay_100
	gosub delay_100
	return

delay_1sec:
	for x=1 to 10
	gosub delay_100
	next x
	return

REM 2 second delay
delay_2sec:
	for x=1 to 20
	gosub delay_100
	next x
	return

;-------------------------------------
;	wait 50 msec
;
; @ 11.0592 MHz:
; 23,000 cycles of djnz is 50 msec 
; each djnz is 2 CPU cycles, or 2.17 usec

wait_50_msec:

#ASM
_wait50ms:
	mov	ACC, #90			
	mov	B, #0
_wait50ms_1:
	djnz	B, $
	djnz	ACC, _wait50ms_1

	ret
#ASM_END



;-------------------------------------
;	NOT YET
;-------------------------------------

not_yet:
	print "Sorry, this ption or choice is not yet available", chr(07H)
    	gosub lcd_goto_line3
	;	 12345678901234567890
	print@	" Not yet available  ",
	gosub delay_1sec
	
	return



;-------------------------------------
;	INCLUDE FILES
;-------------------------------------


#include "tlc2543.inc"
#include "key_e.inc"
#include "lcd_e.inc"
#include "rly_e.inc"
;#include "adc_e.inc"
