;-----------------------------------------------------------------------------
; RELAY DRIVER FOR USE WITH DPB2 REV E
; it will not work with DPB2 REV D
; (The rev level is on the silkscreen on your board).
;
; (C) Copyright 1994 Systronix, Inc All Rights Reserved
;		Systronix, Inc. Salt Lake City, Utah, USA
;		TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
;
; Owners of Systronix products are hereby entitled to use, modify, and copy
; this sample program.  You may incorporate all or part of this program in 
; your own commercial products provided they are not simply copies of 
; Systronix products and do not compete directly with Systronix products.  
; This program is provided by Systronix free of charge and may not be resold.
;
; This program is intended for those of you who are enjoying the benefits of
; the new DPB2 REVE board from Systronix/Intellix.  This card is a very
; easy to use development system for the Dallas DS5000/1/2 DS2250/1/2 and -T
; suffix soft microcontrollers.  If you'd like more information, please call
; or FAX us at the numbers above.
;
; REVISION HISTORY -----------------------------------------------------------
;
;	01/24/94	BAB	Start, derived from RELAY1.INC for DPB2 rev D
;
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
; Allegro UCN5800A
;
; The relay driver has 4 open collector outputs, addressed on the data bus
; as P0.0-3.  Strobe the data with P1.1.
; The data latch looks like a 373 family device: when the strobe is high,
; data flows through transparently, and when strobe is low the data is held.
;
; On power up P1.1 is high, so to turn off the ports, drive P0 low and then
; drive P1.1 low. The driver does have a power on clear.  We drive its OE(L) 
; with a port pin P1.2 which powers up HIGH, disabling the driver until we 
; deliberately enable it.
;
; We use relay 1 (data bit 0) to drive an inexpensive piezo buzzer, available
; from Systronix to click and beep.  It clicks once per second in the 
; metronome subroutine.
;
;-----------------------------------------------------------------------------

    goto relay_inc_end         		; protect against include in program body

    unsigned char relay_status		; one bit for each relay, bit=1 if ON
    unsigned char relay_dat		; relay driver bits numbered 0-3
    unsigned char relay_number		; "user" relay number 1-4


relay_init:
#ASM
	setb	P1.2					; disable relay outputs
	mov     P0,#000H				; shut off relay outputs
	; strobe in data, force P1.1 high, then low
	setb    P1.1
	clr     P1.1
;	mov     P0,#0FFH				; convert back to input
#ASM_END
	relay_status = 0;
	return


relay_set_dat:
    if (relay_number = 1) then
        relay_dat = 0001b
    else
        if (relay_number = 2) then
            relay_dat = 0010b
        else
            if (relay_number = 3) then
                relay_dat = 0100b
            else
                if (relay_number = 4) then relay_dat = 1000b else relay_dat = 0
            endif
        endif
    endif

;	print "Turning on relay bit ", relay_dat
    return

relay_enable:
#ASM
	clr	P1.2					; drive low to turn on
#ASM_END
	return

relay_disable:
#ASM
	setb	P1.2					; drive high to turn off
#ASM_END
	return

relay_turn_on:
    gosub relay_set_dat
    relay_status = relay_status or relay_dat
    goto relay_set_status

relay_turn_off:
    gosub relay_set_dat
    relay_status = relay_status and not relay_dat
    goto relay_set_status

relay_toggle:
    gosub relay_set_dat
    relay_status = relay_status xor relay_dat
    goto relay_set_status

relay_set_status:
#ASM
	mov     DPTR,#__RELAY_STATUS    	; addr in DPTR
	movx    A,@DPTR                 	; RELAY_STATUS in Port 0
	mov     P0,A
	; strobe in data, force P1.1 high, then low
	setb    P1.1
	clr     P1.1
;	mov     P0,#0FFH                	; convert back to input
#ASM_END
	gosub relay_enable
    return


; metronome each second
metronome_1:
#ASM
	mov     DPTR,#__RELAY_STATUS		; addr in DPTR
	movx    A,@DPTR				; RELAY_STATUS in Port 0
	mov     P0,A
	setb	P0.0			        ; set relay 1 to on
	; strobe in data, force P1.1 high, then low
	setb    P1.1
	clr     P1.1
	mov     R0,#0FFH			; one djnz = 2 cycles (~ 2 usec)
	djnz    R0,$                    	; tone duration
	clr     P0.0                    	; turn relay 1 off
	; strobe in data, force P1.1 high, then low
	setb    P1.1
	clr     P1.1
#ASM_END
	return


; make the speaker beep
beep_1:
#ASM
    mov     DPTR,#__RELAY_STATUS    ; addr in DPTR
    movx    A,@DPTR                 ; RELAY_STATUS in Port 0
    mov     P0,A
	setb	P0.0			        ; set relay 1 to on
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1

    ; set tone duration one, 1 djnz = 2 cycles (~ 2 usec)
    mov     R1,#02FH
beep_loop:
    mov     R0,#0FFH
    djnz    R0,$ 
    djnz    R1,beep_loop

    clr     P0.0                    ; turn relay 1 off
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
#ASM_END
    return


; flash backlight iff LED backlight is tied to relay output #2
flash_2:
#ASM
	mov     DPTR,#__RELAY_STATUS 		; addr in DPTR
	movx    A,@DPTR				; RELAY_STATUS in Port 0
	mov     P0,A
	setb	P0.1			        ; set relay 2 on
	; strobe in data, force P1.1 high, then low
	setb    P1.1
    clr     P1.1
    mov     R0,#0FFH                ; one djnz = 2 cycles (~ 2 usec)
    djnz    R0,$                    ; tone duration
    mov     R0,#0FFH                ; one djnz = 2 cycles (~ 2 usec)
    djnz    R0,$                    ; tone duration
    clr     P0.0                    ; turn relay 2 off
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
#ASM_END
    return


relay_inc_end:                  ; protect against include in program body
