; Conditional assembly flags...
; These tell the assembler various compilation options
; Feel free to refer to these in your in-line assembly code
CODE_START EQU 51
DATA_START EQU 24576
CPRINT EQU 1	; serial print
SPRINT EQU 1	; serial print#
UPRINT EQU 1	; user print
UIO    EQU 0	; user i/o drivers
_ALIGN	SET 1	; 8 bit ptrs
PRINT_COMPLETE SET 1	; each print empties buffer
RTC EQU 1	; timer0 RTC
ONEX1 EQU 0	; do not enable ext int 1
ONTIME EQU 1	; enable
ARRAY EQU 0	; no array present   
ERR_MSG EQU 1	; err_msg is present
PUSH_POP EQU 0
READ_DATA EQU 0
ONERR EQU 0
PROGLINE SET 1	; track basic line numbers
RUN_TRAP_B52 EQU 0
RUN_TRAP_LOC EQU 0
SPMAX EQU 127
SPUSE_ONTIME EQU 20	;actual stack space used
SPUSE EQU 54	; actual istack max needed           
BASIC52 EQU 0
BEBASIC EQU 0
TARGET_8XC51F EQU 0
DS5000 EQU 1
ON_WARM SET 0
ON_POR SET 0
ON_RUNTRAP SET 0
ON_WDOG SET 0
ON_PWRFL SET 0
CHECK_ISTACK SET 1
CHECK_MATH SET 0
RELOC_VEC EQU 0
;_%%NO_B52_EQU:

_OPREG_0L 	EQU 0	
_OPREG_0H 	EQU 2
_OPREG_1L 	EQU 1
_OPREG_1H 	EQU 3
_OPREG_2L 	EQU 4
_OPREG_2H 	EQU 5
_R0 		EQU 0
_R1 		EQU 1
_R2 		EQU 2
_R3 		EQU 3
_R4 		EQU 4
_R5 		EQU 5
_R6 		EQU 6
_R7 		EQU 7


_NULLCNT	EQU 10H		
_PHEAD		EQU 11H		
_SPHEAD		EQU 12H		
_TREL1H		EQU 13H		
_TREL1L		EQU 14H
_SPCLEAR	EQU 15H		

_ASTACK_PTR_L	EQU 16H		
_ASTACK_PTR_H	EQU 17H		

	IF (UIO + UPRINT)
_UPHEAD		EQU 18H		
	ENDIF


_RTC_RELOAD	EQU 27H		
_RTC_MILLI	EQU 28H		
_RTC_SEC_LO	EQU 29H		
_RTC_SEC_HI	EQU 2AH		
_ONTIME_H	EQU 2BH		
_ONTIME_L	EQU 2CH		


	IF CPRINT
_CPRT_FLAG	BIT 21H.0	
_CPRT_RDY	BIT 21H.1	
	ENDIF

	IF SPRINT
_SPRT_FLAG	BIT 21H.2	
_SPRT_STOP	BIT 21H.3	
_SPRT_RDY	BIT 21H.4	
	ENDIF

	IF UPRINT
_UPRT_FLAG	BIT 21H.5	
	ENDIF

_ON_EX1		BIT 23H.1	
_ON_EX1_PND	BIT 23H.2	
_ON_EX1_INP	BIT 23H.3	

	IF UIO
_UIO_INP_FLAG	BIT 23H.6	
_UIO_OUT_FLAG	BIT 23H.4	
	ENDIF

_CNTRLS_FLAG	BIT 21H.6 	
_CNTRLC_FLAG	BIT 21H.7 	

_CLOCK_BIT	BIT 22H.0	
_ON_TIME	BIT 22H.1	
_ON_TIME_PND	BIT 22H.2	
_ON_TIME_INP	BIT 22H.3	

_ON_ERR		BIT 22H.4	
					  
_IDLE_END	BIT 22H.5	

_ASTACK_USED	BIT 22H.6	

_CPRT_INP	BIT 22H.7

_ES_FLAG	BIT 23H.0	

	IF DS5000
_WDOG_FLAG	BIT 23H.5	
	ENDIF

;_%%8031_EQU:

TARGET_8032	EQU 0		


;_%%GENERIC_EQU:

CR		EQU 13		
LF		EQU 10		
BS		EQU 8		
CNT_D		EQU 04   	
FPSIZE		EQU 6		


BSKEY		EQU 08H     	



ZERO_DIVIDE	EQU 10		
OVERFLOW	EQU 20		
UNDERFLOW	EQU 30		
BAD_ARGUMENT	EQU 40		

READ_OUT	EQU 50		
READ_TYPE	EQU 60		

ARRAY_INDEX	EQU 70		
STRING_TRUNC	EQU 80		

ONGO_EXPR	EQU 90		

ISTACK_ERR	EQU 100		

ASTACK_FULL	EQU 110		
ASTACK_EMPTY	EQU 120		
POP_TYPE	EQU 130		

MEM_ACC		EQU 140		
MEM_ACC_B52	EQU 150		

START_ERR	EQU 250		
;_%%DS5000_EQU:

MCON 	EQU 0C6H		; DS500X Memory CONtrol sfr
TA	EQU 0C7H		; Timed Access sfr

;_%%SERIAL_IO_EQU:

_CNTRLQ		EQU 11H		
_CNTRLS		EQU 13H		
_CNTRLC		EQU 03H		

_INPLEN		EQU 80		

_FIFOLN		EQU 16		

 
_OUTLEN		EQU 80            

INPUT_ECHO	SET 1		

;_%%SYSTRONIX:

RXD 	BIT P3.0		
T0	BIT P3.4		
T1	BIT P3.5		

LP	BIT P1.7	

    IF TARGET_8032

TL2	EQU 0CCH		
TH2	EQU 0CDH
T2CON	EQU 0C8H		

    ENDIF


    IF TARGET_8XC51F

CH	EQU 0F9H		
CCAP0H	EQU 0FAH
CCAP1H	EQU 0FBH
CCAP2H	EQU 0FCH
CCAP3H	EQU 0FDH
CCAP4H	EQU 0FEH

CL	EQU 0E9H		
CCAP0L	EQU 0EAH
CCAP1L	EQU 0EBH
CCAP2L	EQU 0ECH
CCAP3L	EQU 0EDH
CCAP4L	EQU 0EEH

CCON	EQU 0D8H
CMOD	EQU 0D9H
CCAPM0	EQU 0DAH
CCAPM1	EQU 0DBH
CCAPM2	EQU 0DCH
CCAPM3	EQU 0DDH
CCAPM4	EQU 0DEH

SADEN	EQU 0B9H		
SADDR	EQU 0A9H		

IPH	EQU 0B7H		

    ENDIF

_START_VEC EQU 03H
	org		0000H		;code segment org

	ljmp		033H		;to user program start 51D

;_%%INT0B_GEN:


	org	_START_VEC+8
    IF BASIC52 EQ 0		       	
    	push	PSW			
    ENDIF				
	ljmp	_INT_RTC		
			       
;_%%INT23_GEN:

	org	_START_VEC+20H
    IF BASIC52 EQ 0		       	
    	push	PSW			
    ENDIF				
	ljmp	_INT23			

;_%%INT2B_DS5000:


	org	2BH
	push	PSW
	ljmp	_INT_PFW
	
	org		033H		;actual program start 51D

_START_LOC:		;main entry point when CALLed

_runtrap:		; run trap local iff no B52 interp

_START_NO_B52:
	clr	EA		

	clr	psw.4		
	clr	psw.3

	mov	21H, #0		
	mov	22H, #0
	mov	23H, #0		

	setb 	_IDLE_END	
	setb	TCON.2		

    IF SPRINT
	mov	_SPHEAD, #1	
    ENDIF
    	mov	R7, SP		

		mov	SP, #48		;set stack pointer
		mov	_SPCLEAR, SP		;save SP for CLEAR, etc
;_%%DS5_STARTUP1:
	push	PSW
	push	B
	push	ACC
	push	PCON			; save original PCON value
	anl	MCON, #0FBH		; clear ECE2 bit MCON.2
	lcall	_DS5_WDOG_OFF		; disable watchdog

		; INIT Real Time Clock
		; TH0 for RTC is 112D/70H
	mov _RTC_RELOAD, #112		; TH0 Reload value
	anl TCON, #0CFH		; clr TF0 and TR0
	anl TMOD, #0F0H		; setup timer0 for RTC
	lcall	_CLR_RTC		;clear RTC locations
CONSOLE_TIMER EQU 1
		; TH1 for 9600 baud is 250D/FAH
	mov R0, #250		; Reload value for 9600 baud
	lcall _SET_CBAUD_T1		;Setup Timer1 as baudgen
		; timer1 reload for 9600 baud is 65451D/FFABH
	mov _TREL1H, #255		; MSB reload value
	mov _TREL1L, #171		; LSB reload value
	lcall	_INIT_PRINT		;init print to serial i/o port 
_SERIAL_IO_INIT:
	CLR     _CNTRLS_FLAG	
	CLR     _CNTRLC_FLAG	
	clr	_CPRT_FLAG	
    IF BASIC52
	clr	23H.7		
    ENDIF

    IF SPRINT
 	clr	_SPRT_FLAG	
    ENDIF

	mov	SCON, #50H	
	SETB    ES		
	SETB    EA		


	lcall	_INIT_PAT		;init user i/o
SERIAL_MODE SET 0
;_%%DS5_STARTUP2:

	mov 	A, PCON			; clear PCON flags
	pop	ACC			; orig value in ACC
	pop	_R0			; old ACC
	pop	_R1			; old B
	pop	PSW			; old F0 flag for runtrap detect

_DS_POR_WDCHK:				; reset could have been wdog timeout
	jnb	ACC.2, _DS_POR_PCHK	; EWT =1 if wdog enabled, jump if not
	jnb	ACC.4, _DS_POR_PCHK	; jump if =0, not a wdog timeout
    IF (ON_WDOG * DS5000)     	; if Dallas and user has specified this
	lcall	_DS_USER_WDOG		; ...go do it, return here
    ENDIF				; no need to save acc before this call
	sjmp	_DS_POR_X		; we're done

_DS_POR_PCHK:				; not wdog, see if was a POR reset
	jb	ACC.6, _DS_POR_RCHK	; =1 if not POR, might be run trap
    IF (ON_POR * DS5000)		; if Dallas and user has specified this
	lcall	_DS_USER_POR		; ...go do it, return here
    ENDIF				; no need to save acc before this call
	sjmp	_DS_POR_X		; we're done

_DS_POR_RCHK:				; could it be runtrap?

_DS_POR_RT:				; not POR, not wdog, = runtrap ? 
    IF (RUN_TRAP_LOC * DS5000) 		; could have been run trap
	jnb	F0, _DS_POR_WCHK	;
	cjne	R0, #0AAH, _DS_POR_WCHK	;
	cjne	R1, #055H, _DS_POR_WCHK	;
      IF (ON_RUNTRAP)			; if Dallas and user has specified this
	lcall	_DS_USER_RTRAP		; ...go do it, return here
      ENDIF				; no need to save acc before this call
	sjmp	_DS_POR_X		; it was run trap, exit
    ENDIF				; else fall through 

_DS_POR_WCHK:				; not a runtrap, could be warm reset

					; old SP should have been 7 if we
					; had a hardware reset of any kind
	cjne 	R7, #07H, _DS_POR_ERR	; not warm reset, jump

					; ...else warm reset is OK...
    IF (DS5000 * ON_WARM)		; ...and may have user code
	lcall	_DS_USER_WARM		; ...go do it, return here
    ENDIF				
	sjmp	_DS_POR_X		; we're done

_DS_POR_ERR:				; else an err
    IF ERR_MSG
	mov	DPTR, #_bad_start	; the message
    ENDIF
	mov	A, #START_ERR		; the errval
	ljmp	_ERR_HAND		; handle the error

_DS_POR_X:
	mov	0C7H, #0AAH		; timed access keys
	mov	0C7H, #055H

    IF ON_PWRFL
    	orl	PCON, #048H		; set POR and EPFW bits = 1
    ELSE
	orl	PCON, #040H		; set POR bit = 1
    ENDIF

; errline support
	lcall	_CLEAR_UVAR
;-----------------------------------------------------------------------------
; clear_expr
;
; clear_expr
; DEMO PROGRAM for DPB2 REVE
; clear_expr
;
; clear_expr
; LCD162.BAS
; clear_expr
;
; clear_expr
; Sample program for 16x2 LCD and DS5000 or 2250 targets
; clear_expr
; Not for use with DS2251/2 which have a different Timekeeper.
; clear_expr
;
; clear_expr
; (C) Copyright 1994 Systronix, Inc All Rights Reserved
; clear_expr
;		Systronix, Inc. Salt Lake City, Utah, USA
; clear_expr
;		TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
; clear_expr
;
; clear_expr
; Owners of Systronix products are hereby entitled to use, modify, and copy
; clear_expr
; this sample program.  You may incorporate all or part of this program in 
; clear_expr
; your own commercial products provided they are not simply copies of 
; clear_expr
; Systronix products and do not compete directly with Systronix products.  
; clear_expr
; This program is provided by Systronix free of charge and may not be resold.
; clear_expr
;
; clear_expr
; This program is intended for those of you who have the pleasure of using 
; clear_expr
; the new DPB2 REVE board from Systronix/Intellix.  This card is a very
; clear_expr
; easy to use development system for the Dallas DS5000/1/2 DS2250/1/2 and -T
; clear_expr
; suffix soft microcontrollers.  If you'd like more information, please call
; clear_expr
; or FAX us at the numbers above.
; clear_expr
;
; clear_expr
; REVISION HISTORY -----------------------------------------------------------
; clear_expr
;
; clear_expr
; 03-04-94	BAB	Taken from HELLO242.BAS
; clear_expr
;
; clear_expr
;
; clear_expr
; NOTES AND COMMENTS ---------------------------------------------------------
; clear_expr
;
; clear_expr
; 16x2 LCD has LED backlight pins swapped relative to the 20x4 LCD.
; clear_expr
; The 16x2 LED+ is towrd the bottom edge of the display, away from the row
; clear_expr
; of 14 contacts.
; clear_expr
;
; clear_expr
; Also the 16x2 LCD has a built in 27 ohm current limit resistor, so the
; clear_expr
; DPB2E R6 can be removed.
; clear_expr
;
; clear_expr
;
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
;
; clear_expr
; 
; clear_expr
;
; clear_expr
;
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
; #TARGET DS2250T
; clear_expr
; #CONSOLE MODE=9600
; clear_expr
; #PRINTER MODE=9600
; clear_expr
; #CODE START 0H
; clear_expr
; #DATA START 6000H
; clear_expr
; check math must be off to avoid math overflow when TIME approaches
; clear_expr
; 65535 and we're adding to it
; clear_expr
; #CHECK MATH OFF
; clear_expr
; Sample code for driving a 16x2 LCD
; clear_expr
;
; clear_expr
; LCD CONTROL
; clear_expr
;
; clear_expr
; P1.4 is LCD R/S, H for data, L for instr
; clear_expr
; P1.5 is LCD RD (H), write is L
; clear_expr
; P1.6 is LCD EN, pulse it H to strobe the cycle into the LCD
; clear_expr
;
; clear_expr
; P0 is the data bus
; clear_expr
; Busy flag is data bit 7, P0.7
; clear_expr
;
; clear_expr
; UNSIGNED CHAR LCD_DAT, DATE_TIME, TOP
; clear_expr
; SIGNED INT X
; clear_expr
; UNSIGNED INT TIME_TMP, WAIT_SEC, MSEC_TMP
; clear_expr
; #INCLUDE "rly_e.inc"
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
; RELAY DRIVER FOR USE WITH DPB2 REV E
; clear_expr
; it will not work with DPB2 REV D
; clear_expr
; (The rev level is on the silkscreen on your board).
; clear_expr
;
; clear_expr
; (C) Copyright 1994 Systronix, Inc All Rights Reserved
; clear_expr
;		Systronix, Inc. Salt Lake City, Utah, USA
; clear_expr
;		TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
; clear_expr
;
; clear_expr
; Owners of Systronix products are hereby entitled to use, modify, and copy
; clear_expr
; this sample program.  You may incorporate all or part of this program in 
; clear_expr
; your own commercial products provided they are not simply copies of 
; clear_expr
; Systronix products and do not compete directly with Systronix products.  
; clear_expr
; This program is provided by Systronix free of charge and may not be resold.
; clear_expr
;
; clear_expr
; This program is intended for those of you who are enjoying the benefits of
; clear_expr
; the new DPB2 REVE board from Systronix/Intellix.  This card is a very
; clear_expr
; easy to use development system for the Dallas DS5000/1/2 DS2250/1/2 and -T
; clear_expr
; suffix soft microcontrollers.  If you'd like more information, please call
; clear_expr
; or FAX us at the numbers above.
; clear_expr
;
; clear_expr
; REVISION HISTORY -----------------------------------------------------------
; clear_expr
;
; clear_expr
;	01/24/94	BAB	Start, derived from RELAY1.INC for DPB2 rev D
; clear_expr
;
; clear_expr
;
; clear_expr
; NOTES AND COMMENTS ---------------------------------------------------------
; clear_expr
;
; clear_expr
; Allegro UCN5800A
; clear_expr
;
; clear_expr
; The relay driver has 4 open collector outputs, addressed on the data bus
; clear_expr
; as P0.0-3.  Strobe the data with P1.1.
; clear_expr
; The data latch looks like a 373 family device: when the strobe is high,
; clear_expr
; data flows through transparently, and when strobe is low the data is held.
; clear_expr
;
; clear_expr
; On power up P1.1 is high, so to turn off the ports, drive P0 low and then
; clear_expr
; drive P1.1 low. The driver does have a power on clear.  We drive its OE(L) 
; clear_expr
; with a port pin P1.2 which powers up HIGH, disabling the driver until we 
; clear_expr
; deliberately enable it.
; clear_expr
;
; clear_expr
; We use relay 1 (data bit 0) to drive an inexpensive piezo buzzer, available
; clear_expr
; from Systronix to click and beep.  It clicks once per second in the 
; clear_expr
; metronome subroutine.
; clear_expr
;
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
; clear_expr
	ljmp	_BRELAY_INC_END
; clear_expr
; protect against include in program body
; UNSIGNED CHAR RELAY_STATUS ; one bit for each relay, bit=1 if ON
; clear_expr
; UNSIGNED CHAR RELAY_DAT ; relay driver bits numbered 0-3
; clear_expr
; UNSIGNED INT RELAY_NUMBER ; "user" relay number 1-4
; clear_expr
; clear_expr
; clear_expr
_BRELAY_INIT:
; clear_expr
; #ASM
; clear_expr


	setb	P1.2				; disable relay outputs
    mov     P0,#000H            ; shut off relay outputs
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
;    mov     P0,#0FFH            ; convert back to input
; #ASM_END
; clear_expr
	mov	DPTR, #__RELAY_STATUS
	push	DPL
	push	DPH
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
;
	pop	_OPREG_0H
	pop	_OPREG_0L
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BRELAY_SET_DAT:
; clear_expr
; clear_expr
_if1:
	mov	DPTR, #__RELAY_NUMBER
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else1
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__RELAY_DAT
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
	ljmp	_end_if1
_else1:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_if2:
	mov	DPTR, #__RELAY_NUMBER
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #2
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else2
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__RELAY_DAT
	push	DPL
	push	DPH
	mov	R0, #2
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
	ljmp	_end_if2
_else2:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_if3:
	mov	DPTR, #__RELAY_NUMBER
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #3
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else3
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__RELAY_DAT
	push	DPL
	push	DPH
	mov	R0, #4
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
	ljmp	_end_if3
_else3:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_if4:
	mov	DPTR, #__RELAY_NUMBER
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #4
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else4
; clear_expr
	mov	DPTR, #__RELAY_DAT
	push	DPL
	push	DPH
	mov	R0, #8
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
	ljmp	_end_if4
_else4:
; clear_expr
	mov	DPTR, #__RELAY_DAT
	push	DPL
	push	DPH
	mov	R0, #0
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
_end_if4:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_end_if3:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_end_if2:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_end_if1:
; clear_expr
; clear_expr
;	print "Turning on relay bit ", relay_dat
; clear_expr
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BRELAY_ENABLE:
; clear_expr
; #ASM
; clear_expr


	clr		P1.2	; drive low to turn on
; #ASM_END
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BRELAY_DISABLE:
; clear_expr
; #ASM
; clear_expr


	setb	P1.2	; drive high to turn off
; #ASM_END
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BRELAY_TURN_ON:
; clear_expr
; clear_expr
	lcall	_BRELAY_SET_DAT
; clear_expr
; clear_expr
	mov	DPTR, #__RELAY_STATUS
	push	DPL
	push	DPH
	mov	DPTR, #__RELAY_STATUS
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__RELAY_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_COR
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BRELAY_SET_STATUS
; clear_expr
; clear_expr
; clear_expr
_BRELAY_TURN_OFF:
; clear_expr
; clear_expr
	lcall	_BRELAY_SET_DAT
; clear_expr
; clear_expr
	mov	DPTR, #__RELAY_STATUS
	push	DPL
	push	DPH
	mov	DPTR, #__RELAY_STATUS
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__RELAY_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall	_CNOT
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IAND
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BRELAY_SET_STATUS
; clear_expr
; clear_expr
; clear_expr
_BRELAY_TOGGLE:
; clear_expr
; clear_expr
	lcall	_BRELAY_SET_DAT
; clear_expr
; clear_expr
	mov	DPTR, #__RELAY_STATUS
	push	DPL
	push	DPH
	mov	DPTR, #__RELAY_STATUS
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__RELAY_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_CXOR
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BRELAY_SET_STATUS
; clear_expr
; clear_expr
; clear_expr
_BRELAY_SET_STATUS:
; clear_expr
; #ASM
; clear_expr


    mov     DPTR,#__RELAY_STATUS    ; addr in DPTR
    movx    A,@DPTR                 ; RELAY_STATUS in Port 0
    mov     P0,A
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
;    mov     P0,#0FFH                ; convert back to input
; #ASM_END
; clear_expr
	lcall	_BRELAY_ENABLE
; clear_expr
; clear_expr
	ret
; clear_expr
; metronome each second
; clear_expr
; clear_expr
; clear_expr
_BMETRONOME_1:
; clear_expr
; #ASM
; clear_expr


    mov     DPTR,#__RELAY_STATUS    ; addr in DPTR
    movx    A,@DPTR                 ; RELAY_STATUS in Port 0
    mov     P0,A
	setb	P0.0			        ; set relay 1 to on
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
    mov     R0,#0FFH                ; one djnz = 2 cycles (~ 2 usec)
    djnz    R0,$                    ; tone duration
    clr     P0.0                    ; turn relay 1 off
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
; #ASM_END
; clear_expr
	ret
; clear_expr
; make the speaker beep
; clear_expr
; clear_expr
; clear_expr
_BBEEP_1:
; clear_expr
; #ASM
; clear_expr


    mov     DPTR,#__RELAY_STATUS    ; addr in DPTR
    movx    A,@DPTR                 ; RELAY_STATUS in Port 0
    mov     P0,A
	setb	P0.0			        ; set relay 1 to on
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
    ; set tone duration one, 1 djnz = 2 cycles (~ 2 usec)
    mov     R1,#02FH
beep_loop:
    mov     R0,#0FFH
    djnz    R0,$ 
    djnz    R1,beep_loop
    clr     P0.0                    ; turn relay 1 off
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
; #ASM_END
; clear_expr
	ret
; clear_expr
; flash backlight
; clear_expr
; clear_expr
; clear_expr
_BFLASH_2:
; clear_expr
; #ASM
; clear_expr


    mov     DPTR,#__RELAY_STATUS    ; addr in DPTR
    movx    A,@DPTR                 ; RELAY_STATUS in Port 0
    mov     P0,A
	setb	P0.1			        ; set relay 2 on
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
    mov     R0,#0FFH                ; one djnz = 2 cycles (~ 2 usec)
    djnz    R0,$                    ; tone duration
    mov     R0,#0FFH                ; one djnz = 2 cycles (~ 2 usec)
    djnz    R0,$                    ; tone duration
    clr     P0.0                    ; turn relay 2 off
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
; #ASM_END
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BRELAY_INC_END:
; protect against include in program body
; clear_expr
; clear_expr
; clear_expr
_B100:
	mov	R0, #100
	mov	R2, #0
	lcall	_LINE_DIAG
; Clear Display
; clear_expr
; clear_expr
; clear_expr
_B101:
	mov	R0, #101
	mov	R2, #0
	lcall	_LINE_DIAG
	lcall	_B1000
; clear_expr
; software init
; enable clock time update
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall	_TIME_SET
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall	_MSEC_SET
; clear_expr
; clear_expr
	lcall	_CLOCK_START
; clear_expr
; clear_expr
	lcall _DS5_ECC_RD
; clear_expr
; get current time
; clear_expr
	mov	R0, #1
	mov	R2, #0
	mov DPTR, #_DS_ECC_RUN
	lcall	_CHR_PUT
; clear_expr
; clear_expr
	lcall _DS5_ECC_WR
; clear_expr
; be sure ECC is running
; clear_expr
; clear_expr
_B200:
	mov	R0, #200
	mov	R2, #0
	lcall	_LINE_DIAG
; Now send some data
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	setb	_CPRT_INP
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str0
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
_B285:
	mov	R0, #29
	mov	R2, #1
	lcall	_LINE_DIAG
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #128
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_B1010
; clear_expr
; set to top row addr=000H
;           0	        1				; addr=0 dec, chars 0-16
; clear_expr
;           0123456789012345	
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str1
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
;_%%PRINTLB_INIT:			; save SFRs used by serial print#

  IF	CPRINT			
	jb	_CPRT_FLAG, $		; stay here until console buffer empty
  ENDIF

	setb	_SPRT_FLAG

  	push	IE	  		; save interrupt condition
	push    TH1	 		; ... interrupt and timer1 registers
	push    TL1
	push    TCON
	push    TMOD

	anl	TMOD, #0Fh		; set timer1 for mode 1, 16 bit counter
	orl	TMOD, #10h
	anl	IE, #0C6h 		; leave timer 0 enabled if it already is
			     		; leave ext 1 enabled
			     		; disable serial port interrupt
			     		; disable timer2 overflow interrupt (dependent
			     		; on use of timer2)

	mov	DPTR, #_str2
	lcall	_PRINT_ROM
;_%%PRINTLB_REST:	

	pop	TMOD			; restore SFRs used by serial print#
	pop	TCON
	pop	TL1
	pop	TH1
	pop	IE

	clr	_SPRT_FLAG		; clear the sprt in progress flag

	lcall	_INT_PEND		; check for pending interrupts


; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #192
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_B1010
; clear_expr
; set to 2nd row addr=040H
;           0123456789012345
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str3
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
;_%%PRINTLB_INIT:			; save SFRs used by serial print#

  IF	CPRINT			
	jb	_CPRT_FLAG, $		; stay here until console buffer empty
  ENDIF

	setb	_SPRT_FLAG

  	push	IE	  		; save interrupt condition
	push    TH1	 		; ... interrupt and timer1 registers
	push    TL1
	push    TCON
	push    TMOD

	anl	TMOD, #0Fh		; set timer1 for mode 1, 16 bit counter
	orl	TMOD, #10h
	anl	IE, #0C6h 		; leave timer 0 enabled if it already is
			     		; leave ext 1 enabled
			     		; disable serial port interrupt
			     		; disable timer2 overflow interrupt (dependent
			     		; on use of timer2)

	mov	DPTR, #_str4
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
;_%%PRINTLB_REST:	

	pop	TMOD			; restore SFRs used by serial print#
	pop	TCON
	pop	TL1
	pop	TH1
	pop	IE

	clr	_SPRT_FLAG		; clear the sprt in progress flag

	lcall	_INT_PEND		; check for pending interrupts


; clear_expr
; clear_expr
	mov	DPTR, #__WAIT_SEC
	push	DPL
	push	DPH
	mov	R0, #2
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_BWAITSEC
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str5
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
_BDISPLAY_SHIFT:
; clear_expr
;
; clear_expr
; note that the 16x2 only has 16 chars of display RAM per line
; clear_expr
; but each line is 40 chars long!
; clear_expr
; so a complete circular shift takes 40 chars, 24 of which are blank
; clear_expr
;
; clear_expr
; clear_expr
	lcall	_BWAITSEC
; clear_expr
; clear_expr
	mov	DPTR, #__X
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #_fnlimit5
	push	DPL
	push	DPH
	mov	R0, #16
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #_fnstep5
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
_loop5:
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall	_MSEC_SET
; clear_expr
; clear_expr
_loop6:
; clear_expr
; clear_expr
	lcall	_MSEC_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #200
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UILT
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop6
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #24
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_B1010
; clear_expr
; shift display left
; clear_expr
	mov	DPTR, #__X
	push	DPL
	push	DPH
	mov	DPTR, #__X
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_fnstep5
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #__X
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_fnlimit5
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	mov	DPTR, #_fnstep5
	lcall	_STEP_SI
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop5
; clear_expr
; clear_expr
	mov	DPTR, #__X
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #_fnlimit7
	push	DPL
	push	DPH
	mov	R0, #16
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #_fnstep7
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
_loop7:
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall	_MSEC_SET
; clear_expr
; clear_expr
_loop8:
; clear_expr
; clear_expr
	lcall	_MSEC_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #200
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UILT
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop8
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #28
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_B1010
; clear_expr
; shift display right
; clear_expr
	mov	DPTR, #__X
	push	DPL
	push	DPH
	mov	DPTR, #__X
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_fnstep7
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #__X
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_fnlimit7
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	mov	DPTR, #_fnstep7
	lcall	_STEP_SI
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop7
; clear_expr
; clear_expr
	lcall	_BWAITSEC
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall	_TIME_SET
; clear_expr
; clear_expr
	mov	R0, #2
	mov	R2, #0
	mov	_ONTIME_H, R2		; high byte
	mov	_ONTIME_L, R0		; low byte
	mov	DPTR, #_BTIMER_TICK
	mov	R0, DPL
	mov	R2, DPH
	lcall	_ONTIME
	setb	_ON_TIME		; ontime is active
; clear_expr
; clear_expr
; clear_expr
_BSTAY:
; clear_expr
; clear_expr
	ljmp	_BSTAY
; clear_expr
; clear_expr
; clear_expr
_B999:
	mov	R0, #231
	mov	R2, #3
	lcall	_LINE_DIAG
; BASIC END (subroutines may follow)
	ljmp	_end_module
; clear_expr
; clear_expr
; clear_expr
_B1000:
	mov	R0, #232
	mov	R2, #3
	lcall	_LINE_DIAG
	setb	_CPRT_INP
	mov	DPTR, #_str6
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	lcall	_CLOCK_START
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall	_MSEC_SET
; clear_expr
; clear_expr
_loop9:
; clear_expr
; clear_expr
	lcall	_MSEC_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #20
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UILT
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop9
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	R0, #48
	mov	R2, #0
	mov	P0, R0
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall	_MSEC_SET
; clear_expr
; clear_expr
_loop10:
; clear_expr
; clear_expr
	lcall	_MSEC_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #5
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UILT
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop10
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	lcall	_B1016
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	R0, #48
	mov	R2, #0
	mov	P0, R0
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall	_MSEC_SET
; clear_expr
; clear_expr
_loop11:
; clear_expr
; clear_expr
	lcall	_MSEC_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #5
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UILT
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop11
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	lcall	_B1016
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	R0, #48
	mov	R2, #0
	mov	P0, R0
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall	_MSEC_SET
; clear_expr
; clear_expr
_loop12:
; clear_expr
; clear_expr
	lcall	_MSEC_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #5
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UILT
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop12
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	lcall	_B1016
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	R0, #48
	mov	R2, #0
	mov	P0, R0
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall	_MSEC_SET
; clear_expr
; clear_expr
_loop13:
; clear_expr
; clear_expr
	lcall	_MSEC_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #5
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UILT
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop13
; clear_expr
; set interface to 8 bits, 1 line display
; clear_expr
; 030H = 8 bits, one line, 5x7 font
; clear_expr
; 038H = 8 bits, 2 lines, 5x7 font
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	R0, #56
	mov	R2, #0
	mov	P0, R0
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	lcall	_B1016
; clear_expr
; Turn on display
; clear_expr
; 0FH = cursor on and blinking
; clear_expr
; 0CH = no cursor
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	R0, #12
	mov	R2, #0
	mov	P0, R0
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	lcall	_B1016
; clear_expr
; clear display, cursor home
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	R0, #1
	mov	R2, #0
	mov	P0, R0
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	lcall	_B1016
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_B1010:
	mov	R0, #242
	mov	R2, #3
	lcall	_LINE_DIAG
; strobe instr, call here to use LCD_DAT
; clear_expr
; clear_expr
; clear_expr
_B1015:
	mov	R0, #247
	mov	R2, #3
	lcall	_LINE_DIAG
	mov	DPTR, #__LCD_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	mov	P0, R0
; clear_expr
; clear_expr
; clear_expr
_B1016:
	mov	R0, #248
	mov	R2, #3
	lcall	_LINE_DIAG
; call here with your own data
; clear_expr
; #ASM
; clear_expr


	CLR	P1.4	; set R/S low for instr
	CLR	P1.5	; set WR low
	CLR	P1.6	; clear enable
	SETB	P1.6	; strobe it
	CLR	P1.6	; clear enable
	mov	B, #40	;
	DJNZ	B, $	; wait about 40 usec
; #ASM_END
; clear_expr
; clear_expr
_B1019:
	mov	R0, #251
	mov	R2, #3
	lcall	_LINE_DIAG
	ret
; clear_expr
; clear_expr
; clear_expr
_B1100:
	mov	R0, #76
	mov	R2, #4
	lcall	_LINE_DIAG
; data write, call here to use LCD_DAT
; clear_expr
; clear_expr
; clear_expr
_B1105:
	mov	R0, #81
	mov	R2, #4
	lcall	_LINE_DIAG
	mov	DPTR, #__LCD_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	mov	P0, R0
; clear_expr
; clear_expr
; clear_expr
_B1106:
	mov	R0, #82
	mov	R2, #4
	lcall	_LINE_DIAG
; call here with your own data already on PORT0
; clear_expr
; #ASM
; clear_expr


	SETB	P1.4	; set R/S high for data
	CLR 	P1.5	; set WR low
	CLR	P1.6	; clear enable
	SETB	P1.6	; strobe it
	CLR	P1.6	; clear enable
	mov	B, #50	;
	DJNZ	B, $	; wait about 100 usec
; #ASM_END
; clear_expr
; clear_expr
_B1119:
	mov	R0, #95
	mov	R2, #4
	lcall	_LINE_DIAG
	ret
; clear_expr
; clear_expr
; clear_expr
_BWAITSEC:
; clear_expr
; clear_expr
	mov	DPTR, #__TIME_TMP
	push	DPL
	push	DPH
	lcall	_TIME_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__WAIT_SEC
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIADD
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	mov	DPTR, #__MSEC_TMP
	push	DPL
	push	DPH
	lcall	_MSEC_GET
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
_loop14:
; clear_expr
; clear_expr
	lcall	_TIME_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__TIME_TMP
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIEQ
	push	_OPREG_0L
	push	_OPREG_0H
	lcall	_MSEC_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__MSEC_TMP
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIEQ
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IAND
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_loop14
; clear_expr
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BTIMER_TICK:
; clear_expr
; clear_expr
	lcall	_TIME_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIADD
	mov	_ONTIME_H, R2		; high byte
	mov	_ONTIME_L, R0		; low byte
	mov	DPTR, #_BTIMER_TICK
	mov	R0, DPL
	mov	R2, DPH
	lcall	_ONTIME
	setb	_ON_TIME		; ontime is active
; clear_expr
; clear_expr
_if15:
	mov	DPTR, #__DATE_TIME
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #5
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IGT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else15
; clear_expr
; clear_expr
; clear_expr
	lcall	_BDATE_DISP
; clear_expr
; clear_expr
; clear_expr
	ljmp	_end_if15
_else15:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	lcall	_BTIME_DISP
; clear_expr
; clear_expr
; clear_expr
_end_if15:
; clear_expr
; clear_expr
; clear_expr
_if16:
	mov	DPTR, #__DATE_TIME
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IGT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else16
; clear_expr
	mov	DPTR, #__DATE_TIME
	push	DPL
	push	DPH
	mov	R0, #0
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
	ljmp	_end_if16
_else16:
; clear_expr
	mov	DPTR, #__DATE_TIME
	push	DPL
	push	DPH
	mov	DPTR, #__DATE_TIME
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
_end_if16:
; clear_expr
; clear_expr
; clear_expr
_if17:
	mov	DPTR, #__TOP
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #5
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IGE
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else17
; clear_expr
	mov	DPTR, #__TOP
	push	DPL
	push	DPH
	mov	R0, #0
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
	ljmp	_end_if17
_else17:
; clear_expr
	mov	DPTR, #__TOP
	push	DPL
	push	DPH
	mov	DPTR, #__TOP
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
_end_if17:
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__TOP
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	push	_OPREG_0L
	push	_OPREG_0H
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #6
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_ongo_a18
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_1H
	pop	_OPREG_1L
	ljmp	_ONGO_ERR2
_ongo_a18:
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IGE
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_ongo_b18
	pop	_OPREG_1H
	pop	_OPREG_1L
	ljmp	_ONGO_ERR1
_ongo_b18:
	pop	_OPREG_0H
	pop	_OPREG_0L
	mov	DPTR, #_ongo_tbl18
	mov	R1, DPL
	mov	R3, DPH
	lcall	_ONGO
; clear_expr
; clear_expr
	lcall	_BRELAY_TEST
; clear_expr
; clear_expr
	ljmp	_RETI_BAS
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
; Date and time display, with 16 chars no space between date & time:
; clear_expr
; on LCD line 2
; clear_expr
;
; clear_expr
; 0123456789012345
; clear_expr
; MM-DD-YYHH:MM:SS
; clear_expr
;
; clear_expr
; clear_expr
; clear_expr
_BDATE_TIME_DISP:
; clear_expr
; clear_expr
	lcall _DS5_ECC_RD
; clear_expr
; clear_expr
	lcall	_BMETRONOME_1
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #192
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_B1010
; clear_expr
; set to 2nd row addr=040H
; clear_expr
_if19:
	mov DPTR, #_DS_MONTH
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else19
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str7
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
_else19:
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov DPTR, #_DS_MONTH
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str8
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
_if20:
	mov DPTR, #_DS_DATE
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else20
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str9
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
_else20:
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov DPTR, #_DS_DATE
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str10
	lcall	_PRINT_ROM
	mov DPTR, #_DS_YEAR
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
_if21:
	mov DPTR, #_DS_HOUR
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else21
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str11
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
_else21:
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov DPTR, #_DS_HOUR
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str12
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
_if22:
	mov DPTR, #_DS_MIN
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else22
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str13
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
_else22:
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov DPTR, #_DS_MIN
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str14
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
_if23:
	mov DPTR, #_DS_SEC
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else23
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str15
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
_else23:
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov DPTR, #_DS_SEC
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
	ret
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
; Date display
; clear_expr
;
; clear_expr
; 0123456789012345
; clear_expr
; DATE: MM-DD-19YY
; clear_expr
;
; clear_expr
; clear_expr
; clear_expr
_BDATE_DISP:
; clear_expr
; clear_expr
	lcall _DS5_ECC_RD
; clear_expr
; clear_expr
	lcall	_BMETRONOME_1
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #192
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_B1010
; clear_expr
; set to 2nd row addr=040H
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str16
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
_if24:
	mov DPTR, #_DS_MONTH
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else24
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str17
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
_else24:
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov DPTR, #_DS_MONTH
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str18
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
_if25:
	mov DPTR, #_DS_DATE
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else25
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str19
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
_else25:
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov DPTR, #_DS_DATE
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str20
	lcall	_PRINT_ROM
	mov DPTR, #_DS_YEAR
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str21
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
	ret
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
; Time display
; clear_expr
;
; clear_expr
; 0123456789012345
; clear_expr
; TIME: HH:MM:SS
; clear_expr
;
; clear_expr
; clear_expr
; clear_expr
_BTIME_DISP:
; clear_expr
; clear_expr
	lcall _DS5_ECC_RD
; clear_expr
; clear_expr
	lcall	_BMETRONOME_1
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #192
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_B1010
; clear_expr
; set to 2nd row addr=040H
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str22
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
_if26:
	mov DPTR, #_DS_HOUR
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else26
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str23
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
_else26:
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov DPTR, #_DS_HOUR
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str24
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
_if27:
	mov DPTR, #_DS_MIN
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else27
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str25
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
_else27:
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov DPTR, #_DS_MIN
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str26
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
_if28:
	mov DPTR, #_DS_SEC
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else28
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str27
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
_else28:
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov DPTR, #_DS_SEC
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str28
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BLCDTOP1:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #128
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_B1010
; clear_expr
; set to top row addr=000H
;         0	      1				; addr=0 dec, chars 0-23
; clear_expr
;         0123456789012345
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str29
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BLCDTOP2:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #128
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_B1010
; clear_expr
; set to top row addr=000H
;         0	      1				; addr=0 dec, chars 0-23
; clear_expr
;         0123456789012345
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str30
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BLCDTOP3:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #128
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_B1010
; clear_expr
; set to top row addr=000H
;         0	      1				; addr=0 dec, chars 0-23
; clear_expr
;         0123456789012345
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str31
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BRELAY_TEST:
; clear_expr
; Turn relays 2,3,4 on sequentially then all off then repeat
; clear_expr
; Don't touch relay 1 since it is the metronome
; clear_expr
; clear_expr
_if29:
	mov	DPTR, #__RELAY_NUMBER
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #4
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIGT
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__RELAY_NUMBER
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIEQ
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IOR
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else29
; clear_expr
; clear_expr
; clear_expr
	lcall	_BRELAY_INIT
; clear_expr
; turn all off
; clear_expr
	mov	DPTR, #__RELAY_NUMBER
	push	DPL
	push	DPH
	mov	R0, #2
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; for next time
	pop	_OPREG_0H
	pop	_OPREG_0L
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
	ljmp	_end_if29
_else29:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	lcall	_BRELAY_TURN_ON
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str32
	lcall	_PRINT_ROM
	mov	DPTR, #__RELAY_NUMBER
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_BTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str33
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
	mov	DPTR, #__RELAY_NUMBER
	push	DPL
	push	DPH
	mov	DPTR, #__RELAY_NUMBER
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; for next time
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIADD
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
_end_if29:
; clear_expr
; clear_expr
; clear_expr
	ret
; clear_expr
; clear_expr
; BASIC END (subroutines may follow)
	ljmp	_end_module
; clear_expr
_INT_PFW:
					; all other interrupts locked out!
    IF ON_PWRFL
	lcall	_DS_USER_PWRFL		; call user BASIC routine, ret here
    ENDIF





    

_INT_PFW2:
	mov 	ACC, PCON	 	; check PFW flag PCON.5
	jb	ACC.5, _INT_PFW2 	; wait til it's clear

	pop	PSW  			; pushed at vector
	pop	ACC		
	pop	ACC			; waste calling stack

    	setb	F0			; Runtrap flags -
	mov	A, #0AAH		; These let us detect...
	mov	B, #055H		; ...a run trap at startup

	mov	DPTR, #_runtrap
	push	DPL
	push	DPH	       		; force _runtrap as ret address
	reti				; this will go to the pushed label

_SET_CBAUD_T1:
	anl	TCON, #3Fh	
    IF TARGET_8032
	anl	T2CON, #0CFh	
    ENDIF
	anl	TMOD, #2Fh	
	orl	TMOD, #20h	
	orl	PCON, #80h	
	mov	TH1, R0		
	mov	TL1, #0		
	setb	TR1		
	ret

;_%%DS5_WATCHDOG:


_DS5_WDOG_RST:
	mov	0C7H, #0AAH	; timed access keys
	mov	0C7H, #055H
	setb	IP.7		; reset watchdog
	ret
 

_DS5_WDOG_ON:
	lcall	_DS5_WDOG_RST	; clear WDOG timer to 0
	mov	0C7H, #0AAH	; timed access keys
	mov	0C7H, #055H
	orl	PCON, #004H	; enable watchdog PCON.2
	setb	_WDOG_FLAG	; set "wdog active" flag bit

				; now be sure timer0 is running
	ret


_DS5_WDOG_OFF:
	mov	0C7H, #0AAH	; timed access keys
	mov	0C7H, #055H
	anl	PCON, #0FBH	; disable watchdog PCON.2
	clr	_WDOG_FLAG	; clear "wdog active" flag bit
	ret

_CLEAR_UVAR:	; clear user variables (if any) in external data RAM
	mov	DPTR, #_udataend
	mov	R2, DPH
	mov	R0, DPL
	mov	DPTR, #_udatabeg
	sjmp	_CLEAR1

_CLEAR:
	mov	A, DPL		; add count to the starting address to get a ... 
	add	A, R0		; ... terminal address
	mov	R0, A
	mov	A, DPH
	addc	A, R2
	mov	R2, A
	sjmp	_CLEAR1

	
_CLEARIT:
	clr	A 		; this is the zero that we will write
	movx	@DPTR, A	; write the byte
	inc	DPTR		; point to next byte but don't clear it yet

_CLEAR1:
	mov	A, R0		; compare current count with terminal count
	xrl	A, DPL		; low bytes first
	jnz	_CLEARIT	;
	
	mov	A, R2		; compare the high bytes if the low bytes are the same
	xrl	A, DPH
	jnz	_CLEARIT
	ret    			; reached the terminus so we're done

_UIEQ:
	lcall	_UI_RELOP_TEST
	ljmp	_EQ_COM

_RO_COM:
_NEQ_COM:
	cpl		F0				; compliment F0 so we can share _EQ_COM

_EQ_COM:
	mov		C, F0
	sjmp	_RO_COM_1
	
_GT_COM:
	cpl		C
	
_LT_COM:
	anl		C, /F0
	sjmp	_RO_COM_1


_GE_COM:
	cpl		C

_LE_COM:
	orl		C, F0				

_RO_COM_1:
	jc		_RO_COM_2			; carry == 1 then OPREG0 < OPREG1
	ljmp	_RET_ZERO			; 

_RO_COM_2:
	ljmp	_RET_65K			; 

_UI_RELOP_TEST:
	clr	F0
	mov	A, R2
	cjne	A, _OPREG_1H, _URT_X	; compare the high bytes: jump if not equal

_UC_RELOP_TEST:				; entry point for character compares
	clr	F0
	mov	A, R0			; high bytes equal compare low bytes
	cjne	A, _OPREG_1L, _URT_X	; compare the low bytes: jump if not equal
	setb	F0			; F0 == 1 then:  OPREG0 == OPREG1
					; carry == 1 then:  OPREG0 < OPREG1
_URT_X:					; else: OPREG0 > OPREG1
	ret				; done 
	
_RET_ZERO:
	clr		A				; the ZERO
	mov		R0, A			; put the ZERO in OPREG0
	mov		R2, A
	ret						; returns to the routine that called the compare
	
_RET_65K:
	mov		R0, #0FFh		; put the 65535 in OPREG0
	mov		R2, #0FFh
	ret						; returns to the routine that called the compare
	
_COR:
	mov		A, R0	; low byte of OPREG0
	orl		A, R1	; OPREG0L .OR. OPREG1L
	mov		R0, A	; save the result
	ret

_CNOT:
	mov		A, R0	; low byte of OPREG0
	cpl		A		; .NOT. OPREG0L
	mov		R0, A	; save the result
	ret

_IAND:
	mov		A, R0	; low byte of OPREG0
	anl		A, R1	; OPREG0L .AND. OPREG1L
	mov		R0, A	; save the result
	mov		A, R2	; high byte of OPREG0
	anl		A, R3	; OPREG0H .AND. OPREG1H
	mov		R2, A	; save the result
	ret

_CXOR:
	mov		A, R0	; low byte of OPREG0
	xrl		A, R1	; OPREG0L .XOR. OPREG1L
	mov		R0, A	; save the result
	ret

_INT_PUT:
	mov	A, R0		; get the low byte in the accumulator
	movx	@DPTR, A	; put the byte
 	inc	DPTR		; point to high byte
	mov	A, R2		; get the high byte in the accumulator
	movx	@DPTR, A	; put the byte
	ret			; done

_LINE_DIAG:

	IF DS5000
		mov 	ACC, PCON	 	; check PFW flag PCON.5
		jb	ACC.5, _LINE_DIAGX 	; if PFW int, leave now!
	ENDIF

	IF PROGLINE
		mov dptr, #_BASLINE
		lcall _INT_PUT
	ENDIF

	IF CHECK_ISTACK
		lcall _ISTACK_CHECK
	ENDIF

_LINE_DIAGX:
	ret

_TIME_SET:
	mov	_RTC_SEC_LO, R0		; load the low byte of data from OPREG0
	mov	_RTC_SEC_HI, R2		; load the high byte of data from OPREG0
	ret	   			; done
		
;_%%INT_0B_13:			

  IF ONEX1
_INT13_DISPATCH:			; the ONEX1 handler entry point
	jnb	_ON_EX1, _INT13_DISX	; exit if onex1 instruction not active

  ;********************************
    IF SPRINT				; print#
      	jnb	_SPRT_FLAG, _INT13_SX	; continue if print# not in progress
    	setb	_ON_EX1_PND		; set pend flag for print# use
    	pop	psw			; ret (not reti) to print# in progress
    	ret				; this disables further onex1 interrupts and leaves
					; TCON.3 cleared by call to vector 13H
_INT13_SX:
    ENDIF
  ;********************************


  ;********************************
    IF (CPRINT * PRINT_COMPLETE)	; 6/30/92 to enable ONEX1 while serial I/O
	jnb	_CPRT_INP, _INT13_CX
    	setb	_ON_EX1_PND		; set pend flag for print use
    	pop	psw			; ret (not reti) to print in progress
    	ret				; this disables further onex1 interrupts and leaves
_INT13_CX:
    ENDIF
  ;********************************

    IF (CPRINT * PRINT_COMPLETE)	; ...still need this w/cprt_inp.
	jb	_CPRT_FLAG, $		; print in progress, finish it
    ENDIF				; cprt_inp can be clear but buff still
    					; outputting characters.  We shouldn't
					; care - we can add to those in the
					; buffer if we print in onex1???

	push	DPL			; onex1 instr active so proceed
	push	DPH
	mov	DPTR, #_INT_13_LOC	; get current handler addr
	clr	F0		; means this was NOT the ontime handler, is onex1 instead
	setb	_ON_EX1_INP		; set in progress flag
	clr	_ON_EX1_PND		; clear pend flag
	push	PSW			; to save the F0 flag

	sjmp	_INT_DISPATCH

_INT13_DISX:				; exit with no handler actions
	pop		PSW		; onex1 not active so return 
	reti				

  ENDIF					; endif onex1



  IF RTC

_INT0B_PND_DISP:			; pending ontime entry point
	push	DPL			; save dptr and...
	push	DPH			; ...fall through to rest of int0b

_INT_0B_DISPATCH:			; the RTC handler entry point
	mov	DPTR, #_INT_0B_LOC	; get current handler addr
	setb	F0			; means this was ontime handler
	push	PSW			; to save the F0 flag 

  ENDIF

_INT_DISPATCH:
	push	ACC
	push	B
	push	_R0
	push	_R1
	push	_R2
	push	_R3
	push	_R4
	push	_R5
	push	_R6
	push	_R7	  

	setb	_IDLE_END		; set the flag to terminate IDLE mode

	movx	A, @DPTR		; low byte
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR		; high byte
	mov	DPH, A	   		; load the DPTR with the address of the handler
	mov	DPL, _R0
	clr	A
	jmp	@A+DPTR			; go do the routine

_INT_RTC:

 	jnb	_CLOCK_BIT, _INT_RTC_XX		; real time clock not enabled so quit

	push	ACC				; save accumulator

	mov	TH0, _RTC_RELOAD		; reLOAD THE TIMER
	mov	A, _RTC_MILLI			; GET MILLISECOND COUNTER
	inc	A				; BUMP COUNTER
	cjne	A, #200, _INT_RTC_1		; jump if no need to inc seconds counters
	clr	A				; otherwise FORCE ACC TO BE ZERO
	inc	_RTC_SEC_LO			; INCREMENT LOW TIMER
	cjne	A, _RTC_SEC_LO, _INT_RTC_1	; CHECK LOW VALUE, if 0 it rolled over
	inc	_RTC_SEC_HI			; ...so incr TIMER HIGH byte

_INT_RTC_1:
	mov	_RTC_MILLI, A			; save new millisec value

 
	jnb	_ON_TIME, _INT_RTC_X		; ONTIME not executed so leave

	jb 	_ON_TIME_INP, _INT_RTC_X	; another ONTIME in progress?
						; ...if so, try again later

	jb 	_ON_TIME_PND, _INT_RTC_YES	; ONTIME previously compared?

						; see if time >= ontime value
	mov	A, _ONTIME_H	  	     	; check high byte
	cjne	A, _RTC_SEC_HI, _INT_RTC_NE  	; C set if rtc_h > ontime_h
						; if here, H were ==
	mov	A, _ONTIME_L 	   	     	; get low byte
	cjne	A, _RTC_SEC_LO, _INT_RTC_NE  	; C set if rtc_l > ontime_l
						; if here, both were ==
	sjmp	_INT_RTC_YES   			; ...so go do the ontime

_INT_RTC_NE:					; not ==, could be >
	jnc	_INT_RTC_X			; rtc not >= ontime so leave

_INT_RTC_YES:					; rtc >= ontime

 ;********************************
    IF SPRINT
	jb	_SPRT_FLAG, _INT_RTC_PX		; sprt in progress, try later
    ENDIF
  ;********************************

  ;********************************
    IF CPRINT
	jb	_CPRT_INP, _INT_RTC_PX		; cprt in progress, try later
    	IF PRINT_COMPLETE
	    jb	_CPRT_FLAG, _INT_RTC_PX		; complete the print first
	ENDIF
    ENDIF
  ;********************************

  ;********************************
    IF DS5000 
    	mov	A, MCON
	jb	ACC.2, _INT_RTC_PX		; if ECE2/PES set, leave
    ENDIF					; ...do ontime later

    IF (DS5000 EQ 2)
	jb	RPCTL.5, _INT_RTC_PX		; if EXBS set, leave
    ENDIF					; ...do ontime later
  ;********************************

	pop	ACC				; restore acc before dptr push
	setb	_ON_TIME_INP			; ontime now in progress 
	clr	_ON_TIME_PND			; ontime no longer waiting
	clr	_ON_TIME			; ontime no longer current
	push	DPL				; save current DPTR
	push	DPH
	mov	DPTR, #_INT_RTC_J
	push	DPL			 	; push label we want to go to
	push	DPH
	reti					; pop label->PC and enable RTC interrupts

_INT_RTC_J:					; jump and never return...
	ljmp	_INT_0B_DISPATCH		; ...jump to ontime dispatcher

_INT_RTC_PX:					; if here, exit w/ pnd flag
	setb	_ON_TIME_PND			; ontime waiting to be handled

_INT_RTC_X:					; if here, exit w/o pnd flag
	pop	ACC		       		; restore accumulator

_INT_RTC_XX:
 	pop	PSW		       		; restore PSW from vector push
	reti

_CLR_RTC:
	clr 	A
	mov 	_RTC_SEC_LO, A		; clear RTC time values
	mov 	_RTC_SEC_HI, A
	mov 	_RTC_MILLI, A
	mov 	_ONTIME_L, A		; clear ONTIME {time comparison value}
	mov 	_ONTIME_H, A
_CLR_RTC_FLAGS:
	clr 	_ON_TIME	      	; clear "ONTIME active" flag bit
	clr 	_ON_TIME_PND 		; clear "ONTIME pending" flag bit
	clr 	_ON_TIME_INP 		; clear "ONTIME in process" flag bit
 	ret

;_%%MSEC:

_MSEC_GET:

	mov 	ACC, _RTC_MILLI		; get number of 5 msec ticks
	mov 	B, #5			; 5 msec per tick
	mul	AB
	mov	_R0, ACC		; result LSB
	mov	_R2, B			; result MSB
	ret


_MSEC_SET:
	mov	_R1, #5
	mov	_R3, #0
	lcall	_UIDIV			; get ticks in opreg0
	mov	_RTC_MILLI, _R0		; save ticks 
	ret
_UIDIV:
	clr		C
	mov		A, R1			; test for zero divisor
	orl		A, R3
	jnz		_UIDIV6
	setb	C				; divisor is zero; set carry
	ljmp	_MATH_DIV0		; jump if div by zero
	ret

_UIDIV6:
	mov		R7, #0			; zero the partial remainder
	mov		R6, #0
	mov		R4, #0			; zero quotient registers
	mov		R5, #0
	mov		B, #16			; load loop count
	
_UIDIV1:
	lcall	_UIDIV4			; shift the dividend and return MSB in C
	mov		A, R6			; shift carry into LSB of partial remainder
	rlc		A
	mov		R6, A
	mov		A, R7
	rlc		A
	mov		R7, A
							; now test to see if R7:R6 >= R3:R1
	clr		C
	mov		A, R7			; subtract R3 from R7 to see if R3 < R7
	subb	A, R3			; A = R7 - R3, carry set if R7 < R3
	jc		_UIDIV3	
							; at this point R7 > R3 or R7 = R3
	jnz		_UIDIV2			; jump if R7 > R3
							; if R7 = R3, test for R6 >= R1
	clr		C
	mov		A, R6
	subb	A, R1			; A = R6 - R1, carry set if R6 < R1
	jc		_UIDIV3
	
_UIDIV2:					; subtract the divisor from the partial remainder
	clr		C
	mov		A, R6
	subb	A, R1			; A = R6 - R1
	mov		R6, A
	mov		A, R7
	subb	A, R3			; A = R7 - R3 - borrow
	mov		R7, A
	setb	C				; shift 1 into the quotient
	sjmp	$+3
	
_UIDIV3:					; can't subtract so shift a zero into the quotient
	clr		C
	lcall	_UIDIV5			; shift the carry bit into the quotient
	djnz	B, _UIDIV1		; test for completion

	mov		_OPREG_0L, R4	; Now we are really done, move the quotient ...
	mov		_OPREG_0H, R5	; ... to OPREG0.

	mov		_OPREG_1H, R7	; ... and the remainder to OPREG1
	mov		_OPREG_1L, R6
	clr		C				; clear the carry flag
	ret						; done
	
_UIDIV4:
	; shift the dividend one bit to the left and return the MSB in C
	clr		C
	mov		A, R0
	rlc		A
	mov		R0, A
	mov		A, R2
	rlc		A
	mov		R2, A
	ret

_UIDIV5:
	mov		A, R4		; shift quotient one bit left and C into MSB
	rlc		A
	mov		R4, A
	mov		A, R5
	rlc		A
	mov		R5, A
	ret
	
;_%%MATH_ERRS:

_MATH_OVER:			; overflow
	IF  ERR_MSG 
		mov		DPTR, #_mathover_msg
	ENDIF
		mov A, #OVERFLOW
		ljmp _ERR_HAND

_MATH_DIV0:			; div by zero
	IF  ERR_MSG 
		mov		DPTR, #_mathdiv0_msg
	ENDIF
		mov A, #ZERO_DIVIDE
		ljmp _ERR_HAND


_MATH_BAD:			; bad argument
	IF  ERR_MSG 
		mov		DPTR, #_mathbad_msg
	ENDIF
		mov A, #BAD_ARGUMENT
		ljmp _ERR_HAND


_CLOCK_START:
	anl	TMOD,#0F0H		;set up the mode
	setb	_CLOCK_BIT		;set clock active flag
	orl	IE, #82H		;enable et0 and ea
	setb	TR0			;turn on the timer
	ret

_ONTIME:

	mov	DPTR, #_INT_0B_LOC	; get the address of _INT_0B_LOC
	mov	A, R0  			; save low byte of handler address
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2	  		; save high byte of handler address
	movx	@DPTR, A
	orl	IE, #82H  		; enable timer 0 overflow interupt
	ret		   		; done

_CHR_PUT:
	mov	A, R0		; get the byte in the accumulator
	movx	@DPTR, A	; put the byte
	ret			; done

_CHR_GET:
	movx	A, @DPTR	; get the byte
	mov	R0, A		; put it in OPREG0
	mov	R2, #0		; clr the high byte
	ret			; done

;_%%DS1215:


_DS5_ECC_RD:
	push	IE			; save interrupt status
	anl	IE, #82H		; leave EA and ET0 for RTC

	lcall	_DS5_ECC_CLR		; reset ECC pointer
	lcall	_DS5_ECC_KEY		; apply key to ECC for use

	mov	B, #8			; byte count
	mov	DPTR, #_DS_HSEC		; first storage location

_DS5_ECC_RD1:
	lcall	_DS5_ECC_RB		; read an ECC byte to acc

	movx	@DPTR, A		; save acc value
	inc	DPTR			; next location
	djnz	B, _DS5_ECC_RD1		; do it 8 times
					; now we've read "raw" bcd ecc time

_DS5_ECC_RHR:				; now adj hours, set ampm, mode
	mov	DPTR, #_DS_HOUR		;
	movx	A, @DPTR		; get hours BCD
	mov	R0, A			; copy hrs BCD to R0
	mov	DPTR, #_DS_ECC_MODE	; MODE location
	jb	ACC.7, _DS5_ECC_RD12	; acc.7=1 is 12 hour mode
	mov	A, #24
	movx	@DPTR, A		; mode=24
	mov	DPTR, #_DS_AMPM
	mov	A, R0			; get BCD hrs again
	lcall	_BCD_TO_HEX		; hex hrs in acc
	cjne	A, #12, $+3		; c set if hrs<12, 0 if hrs>=12
	clr	A
	cpl	C
	mov	ACC.0, C   		; acc=1 if hrs>=12
	movx	@DPTR, A		; ampm = 1 if hrs>=12
	sjmp	_DS5_ECC_RHRX		; done with hours

_DS5_ECC_RD12:
	mov	A, #12
	movx	@DPTR, A       		; mode = 12
	mov	DPTR, #_DS_AMPM
	mov	A, R0			; get bcd hrs again
	mov	C, ACC.5		; A/P bit to C
	clr	A			; acc=0
	mov	ACC.0, C		; acc now = a/p bit
	movx	@DPTR, A       		; store ampm

	anl	_R0, #1FH		; mask off upper 3 bits in hrs reg
	mov	A, R0			; get masked BCD hrs again
	mov	DPTR, #_DS_HOUR		;
	movx	@DPTR, A       		; store bcd hrs w/o mode bits
_DS5_ECC_RHRX:

_DS5_ECC_RRUN:				; check run bit, set ecc_run variable
	mov	DPTR, #_DS_DAY		;
	movx	A, @DPTR		; get day BCD
	mov	C, ACC.5		; dallas /OSC bit 0 if running
	mov	R0, A			; copy bcd day into R0
	clr	A
	cpl	C
	mov	ACC.0, C		; A=1 if running (/osc = 0)
	xch	A, R0			; _RUN in R0, bcd day in acc
	anl	A, #7			; mask off osc bit from day
	movx	@DPTR, A       		; store day w/o osc bit
	xch	A, R0			; _RUN back in acc
	mov	DPTR, #_DS_ECC_RUN
	movx	@DPTR, A       		; store run value

_DS5_ECC_BH:				; convert bcd time to binary
	mov	B, #8			; byte count
	mov	DPTR, #_DS_HSEC		; first storage location
_DS5_ECC_BH1:
	movx	A, @DPTR		; get BCD value in acc
	lcall	_BCD_TO_HEX		; bcd in acc to binary in acc
	movx	@DPTR, A		; save acc value
	inc	DPTR			; next location
	djnz	B, _DS5_ECC_BH1		; do it 8 times

	pop	IE			; restore interrupts
	ret


_DS5_ECC_WR:

_DS5_ECC_HB:				; convert hex(binary) time to bcd
	mov	B, #8			; byte count
	mov	DPTR, #_DS_HSEC		; first storage location
_DS5_ECC_HB1:
	movx	A, @DPTR		; get BCD value in acc
	lcall	_HEX_TO_BCD		; binary in acc to hex in acc
	movx	@DPTR, A		; save acc value
	inc	DPTR			; next location
	djnz	B, _DS5_ECC_HB1		; do it 8 times, B is 0 when done

_DS5_ECC_WHR:				; now adj hours, set ampm, mode
	mov	DPTR, #_DS_ECC_MODE	;
	movx	A, @DPTR		; get 12/24 in acc
	cjne	A, #13, $+3		; c set if mode<13, 0 if >=13
	jnc	_DS5_ECC_WHR24		; jump if 24 hour mode
_DS5_ECC_WHR12:				; set up 12 hour mode, C=1
	mov	DPTR, #_DS_AMPM		;
	movx	A, @DPTR		; get 0/1 in acc, 0=AM, else=PM
	jz	_DS5_ECC_WHRA		; jump if AM
					; if here, is PM in 12-hour mode
	setb	B.5			; set PM bit
_DS5_ECC_WHRA:				; if here, AM, acc already clear
	mov	B.7, C			; set 12 hour mode bit
					; B now has mode bits set
_DS5_ECC_WHR24:				; if 24 hour mode, B is zero
	mov	DPTR, #_DS_HOUR		;
	movx	A, @DPTR		; get bcd hrs in acc
	orl	A, B			; 0 iff 24 hr, mode&ampm if 12 hr
	movx	@DPTR, A		; save adjusted bcd hrs
_DS5_ECC_WHRX:				; done with hours adj

_DS5_ECC_WRUN:				; check run bit, set ecc flag
	mov	DPTR, #_DS_ECC_RUN	;
	movx	A, @DPTR		; get 0/1 in acc, 0=stop, else=run
	setb	C			; C = 1
	jz	_DS5_ECC_WSTP		; jump if acc=0 for stop
	clr	C			; else C=0 if run
_DS5_ECC_WSTP:				; here C=1 if stop
	mov	DPTR, #_DS_DAY		;
	movx	A, @DPTR		; bcd day in acc
	mov	ACC.5, C		; set if stop
	movx	@DPTR, A		; save adjusted bcd day
	

_DS5_ECC_WR1:				; ...now go do the ecc write
	push	IE			; save interrupt status
	anl	IE, #82H		; leave EA and ET0 for RTC

	lcall	_DS5_ECC_CLR		; reset ECC pointer
	lcall	_DS5_ECC_KEY		; apply key to ECC for use

	mov	B, #8			; byte count
	mov	DPTR, #_DS_HSEC		; first storage location

_DS5_ECC_WR2:				; 
	movx	A, @DPTR		; bcd data in acc
	lcall	_DS5_ECC_WB		; write acc byte to an ECC byte
	inc	DPTR			; next location
	djnz	B, _DS5_ECC_WR2		; do it 8 times

	lcall	_DS5_ECC_RD		; update ecc variables
	pop	IE			; restore interrupts
	ret



_BCD_TO_HEX:
	push	B

	mov 	R0, A			; copy acc
	anl	A, #0F0H 		; clear low nibble
	swap	A			; high nibble now in low place
	mov 	B, #10			; mul old high nibble by 10
	mul	AB			; old high nib * 10 in acc
	mov	B,A			; partial result to B
	xch	A, R0			; old byte back in acc
	anl	A, #00FH 		; mask off old high nibble
	add	A, B			; add old low nibble to acc

	pop	B
	ret




_HEX_TO_BCD:
	push	B

	mov	B, #10
	div	AB		; acc = acc /10, B = acc rem 10
	swap	A
	add	A,B

	pop	B
	ret



_DS5_ECC_CLR:
	mov	B, #09H
_DS5_ECC_CLR1:
	lcall	_DS5_ECC_RB		; read an ECC byte
	djnz	B, _DS5_ECC_CLR1	; do 9 of them
	ret



_DS5_ECC_RB:
	push	DPL
	push	DPH
	push	B
	push	MCON
	orl	MCON, #04H		; set ECE2 bit

	mov	DPH, #0
	mov	DPL, #04H		; set bit 2 of addr 
	mov 	B, #08H			; bit count

_DS5_ECC_RB1:
	push	ACC
	movx	A, @DPTR		; get bit
	rlc	A			; move bit to carry
	pop	ACC			; get byte value so far
	rrc	A			; move bit into acc
	djnz	B, _DS5_ECC_RB1		; loop for 8 bits

	pop	MCON			; restore MCON, ECE2 off
	pop	B
	pop	DPH
	pop	DPL
	ret
	



_DS5_ECC_KEY:
	mov 	B, #04H
	mov	A, #0C5H

_DS5_ECC_KEY1:
	lcall	_DS5_ECC_WB		; write a byte
	xrl	A, #0FFH		; exor it
	lcall	_DS5_ECC_WB		; write a byte
	swap	A			; change pattern
	djnz	B, _DS5_ECC_KEY1	; write total of 4x2 = 8 bytes
	ret




_DS5_ECC_WB:

	push	DPL
	push	DPH
	push	B
	push	MCON
	orl	MCON, #04H		; set ECE2 bit

	mov	DPH, #0
	mov 	B, #08H			; bit count

_DS5_ECC_WB1:
	push	ACC			; save data byte in acc
	anl	A, #1			; acc.0 is the data bit, others=0
	mov	DPL, A			; now DPL is the address & data
	movx	A, @DPTR		; output data/addr via DPL on P0
	pop	ACC			; get back data byte
	rr	A			; next data bit in position
	djnz	B, _DS5_ECC_WB1		; do for 8 bits

	pop	MCON
	pop	B
	pop	DPH
	pop	DPL
	ret

_INIT_PRINT:

	MOV	DPTR, #_OUTOTP		; TAIL OR OUTPUT POINTER
	MOV	A, #HIGH _OUTBUF	; GET MSB
	MOVX	@DPTR, A		; SAVE MSB
	INC	DPTR
	MOV	A, #LOW _OUTBUF
	MOVX	@DPTR, A		; SAVE LSB

	MOV	DPTR, #_OUTINP		; HEAD OR INPUT POINTER
	MOV	A, #HIGH _OUTBUF	; GET MSB
	MOVX	@DPTR, A		; SAVE MSB
	INC	DPTR
	MOV	A, #LOW _OUTBUF
	MOVX	@DPTR, A		; SAVE LSB

	MOV	_NULLCNT, #0		; SET NULL COUNTER to ZERO
	mov	_PHEAD, #1		; set print head to column 1
	clr	_CPRT_FLAG		; clear print in progress flag
	clr	_CPRT_INP		; print active flag
	RET


_PRTCOM:
	CLR	ES			; CLEAR ENABLE FOR SERIAL INTERRUPTS

	PUSH	DPL
	PUSH	DPH
		 
	MOV    	R0,A			; save the data byte
	MOV    	DPTR,#_OUTINP		; GET head POINTER address
	MOVX	A,@DPTR			; GET head ptr MSB
	MOV	R1,A			; save it 
	INC	DPTR			; bump the address
	MOVX	A,@DPTR			; GET head ptr LSB 

	MOV	DPL,A			; put head ptr in DPTR
	MOV	DPH,R1			;
	MOV	A,R0			; GET the DATA byte
	MOVX	@DPTR,A			; save it in the buffer at head ptr
	INC	DPTR			; incr head ptr to next location
	MOV	A,DPL			; SEE IF we're AT END OF BUFFER
	CJNE	A, # LOW _OUTBFE, _PRTCM1	; if not at end, jump

    IF _ALIGN EQ 0
	MOV	A,DPH 			; test the high byte
	CJNE	A, # HIGH _OUTBFE, _PRTCM1   	; if not at end, jump
    ENDIF
					; we are at end of buffer...
	MOV	DPTR,#_OUTBUF		; ...so make head = _OUTBUF [0]

_PRTCM1:
    IF _ALIGN EQ 0
	MOV	R0,DPL			; SAVE new head POINTER
	MOV	R1,DPH			; in R1:R0
	MOV	A,DPH
	MOV	DPTR,#_OUTINP		; get head ptr storage addr
	MOVX	@DPTR,A			; SAVE MSB of new head ptr 
	INC	DPTR			; bump the address
	MOV	A,R0			; 
	MOVX	@DPTR,A			; SAVE LSB of new head ptr
    
    ELSE
	MOV	R0,DPL			; SAVE new head POINTER bab 2/25/91
					; for prtcm2 compare
	MOV	A,DPL			; SAVE new head POINTER
	MOV	DPTR,#_OUTINP+1		; get head ptr storage addr
	MOVX	@DPTR,A			; SAVE LSB of new head ptr
    ENDIF


	mov	DPL, R0			; this mess added back in from
	mov	DPH, R1			; 2/10 version
    	inc	DPTR			; bab 2/25/91
	MOV	A,DPL			; SEE IF we're AT END OF BUFFER
	CJNE	A, # LOW _OUTBFE, _PRTCMF	; if not at end, jump

    IF _ALIGN EQ 0
	MOV	A,DPH 			; test the high byte
	CJNE	A, # HIGH _OUTBFE, _PRTCMF   	; if not at end, jump
    ENDIF
					; we are at end of buffer...
	MOV	DPTR,#_OUTBUF		; ...so make head = _OUTBUF [0]

_PRTCMF:
  
	mov	R0, DPL			; low byte of (inp ptr +1) in R0


	MOV	DPTR,#_OUTOTP		; GET OUTPUT POINTER
	INC	DPTR			; point to low byte

					; only test low byte of address since
					; a change must happen there as long
_PRTCM2:				; as buffer length is less than 256.
	MOVX	A,@DPTR			; get low byte of output ptr
	CJNE	A,_R0,_PRTCM3		; if inp ptr = out ptr, wait here
	SETB	ES			; INTERRUPT WINDOW
	NOP				
	NOP
	CLR	ES
	SJMP	_PRTCM2			; CONTINUE WAITING	 

_PRTCM3:
	jb	_CPRT_FLAG, _PRTCM4	; buffer to sbuf xfers already started
					; This is only place we set cprt_flag.
	setb	_CPRT_FLAG		; set the print in progress flag
	SETB	TI			; SET TRANS INT to start 1st xfer...
					; ...from buffer to serial port
					; cprt_flag is cleared in int23
					; if inp=out of outbuf pointers

_PRTCM4:
	POP	DPH
	POP	DPL
		
	SETB	ES			; ENABLE SERIAL INTERRUPTS

	RET
_INT23:
	jb	RI, _READ_INT		; jump if a receive interrupt

    IF UIO
	jnb	_UIO_OUT_FLAG, _INT23_UX	; leave if not user output
	lcall	_UIO_TI				; call user TI routine
	ljmp	_IN23ET0			; leave the int23 handler
_INT23_UX:
    ENDIF

    IF UPRINT
	jnb	_UPRT_FLAG, _INT23_UPX		; leave if not user output
	lcall	_PAT_TI				; call user print@ TI routine
	ljmp	_IN23ET0			; leave the int23 handler
_INT23_UPX:
    ENDIF



_PRINT_INT:
	clr	TI			; clear transmit INTERRUPT
	jnb	_CNTRLS_FLAG, _PRINT_I0	; INHIBIT OUTPUT IF SET
	ljmp	_IN23ET0

_PRINT_I0:
	push	ACC			; SAVE ACC
	push	DPL			; PUSH ALL USED REG'S PSW PUSHED BEFORE 
	push	DPH

	push	_R0
	push	_R1
	push	_R2
	push	_R3

    IF _ALIGN EQ 0
	mov     DPTR, #_OUTINP		; get the head pointer address
	movx	A, @DPTR		; get the head pointer MSB
	mov	R0, A		  	; and save it
    	inc	DPTR			; bump the address
	movx	A, @DPTR		; get the head pointer LSB

    ELSE

	mov     DPTR, #_OUTINP+1	; get the head pointer address
	movx	A, @DPTR		; get the head pointer LSB

    ENDIF
    
	mov	R2, A			; and save it

	mov     DPTR, #_OUTOTP		; get the tail pointer address
	movx	A, @DPTR		; get the tail pointer MSBB
	mov	R1, A			; and save it
	inc	DPTR			; bump the address
	movx	A, @DPTR	     	; get the tail pointer LSB
	mov	R3, A			; and save it

	cjne	A, _R2, _PRINT_I1    	; if low bytes not the same, jump
	
    IF _ALIGN EQ 0
	mov	A, R1			; get the tail's high byte
	cjne	A, _R0, _PRINT_I1	; if high bytes not the same, jump
    ENDIF

	clr	_CPRT_FLAG		; head == tail clr print in progress

	ljmp	_OVREXT			; and exit


_PRINT_I1:
	mov	DPL, _R3	   	; head != tail
	mov	DPH, _R1	 	; get the tail pointer into DPTR
	movx	A, @DPTR	     	; get the data from the tail
	mov	SBUF, A			; SBUF it

	inc	DPTR			; advance the tail pointer
	mov	A, DPL			; tail pointer == address of _OUTBFE?
	cjne	A, #LOW _OUTBFE, _PRINT_I2	; if not equal continue

    IF _ALIGN EQ 0
	mov	A, DPH             	; get the high byte
	cjne	A, #HIGH _OUTBFE, _PRINT_I2	; if not equal continue
    ENDIF

	mov	DPTR, #_OUTBUF		; make tail point to _OUTBUF[0]

_PRINT_I2:
    IF _ALIGN EQ 0
	mov	R0, DPL			; Save the tail pointer
	mov	A, DPH			; first the high byte
	mov	DPTR, #_OUTOTP		; get the tails location
	movx	@DPTR, A		; save the MSB
	inc	DPTR			; bump the address
	mov	A, R0			; get the low byte
	movx	@DPTR, A		; save it

    ELSE
	mov	A, DPL			; only save the low byte
	mov	DPTR, #_OUTOTP+1	; get the tail's location
	movx	@DPTR, A		; save the MSB
    ENDIF

	ljmp	_OVREXT			; and exit


_READ_INT:

    ;-------------------------------------------------------------------------
    ; If user input we better call the user handler, since we can't have
    ; both a user and console input routine at the same time.
    ;
	
    IF UIO
	jnb	_UIO_INP_FLAG, _READ_INT_UX	; leave if not user input
	lcall	_UIO_RI				; call user RI routine
	ljmp	_IN23ET0			; leave the int23 handler
_READ_INT_UX:
    ENDIF

	PUSH	ACC
	MOV	A, SBUF			; receive data to acc
        CLR	RI

	jb	_IDLE_END, _INCK00	; not idle so proceed 
	ljmp	_IN23ET			; leave if idle (note we cleared RI)

_INCK00:
	CJNE	A,#_CNTRLC,_INCK01	; SEE IF CONTROL C 
	JB	_CNTRLC_FLAG,_INCK01	; CONTROL C DISABLED
	LJMP   _CNTLC			; leave and don't come back

_INCK01:
	CJNE	A, #_CNTRLS,_INCK02	; SEE IF CONTROL S
	SETB	_CNTRLS_FLAG		; SET BIT FOR OTHERS
	SJMP	_IN23ET			; EXIT

_INCK02:
	CJNE	A,#_CNTRLQ, _INCK03	; IS IT A CONTROL Q
	JNB	_CNTRLS_FLAG, _IN23ET	; BIT ALREADY CLEAR CONT
	SETB	TI			; START INTERRUPT
	CLR	_CNTRLS_FLAG		; CLEAR BIT FOR OTHERS
	SJMP	_IN23ET			; EXIT

_INCK03:
	PUSH	DPL			; PUSH USED REG'S - PSW PUSHED already
	PUSH	DPH
	PUSH	_R0
	PUSH	_R1
	PUSH	_R2
	PUSH	_R3

	MOV	R2, A			; SAVE DATA
         
	;SEE IF BUFFER IS FULL

	MOV	DPTR, #_TALPTR+1     ; GET TAIL OR OUTPUT POINTER
	MOVX	A, @DPTR             ; AND SAVE
	MOV	R0, A                ; LSB of tail pointer in R0

	MOV	DPTR, #_FIFOBE       ; GET END OF BUFFER
	MOV	R3, DPL              ; AND SAVE LSB of FIFOBE address in R3

	MOV	DPTR, #_HEDPTR       ; GET HEAD OR INPUT POINTER
	MOVX	A, @DPTR 
	MOV	R1, A                ; AND SAVE MSB of head in R1
	INC	DPTR 
	MOVX	A, @DPTR             ; GET LSB of head in A

	MOV	DPL, A               ; RESTORE LSB of head pointer
	MOV	DPH, R1              ; RESTORE MSB of head
	INC	DPTR			; incr head pointer
	MOV	A, DPL               ; SEE IF AT END OF BUFFER
	CJNE	A, _R3,_INCK04       ; NOT AT END CONTINUE
	MOV	DPTR, #_FIFOBF       ; GET START OF BUFFER as new head ptr

_INCK04:


         
	MOV     A,R2                ; GET DATA from R2
	MOVX    @DPTR,A             ; AND STORE at new head pointer
        
	MOV     A,DPH               ; SAVE new head POINTER
	MOV     R1,DPL
	MOV     DPTR,#_HEDPTR       ; AT LOCATION
	MOVX    @DPTR,A             ; SAVE MSB
	MOV     A,R1
	INC     DPTR
	MOVX    @DPTR,A		; SAVE LSB of new head ptr


	CJNE	A,_R0,_OVREXT   ; if not same, proceed
				; if here old tail == new head
	mov	DPTR, #_TALPTR	; get tail ptr addr
	movx	A, @DPTR	; get old tail MSB
	mov	DPH, A		; 
	mov	DPL, R0		; old tail now in DPTR
	inc	DPTR		; new tail, may be at buffer end?
	mov	A, DPL		; lsb of new tail to ACC
	CJNE	A, _R3, _TAILSAVE	; tail <> end so save it
	MOV	DPTR, #_FIFOBF		; GET START OF BUFFER as new tail ptr

_TAILSAVE:
	MOV     A,DPH               ; MSB of new tail
	MOV     R1,DPL
	MOV     DPTR,#_TALPTR       ; tail pointer storage location
	MOVX    @DPTR,A             ; SAVE MSB
	MOV     A,R1
	INC     DPTR
	MOVX    @DPTR,A		; SAVE LSB of new tail ptr

_OVREXT:
	POP    _R3			; RESTORE ALL USED REG"S
	POP    _R2  
	POP	_R1
	POP	_R0
	POP	DPH
	POP	DPL

_IN23ET:
	POP	ACC		        

_IN23ET0:
	POP	PSW			;PUSHED at vector 
	RETI				;EXIT INTERRUPT HANDLER

_PRINT_DONE:
    IF (CPRINT * PRINT_COMPLETE)
    	jb _CPRT_FLAG, $		; wait til buffer empty
    ENDIF
	RET

_PUTC:
	lcall	_PRINT_HEAD		; position the print head counter

    IF SPRINT
	jnb _SPRT_FLAG, _PUTC_SX	; go elsewhere if not serial print
    	lcall   _PRTLB_COM      	; output the character to the serial printer
	ret		       		; exit
_PUTC_SX:
    ENDIF

    IF UIO
	jnb _UIO_OUT_FLAG, _PUTC_UX 	; go elsewhere if not user output
    	lcall   _UIO_OUT	      	; else call the user output driver
	ret		       		; exit
_PUTC_UX:
    ENDIF

    IF UPRINT
	jnb _UPRT_FLAG, _PUTC_UPX 	; go elsewhere if not user output
    	lcall   _PRINT_AT	      	; else call the print@ output driver
	ret		       		; exit
_PUTC_UPX:
    ENDIF



_CPUTC:					; console print
  IF CPRINT
    lcall   _PRTCOM         		; output to the output buffer
  ENDIF
	ret				; done

_PRINT_HEAD:
	mov	R1, #_PHEAD

    IF SPRINT
	jnb 	_SPRT_FLAG, _PHD_SX
	mov	R1, #_SPHEAD
_PHD_SX:
    ENDIF

    IF UIO
	jnb _UIO_OUT_FLAG, _PHD_UX 	; go elsewhere if not user output
	mov	R1, #_UPHEAD
_PHD_UX:
    ENDIF

    IF UPRINT
	jnb _UPRT_FLAG, _PHD_UPX 	; go elsewhere if not user output
	mov	R1, #_UPHEAD
	ret		       		; exit
_PHD_UPX:
    ENDIF


	cjne	A, #20H, _PHD2		; is it a printable character?

_PHD2:
	jc	_PHD3	  	    	; continue test if not printable
	inc	@R1		    	; printable so bump print head counter
	ret
	
_PHD3:
	cjne	A, #CR, _PHD4		; jump if not CR
	mov	@R1, #1			; is CR, so reset print head counter
	ret

_PHD4:
	cjne	A, #BS, _PHD5		; dec print head counter if a backspace
	dec	@R1			; is BS, so decrement the print head counter
	ret
	
_PHD5:
	cjne	A, #LF, _PHD6		; if not a LF return
	pop	ACC			; else is LF so waste the calling stack
	pop	ACC
	ljmp	_PUT_NEW_LINE_2		; then output newline and take care of NULLs

_PHD6:
	ret				; not printable not CR, BS, LF so return

_PUT_NEW_LINE:
	mov	A, #CR			; carriage return
	lcall	_PUTC			; output it

_PUT_NEW_LINE_2:
	mov	A, #LF			; line feed

  IF SPRINT
	jnb	_SPRT_FLAG, _PNL_SX	; serial printer option if flag set
	lcall	_PRTLB_COM		; output it to the serial port
	sjmp	_PNL_4
_PNL_SX:
  ENDIF


    IF UIO
	jnb	_UIO_OUT_FLAG, _PNL_UX	; leave if not user output
	lcall	_UIO_OUT		; call user out routine
	sjmp	_PNL_4
_PNL_UX:
    ENDIF

    IF UPRINT
	jnb	_UPRT_FLAG, _PNL_UPX	; leave if not user output
	lcall	_PRINT_AT		; call print@ out routine
	sjmp	_PNL_4
_PNL_UPX:
    ENDIF


  IF CPRINT
	lcall	_PRTCOM			; output it to the console
  ENDIF

_PNL_4:
	mov	A, _NULLCNT		; get the NULL count
	jz	$+7		    	; no NULLs if zero so exit
	mov	R0, A			; save the count
	clr	A		    	; this is the NULL
	lcall	_REP_CHAR		; output NULLs
	ret			    	; done
	
_REP_CHAR:

  IF SPRINT
	jnb	 _SPRT_FLAG, _RC_SX	; leave if not printer output
_RC_S1:
	lcall	_PRTLB_COM		; call printer out routine
	djnz	R0, _RC_S1		; decrement count and loop 'til done
	ret
_RC_SX:
  ENDIF

    IF UIO
	jnb	_UIO_OUT_FLAG, _RC_UX	; leave if not user output
_RC_U1:
	lcall	_UIO_OUT		; call user out routine
	djnz	R0, _RC_U1		; decrement count and loop 'til done
	ret
_RC_UX:
    ENDIF

    IF UPRINT
	jnb	_UPRT_FLAG, _RC_UPX	; leave if not user output
_RC_UP1:
	lcall	_PRINT_AT		; call user print@ out routine
	djnz	R0, _RC_UP1		; decrement count and loop 'til done
	ret
_RC_UPX:
    ENDIF


_RC_2:
  IF CPRINT
  	push	_R0
	push	ACC
	lcall	_PRTCOM			; output the character to the console
	pop	ACC
	pop	_R0
	djnz	R0, _RC_2		; decrement count and loop 'til done
  ENDIF
	ret

_CNTLC_WOB:
	CLR	EA			; Disable all interrupts incl ES & RTC

_CNTLC:

_CNTLC1:
	MOV	DPTR,#_CNTLC2
	PUSH	DPL
	PUSH	DPH
	RETI				; close serial interrupt, pop PC to the DPTR value  

_CNTLC2:
	clr	C
	orl	C, _ON_EX1_INP
	orl	C, _ON_EX1_PND
	jnc	_CNTLC3			; was onex1 pend or in progress?
	mov	DPTR, #_CNTLC3		; if here, onex1 was in progress
	push	DPL
	push	DPH
	reti				; close onex1 interrupt, pop PC to the DPTR value  

_CNTLC3:
    IF CPRINT				; only check if console print is present
    	jnb	_CPRT_FLAG, _NOCHAR  	;jump if print not in progress
    	jnb	TI, $			; else wait 'til TI asserts from last char
    ENDIF

_NOCHAR:

	mov	SP, _SPCLEAR		; restore stack pointer 
    IF RUN_TRAP_LOC			; run trap in BCI51 code

      IF (DS5000 + TARGET_8XC51F)
    	setb	F0			;
	mov	A, #0AAH		;
	mov	B, #055H		; To detect a run trap at startup
      ENDIF
	ljmp 	_runtrap

    ENDIF

 ;********************************
    IF DS5000
    	jnb	_WDOG_FLAG, _CNTLC_DSX	; if wdog not active jump
	clr	EA   	  		; disable all interrupts
	sjmp	$			; wait for watchdog to expire
_CNTLC_DSX:
    ENDIF
 ;********************************
   
					; no runtrap or wdog active so...
	ret				; RETurn to whatever CALLed this program
					; otherwise crash ungracefully if nothing called it

_PRINT_REST:	

    IF (CPRINT * PRINT_COMPLETE)
    	jb _CPRT_FLAG, $			; wait til buffer empty
    ENDIF
	clr	_CPRT_INP			; clear cprt in progress flag

	lcall	_INT_PEND			; check for pending interrupts

	ret

_INT_PEND:

    IF ONEX1
	jnb	_ON_EX1_PND, _ONEX1_PND_X	; no onex1 pend so jump past
	mov	DPTR, #_ONEX1_PND_X 	
	PUSH	DPL				; push reti return addr... 
	PUSH	DPH				; ...for reti from onex1
	push	PSW				; int13 expects a pushed psw
	ljmp	_INT13_DISPATCH			; handle pending onex1
_ONEX1_PND_X:					; will return here if handled
    ENDIF

    IF ONTIME
	jnb	_ON_TIME_PND, _ONTIME_PND_X	; no ontime pend so jump past
	setb	_ON_TIME_INP			; ontime now in progress 
	clr	_ON_TIME_PND			; ontime no longer pending
	clr	_ON_TIME			; ontime no longer active
	mov	DPTR, #_ONTIME_PND_X 	
	PUSH	DPL				; push return addr... 
	PUSH	DPH				; ...for ret from ontime
	push	PSW				; int0B expects a pushed psw
	ljmp	_INT0B_PND_DISP			; handle pending ontime
_ONTIME_PND_X:					; will return here if handled
    ENDIF

	ret

_PRINT_ROM:


_PRR_1:
	clr	A
	movc	A, @A+DPTR		; get the byte to be printed (1)
	jz	_PRINT_ROM2	   	; if null terminator is present we're done (2)
	lcall	_PUTC			; put the character	(3)
	inc	DPTR			; point to the next character (1)
	sjmp	_PRR_1			; do another (2)


_PRINT_ROM2:
    IF (CPRINT * PRINT_COMPLETE)
	jb _CPRT_FLAG, $		; wait til buffer empty
    ENDIF
	ret	     			; done

;_%%PAT:


_INIT_PAT:
	clr	_UPRT_FLAG		; clear print@ flag
	mov	_UPHEAD, #1		; initialize user print head to col 1
	ret




_PAT_TI:
	clr	TI			; clear it
	ret				; no action, return to int23 handler



_PRINT_AT:



	push	IE					; save IE
	clr	ES					; be sure serial interrupts are off
	clr 	EX1					; turn off EX1 also

	mov 	P0, A					; write char in acc to P0
	SETB	P1.4					; set R/S high for data
	CLR 	P1.5					; set WR low
	CLR	P1.6					; clear enable
	SETB	P1.6					; strobe it
	CLR	P1.6					; clear enable

_LCD_BSY:
	mov	P0, #0FFH				; make P0 input
	CLR	P1.4					; set R/S low
	SETB 	P1.5					; set RD/WR high
	SETB	P1.6					; strobe it w/ high enable
	JB	P0.7, $					; wait while busy
	CLR	P1.6					; clear enable

	pop 	IE					;
	
	ret



_PRTLB_COM:

	mov	B, #SERIAL_MODE
	mov	R5, #8			; default data bits
	jnb	B.3, _DATA8		; jump if B.3=0, 8 data bits
	dec	R5				; B.3=1, we have 7 data bits
	clr	ACC.7			; clear 8th data bit for parity calc

_DATA8:
	mov	R4, A			; save data char 

	clr	ACC.0			; clear start bit
	clr	TR1			; stop timer if running
	mov	TL1, #0			; clear the timer to start from...
	mov	TH1, #0			; ...a known count of 0
					; after this, we'll add timer1 rollover count
					; to the reload value.
	LCALL	_PRTLB_T1LD		; LOAD AND START TIMER This is start bit

	mov	A, R4			; data char back in acc
					; start bit is now in progress

_PRTLB_COM_1:

	JNB    	TF1, $			; wait for start bit to finish
	RL	A	    		; compensate for upcoming RR which puts 1st
			    		; data bit back in place

_PLBCM0:				; 
	RR	A			; GET NEXT BIT (1 cycle) 
	LCALL	_PRTLB_T1LD		; LOAD UP COUNT AGAIN (16 cycles)
					; after counter start 
	JNB	TF1, $			; WAIT TIL TIMER READY (0-2 cycles)
	DJNZ	R5, _PLBCM0		; LOOP UNTIL DONE (2 cycles)
					; data bits now done
	clr 	C			; cycles=3
	orl	C, B.2			; cycles=5
	orl	C, B.1			; C set if any parity needed cycles=7
	jnc 	_NOPAR			; any parity?cycles=9

	mov	C, P			; get raw parity bit
	jb	B.2, _EVEN		; jump over cpl if even parity
	cpl	C			; cpl for odd parity
_EVEN:
	mov 	acc.0, C		; set parity bit
	LCALL	_PRTLB_T1LD		; LOAD UP COUNT AGAIN (parity bit)
	JNB	TF1, $			; WAIT TIL TIMER READY (0-2 cycles)

_NOPAR:					; 1st stop bit
	setb	acc.0
	LCALL	_PRTLB_T1LD		; LOAD UP COUNT AGAIN (1st stop bit)
	JNB	TF1, $			; WAIT TIL TIMER READY (0-2 cycles)


	jnb	B.0, _PLBCMX		; 2nd stop bit?
	LCALL	_PRTLB_T1LD		; LOAD UP COUNT AGAIN (2nd stop bit)
	JNB	TF1, $			; 2nd stop bit

	;
	; A single stop bit is done, so we could enable interrupts here
	; Note that B52 print# outputs 2 stop bits.
	;
	; bab/wsk 10/21/90 
	;
	; In future:
	;
	; add a discrete stop bit here and enable interrupts somehow, so that
	; we can handle a RTC interrupt and serial port int such as control-c
	;

_PLBCMX:
	mov 	A, R4			; data char back in acc in case of rep_char
	RET				; EXIT SUBROUTINE

_PRTLB_T1LD:

	push	acc			; save the byte to output

	MOV	A, _TREL1L		; timer 1 reload LSB (2) 

	anl	TCON, #3Fh		; stop timer 1 and clear timer 1 overflow flag 
	
	add	A, TL1			; cycles = 1
	mov 	TL1, A			; cycles = 2

	MOV	A, _TREL1H		; timer 1 reload MSB (2) [cycles=3]
	addc	A, TH1			; cycles = 4
	mov 	TH1, A			; cycles = 5
	
	pop	acc			; restore the data byte, cycles = 7

	rrc	A			; move lsb into C	*** add 1 cycle  cycles=8
					; ** Next instr is the bit transition! **
	MOV	LP, C			; OUTPUT THE DATA (2) [cycles=10]

	SETB	TR1			; START IT NOW (1) [cycles=11]
					; now the counter is running so the cycle width
					; of the bit cell is counter-timed, not 
					; instruction - timed.	
					; Due to TF1 test vagaries, the time is within
					; +/- 2 cycles, or is it +/- 1?
					; Better to be slightly fast than slow
					; for serial ports.
					;
	rlc	A			; restore acc and C as it was

	RET				; EXIT SUBROUTINE [cycles=0]

_UILT:
	lcall	_UI_RELOP_TEST
	ljmp	_LT_COM

_UIADD:
	setb	F0			; this means we're doing unsigned adds
	sjmp	_IADD_1		; now go do it

_IADD:
	clr		F0			; this means we're doing signed adds

_IADD_1:
	clr		C			; setup
	mov		A, R0		; add the low order bytes
	add		A, R1
	mov		R0, A		; save the result
	mov		A, R2		; add the high order bytes and propogate the carry
	addc	A, R3
	mov		R2, A		; save the result
	jbc		F0, _IADD_2	; skip next if we're doing unsigned adds
	mov		C, OV		; get overflow status of signed addition
	clr		OV

_IADD_2:
	jnc		_IADD_X
	ljmp	_MATH_OVER		

_IADD_X:
	ret

_STEP_SI:
	clr		C
	inc		DPTR				; point to high byte
	movx	A, @DPTR			; get high byte
	rlc		A					; carry set if sign bit was set
	jc		_STEP_SIN
	ljmp	_ILE

_STEP_SIN:
	ljmp	_IGE

_SI_RELOP_TEST:
	clr		F0
	mov		A, R3				; get OPREG1 sign
	rlc		A
	mov		A, R2				; get OPREG0 sign
	lcall	_OP_SIGNS			; adjust for the jump table
	mov		DPTR, #_SRT_1		; get the address of the jump table
	jmp		@A+DPTR				; jump from jump table
	
_SRT_1:
	sjmp	_SRT_2				; both values are positive
	setb	C					; OPREG0 negative, OPREG1 positive
	ret
	ret							; OPREG0 positive, OPREG1 negative
	nop							; occupy space

_SRT_4:							; both values are negative
	mov		A, R2				; swap the OPREGs then compare as unsigned
	xch		A, R3				; R2 to R3
	mov		R2, A				; R3 to R2
	mov		A, R0				; swap low bytes
	xch		A, R1				; R0 to R1
	mov		R0, A				; R1 to R0
	lcall	_UI_RELOP_TEST		; do the compare
	jb		F0, $+4				; convert the result if OPREG0 != OPREG1
	cpl		C					;
	ret
	
_SRT_2:							; both values are positive
	lcall	_UI_RELOP_TEST		; do the compare
	ret
	
_IGE:
	lcall	_SI_RELOP_TEST
	ljmp	_GE_COM

_ILE:
	lcall	_SI_RELOP_TEST
	ljmp	_LE_COM

_OP_SIGNS:
	rlc	A					; one sign in ACC.0, the other in carrry
	rlc	A					; 0 - 3 (ACC.1 & ACC.0)
	rlc	A					; 0, 2, 4, 6 (ACC.2 and ACC.1)
	clr	C
	anl	A, #6				; clear all remaining bits
	ret							; done

_TIME_GET:
	mov	A, _RTC_SEC_HI			; high byte into accumulator
	mov	R0, _RTC_SEC_LO			; low byte into OPREG0
	cjne	A, _RTC_SEC_HI, _TIME_GET	; validate, repeat if upper byte changed
	mov	R2, A				; save final value
	ret					; done

_IGT:
	lcall	_SI_RELOP_TEST
	ljmp	_GT_COM

_ILT:
	lcall	_SI_RELOP_TEST
	ljmp	_LT_COM

_ONGO:
	MOV   A,R0
    ADD   A,R0			; mult R0 by two to get # of bytes offset

    MOV   DPL,R1		; base addr of table into dptr
    MOV   DPH,R3		;
    ADD   A,DPL			; add offset
    MOV   DPL,A
    MOV   A,#0
    ADDC  A,DPH
    MOV   DPH,A
    CLR   A
    MOVC  A,@A+DPTR     ;GET ADDRESS IN TABLE IN DPTR
    MOV   R2,A
    INC   DPTR
    CLR   A
    MOVC  A,@A+DPTR     ;GET LEAST SIG PART OF ADDRESS
    MOV   DPL,A
    MOV   A,R2
    MOV   DPH,A
    CLR   A       
    JMP   @A+DPTR		; jump to the location in the table and
						; begin executing there
_ONGO_ERRS:

_ONGO_ERR1:			; expr negative
	IF ERR_MSG
		mov		DPTR, #_ongo_expr_neg
	ENDIF
		sjmp	_ONGO_ERRCOM

_ONGO_ERR2:			; expr too big
	IF ERR_MSG
		mov		DPTR, #_ongo_expr_big
	ENDIF
		sjmp	_ONGO_ERRCOM

_ONGO_ERRCOM:
		mov A, #ONGO_EXPR				
	 	ljmp	_ERR_HAND
_RETI_BAS:

	pop	_R7
	pop	_R6
	pop	_R5
	pop	_R4
	pop	_R3
	pop	_R2
	pop	_R1
	pop	_R0
	pop	B
	pop	ACC

	pop	PSW	    		; get the F0 = ONTIME in progress flag
	jb F0, _RETI_ONTIME

_RETI_ONEX1:
	pop	DPH
	pop	DPL
	pop	PSW
	clr	_ON_EX1_INP		; not ontime, so was an onex1
	reti				; note is a reti for onex1

_RETI_ONTIME:
	pop	DPH
	pop	DPL
	pop	PSW
	clr _ON_TIME_INP		; clear ontime in process
	ret	  			; note not a reti for ontime
	
_UCTOA:
	mov	DPL, R1		; point to the destination
	mov	DPH, R3
	mov	R2,	 #0		; insure 0 for msb for BTOA
	lcall	_BTOA	; do the conversion.
	ret

_BTOA:
	clr	C
	mov	A, R0		; is the value zero?
	orl	A, R2
	jnz	_BTOA_1		; jump if it isn't
	
	push	ACC		; save it
	mov	R4, #1		; set the counter
	sjmp	_BTOA_3

_BTOA_1:
	mov	R4, #0		; zero the counter

_BTOA_2:
	mov	R1, #0Ah	; divisor
	lcall	_NDIV		; divide by 10
	push	_R1		; save the result
	inc	R4		; count it
	mov	A, R0		; are we done
	orl	A, R2
	jnz	_BTOA_2

_BTOA_3:
	mov	R1, #'0'	; the ASCII bias (30h)
	
_BTOA_4:
	pop	ACC		; get the ms digit
	add	A, R1		; convert to ASCII
	movx	@DPTR, A	; save it
	inc	DPTR
	djnz	R4, _BTOA_4	; are we done?
	
	clr	A		; the null terminator
	movx	@DPTR, A	; save it
_BTOA_OUT:
	ret

_NDIV:
	mov		R7, _R2			; move dividend into R7:R6
	mov		R6, _R0
	

	mov		R3, _R1			; store nibble divisor
	mov		R0, #_R7		; point to MS byte of dividend and eventual result
	mov		R1, #_R2		; R1 now a pointer to R2 so we can use nibble XCHD
	mov		A, R7			; get MS byte of dividend
	mov		B, R3			; put nibble divisor in B
	div		AB				; do the first division
	mov		R2, B			; move remainder to R2 so we can use XCHD in loop
	mov		R7, A			; MS byte now done, store in dividend/result
	dec		R0				; bump pointer to next MS byte
	
	mov		A, @R0			; get next byte of dividend in ACC
	xchd	A, @R1			; put remainder stored in R2 in LOW nibble of ACC
	swap	A				; mow remainder is in high nibble of ACC and next
							; MS nibble of dividendis in LOW nibble
	mov		B, R3			; divide again by divisor nibble
	div		AB
	mov		R2, B			; save remainder in R2
	swap	A				; put nibble result in high nibble and store in 
	xch		A, @R0			; DIVIDEND/RESULT while retrieving original
							; dividend byte (low nibble)
	swap	A				; LS nibble of dividend to hi nibble of ACC
	xchd	A, @R1			; remainder to low nibble of ACC
	swap	A				; swap remainder to high nibble for next divide
	mov		B, R3			; divide again by divisor nibble
	div		AB
	mov		R2, B			; save remainder in R2
	xchd	A, @R0			; store lo nibble result this byte in DIVIDEND/RESULT
	

	mov		R0, _R6			; return the results in OPREG0
	mov		R2, _R7
	mov		R1, B			; and the remainder from last divide in OPREG1
	ret
	
_PRINT:					; print from external memory

_PRINTC:			   	; console print routine begins here

_PRINT1:
	movx	A, @DPTR		; get the byte to be printed (1)
	jz	 _PRINT2		; if null terminator is present we're done (2)
	lcall	_PUTC			; put the character	(3)
	inc	 DPTR			; point to the next character (1)
	sjmp	_PRINT1			; do another (3)

_PRINT2:
    IF (CPRINT * PRINT_COMPLETE)
    	jb _CPRT_FLAG, $		; wait til buffer empty
    ENDIF
  ret					; done

_UIGT:
	lcall	_UI_RELOP_TEST
	ljmp	_GT_COM

_IOR:
	mov		A, R0	; low byte of OPREG0
	orl		A, R1	; OPREG0L .OR. OPREG1L
	mov		R0, A	; save the result
	mov		A, R2	; high byte of OPREG0
	orl		A, R3	; OPREG0H .OR. OPREG1H
	mov		R2, A	; save the result
	ret

_end_module:		;end of this compiled module
	clr	_ON_TIME		;clear ONTIME flag
	lcall	_PRINT_DONE		;wait until print buffer empty
_END_AND_HALT:

	sjmp	$	

_ISTACK_CHECK:
	mov	A, #SPUSE		; max stack space we will use
	clr	C			; don't want to subtract the C
    IF ONEX1
    	jnb	_ON_EX1_INP, _CHK_ONEX1X	; not in handler -> jump
    	subb	A, #SPUSE_ONEX1		; we are, don't count its stack use
_CHK_ONEX1X:
    ENDIF

    IF ONTIME
    	jnb	_ON_TIME_INP, _CHK_ONTIMEX	; not in handler -> jump
    	subb	A, #SPUSE_ONTIME	; we are, don't count its stack use
_CHK_ONTIMEX:
    ENDIF
	mov	B, A			; save adjusted usage in B reg

	mov	A, SP
	cjne	A, _SPCLEAR, _ISTK_CHK2	; C set if SP < SPCLEAR

_ISTK_CHK2:
	jc	_ISTK_CHK_ERR		; SP < SPCLEAR is error, else...
					; ...SP >= SPCLEAR, so it's OK
	mov	A, #SPMAX		; SP upper limit (7FH or FFH)
	cpl	A			; now 00H for '32 or 80H for '31
	add	A, SP			; add current value
					; overflow not possible yet
	jc	_ISTK_CHK_ERR		; if overflowed, error
	add	A, B			; add most we'll need
	jc	_ISTK_CHK_ERR		; if overflowed, error
_ISTK_CHK_X:
	ret				; else OK so return

_ISTK_CHK_ERR:
	mov	SP, _SPCLEAR		; clear SP so we don't crash
	ljmp	_ISTACK_ERR2		; handle the error

_ISTACK_ERR2:			; Istack over or underflow 
	IF  ERR_MSG 
		mov		DPTR, #_istk_err_msg
	ENDIF
		mov A, #ISTACK_ERR		; the errval value
	 	ljmp	_ERR_HAND
_ERR_PRINT:

  IF CONSOLE_TIMER EQ 1
_ERR_PRINT2:	
  ENDIF
	push DPL			; save ptr to specific err msg
	push DPH
 	lcall _PUT_NEW_LINE
	mov DPTR, #_com_msg1
	lcall _PRINT_ROM		; output it
  IF PROGLINE
	lcall _ERR_LINE_PRT		; output failing line number 
  ENDIF
	pop DPH				; get ptr to specific err msg
	pop DPL
	lcall _PRINT_ROM		; output specific err msg
 	lcall _PUT_NEW_LINE



  IF CONSOLE_TIMER EQ 1
  ENDIF

_ERR_PRINTX:
	ret
_ERR_LINE_PRT:
  IF PROGLINE
	mov DPTR, #_com_msg2
	lcall _PRINT_ROM		; output '(LINE '
	mov DPTR, #_ERRLINE
	lcall _INT_GET			; errline in opreg0
	mov DPTR, #_pbuffer
	mov R1, DPL
	mov R3, DPH
	lcall _BTOA			; opreg0 convert to ascii
	mov DPTR, #_pbuffer
	lcall _PRINT 			; output line number
	mov DPTR, #_com_msg3
	lcall _PRINT_ROM		; output '): '
	ret
  ENDIF
_INT_GET:
	movx	A, @DPTR	; get the low byte
	mov	R0, A		; put it in OPREG0
	inc	DPTR
	movx	A, @DPTR	; get the high byte
	mov	R2, A		; put it in OPREG0
	ret			; done

_ERR_HAND:
    IF CHECK_MATH EQ 0
				; if not math checking, we ignore math errors
	cjne A, #40, $+3  	; was it a math error (C set iff val <40)?
	jnc $+3			; no, so proceed to handle it
	ret			; yes, do nothing and return 
    ENDIF
	push ACC		; push errval to save it
    IF PROGLINE
	push _R0		; push any math error value
	push _R2
	push ACC		; push errval to save it (again)
	push DPL		; save specific error message ptr
	push DPH
	mov DPTR, #_BASLINE	; update errline value
	lcall _INT_GET		; current line # in opreg0 (acc gets wasted)
	mov DPTR, #_ERRLINE
	lcall _INT_PUT		; save it in errline location
	pop DPH			; retrieve specific err msg ptr
	pop DPL
	pop ACC			; errval back in acc
    ENDIF

    IF ERR_MSG			; print message to console?
    	IF CHECK_MATH EQ 0
					; if not math checking, we ignore math errors
		cjne A, #40, $+3  	; was it a math error (C set iff val <40)?
		jc _ERR_HAND_MSGX  	; yes, jump past print
	ENDIF
	lcall _ERR_PRINT
	jb _CPRT_FLAG, $ 	; finish any printing
_ERR_HAND_MSGX:
    ENDIF

    IF PROGLINE
	pop _R2	 		; pop math error value back
	pop _R0	 		; in case we return
    ENDIF

	pop ACC			; pop errval back
	
  	mov DPTR, #_ERRVAL 	; update ERRVAL regardless of onerr
	movx @DPTR, A	   	; store ERRVAL

    IF ONERR				; save errval and jump to onerr code
  	jnb _ON_ERR, _ERR_ONERRX	; jump ahead if onerr inactive
	    IF CHECK_MATH EQ 0
					; if not math checking, we ignore math errors
 	   	cjne A, #40, $+3 	; was it a math error (C set iff val <40)?
	    	jc _ERR_ONERRX	 	; yes, jump past dispatcher
	    ENDIF
    	ljmp _ONERR_DISPATCH	; else jump to onerr handler, never to return
_ERR_ONERRX:
	ENDIF

	;
	; If here, onerr not active, run trap may be
	;

  IF (RUN_TRAP_LOC + RUN_TRAP_B52) EQ 0	; no run trap? so return or hang
	;
	; No run trap, so we can either hang or stagger on by returning
	; We test for certain errors on which to allow return
	;
	cjne A, #STRING_TRUNC, $+4	; was the error a string truncation?
	ret		; yes, return
    IF CHECK_MATH EQ 0
    	; if not math checking, we allow return on these errors
    	cjne A, #40, $+3		; was it a math error (C set iff val <40)?
    	jnc $+3				; no, jump to next test
    	ret				; yes, math error, so return
    ENDIF
    	cjne A, #MEM_ACC_B52, _ERR_HANG	; B52 istack or mtop conflict?
    	ret				; yes, return to whatever called it
_ERR_HANG:
	; Close any open interrupts
	;
	jnb _ON_EX1_INP, _ERR_HANG_2	; was onex1 in progress?
	jnb _ON_EX1_PND, _ERR_HANG_2	; was onex1 pending?
	mov DPTR, #_ERR_HANG_2	 	; if here, onex1 was in progress
	PUSH   DPL
	PUSH   DPH
	RETI   				; exit onex1 interrupt, pop PC to the DPTR value  
_ERR_HANG_2:
	clr	EA			; disable all interrupts
	sjmp 	$		 	; stay here forever or until wdog timeout
  ENDIF

  	;
  	; If here, one of the run traps is active
	; Close any open interrupts
	;
	clr	EA
	jnb _ON_EX1_INP, _ERR_HAND_2	; was onex1 in progress?
	jnb _ON_EX1_PND, _ERR_HAND_2	; was onex1 pending?
	mov DPTR, #_ERR_HAND_2		; if here, onex1 was in progress
	PUSH   DPL
	PUSH   DPH
	RETI   			; exit onex1 interrupt, pop PC to the DPTR value  

	;
	; Compiler only allows one of the run trap options active
	; If B52, local runtrap is placed differently than non-B52 case
	;
_ERR_HAND_2:
    IF (RUN_TRAP_LOC + RUN_TRAP_B52)
      IF (DS5000 + TARGET_8XC51F)
    	setb	F0		;
	mov	A, #0AAH	;
	mov	B, #055H	; This helps us detect a run trap at startup
      ENDIF
        IF RUN_TRAP_LOC		; ONERR not active, run trap in BCI51 code
     	mov SP, _SPCLEAR	; reset stack pointer
	ljmp _runtrap
	ELSE
     	ljmp _RET_B52		; return to B52, B52 assumed to run trap there
	ENDIF
    ENDIF

	clr	EA     		; disable all interrupts
    				; we can be here only due to runaway code since
				; run trap inactive was handled earlier, this
	sjmp $		 	; is here just as a precaution.

;_%%DALLAS_MSG:

	IF ERR_MSG

	ENDIF

_str0:	db	'Sending data...',0
_str1:	db	'NEW! SYSTEM DPB2',0
_str2:	db	'New DPB2 rev E ',0
_str3:	db	' from Systronix ',0
_str4:	db	'from Systronix!',0
_str5:	db	'Starting main loop',0
_str6:	db	'Clearing Display...',0

_ongo_tbl18:
	dw	_BLCDTOP1
	dw	_BLCDTOP1
	dw	_BLCDTOP2
	dw	_BLCDTOP2
	dw	_BLCDTOP3
	dw	_BLCDTOP3
_str7:	db	'0',0
_str8:	db	'-',0
_str9:	db	'0',0
_str10:	db	'-',0
_str11:	db	'0',0
_str12:	db	':',0
_str13:	db	'0',0
_str14:	db	':',0
_str15:	db	'0',0
_str16:	db	' DATE: ',0
_str17:	db	'0',0
_str18:	db	'-',0
_str19:	db	'0',0
_str20:	db	'-',0
_str21:	db	' ',0
_str22:	db	' TIME: ',0
_str23:	db	'0',0
_str24:	db	':',0
_str25:	db	'0',0
_str26:	db	':',0
_str27:	db	'0',0
_str28:	db	'  ',0
_str29:	db	' SYSTRONIX DPB2 ',0
_str30:	db	'  QUICK & EASY  ',0
_str31:	db	'EMBEDDED CONTROL',0
_str32:	db	'Relay ',0
_str33:	db	' on!',0
;_%%MATH_MSG:

	IF ERR_MSG
_mathdiv0_msg:	db	'Divide by Zero',0
_mathover_msg:	db	'Math Overflow',0
_mathunder_msg:	db	'Math Underflow',0
_mathbad_msg:	db	'Math Argument Bad',0
	ENDIF

;_%%DS5ECC_STR:

_DS5_DAY_TAB:	DB 'SunMonTueWedThuFriSat',0


_DS5_MON_TAB:	DB 'JanFebMarAprMayJunJulAugSepOctNovDec',0

;_%%ONGO_MSG:
	IF (ERR_MSG)
_ongo_expr_neg:	db	'ON {expr} Negative',0
_ongo_expr_big:	db	'ON {expr} Too Big',0
	ENDIF

;_%%ISTACK_MSG:

	IF ERR_MSG
_istk_b52_msg:	db	'Istack/B52 Conflict',0
_istk_err_msg:	db	'Istack Error',0
	ENDIF

;_%%RELOC_MSG:

	IF ERR_MSG
_RELOC_MSG:	db	'Vector relocation FAILED',0
	ENDIF

;_%%COM_MSG:

	IF ERR_MSG
_com_msg1: db 'ERROR ',0
_com_msg2: db '(Line ',0
_com_msg3: db '): ',0

_bad_start: db 'STARTUP/RESET',0
	ENDIF


_cdataend:	; code space ends here
	org		24576		;data segment org 6000H


_databeg:	;data variable clear starts here

_udatabeg:	; user data clear starts here

_fnstep7:	ds	2
_fnlimit7:	ds	2
_fnstep5:	ds	2
_fnlimit5:	ds	2
__RELAY_NUMBER:	ds	2
__RELAY_DAT:	ds	1
__RELAY_STATUS:	ds	1
__MSEC_TMP:	ds	2
__WAIT_SEC:	ds	2
__TIME_TMP:	ds	2
__X:	ds	2
__TOP:	ds	1
__DATE_TIME:	ds	1
__LCD_DAT:	ds	1

_udataend:	; user data clear stops just prior to here

;_%%LINENUM_DATA:

_BASLINE:	DS	2	; address of current BASIC line number (stored L:H)
_ERRLINE:	DS	2	; address of BASIC line number with error (stored L:H)

;_%%INT0B_DATA:

_INT_0B_LOC:	DS	2	; address of user's ONTIME routine (L:H)

;_%%DS1215_DATA:


_DS_HSEC:	DS	1
_DS_SEC:	DS	1
_DS_MIN:	DS	1
_DS_HOUR:	DS	1

_DS_DAY:	DS	1
_DS_DATE:	DS	1
_DS_MONTH:	DS	1
_DS_YEAR:	DS	1

_DS_AMPM:	DS	1			; iff 12 hr mode: 1=PM, 0=AM
_DS_ECC_MODE:	DS	1			; 12/24, 0 = 24 hr, non-0 = 12 hr
_DS_ECC_RUN:	DS	1			; 0 = run, non-0 = halt clock
_DS_AMPM$:	DS	3			; am/pm text string, 2 + null
_DS_DAY$:	DS	4			; day text string, 3 + null
_DS_MONTH$:	DS	4			; month text string, 3 + null

;_%%INT23_DATA:
_FIFOBF:	DS	_FIFOLN	; GET and INT23 Buffer (number of 
				; typeahead keys we can remember)
_FIFOBE:	DS	1	; End of FIFOBF, MUST BE 1 FOR 1ST INC
_TALPTR:	DS	2	; Tail Pointer for input to _FIFOBF MSB:LSB
_HEDPTR:	DS	2	; Head Pointer for output from _FIFOBF

;_%%INPUT_DATA:

_INPBUF:	DS	_INPLEN	; Storage for the INPUT routine.
_INPBFE:	DS	2	; End of above Buffer, USED FOR NULL
_INPPTR:	DS	2	; Input Pointer for INPBUF

;_%%PRINT_DATA:

_OUTINP:	DS	2	; In Pointer
_OUTOTP:	DS	2	; Out Pointer



	IF _ALIGN

    IF (_ALIGN * (($ AND 0FF80h) NE (($ + _OUTLEN) AND 0FF80h)))
   	ORG	$ + (_OUTLEN - ($ + _OUTLEN) AND 007Fh)
    ENDIF

    	ENDIF

_OUTBUF:	DS	_OUTLEN	; Storage for OUTPUT buffer
_OUTBFE:	DS	1	; End of above Buffer

_pbuffer:	ds	8
;_%%ERRVAL_DATA:
	IF (BASIC52 + BEBASIC)
						; ERRVAL already assigned via EQUATE 
	ELSE
_ERRVAL:		DS	1	; Location of the Error value
	ENDIF

_dataend:	; data variable clear ends here

; End of assembly file
	END  _START_LOC
