;-----------------------------------------------------------------------------
;
; DEMO PROGRAM for DPB2 REVE
;	DPB2_RLY to test new relay driver RLY_E2.INC
;
; Supported: serial I/O, four relay driver outputs
;
; (C) Copyright 1994-1996 Systronix, Inc All Rights Reserved
;	Systronix, Inc. Salt Lake City, Utah, USA
;	TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
;	www.systronix.com	email: support@systronix.com
;	COMPLETE SYSTEMS for RAPID PROTOTYPING
;
; Owners of Systronix products are hereby entitled to use, modify, and copy
; this sample program.  You may incorporate all or part of this program in 
; your own commercial products provided they are not simply copies of 
; Systronix products and do not compete directly with Systronix products.  
; This program is provided by Systronix free of charge and may not be resold.
;
; REVISION HISTORY DPB2E_X----------------------------------------------------
;
;
; 96 Sep 25	BAB	Fixed number key test to be 1-4 as it should
; 96 Sep 24	BAB	Start, works great, released to the Internet
;
; DESIRED MODIFICATIONS ------------------------------------------------------
;
; Add an onerr handler which prints error code to the LCD
;
;
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
; Notice that all printing to the LCD or serial port occurs outside all
; interrupt handlers.  If you have print routines interrupting other print
; routines you can expect all sorts of strange-looking output.
;
; This file was written with tab stops every 4 characters
;
;

;
;-----------------------------------------------------------------------------

#target DS2250T
#console mode = 19200
#code start 0h
#data start 6000H
#xtal 11059200

	string REVISION$[4]			; revision code
	unsigned char key, mode, kon, off, toggle, x, bad

	kon = 1
	off = 0
	toggle = 2
	bad	= 255
	
	REVISION$ = "A"
	gosub relay_init
	gosub relay_enable

	; Give Kit5K time to switch from load to terminal mode when using a script to
	; load and then monitor serial output from DPB2...
	; Most programmers will probably want to take this out to eliminate the startup delay.
	gosub delay_2sec								

	print "Example Program DPB2_RLY, Revision ", REVISION$


	; disable LCD in case it is plugged in, so it doesn't clash with port0
	; Take out this line if you use the LCD and call lcd_init
	port1 = port1 AND 0BFH			

again:
	print "Choose the mode of change: N/F/T (enter to start over)"
	print "    N - turn on relay bit"
	print "    F - turn off relay bit"
	print "    T - toggle a relay bit"	
	print "Then press a key 1-4 to select a relay to change"

	gosub relay_display

	do : key = get : while (key=0)		; get a key
	if (key = 00DH) then goto again		; enter key pressed

	mode = bad
	if key = ASC(N) then mode = kon
	if key = ASC(n) then mode = kon
	if key = ASC(F) then mode = off	
	if key = ASC(f) then mode = off
	if key = ASC(T) then mode = toggle
	if key = ASC(t) then mode = toggle

	if (mode = bad) then
		print "Bad mode choice, must be N/F/T, try again"
		goto again
		endif
	print "Mode = ", CHR(key)

relay_bit:
	do : key = get : while (key=0)		; get a relay bit # key

	if (key = 0DH) then goto again		; enter key pressed

	if ( (key = 30H ) OR (key > 34H) ) then
		print "Key value out of range, try again"
		goto relay_bit
		endif

	relay_number = key - 30H		; convert from ASCII to hex 1-4

	if ( mode = kon ) then gosub relay_turn1_on : goto relay_new
	if ( mode = off ) then gosub relay_turn1_off : goto relay_new
	if ( mode = toggle ) then gosub relay_toggle1 : goto relay_new
relay_new:	
	gosub relay_display
	goto relay_bit

END	


;-------------------------------------
;       UPDATE RELAY OUTPUT DISPLAY
;-------------------------------------
;
relay_display:
	print "Relay outputs = ",
	if (relay_status AND 0000_1000B) then print 1, else print 0,
	if (relay_status AND 0000_0100B) then print 1, else print 0,
	if (relay_status AND 0000_0010B) then print 1, else print 0,
	if (relay_status AND 0000_0001B) then print 1, else print 0,
	print
	return
	

	
;-------------------------------------
;       DELAY ROUTINES
;-------------------------------------

;-----------------------------------------------------------------------------
; wait about 100 msec at 11.0592 MHz
; At 11.0592 Mhz one processor cycle is 1.0851 usec
; A DJNZ takes 2 cycles or 2.17 usec
; So 100 msec is 46,083 cycles
; Change this for other crystals

wait_100msec:
#ASM
	mov     R1, #200
wait_100msec1:
	mov     R0, #230
	djnz    R0, $
	djnz    R1, wait_100msec1
#ASM_END
    return

REM 2 second delay
delay_2sec:
	for x=1 to 20
	gosub wait_100msec
	next x
	return



;-------------------------------------
;       INCLUDE FILES
;-------------------------------------


#include "rly_e2.inc"
