;-----------------------------------------------------------------------------
;
; DEMO PROGRAM for DPB2 REVE
;	DPB2E_X where X is program revision
;	this is revision "F" testing LCD_E.INC without using RTC timer0
;
; Supported: 4x4 keypad, 20x4 LCD, 8-bit ADC, serial I/O, four relay driver 
; outputs, four digital inputs, Dallas Timekeeper parts DS5000T and DS2250T.
; Not for use with DS2251/2 which have a different Timekeeper.
;
; (C) Copyright 1994-1996 Systronix, Inc All Rights Reserved
;               Systronix, Inc. Salt Lake City, Utah, USA
;               TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
;				www.systronix.com	email: support@systronix.com
;				COMPLETE SYSTEMS for RAPID PROTOTYPING
;
; Owners of Systronix products are hereby entitled to use, modify, and copy
; this sample program.  You may incorporate all or part of this program in 
; your own commercial products provided they are not simply copies of 
; Systronix products and do not compete directly with Systronix products.  
; This program is provided by Systronix free of charge and may not be resold.
;
; This program is intended for those of you who are using the new DPB2 REVE
; board from Systronix/Intellix.  This card is a very
; easy to use development system for the Dallas DS5000/1/2 DS2250/1/2 and -T
; suffix soft microcontrollers.  If you'd like more information, please call
; or FAX us at the numbers above.
;
; REVISION HISTORY DPB2E_X----------------------------------------------------
;
; 97 Dec 02	BAB	rev F, testing LCD_F.INC
;			The LCD_F.INC doesn't use MSEC, and this BASIC program
;			doesn't use the BCI51 RTC: no ONTIME, CLOCK1, MSEC or TIME
;			This supports a user-defined TIMER0 interrupt handler
;
; 96 Sep 23	BAB	rev E, testing new relay driver include file
;
; 96 Jul 11	BAB	D2, hopefully fixed a minor bug which displayed the time
;			values before ds_ecc_rd had been called! This caused the
;			date and time line to have an extra character in the far
;			right position. Then when the ecc_rd got called and the
;			correct values were displayed, it made the seconds look
;			like a 3-digit value with the rightmost digit fixed. This
;			would remain until the main program loop iterated and cleared
;			the LCD.
;
; 96 Apr 11	BAB	D1 fixed a bug in delay_100 which could wait forever after
;			time was 65534 seconds.
;			Also took out delay_100, replaced with wait_100msec.
;			Valid only for 11.0592 MHz, change it for other crystals
;			(the program will still work, but the delay will change).
;			Also took out the change in scrolling display speed with
;			up and down arrow keys controlling the former delay_time
;			variable which is now gone.
; 96 Apr 06	bab	Fixed a bug in the routine update_time_disp which could
;			cause incorrect printing to the LCD when time values
;			rolled over say from 9 to 10 while we were updating the
;			LCD.
;
;  04/22/94     BAB     Fixed a bug in delay_100 which could cause an eternal 
;                       do loop when TIME reached 0FFFFH.  Added check for
;                       start_time at overflow 65535.  Also changed start_time
;                       declaration to unsigned integer to match type of TIME.
;  03/25/94     BAB     Added display speed control by up and down arrow keys
;  03/09/94     BAB     Changed relay include to rly_e.inc, added to zip
;                               example file for DPB2EXMP
;  01/24/94     BAB     Start, derived from DPB2_A
;  01/25/94     BAB     DPB2E_B.BAS, cleanup, added comments, took
;                       out all printing in interrupt handlers
;                       Added ext input and relay display to LCD,
;                       changed ADC and KEY display to fit
;
; DESIRED MODIFICATIONS ------------------------------------------------------
;
; Add an onerr handler which prints error code to the LCD
;
;
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
; Notice that all printing to the LCD or serial port occurs outside all
; interrupt handlers.  If you have print routines interrupting other print
; routines you can expect all sorts of strange-looking output.
;
; This file was written with tab stops every 4 characters
;
;
;
;-----------------------------------------------------------------------------

#target DS2250T
#console mode = 19200
#printer mode = 9600
#code start 0h
#data start 6000H
#xtal 11059200

;#check istack off
#check math off
#print complete on  				; keep LCD lines from conflicting
		    				; when print@ing from ONEX1

#include "key_e.inc"
#include "lcd_f.inc"
#include "rly_e2.inc"
#include "adc_e.inc"

		    				

	string REVISION$[4]			; revision code
	
	signed int X

	unsigned character temp_uc
	unsigned char time_fresh		; =1 if fresh, 0 if needs update	

	REVISION$ = "F"


	; initialize the time values before any attempt to display them
	ds_ecc_rd

	gosub relay_init
	gosub relay_enable

	print "LCD init"
	gosub lcd_init				; initialize lcd and clear it

	;                1         2
	;		12345678901234567890
	gosub lcd_goto_line1
	print@ "  Welcome to DPB2!  ",

	; Give Kit5K time to switch from load to terminal mode when using a script to
	; load and then monitor serial output from DPB2...
	; Most programmers will probably want to take this out to eliminate the startup delay.
	gosub delay_2sec								

	TCON = TCON AND 0F7H			; clear any pending onex



again:

	onex1 keypress_off
	
	print "DPB2E DS5000/DS2250 family serial output test:"
	print "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+"

	print# "DPB2E serial printer test:"
	print# "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+"

	ONEX1 keypress_handler


	;       	 1         2
	;	12345678901234567890
	gosub lcd_goto_line1
	print@ "*  SYSTRONIX DPB2  *",

	;	12345678901234567890
	gosub lcd_goto_line2
	print@ " DEVELOPMENT SYSTEM ",

	gosub lcd_goto_line3
	;	12345678901234567890    
	print@ "  EXAMPLE  PROGRAM  ",

	gosub lcd_clear_line4
	gosub lcd_goto_line4
	;	12345678901234567890      
	print@ "  REVISION DPB2E_", REVISION$,
	print "Example Program DPB2E_", REVISION$   
	gosub delay_2sec
	gosub delay_2sec


    gosub lcd_goto_line2
REM         12345678901234567890
    print@ "ADC=        EXT=    ",
 
    gosub lcd_goto_line3
REM         12345678901234567890
    print@ "KEY:        REL=    ",

    string lcd_str$(180)

    lcd_str$ = "From SYSTRONIX: Universal DALLAS Development Board DPB2 revision E"
	print lcd_str$
    gosub display_string

    lcd_str$ = "Use any DS5000, DS2250, DS2251 or DS2252 Soft Microcontroller"
    gosub display_string

    lcd_str$ = "1 Serial I/O port, 1 printer port, 4 Relay drivers, 8-bit ADC, Keypad and LCD Interfaces"
    gosub display_string

    lcd_str$ = "NEW in revision E: four rugged digital inputs, ADC attenuator for larger input range,"
    gosub display_string

    lcd_str$ = "Extensive ground plane for low emitted and received RF noise and static,"
    gosub display_string

    lcd_str$ = "Convenient 8x2 header for all power and I/O connections, relay output enable, and more."
    gosub display_string

    lcd_str$ = "Plus POWERFUL, EASY-TO-USE BASIC development software!"
    gosub display_string

    lcd_str$ = "Enclosures, keypads, LCDs and other accessories are also available."
    gosub display_string

    goto again
    END


;-------------------------------------
;       DISPLAY_STRING
;-------------------------------------

display_string:
    int start_pos
    int i, j, str_len

    str_len = 0
get_str_len:
    if (asc(lcd_str$(str_len)) <> 0) then
	str_len = str_len + 1
	goto get_str_len
    endif
    
;    print "display_string: ", lcd_str$, " length = ", str_len
    
    for i = 0 to 19
	lcd_ypos = 1
	lcd_xpos = i+1
	gosub lcd_goto_xy
	if (i < str_len) then
	    print@ chr(lcd_str$(i)),
	else
	    print@ " ",
	endif

	gosub update_time
	gosub update_adc
	gosub update_ext
	
    gosub update_time_disp
    gosub update_adc_disp
    gosub update_ext_disp
    gosub update_key_disp
    gosub update_rel_disp
    next

    for j = 1 to 10
	gosub update_time
	gosub update_adc
	gosub update_ext    
	gosub update_time_disp
	gosub update_adc_disp
	gosub update_key_disp
	gosub update_ext_disp
	gosub update_rel_disp
	gosub wait_100msec
    next

    start_pos = 1
    do
	for i = 0 to 19
	    lcd_ypos = 1
	    lcd_xpos = i+1
	    gosub lcd_goto_xy
	    if (start_pos+i < str_len) then
		print@ chr(lcd_str$(start_pos+i)),
	    else
		print@ " ",
	    endif
	next
	gosub update_time
	gosub update_adc
	gosub update_ext
	gosub update_time_disp
	gosub update_adc_disp
	gosub update_ext_disp
	gosub update_key_disp
	gosub update_rel_disp

	for j = 1 to 2
	    gosub wait_100msec
	gosub update_time
	gosub update_adc
	gosub update_ext	    
	gosub update_time_disp
	gosub update_adc_disp
	gosub update_ext_disp
	gosub update_key_disp
	gosub update_rel_disp
	next
	
	start_pos = start_pos + 1
    while (start_pos <= str_len)
    return
	
;-------------------------------------
;       DELAY ROUTINES
;-------------------------------------


;-----------------------------------------------------------------------------
; wait about 100 msec at 11.0592 MHz
; At 11.0592 Mhz one processor cycle is 1.0851 usec
; A DJNZ takes 2 cycles or 2.17 usec
; So 100 msec is 46,083 cycles
; Change this for other crystals

wait_100msec:
#ASM
	mov     R1, #200
wait_100msec1:
	mov     R0, #230
	djnz    R0, $
	djnz    R1, wait_100msec1
#ASM_END
    return

REM 2 second delay
delay_2sec:
	for x=1 to 20
	gosub wait_100msec
	next x
	return


;-------------------------------------
;       KEYPRESS (ONEX1) HANDLER
;-------------------------------------

REM EX1 handler
keypress_handler:
	gosub key_get_val               ; key value in key_dat

	; turn on relay or 1-4, or all off if 0 key
	relay_number = key_dat
	if key_dat = 0 then gosub relay_init else gosub relay_turn1_on

keypress_off:
	reti

update_key_disp:
    lcd_xpos = 5
    lcd_ypos = 3
    gosub lcd_goto_xy
    PH0.@ key_raw, ">", key_dat,
    RETurn



;-------------------------------------
;       UPDATE TIME
;-------------------------------------


REM Get a new time and click the buzzer
update_time:
    DS_ECC_RD
;    gosub metronome_1
    return

;-------------------------------------
;	UPDATE TIME DISPLAY
;
; copying to temp_uc prevents the ontime interrupt from 
; changing a value as we are analyzing it!  We could decide
; it was a 9, print a leading 0, then it rolls to 10 and 
; we print too many characters for the line.
;-------------------------------------

update_time_disp:
   	gosub lcd_goto_line4
	
	print@ " ",
	temp_uc = DS_MONTH
    	IF temp_uc < 10 then print@ "0",
    	print@ temp_uc, "-",
	temp_uc = DS_DATE
    	IF temp_uc < 10 then print@ "0",
    	print@ temp_uc, "-", DS_YEAR, "  ",
	temp_uc = DS_HOUR
    	IF temp_uc < 10 then print@ "0",
    	print@ temp_uc, ":",
	temp_uc = DS_MIN
    	IF temp_uc < 10 then print@ "0",
    	print@ temp_uc, ":",
	temp_uc = DS_SEC
    	IF temp_uc < 10 then print@ "0",
    	print@ temp_uc,
	
	time_fresh = 1									; we've freshened the display

    return





;-------------------------------------
;       UPDATE ADC READING
;-------------------------------------

update_adc:
    gosub adc_read
    return
    
update_adc_disp:
    lcd_xpos = 5
    lcd_ypos = 2
    gosub lcd_goto_xy
    ph0.@ ADC_DAT,"/",
    if ADC_DAT < 10 then
	print@ "00",
    else
	if ADC_DAT < 100 then print@ "0",
    endif
    print@ ADC_DAT,                     			; print dec value
    return


;-------------------------------------
;       UPDATE EXT INP READINGS
;-------------------------------------
; Note that the 14C89 input buffer inverts it's
; input signal and has internal input pulldowns.
; Therefore, no input is a HIGH on the 14C89's output.
;
; Your jumpers may be set to bypass the 14C89, so
; consider that when interpreting the 1s and 0s here.
;
; ext inp P3.2/3/4/5 are asserted LOW

unsigned char EXTINP            					; holds value of 4 ext inputs

update_ext:
#ASM
	mov     A, P3
	anl     A, #00111100B   						; mask all but P3.2-P3.5
	rr      A               						; rotate to right
	rr      A               						; now all data in low nibble
	mov     DPTR, #__EXTINP
	movx    @DPTR, A        						; store value in BASIC variable
#ASM_END
    return
    
update_ext_disp:
    lcd_xpos = 17
    lcd_ypos = 2
    gosub lcd_goto_xy
    if (EXTINP AND 0000_1000B) then print@ 1, else print@ 0,
    if (EXTINP AND 0000_0100B) then print@ 1, else print@ 0,
    if (EXTINP AND 0000_0010B) then print@ 1, else print@ 0,
    if (EXTINP AND 0000_0001B) then print@ 1, else print@ 0,
    return


;-------------------------------------
;       UPDATE RELAY OUTPUT DISPLAY
;-------------------------------------
;
update_rel_disp:
    lcd_xpos = 17
    lcd_ypos = 3
    gosub lcd_goto_xy
    if (relay_status AND 0000_1000B) then print@ 1, else print@ 0,
    if (relay_status AND 0000_0100B) then print@ 1, else print@ 0,
    if (relay_status AND 0000_0010B) then print@ 1, else print@ 0,
    if (relay_status AND 0000_0001B) then print@ 1, else print@ 0,
    return


;-------------------------------------
;       INCLUDE FILES
;-------------------------------------
