;-----------------------------------------------------------------------------
;
; DEMO PROGRAM for DPB2 REVE
;
; Supported: 4x4 keypad, 20x4 LCD, 8-bit ADC, serial I/O, four relay driver 
; outputs, four digital inputs, Dallas Timekeeper parts DS5000T and DS2250T.
; Not for use with DS2251/2 which have a different Timekeeper.
;
; (C) Copyright 1994 Systronix, Inc All Rights Reserved
;		Systronix, Inc. Salt Lake City, Utah, USA
;		TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
;
; Owners of Systronix products are hereby entitled to use, modify, and copy
; this sample program.  You may incorporate all or part of this program in 
; your own commercial products provided they are not simply copies of 
; Systronix products and do not compete directly with Systronix products.  
; This program is provided by Systronix free of charge and may not be resold.
;
; This program is intended for those of you who have the pleasure of using 
; the new DPB2 REVE board from Systronix/Intellix.  This card is a very
; easy to use development system for the Dallas DS5000/1/2 DS2250/1/2 and -T
; suffix soft microcontrollers.  If you'd like more information, please call
; or FAX us at the numbers above.
;
; REVISION HISTORY DPB2E_B----------------------------------------------------
;
;  04/22/94	BAB	Fixed a bug in delay_100 which could cause an eternal 
;			do loop when TIME reached 0FFFFH.  Added check for
;			start_time at overflow 65535.  Also changed start_time
;			declaration to unsigned integer to match type of TIME.
;  03/25/94	BAB	Added display speed control by up and down arrow keys
;  03/09/94	BAB	Changed relay include to rly_e.inc, added to zip
;				example file for DPB2EXMP
;  01/24/94	BAB	Start, derived from DPB2_A
;  01/25/94	BAB	DPB2E_B.BAS, cleanup, added comments, took
;			out all printing in interrupt handlers
;			Added ext input and relay display to LCD,
;			changed ADC and KEY display to fit
;
; DESIRED MODIFICATIONS ------------------------------------------------------
;
; Add an onerr handler which prints error code to the LCD
;
;
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
; Notice that all printing to the LCD or serial port occurs outside all
; interrupt handlers.  If you have print routines interrupting other print
; routines you can expect all sorts of strange-looking output.
;
;

;
;-----------------------------------------------------------------------------

#target DS2250T
#console mode = 9600
#printer mode = 9600
#code start 0h
#data start 6000H


;#check istack off
#check math off
#print complete on  ; keep LCD lines from conflicting
                    ; when print@ing from ONEX1

	int delay_time

	signed int X

	unsigned character temp_uc
    
	delay_time = 100
    
    ; enable real time counter update
    TIME = 0 : MSEC = 0 : CLOCK1
    ONTIME 2, timer_tick

	gosub relay_init
	gosub relay_enable

	print "LCD init"
	gosub lcd_init                  			; initialize lcd and clear it

	TCON = TCON AND 0F7H            		; clear any pending onex1

	TCON = TCON OR 040H				; set TCON.2 for falling edge trigger

again:

	onex1 keypress_off
	clock0						; stop RTC for print# use
	
	print "DPB2E DS5000/DS2250 family serial output test:"
	print "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+"

	print# "DPB2E serial printer test:"
	print# "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+"

	clock1
	ONEX1 keypress_handler



REM                  1         2
REM         12345678901234567890
    gosub lcd_goto_line1
    print@ "*  SYSTRONIX DPB2  *",
    gosub delay_2sec

    gosub lcd_goto_line2
    print@ "THE FINEST UNIVERSAL",

    gosub lcd_goto_line3
    print@ " DALLAS DEVELOPMENT ",

    gosub lcd_goto_line4
    print@ "  SYSTEM AVAILABLE! ",
    gosub delay_2sec


    gosub lcd_goto_line2
REM         12345678901234567890
    print@ "ADC=        EXT=    ",
 
    gosub lcd_goto_line3
REM         12345678901234567890
    print@ "KEY:        REL=    ",

    string lcd_str$(180)

    lcd_str$ = "From SYSTRONIX: Universal DALLAS Development Board DPB2 revision E"
	print lcd_str$
    gosub display_string

    lcd_str$ = "Use any DS5000, DS2250, DS2251 or DS2252 Soft Microcontroller"
    gosub display_string

    lcd_str$ = "1 Serial I/O port, 1 printer port, 4 Relay drivers, 8-bit ADC, Keypad and LCD Interfaces"
    gosub display_string

    lcd_str$ = "NEW in revision E: four rugged digital inputs, ADC attenuator for larger input range,"
    gosub display_string

    lcd_str$ = "Extensive ground plane for low emitted and received RF noise and static,"
    gosub display_string

    lcd_str$ = "Convenient 8x2 header for all power and I/O connections, relay output enable, and more."
    gosub display_string

    lcd_str$ = "Plus POWERFUL, EASY-TO-USE BASIC development software!"
    gosub display_string

    lcd_str$ = "Enclosures, keypads, LCDs and other accessories are also available."
    gosub display_string

    goto again
    END


;-------------------------------------
;	DISPLAY_STRING
;-------------------------------------

display_string:
    int start_pos
    int i, j, str_len

    str_len = 0
get_str_len:
    if (asc(lcd_str$(str_len)) <> 0) then
        str_len = str_len + 1
        goto get_str_len
    endif
    
;    print "display_string: ", lcd_str$, " length = ", str_len
    
    for i = 0 to 19
        lcd_ypos = 1
        lcd_xpos = i+1
        gosub lcd_goto_xy
        if (i < str_len) then
            print@ chr(lcd_str$(i)),
        else
            print@ " ",
        endif
    gosub update_time_disp
    gosub update_adc_disp
    gosub update_ext_disp
    gosub update_key_disp
    gosub update_rel_disp
    next

    for j = 1 to 10
        gosub update_time_disp
        gosub update_adc_disp
        gosub update_key_disp
	gosub update_ext_disp
	gosub update_rel_disp
        gosub delay_100
    next

    start_pos = 1
    do
        for i = 0 to 19
            lcd_ypos = 1
            lcd_xpos = i+1
            gosub lcd_goto_xy
            if (start_pos+i < str_len) then
                print@ chr(lcd_str$(start_pos+i)),
            else
                print@ " ",
            endif
        next

        gosub update_time_disp
        gosub update_adc_disp
	gosub update_ext_disp
        gosub update_key_disp
	gosub update_rel_disp

        for j = 1 to 2
            gosub delay_100
        gosub update_time_disp
        gosub update_adc_disp
	gosub update_ext_disp
        gosub update_key_disp
	gosub update_rel_disp
        next
        
        start_pos = start_pos + 1
    while (start_pos <= str_len)
    return
        
;-------------------------------------
;	DELAY ROUTINES
;-------------------------------------


REM 100 msec delay
delay_100:
    int start_msec 
	unsigned int start_time
    start_msec = msec
    start_time = time

	; start_time checked for integer overflow BAB 4/22/94
	if start_time = 65535 then start_time = 0 

    do : until (msec > start_msec+delay_time) or (time > start_time)
    return

REM 2 second delay
delay_2sec:
	for x=1 to 20
	gosub delay_100
	next x
	return


;-------------------------------------
;	KEYPRESS (ONEX1) HANDLER
;-------------------------------------

REM EX1 handler
keypress_handler:
    gosub key_get_val               ; key value in key_dat

; this code can be used to change the display speed by pressing
; up and down arrow keys
	; up arrow makes faster, less delay
	if (key_dat = 014H) then delay_time = delay_time - 10
	; down arrow makes slower, more delay
	if (key_dat = 013H) then delay_time = delay_time + 10
	if (delay_time < 0) then delay_time = 0
	if (delay_time > 1000) then delay_time = 1000
;    print "delay_time = ", delay_time

	; turn on relay output 0 (off) or 1-4, one on
    relay_number = key_dat
    if key_dat = 0 then gosub relay_init else gosub relay_turn_on

keypress_off:
    reti

update_key_disp:
    lcd_xpos = 5
    lcd_ypos = 3
    gosub lcd_goto_xy
    PH0.@ key_raw, ">", key_dat,
    RETurn

;-------------------------------------
;	ONTIME HANDLER
;-------------------------------------

REM Ontime handler
    
timer_tick:
    ontime time+1, timer_tick
    gosub update_time
    gosub update_adc
    gosub update_ext

    RETI


;-------------------------------------
;	UPDATE TIME
;-------------------------------------


REM Get a new time and click the buzzer
update_time:
    DS_ECC_RD
    gosub metronome_1
    return

REM update time display on bottom line
update_time_disp:
    lcd_xpos = 1
    lcd_ypos = 4
    gosub lcd_goto_xy

    print@ " ",
    IF DS_MONTH < 10 then print@ "0",
    print@ DS_MONTH, "-",
    IF DS_DATE < 10 then print@ "0",
    print@ DS_DATE, "-", DS_YEAR, "  ",
    IF DS_HOUR < 10 then print@ "0",
    print@ DS_HOUR, ":",
    IF DS_MIN < 10 then print@ "0",
    print@ DS_MIN, ":",
    IF DS_SEC < 10 then print@ "0",
    print@ DS_SEC," ",
    return


;-------------------------------------
;	UPDATE ADC READING
;-------------------------------------

update_adc:
    gosub adc_read
    return
    
update_adc_disp:
    lcd_xpos = 5
    lcd_ypos = 2
    gosub lcd_goto_xy
    ph0.@ ADC_DAT,"/",
    if ADC_DAT < 10 then
        print@ "00",
    else
        if ADC_DAT < 100 then print@ "0",
    endif
    print@ ADC_DAT, 			; print dec value
    return


;-------------------------------------
;	UPDATE EXT INP READINGS
;-------------------------------------
;
; ext inp P3.2/3/4/5 are asserted LOW

unsigned char EXTINP		; holds value of 4 ext inputs

update_ext:
#ASM
	mov	A, P3
;	xrl	A, #0FFH	; complement values, 0 becomes 1
	anl	A, #00111100B	; mask all but P3.2-P3.5
	rr	A		; rotate to right
	rr	A		; now all data in low nibble
	mov	DPTR, #__EXTINP
	movx	@DPTR, A	; store value in BASIC variable
#ASM_END
    return
    
update_ext_disp:
    lcd_xpos = 17
    lcd_ypos = 2
    gosub lcd_goto_xy
    if (EXTINP AND 0000_1000B) then print@ 1, else print@ 0,
    if (EXTINP AND 0000_0100B) then print@ 1, else print@ 0,
    if (EXTINP AND 0000_0010B) then print@ 1, else print@ 0,
    if (EXTINP AND 0000_0001B) then print@ 1, else print@ 0,
    return


;-------------------------------------
;	UPDATE RELAY OUTPUT DISPLAY
;-------------------------------------
;
update_rel_disp:
    lcd_xpos = 17
    lcd_ypos = 3
    gosub lcd_goto_xy
    if (relay_status AND 0000_1000B) then print@ 1, else print@ 0,
    if (relay_status AND 0000_0100B) then print@ 1, else print@ 0,
    if (relay_status AND 0000_0010B) then print@ 1, else print@ 0,
    if (relay_status AND 0000_0001B) then print@ 1, else print@ 0,
    return




;-------------------------------------
;	INCLUDE FILES
;-------------------------------------


#include "key_e.inc"
#include "lcd_e.inc"
#include "rly_e.inc"
#include "adc_e.inc"
