; Conditional assembly flags...
; These tell the assembler various compilation options
; Feel free to refer to these in your in-line assembly code
CODE_START EQU 51
DATA_START EQU 24576
CPRINT EQU 1	; serial print
SPRINT EQU 1	; serial print#
UPRINT EQU 1	; user print
UIO    EQU 0	; user i/o drivers
_ALIGN	SET 1	; 8 bit ptrs
PRINT_COMPLETE SET 1	; each print empties buffer
RTC EQU 1	; timer0 RTC
ONEX1 EQU 1	; enable ext int 1
ONTIME EQU 1	; enable
ARRAY EQU 1	; arrays present     
ERR_MSG EQU 1	; err_msg is present
PUSH_POP EQU 0
READ_DATA EQU 0
ONERR EQU 0
PROGLINE SET 1	; track basic line numbers
RUN_TRAP_B52 EQU 0
RUN_TRAP_LOC EQU 0
SPMAX EQU 127
SPUSE_ONEX1 EQU 14	;actual stack space used
SPUSE_ONTIME EQU 20	;actual stack space used
SPUSE EQU 68	; actual istack max needed           
BASIC52 EQU 0
BEBASIC EQU 0
TARGET_8XC51F EQU 0
DS5000 EQU 1
ON_WARM SET 0
ON_POR SET 0
ON_RUNTRAP SET 0
ON_WDOG SET 0
ON_PWRFL SET 0
CHECK_ISTACK SET 1
CHECK_MATH SET 0
RELOC_VEC EQU 0
;_%%NO_B52_EQU:

_OPREG_0L 	EQU 0	
_OPREG_0H 	EQU 2
_OPREG_1L 	EQU 1
_OPREG_1H 	EQU 3
_OPREG_2L 	EQU 4
_OPREG_2H 	EQU 5
_R0 		EQU 0
_R1 		EQU 1
_R2 		EQU 2
_R3 		EQU 3
_R4 		EQU 4
_R5 		EQU 5
_R6 		EQU 6
_R7 		EQU 7


_NULLCNT	EQU 10H		
_PHEAD		EQU 11H		
_SPHEAD		EQU 12H		
_TREL1H		EQU 13H		
_TREL1L		EQU 14H
_SPCLEAR	EQU 15H		

_ASTACK_PTR_L	EQU 16H		
_ASTACK_PTR_H	EQU 17H		

	IF (UIO + UPRINT)
_UPHEAD		EQU 18H		
	ENDIF


_RTC_RELOAD	EQU 27H		
_RTC_MILLI	EQU 28H		
_RTC_SEC_LO	EQU 29H		
_RTC_SEC_HI	EQU 2AH		
_ONTIME_H	EQU 2BH		
_ONTIME_L	EQU 2CH		


	IF CPRINT
_CPRT_FLAG	BIT 21H.0	
_CPRT_RDY	BIT 21H.1	
	ENDIF

	IF SPRINT
_SPRT_FLAG	BIT 21H.2	
_SPRT_STOP	BIT 21H.3	
_SPRT_RDY	BIT 21H.4	
	ENDIF

	IF UPRINT
_UPRT_FLAG	BIT 21H.5	
	ENDIF

_ON_EX1		BIT 23H.1	
_ON_EX1_PND	BIT 23H.2	
_ON_EX1_INP	BIT 23H.3	

	IF UIO
_UIO_INP_FLAG	BIT 23H.6	
_UIO_OUT_FLAG	BIT 23H.4	
	ENDIF

_CNTRLS_FLAG	BIT 21H.6 	
_CNTRLC_FLAG	BIT 21H.7 	

_CLOCK_BIT	BIT 22H.0	
_ON_TIME	BIT 22H.1	
_ON_TIME_PND	BIT 22H.2	
_ON_TIME_INP	BIT 22H.3	

_ON_ERR		BIT 22H.4	
					  
_IDLE_END	BIT 22H.5	

_ASTACK_USED	BIT 22H.6	

_CPRT_INP	BIT 22H.7

_ES_FLAG	BIT 23H.0	

	IF DS5000
_WDOG_FLAG	BIT 23H.5	
	ENDIF

;_%%8031_EQU:

TARGET_8032	EQU 0		


;_%%GENERIC_EQU:

CR		EQU 13		
LF		EQU 10		
BS		EQU 8		
CNT_D		EQU 04   	
FPSIZE		EQU 6		


BSKEY		EQU 08H     	



ZERO_DIVIDE	EQU 10		
OVERFLOW	EQU 20		
UNDERFLOW	EQU 30		
BAD_ARGUMENT	EQU 40		

READ_OUT	EQU 50		
READ_TYPE	EQU 60		

ARRAY_INDEX	EQU 70		
STRING_TRUNC	EQU 80		

ONGO_EXPR	EQU 90		

ISTACK_ERR	EQU 100		

ASTACK_FULL	EQU 110		
ASTACK_EMPTY	EQU 120		
POP_TYPE	EQU 130		

MEM_ACC		EQU 140		
MEM_ACC_B52	EQU 150		

START_ERR	EQU 250		
;_%%DS5000_EQU:

MCON 	EQU 0C6H		; DS500X Memory CONtrol sfr
TA	EQU 0C7H		; Timed Access sfr

;_%%SERIAL_IO_EQU:

_CNTRLQ		EQU 11H		
_CNTRLS		EQU 13H		
_CNTRLC		EQU 03H		

_INPLEN		EQU 80		

_FIFOLN		EQU 16		

 
_OUTLEN		EQU 80            

INPUT_ECHO	SET 1		

;_%%SYSTRONIX:

RXD 	BIT P3.0		
T0	BIT P3.4		
T1	BIT P3.5		

LP	BIT P1.7	

    IF TARGET_8032

TL2	EQU 0CCH		
TH2	EQU 0CDH
T2CON	EQU 0C8H		

    ENDIF


    IF TARGET_8XC51F

CH	EQU 0F9H		
CCAP0H	EQU 0FAH
CCAP1H	EQU 0FBH
CCAP2H	EQU 0FCH
CCAP3H	EQU 0FDH
CCAP4H	EQU 0FEH

CL	EQU 0E9H		
CCAP0L	EQU 0EAH
CCAP1L	EQU 0EBH
CCAP2L	EQU 0ECH
CCAP3L	EQU 0EDH
CCAP4L	EQU 0EEH

CCON	EQU 0D8H
CMOD	EQU 0D9H
CCAPM0	EQU 0DAH
CCAPM1	EQU 0DBH
CCAPM2	EQU 0DCH
CCAPM3	EQU 0DDH
CCAPM4	EQU 0DEH

SADEN	EQU 0B9H		
SADDR	EQU 0A9H		

IPH	EQU 0B7H		

    ENDIF

_START_VEC EQU 03H
	org		0000H		;code segment org

	ljmp		033H		;to user program start 51D

;_%%INT0B_GEN:


	org	_START_VEC+8
    IF BASIC52 EQ 0		       	
    	push	PSW			
    ENDIF				
	ljmp	_INT_RTC		
			       
;_%%INT13_GEN:

	org	_START_VEC+10H
    IF BASIC52 EQ 0		       	
    	push	PSW			
    ENDIF				
	ljmp	_INT13_DISPATCH		

;_%%INT23_GEN:

	org	_START_VEC+20H
    IF BASIC52 EQ 0		       	
    	push	PSW			
    ENDIF				
	ljmp	_INT23			

;_%%INT2B_DS5000:


	org	2BH
	push	PSW
	ljmp	_INT_PFW
	
	org		033H		;actual program start 51D

_START_LOC:		;main entry point when CALLed

_runtrap:		; run trap local iff no B52 interp

_START_NO_B52:
	clr	EA		

	clr	psw.4		
	clr	psw.3

	mov	21H, #0		
	mov	22H, #0
	mov	23H, #0		

	setb 	_IDLE_END	
	setb	TCON.2		

    IF SPRINT
	mov	_SPHEAD, #1	
    ENDIF
    	mov	R7, SP		

		mov	SP, #48		;set stack pointer
		mov	_SPCLEAR, SP		;save SP for CLEAR, etc
;_%%DS5_STARTUP1:
	push	PSW
	push	B
	push	ACC
	push	PCON			; save original PCON value
	anl	MCON, #0FBH		; clear ECE2 bit MCON.2
	lcall	_DS5_WDOG_OFF		; disable watchdog

		; INIT Real Time Clock
		; TH0 for RTC is 112D/70H
	mov _RTC_RELOAD, #112		; TH0 Reload value
	anl TCON, #0CFH		; clr TF0 and TR0
	anl TMOD, #0F0H		; setup timer0 for RTC
	lcall	_CLR_RTC		;clear RTC locations
CONSOLE_TIMER EQU 1
		; TH1 for 9600 baud is 250D/FAH
	mov R0, #250		; Reload value for 9600 baud
	lcall _SET_CBAUD_T1		;Setup Timer1 as baudgen
		; timer1 reload for 9600 baud is 65451D/FFABH
	mov _TREL1H, #255		; MSB reload value
	mov _TREL1L, #171		; LSB reload value
	lcall	_INIT_PRINT		;init print to serial i/o port 
_SERIAL_IO_INIT:
	CLR     _CNTRLS_FLAG	
	CLR     _CNTRLC_FLAG	
	clr	_CPRT_FLAG	
    IF BASIC52
	clr	23H.7		
    ENDIF

    IF SPRINT
 	clr	_SPRT_FLAG	
    ENDIF

	mov	SCON, #50H	
	SETB    ES		
	SETB    EA		


	lcall	_INIT_PAT		;init user i/o
SERIAL_MODE SET 0
;_%%DS5_STARTUP2:

	mov 	A, PCON			; clear PCON flags
	pop	ACC			; orig value in ACC
	pop	_R0			; old ACC
	pop	_R1			; old B
	pop	PSW			; old F0 flag for runtrap detect

_DS_POR_WDCHK:				; reset could have been wdog timeout
	jnb	ACC.2, _DS_POR_PCHK	; EWT =1 if wdog enabled, jump if not
	jnb	ACC.4, _DS_POR_PCHK	; jump if =0, not a wdog timeout
    IF (ON_WDOG * DS5000)     	; if Dallas and user has specified this
	lcall	_DS_USER_WDOG		; ...go do it, return here
    ENDIF				; no need to save acc before this call
	sjmp	_DS_POR_X		; we're done

_DS_POR_PCHK:				; not wdog, see if was a POR reset
	jb	ACC.6, _DS_POR_RCHK	; =1 if not POR, might be run trap
    IF (ON_POR * DS5000)		; if Dallas and user has specified this
	lcall	_DS_USER_POR		; ...go do it, return here
    ENDIF				; no need to save acc before this call
	sjmp	_DS_POR_X		; we're done

_DS_POR_RCHK:				; could it be runtrap?

_DS_POR_RT:				; not POR, not wdog, = runtrap ? 
    IF (RUN_TRAP_LOC * DS5000) 		; could have been run trap
	jnb	F0, _DS_POR_WCHK	;
	cjne	R0, #0AAH, _DS_POR_WCHK	;
	cjne	R1, #055H, _DS_POR_WCHK	;
      IF (ON_RUNTRAP)			; if Dallas and user has specified this
	lcall	_DS_USER_RTRAP		; ...go do it, return here
      ENDIF				; no need to save acc before this call
	sjmp	_DS_POR_X		; it was run trap, exit
    ENDIF				; else fall through 

_DS_POR_WCHK:				; not a runtrap, could be warm reset

					; old SP should have been 7 if we
					; had a hardware reset of any kind
	cjne 	R7, #07H, _DS_POR_ERR	; not warm reset, jump

					; ...else warm reset is OK...
    IF (DS5000 * ON_WARM)		; ...and may have user code
	lcall	_DS_USER_WARM		; ...go do it, return here
    ENDIF				
	sjmp	_DS_POR_X		; we're done

_DS_POR_ERR:				; else an err
    IF ERR_MSG
	mov	DPTR, #_bad_start	; the message
    ENDIF
	mov	A, #START_ERR		; the errval
	ljmp	_ERR_HAND		; handle the error

_DS_POR_X:
	mov	0C7H, #0AAH		; timed access keys
	mov	0C7H, #055H

    IF ON_PWRFL
    	orl	PCON, #048H		; set POR and EPFW bits = 1
    ELSE
	orl	PCON, #040H		; set POR bit = 1
    ENDIF

; errline support
	lcall	_CLEAR_UVAR
;-----------------------------------------------------------------------------
; clear_expr
;
; clear_expr
; DEMO PROGRAM for DPB2 REVE
; clear_expr
;
; clear_expr
; Supported: 4x4 keypad, 20x4 LCD, 8-bit ADC, serial I/O, four relay driver 
; clear_expr
; outputs, four digital inputs, Dallas Timekeeper parts DS5000T and DS2250T.
; clear_expr
; Not for use with DS2251/2 which have a different Timekeeper.
; clear_expr
;
; clear_expr
; (C) Copyright 1994 Systronix, Inc All Rights Reserved
; clear_expr
;		Systronix, Inc. Salt Lake City, Utah, USA
; clear_expr
;		TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
; clear_expr
;
; clear_expr
; Owners of Systronix products are hereby entitled to use, modify, and copy
; clear_expr
; this sample program.  You may incorporate all or part of this program in 
; clear_expr
; your own commercial products provided they are not simply copies of 
; clear_expr
; Systronix products and do not compete directly with Systronix products.  
; clear_expr
; This program is provided by Systronix free of charge and may not be resold.
; clear_expr
;
; clear_expr
; This program is intended for those of you who have the pleasure of using 
; clear_expr
; the new DPB2 REVE board from Systronix/Intellix.  This card is a very
; clear_expr
; easy to use development system for the Dallas DS5000/1/2 DS2250/1/2 and -T
; clear_expr
; suffix soft microcontrollers.  If you'd like more information, please call
; clear_expr
; or FAX us at the numbers above.
; clear_expr
;
; clear_expr
; REVISION HISTORY DPB2E_B----------------------------------------------------
; clear_expr
;
; clear_expr
;  04/22/94	BAB	Fixed a bug in delay_100 which could cause an eternal 
; clear_expr
;			do loop when TIME reached 0FFFFH.  Added check for
; clear_expr
;			start_time at overflow 65535.  Also changed start_time
; clear_expr
;			declaration to unsigned integer to match type of TIME.
; clear_expr
;  03/25/94	BAB	Added display speed control by up and down arrow keys
; clear_expr
;  03/09/94	BAB	Changed relay include to rly_e.inc, added to zip
; clear_expr
;				example file for DPB2EXMP
; clear_expr
;  01/24/94	BAB	Start, derived from DPB2_A
; clear_expr
;  01/25/94	BAB	DPB2E_B.BAS, cleanup, added comments, took
; clear_expr
;			out all printing in interrupt handlers
; clear_expr
;			Added ext input and relay display to LCD,
; clear_expr
;			changed ADC and KEY display to fit
; clear_expr
;
; clear_expr
; DESIRED MODIFICATIONS ------------------------------------------------------
; clear_expr
;
; clear_expr
; Add an onerr handler which prints error code to the LCD
; clear_expr
;
; clear_expr
;
; clear_expr
;
; clear_expr
; NOTES AND COMMENTS ---------------------------------------------------------
; clear_expr
;
; clear_expr
; Notice that all printing to the LCD or serial port occurs outside all
; clear_expr
; interrupt handlers.  If you have print routines interrupting other print
; clear_expr
; routines you can expect all sorts of strange-looking output.
; clear_expr
;
; clear_expr
;
; clear_expr
;
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
; #TARGET DS2250T
; clear_expr
; #CONSOLE MODE = 9600
; clear_expr
; #PRINTER MODE = 9600
; clear_expr
; #CODE START 0H
; clear_expr
; #DATA START 6000H
; clear_expr
;#check istack off
; clear_expr
; #CHECK MATH OFF
; clear_expr
; #PRINT COMPLETE ON ; keep LCD lines from conflicting
; clear_expr
; when print@ing from ONEX1
; clear_expr
; INT DELAY_TIME
; clear_expr
; SIGNED INT X
; clear_expr
; UNSIGNED CHARACTER TEMP_UC
; clear_expr
; clear_expr
	mov	DPTR, #__DELAY_TIME
	push	DPL
	push	DPH
	mov	R0, #100
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; enable real time counter update
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall	_TIME_SET
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall	_MSEC_SET
; clear_expr
; clear_expr
	lcall	_CLOCK_START
; clear_expr
; clear_expr
	mov	R0, #2
	mov	R2, #0
	mov	_ONTIME_H, R2		; high byte
	mov	_ONTIME_L, R0		; low byte
	mov	DPTR, #_BTIMER_TICK
	mov	R0, DPL
	mov	R2, DPH
	lcall	_ONTIME
	setb	_ON_TIME		; ontime is active
; clear_expr
; clear_expr
	lcall	_BRELAY_INIT
; clear_expr
; clear_expr
	lcall	_BRELAY_ENABLE
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str0
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
	lcall	_BLCD_INIT
; clear_expr
; initialize lcd and clear it
; clear_expr
	mov	R0, TCON
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #247
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; clear any pending onex1
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_CAND
	mov	TCON, R0
; clear_expr
; clear_expr
	mov	R0, TCON
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #64
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; set TCON.2 for falling edge trigger
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_COR
	mov	TCON, R0
; clear_expr
; clear_expr
; clear_expr
_BAGAIN:
; clear_expr
; clear_expr
	mov	DPTR, #_BKEYPRESS_OFF
	mov	R0, DPL
	mov	R2, DPH
	lcall	_ONEX1
; clear_expr
; clear_expr
	lcall	_CLOCK_STOP
; clear_expr
; stop RTC for print# use
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str1
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str2
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
;_%%PRINTLB_INIT:			; save SFRs used by serial print#

  IF	CPRINT			
	jb	_CPRT_FLAG, $		; stay here until console buffer empty
  ENDIF

	setb	_SPRT_FLAG

  	push	IE	  		; save interrupt condition
	push    TH1	 		; ... interrupt and timer1 registers
	push    TL1
	push    TCON
	push    TMOD

	anl	TMOD, #0Fh		; set timer1 for mode 1, 16 bit counter
	orl	TMOD, #10h
	anl	IE, #0C6h 		; leave timer 0 enabled if it already is
			     		; leave ext 1 enabled
			     		; disable serial port interrupt
			     		; disable timer2 overflow interrupt (dependent
			     		; on use of timer2)

	mov	DPTR, #_str3
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
;_%%PRINTLB_REST:	

	pop	TMOD			; restore SFRs used by serial print#
	pop	TCON
	pop	TL1
	pop	TH1
	pop	IE

	clr	_SPRT_FLAG		; clear the sprt in progress flag

	lcall	_INT_PEND		; check for pending interrupts


; clear_expr
; clear_expr
;_%%PRINTLB_INIT:			; save SFRs used by serial print#

  IF	CPRINT			
	jb	_CPRT_FLAG, $		; stay here until console buffer empty
  ENDIF

	setb	_SPRT_FLAG

  	push	IE	  		; save interrupt condition
	push    TH1	 		; ... interrupt and timer1 registers
	push    TL1
	push    TCON
	push    TMOD

	anl	TMOD, #0Fh		; set timer1 for mode 1, 16 bit counter
	orl	TMOD, #10h
	anl	IE, #0C6h 		; leave timer 0 enabled if it already is
			     		; leave ext 1 enabled
			     		; disable serial port interrupt
			     		; disable timer2 overflow interrupt (dependent
			     		; on use of timer2)

	mov	DPTR, #_str4
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
;_%%PRINTLB_REST:	

	pop	TMOD			; restore SFRs used by serial print#
	pop	TCON
	pop	TL1
	pop	TH1
	pop	IE

	clr	_SPRT_FLAG		; clear the sprt in progress flag

	lcall	_INT_PEND		; check for pending interrupts


; clear_expr
; clear_expr
	lcall	_CLOCK_START
; clear_expr
; clear_expr
	mov	DPTR, #_BKEYPRESS_HANDLER
	mov	R0, DPL
	mov	R2, DPH
	lcall	_ONEX1
; clear_expr
;                  1         2
; clear_expr
;         12345678901234567890
; clear_expr
; clear_expr
	lcall	_BLCD_GOTO_LINE1
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str5
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
	lcall	_BDELAY_2SEC
; clear_expr
; clear_expr
	lcall	_BLCD_GOTO_LINE2
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str6
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
	lcall	_BLCD_GOTO_LINE3
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str7
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
	lcall	_BLCD_GOTO_LINE4
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str8
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
	lcall	_BDELAY_2SEC
; clear_expr
; clear_expr
	lcall	_BLCD_GOTO_LINE2
; clear_expr
;         12345678901234567890
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str9
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
	lcall	_BLCD_GOTO_LINE3
; clear_expr
;         12345678901234567890
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str10
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; STRING LCD_STR$(180)
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_STR$
	push	DPL
	push	DPH
	mov	R0, #181
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_str11
	push	DPL
	push	DPH
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_2H
	pop	_OPREG_2L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_STR_ASN
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #__LCD_STR$
	lcall	_PRINT
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
	lcall	_BDISPLAY_STRING
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_STR$
	push	DPL
	push	DPH
	mov	R0, #181
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_str12
	push	DPL
	push	DPH
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_2H
	pop	_OPREG_2L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_STR_ASN
; clear_expr
; clear_expr
	lcall	_BDISPLAY_STRING
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_STR$
	push	DPL
	push	DPH
	mov	R0, #181
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_str13
	push	DPL
	push	DPH
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_2H
	pop	_OPREG_2L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_STR_ASN
; clear_expr
; clear_expr
	lcall	_BDISPLAY_STRING
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_STR$
	push	DPL
	push	DPH
	mov	R0, #181
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_str14
	push	DPL
	push	DPH
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_2H
	pop	_OPREG_2L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_STR_ASN
; clear_expr
; clear_expr
	lcall	_BDISPLAY_STRING
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_STR$
	push	DPL
	push	DPH
	mov	R0, #181
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_str15
	push	DPL
	push	DPH
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_2H
	pop	_OPREG_2L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_STR_ASN
; clear_expr
; clear_expr
	lcall	_BDISPLAY_STRING
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_STR$
	push	DPL
	push	DPH
	mov	R0, #181
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_str16
	push	DPL
	push	DPH
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_2H
	pop	_OPREG_2L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_STR_ASN
; clear_expr
; clear_expr
	lcall	_BDISPLAY_STRING
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_STR$
	push	DPL
	push	DPH
	mov	R0, #181
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_str17
	push	DPL
	push	DPH
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_2H
	pop	_OPREG_2L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_STR_ASN
; clear_expr
; clear_expr
	lcall	_BDISPLAY_STRING
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_STR$
	push	DPL
	push	DPH
	mov	R0, #181
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_str18
	push	DPL
	push	DPH
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_2H
	pop	_OPREG_2L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_STR_ASN
; clear_expr
; clear_expr
	lcall	_BDISPLAY_STRING
; clear_expr
; clear_expr
	ljmp	_BAGAIN
; clear_expr
; clear_expr
; BASIC END (subroutines may follow)
	ljmp	_end_module
; clear_expr
;-------------------------------------
; clear_expr
;	DISPLAY_STRING
; clear_expr
;-------------------------------------
; clear_expr
; clear_expr
; clear_expr
_BDISPLAY_STRING:
; clear_expr
; INT START_POS
; clear_expr
; INT I, J, STR_LEN
; clear_expr
; clear_expr
	mov	DPTR, #__STR_LEN
	push	DPL
	push	DPH
	mov	R0, #0
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
_BGET_STR_LEN:
; clear_expr
; clear_expr
_if1:
	mov	DPTR, #__LCD_STR$
	push	DPL
	push	DPH
	mov	DPTR, #__STR_LEN
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #180
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_ARRAY_ERR1
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIADD
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	mov		DPL, R1
	mov		DPH, R3
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_INEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else1
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__STR_LEN
	push	DPL
	push	DPH
	mov	DPTR, #__STR_LEN
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BGET_STR_LEN
; clear_expr
; clear_expr
; clear_expr
_else1:
; clear_expr
; clear_expr
;    print "display_string: ", lcd_str$, " length = ", str_len
; clear_expr
; clear_expr
	mov	DPTR, #__I
	push	DPL
	push	DPH
	mov	R0, #0
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #_fnlimit2
	push	DPL
	push	DPH
	mov	R0, #19
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #_fnstep2
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
_loop2:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_YPOS
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_XPOS
	push	DPL
	push	DPH
	mov	DPTR, #__I
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_BLCD_GOTO_XY
; clear_expr
; clear_expr
_if3:
	mov	DPTR, #__I
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__STR_LEN
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else3
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #__LCD_STR$
	push	DPL
	push	DPH
	mov	DPTR, #__I
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #180
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_ARRAY_ERR1
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIADD
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	mov		DPL, R1
	mov		DPH, R3
	lcall	_CHR_GET
	mov		A, R0
	lcall	_PUTC
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
; clear_expr
	ljmp	_end_if3
_else3:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str19
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
; clear_expr
_end_if3:
; clear_expr
; clear_expr
; clear_expr
	lcall	_BUPDATE_TIME_DISP
; clear_expr
; clear_expr
	lcall	_BUPDATE_ADC_DISP
; clear_expr
; clear_expr
	lcall	_BUPDATE_EXT_DISP
; clear_expr
; clear_expr
	lcall	_BUPDATE_KEY_DISP
; clear_expr
; clear_expr
	lcall	_BUPDATE_REL_DISP
; clear_expr
; clear_expr
	mov	DPTR, #__I
	push	DPL
	push	DPH
	mov	DPTR, #__I
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_fnstep2
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #__I
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_fnlimit2
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	mov	DPTR, #_fnstep2
	lcall	_STEP_SI
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop2
; clear_expr
; clear_expr
	mov	DPTR, #__J
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #_fnlimit4
	push	DPL
	push	DPH
	mov	R0, #10
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #_fnstep4
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
_loop4:
; clear_expr
; clear_expr
	lcall	_BUPDATE_TIME_DISP
; clear_expr
; clear_expr
	lcall	_BUPDATE_ADC_DISP
; clear_expr
; clear_expr
	lcall	_BUPDATE_KEY_DISP
; clear_expr
; clear_expr
	lcall	_BUPDATE_EXT_DISP
; clear_expr
; clear_expr
	lcall	_BUPDATE_REL_DISP
; clear_expr
; clear_expr
	lcall	_BDELAY_100
; clear_expr
; clear_expr
	mov	DPTR, #__J
	push	DPL
	push	DPH
	mov	DPTR, #__J
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_fnstep4
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #__J
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_fnlimit4
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	mov	DPTR, #_fnstep4
	lcall	_STEP_SI
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop4
; clear_expr
; clear_expr
	mov	DPTR, #__START_POS
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
_loop5:
; clear_expr
; clear_expr
	mov	DPTR, #__I
	push	DPL
	push	DPH
	mov	R0, #0
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #_fnlimit6
	push	DPL
	push	DPH
	mov	R0, #19
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #_fnstep6
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
_loop6:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_YPOS
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_XPOS
	push	DPL
	push	DPH
	mov	DPTR, #__I
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_BLCD_GOTO_XY
; clear_expr
; clear_expr
_if7:
	mov	DPTR, #__START_POS
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__I
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__STR_LEN
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else7
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #__LCD_STR$
	push	DPL
	push	DPH
	mov	DPTR, #__START_POS
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__I
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	push	_OPREG_0L
	push	_OPREG_0H
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #180
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_ARRAY_ERR1
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIADD
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	mov		DPL, R1
	mov		DPH, R3
	lcall	_CHR_GET
	mov		A, R0
	lcall	_PUTC
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
; clear_expr
	ljmp	_end_if7
_else7:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str20
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
; clear_expr
_end_if7:
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__I
	push	DPL
	push	DPH
	mov	DPTR, #__I
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_fnstep6
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #__I
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_fnlimit6
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	mov	DPTR, #_fnstep6
	lcall	_STEP_SI
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop6
; clear_expr
; clear_expr
	lcall	_BUPDATE_TIME_DISP
; clear_expr
; clear_expr
	lcall	_BUPDATE_ADC_DISP
; clear_expr
; clear_expr
	lcall	_BUPDATE_EXT_DISP
; clear_expr
; clear_expr
	lcall	_BUPDATE_KEY_DISP
; clear_expr
; clear_expr
	lcall	_BUPDATE_REL_DISP
; clear_expr
; clear_expr
	mov	DPTR, #__J
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #_fnlimit8
	push	DPL
	push	DPH
	mov	R0, #2
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #_fnstep8
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
_loop8:
; clear_expr
; clear_expr
	lcall	_BDELAY_100
; clear_expr
; clear_expr
	lcall	_BUPDATE_TIME_DISP
; clear_expr
; clear_expr
	lcall	_BUPDATE_ADC_DISP
; clear_expr
; clear_expr
	lcall	_BUPDATE_EXT_DISP
; clear_expr
; clear_expr
	lcall	_BUPDATE_KEY_DISP
; clear_expr
; clear_expr
	lcall	_BUPDATE_REL_DISP
; clear_expr
; clear_expr
	mov	DPTR, #__J
	push	DPL
	push	DPH
	mov	DPTR, #__J
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_fnstep8
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #__J
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_fnlimit8
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	mov	DPTR, #_fnstep8
	lcall	_STEP_SI
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop8
; clear_expr
; clear_expr
	mov	DPTR, #__START_POS
	push	DPL
	push	DPH
	mov	DPTR, #__START_POS
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	mov	DPTR, #__START_POS
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__STR_LEN
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILE
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop5
; clear_expr
; clear_expr
	ret
; clear_expr
;-------------------------------------
; clear_expr
;	DELAY ROUTINES
; clear_expr
;-------------------------------------
; clear_expr
; 100 msec delay
; clear_expr
; clear_expr
; clear_expr
_BDELAY_100:
; clear_expr
; INT START_MSEC 
; clear_expr
; UNSIGNED INT START_TIME
; clear_expr
; clear_expr
	mov	DPTR, #__START_MSEC
	push	DPL
	push	DPH
	lcall	_MSEC_GET
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	mov	DPTR, #__START_TIME
	push	DPL
	push	DPH
	lcall	_TIME_GET
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; start_time checked for integer overflow BAB 4/22/94
; clear_expr
; clear_expr
_if9:
	mov	DPTR, #__START_TIME
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #255
	mov	R2, #255
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else9
; clear_expr
	mov	DPTR, #__START_TIME
	push	DPL
	push	DPH
	mov	R0, #0
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
_else9:
; clear_expr
; clear_expr
; clear_expr
_loop10:
; clear_expr
; clear_expr
	lcall	_MSEC_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__START_MSEC
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__DELAY_TIME
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIGT
	push	_OPREG_0L
	push	_OPREG_0H
	lcall	_TIME_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__START_TIME
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIGT
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IOR
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_loop10
; clear_expr
; clear_expr
	ret
; clear_expr
; 2 second delay
; clear_expr
; clear_expr
; clear_expr
_BDELAY_2SEC:
; clear_expr
; clear_expr
	mov	DPTR, #__X
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #_fnlimit11
	push	DPL
	push	DPH
	mov	R0, #20
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #_fnstep11
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
_loop11:
; clear_expr
; clear_expr
	lcall	_BDELAY_100
; clear_expr
; clear_expr
	mov	DPTR, #__X
	push	DPL
	push	DPH
	mov	DPTR, #__X
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_fnstep11
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
	mov	DPTR, #__X
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_fnlimit11
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	mov	DPTR, #_fnstep11
	lcall	_STEP_SI
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop11
; clear_expr
; clear_expr
	ret
; clear_expr
;-------------------------------------
; clear_expr
;	KEYPRESS (ONEX1) HANDLER
; clear_expr
;-------------------------------------
; clear_expr
; EX1 handler
; clear_expr
; clear_expr
; clear_expr
_BKEYPRESS_HANDLER:
; clear_expr
; clear_expr
	lcall	_BKEY_GET_VAL
; clear_expr
; key value in key_dat
; this code can be used to change the display speed by pressing
; clear_expr
; up and down arrow keys
; clear_expr
; up arrow makes faster, less delay
; clear_expr
; clear_expr
_if12:
	mov	DPTR, #__KEY_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #20
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else12
; clear_expr
	mov	DPTR, #__DELAY_TIME
	push	DPL
	push	DPH
	mov	DPTR, #__DELAY_TIME
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ISUB
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
_else12:
; clear_expr
; clear_expr
; down arrow makes slower, more delay
; clear_expr
; clear_expr
_if13:
	mov	DPTR, #__KEY_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #19
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else13
; clear_expr
	mov	DPTR, #__DELAY_TIME
	push	DPL
	push	DPH
	mov	DPTR, #__DELAY_TIME
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
_else13:
; clear_expr
; clear_expr
; clear_expr
_if14:
	mov	DPTR, #__DELAY_TIME
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else14
; clear_expr
	mov	DPTR, #__DELAY_TIME
	push	DPL
	push	DPH
	mov	R0, #0
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
_else14:
; clear_expr
; clear_expr
; clear_expr
_if15:
	mov	DPTR, #__DELAY_TIME
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #232
	mov	R2, #3
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IGT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else15
; clear_expr
	mov	DPTR, #__DELAY_TIME
	push	DPL
	push	DPH
	mov	R0, #232
	mov	R2, #3
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
_else15:
; clear_expr
; clear_expr
;    print "delay_time = ", delay_time
; clear_expr
; turn on relay output 0 (off) or 1-4, one on
; clear_expr
; clear_expr
	mov	DPTR, #__RELAY_NUMBER
	push	DPL
	push	DPH
	mov	DPTR, #__KEY_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
_if16:
	mov	DPTR, #__KEY_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else16
; clear_expr
	lcall	_BRELAY_INIT
; clear_expr
	ljmp	_end_if16
_else16:
; clear_expr
	lcall	_BRELAY_TURN_ON
_end_if16:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_BKEYPRESS_OFF:
; clear_expr
; clear_expr
	ljmp	_RETI_BAS
; clear_expr
; clear_expr
; clear_expr
_BUPDATE_KEY_DISP:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_XPOS
	push	DPL
	push	DPH
	mov	R0, #5
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_YPOS
	push	DPL
	push	DPH
	mov	R0, #3
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_BLCD_GOTO_XY
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #__KEY_RAW
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_PH0
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str21
	lcall	_PRINT_ROM
	mov	DPTR, #__KEY_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_PH0
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
	ret
; clear_expr
;-------------------------------------
; clear_expr
;	ONTIME HANDLER
; clear_expr
;-------------------------------------
; clear_expr
; Ontime handler
; clear_expr
; clear_expr
; clear_expr
_BTIMER_TICK:
; clear_expr
; clear_expr
	lcall	_TIME_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIADD
	mov	_ONTIME_H, R2		; high byte
	mov	_ONTIME_L, R0		; low byte
	mov	DPTR, #_BTIMER_TICK
	mov	R0, DPL
	mov	R2, DPH
	lcall	_ONTIME
	setb	_ON_TIME		; ontime is active
; clear_expr
; clear_expr
	lcall	_BUPDATE_TIME
; clear_expr
; clear_expr
	lcall	_BUPDATE_ADC
; clear_expr
; clear_expr
	lcall	_BUPDATE_EXT
; clear_expr
; clear_expr
	ljmp	_RETI_BAS
; clear_expr
;-------------------------------------
; clear_expr
;	UPDATE TIME
; clear_expr
;-------------------------------------
; clear_expr
; update time on bottom line
; clear_expr
; clear_expr
; clear_expr
_BUPDATE_TIME:
; clear_expr
; clear_expr
	lcall _DS5_ECC_RD
; clear_expr
; clear_expr
	lcall	_BMETRONOME_1
; clear_expr
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BUPDATE_TIME_DISP:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_XPOS
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_YPOS
	push	DPL
	push	DPH
	mov	R0, #4
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_BLCD_GOTO_XY
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str22
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
_if17:
	mov DPTR, #_DS_MONTH
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else17
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str23
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
_else17:
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov DPTR, #_DS_MONTH
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str24
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
_if18:
	mov DPTR, #_DS_DATE
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else18
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str25
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
_else18:
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov DPTR, #_DS_DATE
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str26
	lcall	_PRINT_ROM
	mov DPTR, #_DS_YEAR
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str27
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
_if19:
	mov DPTR, #_DS_HOUR
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else19
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str28
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
_else19:
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov DPTR, #_DS_HOUR
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str29
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
_if20:
	mov DPTR, #_DS_MIN
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else20
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str30
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
_else20:
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov DPTR, #_DS_MIN
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str31
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
_if21:
	mov DPTR, #_DS_SEC
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else21
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str32
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
_else21:
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov DPTR, #_DS_SEC
	lcall	_CHR_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str33
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
	ret
; clear_expr
;-------------------------------------
; clear_expr
;	UPDATE ADC READING
; clear_expr
;-------------------------------------
; clear_expr
; clear_expr
; clear_expr
_BUPDATE_ADC:
; clear_expr
; clear_expr
	lcall	_BADC_READ
; clear_expr
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BUPDATE_ADC_DISP:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_XPOS
	push	DPL
	push	DPH
	mov	R0, #5
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_YPOS
	push	DPL
	push	DPH
	mov	R0, #2
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_BLCD_GOTO_XY
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #__ADC_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_PH0
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str34
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
_if22:
	mov	DPTR, #__ADC_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else22
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str35
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
; clear_expr
	ljmp	_end_if22
_else22:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_if23:
	mov	DPTR, #__ADC_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #100
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else23
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #_str36
	lcall	_PRINT_ROM
	clr	_UPRT_FLAG
; clear_expr
_else23:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_end_if22:
; clear_expr
; clear_expr
; clear_expr
	setb	_UPRT_FLAG
	mov	DPTR, #__ADC_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
; print dec value
	clr	_UPRT_FLAG
; clear_expr
; clear_expr
	ret
; clear_expr
;-------------------------------------
; clear_expr
;	UPDATE EXT INP READINGS
; clear_expr
;-------------------------------------
; clear_expr
;
; clear_expr
; ext inp P3.2/3/4/5 are asserted LOW
; clear_expr
; UNSIGNED CHAR EXTINP ; holds value of 4 ext inputs
; clear_expr
; clear_expr
; clear_expr
_BUPDATE_EXT:
; clear_expr
; #ASM
; clear_expr


	mov	A, P3
;	xrl	A, #0FFH	; complement values, 0 becomes 1
	anl	A, #00111100B	; mask all but P3.2-P3.5
	rr	A		; rotate to right
	rr	A		; now all data in low nibble
	mov	DPTR, #__EXTINP
	movx	@DPTR, A	; store value in BASIC variable
; #ASM_END
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BUPDATE_EXT_DISP:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_XPOS
	push	DPL
	push	DPH
	mov	R0, #17
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_YPOS
	push	DPL
	push	DPH
	mov	R0, #2
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_BLCD_GOTO_XY
; clear_expr
; clear_expr
_if24:
	mov	DPTR, #__EXTINP
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #8
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_CAND
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else24
; clear_expr
	setb	_UPRT_FLAG
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ITOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
; clear_expr
	ljmp	_end_if24
_else24:
; clear_expr
	setb	_UPRT_FLAG
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ITOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
_end_if24:
; clear_expr
; clear_expr
; clear_expr
_if25:
	mov	DPTR, #__EXTINP
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #4
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_CAND
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else25
; clear_expr
	setb	_UPRT_FLAG
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ITOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
; clear_expr
	ljmp	_end_if25
_else25:
; clear_expr
	setb	_UPRT_FLAG
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ITOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
_end_if25:
; clear_expr
; clear_expr
; clear_expr
_if26:
	mov	DPTR, #__EXTINP
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #2
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_CAND
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else26
; clear_expr
	setb	_UPRT_FLAG
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ITOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
; clear_expr
	ljmp	_end_if26
_else26:
; clear_expr
	setb	_UPRT_FLAG
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ITOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
_end_if26:
; clear_expr
; clear_expr
; clear_expr
_if27:
	mov	DPTR, #__EXTINP
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_CAND
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else27
; clear_expr
	setb	_UPRT_FLAG
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ITOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
; clear_expr
	ljmp	_end_if27
_else27:
; clear_expr
	setb	_UPRT_FLAG
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ITOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
_end_if27:
; clear_expr
; clear_expr
; clear_expr
	ret
; clear_expr
;-------------------------------------
; clear_expr
;	UPDATE RELAY OUTPUT DISPLAY
; clear_expr
;-------------------------------------
; clear_expr
;
; clear_expr
; clear_expr
; clear_expr
_BUPDATE_REL_DISP:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_XPOS
	push	DPL
	push	DPH
	mov	R0, #17
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_YPOS
	push	DPL
	push	DPH
	mov	R0, #3
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_BLCD_GOTO_XY
; clear_expr
; clear_expr
_if28:
	mov	DPTR, #__RELAY_STATUS
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #8
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_CAND
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else28
; clear_expr
	setb	_UPRT_FLAG
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ITOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
; clear_expr
	ljmp	_end_if28
_else28:
; clear_expr
	setb	_UPRT_FLAG
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ITOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
_end_if28:
; clear_expr
; clear_expr
; clear_expr
_if29:
	mov	DPTR, #__RELAY_STATUS
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #4
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_CAND
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else29
; clear_expr
	setb	_UPRT_FLAG
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ITOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
; clear_expr
	ljmp	_end_if29
_else29:
; clear_expr
	setb	_UPRT_FLAG
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ITOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
_end_if29:
; clear_expr
; clear_expr
; clear_expr
_if30:
	mov	DPTR, #__RELAY_STATUS
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #2
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_CAND
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else30
; clear_expr
	setb	_UPRT_FLAG
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ITOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
; clear_expr
	ljmp	_end_if30
_else30:
; clear_expr
	setb	_UPRT_FLAG
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ITOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
_end_if30:
; clear_expr
; clear_expr
; clear_expr
_if31:
	mov	DPTR, #__RELAY_STATUS
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_CAND
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else31
; clear_expr
	setb	_UPRT_FLAG
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ITOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
; clear_expr
	ljmp	_end_if31
_else31:
; clear_expr
	setb	_UPRT_FLAG
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ITOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	clr	_UPRT_FLAG
_end_if31:
; clear_expr
; clear_expr
; clear_expr
	ret
; clear_expr
;-------------------------------------
; clear_expr
;	INCLUDE FILES
; clear_expr
;-------------------------------------
; clear_expr
; #INCLUDE "key_e.inc"
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
;
; clear_expr
; KEYPAD INCLUDE FILE for DPB2 board rev E
; clear_expr
;
; clear_expr
; (C) Copyright 1994 Systronix, Inc All Rights Reserved
; clear_expr
;		Systronix, Inc. Salt Lake City, Utah, USA
; clear_expr
;		TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
; clear_expr
;
; clear_expr
; Owners of Systronix products are hereby entitled to use, modify, and copy
; clear_expr
; this sample program.  You may incorporate all or part of this program in 
; clear_expr
; your own commercial products provided they are not simply copies of 
; clear_expr
; Systronix products and do not compete directly with Systronix products.  
; clear_expr
; This program is provided by Systronix free of charge and may not be resold.
; clear_expr
;
; clear_expr
; This program is intended for those of you who have the pleasure of using 
; clear_expr
; the new DPB2 REVE board from Systronix/Intellix.  This card is a very
; clear_expr
; easy to use development system for the Dallas DS5000/1/2 DS2250/1/2 and -T
; clear_expr
; suffix soft microcontrollers.  If you'd like more information, please call
; clear_expr
; or FAX us at the numbers above.
; clear_expr
;
; clear_expr
; REVISION HISTORY -----------------------------------------------------------
; clear_expr
;
; clear_expr
;	03/25/94	BAB	Fixed up arrow / left arrow: now are correctly mapped,
; clear_expr
;					left arrow is a raw 01H, up arrow a raw 00H
; clear_expr
;	03/02/94	BAB	Added new header, released in ZIP file
; clear_expr
;
; clear_expr
;
; clear_expr
; NOTES AND COMMENTS ---------------------------------------------------------
; clear_expr
;
; clear_expr
; Keypad control
; clear_expr
; Keypad output enable is P1.3
; clear_expr
; Keypad interrupt goes high when a key is pressed and then low
; clear_expr
; when released.  This is wired to the Dallas INT1 input.
; clear_expr
; If TCON.2 is set to a 1, a key press will cause an INT1 on its
; clear_expr
; falling edge, i.e., when the key is released.
; clear_expr
;
; clear_expr
; To read the value of the key, drive P1.3 low and read the data on the PORT0
; clear_expr
; data port.
; clear_expr
;
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
; clear_expr
	ljmp	_BKEY_INC_END
; clear_expr
; protect against include in program body
; UNSIGNED CHAR KEY_DAT, KEY_RAW
; clear_expr
; get key value and put in KEY_DAT
; clear_expr
; clear_expr
; clear_expr
_BKEY_GET_DATA:
; clear_expr
; clear_expr
	mov	R0, #255
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; make Port0 input
	pop	_OPREG_0H
	pop	_OPREG_0L
	mov	P0, R0
; clear_expr
; clear_expr
	mov	R0, P1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #247
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; clear P1.3 to read keypad data
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_CAND
	mov	P1, R0
; clear_expr
; clear_expr
	mov	DPTR, #__KEY_DAT
	push	DPL
	push	DPH
	mov	R0, P0
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	mov	R0, P1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #8
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; set P1.3 to take C922 off the data bus!
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_COR
	mov	P1, R0
; clear_expr
; clear_expr
	mov	DPTR, #__KEY_DAT
	push	DPL
	push	DPH
	mov	DPTR, #__KEY_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #15
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; mask off upper nibble
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_CAND
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	mov	DPTR, #__KEY_RAW
	push	DPL
	push	DPH
	mov	DPTR, #__KEY_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ret
; clear_expr
; get key's value 
; clear_expr
;    numeric keys = numeric value
; clear_expr
;    non-numeric keys = 0FxH
; clear_expr
; clear_expr
; clear_expr
_BKEY_GET_VAL:
; clear_expr
; clear_expr
	lcall	_BKEY_GET_DATA
; clear_expr
; #ASM
; clear_expr


	mov	    DPTR,#__KEY_DAT     ; addr in DPTR
	movx    A,@DPTR             ; put value into acc
    add     A,#02H              ; adjust for jump
    movc    A,@A+PC             ; get lookup value into acc
    sjmp    OVER_KEY_TABLE      ; jump over data
    ; lookup data entries
	; this translates Systronix keypad 100222 into the keys used
	; in our HPC1 system.  Note that pin 1 of the keypad connector is
	; the rightmost pin as you face the keypad with the flex cable
	; extending away from you, out of the top of the keypad.
	;
	; 1xH are the non-numeric keys
	;
    DB      14H            		; 0 - up arrow
    DB      15H                 ; 1 - del/backspace
    DB      13H                 ; 2 - down arrow
    DB      12H	                ; 3 - enter
    DB      06H		            ; 4 - 
    DB      09H                 ; 5 -
    DB      03H                 ; 6 -
    DB      11H                 ; 7 - dec point
    DB      05H            		; 8 - 
    DB      08H             	; 9 - 
    DB      02H             	; A - 
    DB      00H            		; B - 
    DB      04H                 ; C -
    DB      07H                 ; D -
    DB      01H                 ; E -
    DB      10H                 ; F - escape
OVER_KEY_TABLE:
	movx    @DPTR,A             ; store value in KEY_DAT
; #ASM_END
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BKEY_INC_END:
; protect against include in program body
; clear_expr
; #INCLUDE "lcd_e.inc"
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
;
; clear_expr
; LCD INCLUDE FILE for DPB2 boards rev D and rev E
; clear_expr
;
; clear_expr
;
; clear_expr
; (C) Copyright 1994 Systronix, Inc All Rights Reserved
; clear_expr
;		Systronix, Inc. Salt Lake City, Utah, USA
; clear_expr
;		TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
; clear_expr
;
; clear_expr
; Owners of Systronix products are hereby entitled to use, modify, and copy
; clear_expr
; this sample program.  You may incorporate all or part of this program in 
; clear_expr
; your own commercial products provided they are not simply copies of 
; clear_expr
; Systronix products and do not compete directly with Systronix products.  
; clear_expr
; This program is provided by Systronix free of charge and may not be resold.
; clear_expr
;
; clear_expr
; This program is intended for those of you who have the pleasure of using 
; clear_expr
; the new DPB2 REVE board from Systronix/Intellix.  This card is a very
; clear_expr
; easy to use development system for the Dallas DS5000/1/2 DS2250/1/2 and -T
; clear_expr
; suffix soft microcontrollers.  If you'd like more information, please call
; clear_expr
; or FAX us at the numbers above.
; clear_expr
;
; clear_expr
; REVISION HISTORY LCD_E.INC -------------------------------------------------
; clear_expr
;
; clear_expr
;	95 Jan 30	BAB	Fixed some shift direction bugs and return
; clear_expr
;				pop mismatch reported by DH
; clear_expr
;	94 Nov 28	BAB	Cleaned up tabs/spaces, removed commented-out code
; clear_expr
;	03/02/94	BAB	Fixed blank display bug and LCD/ONEX1 collisions
; clear_expr
;				with simultaneous PORT0 use.
; clear_expr
;				Disabled ONEX1 interrupt in LCD access
; clear_expr
;	01/25/94	BAB	Cleanup, comments
; clear_expr
;	11/XX/94	KDH	Start
; clear_expr
;
; clear_expr
;
; clear_expr
; NOTES AND COMMENTS ---------------------------------------------------------
; clear_expr
;
; clear_expr
; Keep all printing to the LCD or serial port outside interrupt handlers.  
; clear_expr
; If you have print routines interrupting other print
; clear_expr
; routines you can expect all sorts of strange-looking output. Alternatively 
; clear_expr
; you can have all printing inside one interrupt handler.  The point is to 
; clear_expr
; keep printing in one place and don't have print routines interrupting each 
; clear_expr
; other!
; clear_expr
;
; clear_expr
; The keypad on DPB2 shares Port0 with the LCD data bus.  Therefore we turn
; clear_expr
; off EX1 (used by ONEX1, the keypad handler) during an LCD write.  Otherwise,
; clear_expr
; a keypress could interrupt an LCD data transfer and place keypad data on the
; clear_expr
; LCD data bus.  Guaranteed to cause strange-looking LCD display!
; clear_expr
;
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
;
; clear_expr
; LCD Access Timing:
; clear_expr
;
; clear_expr
; LCD initialization occurs automaticlly provided:
; clear_expr
;   1) Power supply rise from 0.2 to 4.5V is 0.1 msec min, 10 msec max
; clear_expr
; 	2) Power supply off (less than 0.2V) time is at least 1 msec
; clear_expr
;	During power-on init, the busy flag is held high, typically for 10 msec
; clear_expr
;
; clear_expr
; If there is any chance the power supply doesn't meet these conditions, you
; clear_expr
; should reset by firmware instructions.	
; clear_expr
;
; clear_expr
; LCD intialization by firmware is different from normal instruction writes, 
; clear_expr
; in that you cannot monitor the busy flag and delay between writes is up to 
; clear_expr
; 4.1 msec.
; clear_expr
; 
; clear_expr
;
; clear_expr
; Instruction writes to the LCD take 40 usec max except for clear display and
; clear_expr
; return home which take up to 1.64 msec.  You can monitor the busy flag for
; clear_expr
; all these.
; clear_expr
;
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
;	95 Jan	A customer has reported that Rohm brand LCDs do not use the
; clear_expr
; same initialization timing as all the other LCDs we have used (Denistron,
; clear_expr
; Optrex, Kyocera, Samsung, Hitachi, Samtron, etc).
; clear_expr
;
; clear_expr
;
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
; HD44780 and equivalent character type LCD controller description
; clear_expr
;
; clear_expr
; Hitachi HD44780 type controllers have up to 80 character locations, hex
; clear_expr
; addresses 00H thru 4FH (4FH = 80 decimal).  When right-shifting even
; clear_expr
; an 8-character display, location 4FH shifts into character 0!
; clear_expr
;
; clear_expr
; DD RAM = Display Data RAM, character codes 20H thru FFH
; clear_expr
; CG RAM = Character Generator RAM, character codes 00H thru 0FH
; clear_expr
;
; clear_expr
;
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
; LCD Display Sizes and Addresses
; clear_expr
;
; clear_expr
; One line displays:
; clear_expr
;	 8x1 has DD RAM addresses 00H thru 07H, left to right
; clear_expr
;	16x1 has DD RAM addresses 00H thru 0FH, left to right
; clear_expr
;
; clear_expr
; Two line displays, less than 40x2:
; clear_expr
;	Top line has DD RAM addresses 00H thru 27H, left to right
; clear_expr
;	Bottom line has DD RAM addresses 40H thru 67H, left to right
; clear_expr
;
; clear_expr
;	A right shift wraps each line on itself - address 27H moves into the 
; clear_expr
;	top line, character 0.  Address 67H moves into the bottom line first
; clear_expr
;	character.
; clear_expr
;	
; clear_expr
;	
; clear_expr
;
; clear_expr
;
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
;
; clear_expr
; LCD CONTROL
; clear_expr
; 
; clear_expr
; Entry points:
; clear_expr
;   lcd_init        -- initialize the lcd
; clear_expr
;   lcd_clr_display -- clear the entire lcd display
; clear_expr
;   lcd_home        -- set the lcd display to the original position,
; clear_expr
;                        (undo display shift) and set cursor postion to (0,0)
; clear_expr
;   lcd_cursor_inc  -- set cursor to write from left to right
; clear_expr
;   lcd_cursor_dec  -- set cursor to write from right to left
; clear_expr
;   lcd_shift_on    -- set display to shift as if cursor stays stationary
; clear_expr
;   lcd_shift_off   -- set display to not shift
; clear_expr
;   lcd_display_on  -- turn the display on
; clear_expr
;   lcd_display_off -- turn the display off
; clear_expr
;   lcd_cursor_on   -- turn the cursor on
; clear_expr
;   lcd_cursor_off  -- turn the cursor off
; clear_expr
;   lcd_blink_on    -- turn the cursor blink on
; clear_expr
;   lcd_blink_off   -- turn the cursor blink off
; clear_expr
;   lcd_goto_line1  -- set the cursor position to (0,1)
; clear_expr
;   lcd_goto_line2  -- set the cursor position to (0,2)
; clear_expr
;   lcd_goto_line3  -- set the cursor position to (0,3)
; clear_expr
;   lcd_goto_line4  -- set the cursor position to (0,4)
; clear_expr
;   lcd_goto_xy     -- set the cursor position to (lcd_xpos,lcd_ypos)
; clear_expr
;   lcd_set_dd_pos  -- set the cursor position to absolute value to lcd_dat
; clear_expr
;   lcd_get_dd_pos  -- get the cursor's absolute value postion into lcd_dat
; clear_expr
;   lcd_write_data  -- write the data in lcd_dat to the current position
; clear_expr
;   lcd_read_data   -- get the data into lcd_dat from the current position
; clear_expr
;
; clear_expr
; P1.4 is LCD RS (register select), Data (H), Instruction (L)
; clear_expr
; P1.5 is LCD R/W (read/write) Read (H), Write (L)
; clear_expr
; P1.6 is LCD enable, pulse it H to strobe the cycle into the LCD
; clear_expr
;
; clear_expr
; P0 is the data bus
; clear_expr
; Busy flag is data bit 7, P0.7
; clear_expr
;
; clear_expr
;
; clear_expr
; clear_expr
	ljmp	_BLCD_INC_END
; clear_expr
; protect against include in program body
; UNSIGNED CHAR LCD_DAT, LCD_CFG
; clear_expr
; UNSIGNED CHAR LCD_BUSY
; clear_expr
; SIGNED INT LCD_XPOS
; clear_expr
; SIGNED INT LCD_YPOS
; clear_expr
; UNSIGNED CHAR LCD_DISP_STAT ; display on/off, cursor on/off, blink on/off
; clear_expr
; UNSIGNED CHAR LCD_EM_STAT ; cursor move right/left, display shift on/off
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
;
; clear_expr
; Applies to any resolution display
; clear_expr
; clear_expr
; clear_expr
_BLCD_INIT:
; clear_expr
;    print "lcd_init"
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_EM_STAT
	push	DPL
	push	DPH
	mov	R0, #0
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DISP_STAT
	push	DPL
	push	DPH
	mov	R0, #0
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_CLOCK_START
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall	_MSEC_SET
; clear_expr
; clear_expr
_loop32:
; clear_expr
; clear_expr
	lcall	_MSEC_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #20
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UILT
	push	_OPREG_0L
	push	_OPREG_0H
; delay 20 msecs
	pop	_OPREG_0H
	pop	_OPREG_0L
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop32
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #48
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; function set 8 bits
	pop	_OPREG_0H
	pop	_OPREG_0L
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_BLCD_INS_WRNB
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall	_MSEC_SET
; clear_expr
; clear_expr
_loop33:
; clear_expr
; clear_expr
	lcall	_MSEC_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #5
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UILT
	push	_OPREG_0L
	push	_OPREG_0H
; delay 5 msecs
	pop	_OPREG_0H
	pop	_OPREG_0L
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop33
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #48
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; function set 8 bits
	pop	_OPREG_0H
	pop	_OPREG_0L
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_BLCD_INS_WRNB
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall	_MSEC_SET
; clear_expr
; clear_expr
_loop34:
; clear_expr
; clear_expr
	lcall	_MSEC_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #5
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UILT
	push	_OPREG_0L
	push	_OPREG_0H
; delay 5 msecs
	pop	_OPREG_0H
	pop	_OPREG_0L
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop34
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #48
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; function set 8 bits
	pop	_OPREG_0H
	pop	_OPREG_0L
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_BLCD_INS_WRNB
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall	_MSEC_SET
; clear_expr
; clear_expr
_loop35:
; clear_expr
; clear_expr
	lcall	_MSEC_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #5
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UILT
	push	_OPREG_0L
	push	_OPREG_0H
; delay 5 msecs
	pop	_OPREG_0H
	pop	_OPREG_0L
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_loop35
; clear_expr
; set interface to 8 bits, 1 line display
; clear_expr
; 030H = 8 bits, one line, 5x7 font
; clear_expr
; 038H = 8 bits, 2 or 4 lines, 5x7 font
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #56
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	lcall	_BLCD_INS_WRNB
; clear_expr
; clear_expr
	lcall	_BLCD_CLR_DISPLAY
; clear_expr
; clear_expr
	lcall	_BLCD_DISPLAY_ON
; clear_expr
; clear_expr
	ret
; clear_expr
; Clear display, cursor home (takes about 2 msec)
; clear_expr
; Be sure to call with long delay version of instr write
; clear_expr
; clear_expr
; clear_expr
_BLCD_CLR_DISPLAY:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_INS_WRNB
; clear_expr
; Resets display to original position and cursor position to 0,  (takes about 2 msec)
; clear_expr
; Be sure to call with long delay version of instr write
; clear_expr
; clear_expr
; clear_expr
_BLCD_HOME:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #2
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_INS_WRNB
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
; Cursor move and display shift are performed during data read and write
; clear_expr
; These apply to any resolution display
; clear_expr
; Set Cursor shift to right after a data read or write
; clear_expr
; clear_expr
; clear_expr
_BLCD_CURSOR_INC:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_EM_STAT
	push	DPL
	push	DPH
	mov	DPTR, #__LCD_EM_STAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #2
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; set shift direction bit
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_COR
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_EM_LAS
; clear_expr
; Set Cursor shift to left
; clear_expr
; clear_expr
; clear_expr
_BLCD_CURSOR_DEC:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_EM_STAT
	push	DPL
	push	DPH
	mov	DPTR, #__LCD_EM_STAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #253
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; clear shift direction bit
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_CAND
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_EM_LAS
; clear_expr
; Set display shift on after a data read or write
; clear_expr
; clear_expr
; clear_expr
_BLCD_SHIFT_ON:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_EM_STAT
	push	DPL
	push	DPH
	mov	DPTR, #__LCD_EM_STAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; set display shift bit
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_COR
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_EM_LAS
; clear_expr
; Set display shift off
; clear_expr
; clear_expr
; clear_expr
_BLCD_SHIFT_OFF:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_EM_STAT
	push	DPL
	push	DPH
	mov	DPTR, #__LCD_EM_STAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	lcall	_CNOT
	push	_OPREG_0L
	push	_OPREG_0H
; clear display shift bit
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IAND
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_EM_LAS
; clear_expr
; Entry mode is a write cycle which sets cursor move and display shift
; clear_expr
;
; clear_expr
; load current entry mode status, set entry mode control bit and strobe
; clear_expr
; clear_expr
; clear_expr
_BLCD_EM_LAS:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	DPTR, #__LCD_EM_STAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #4
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; set entry mode control bit
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_COR
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_INS_WRITE
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
; Display on/off, cursor on/off and blink on/off
; clear_expr
; These apply to any resolution display
; clear_expr
; Turn on display
; clear_expr
; clear_expr
; clear_expr
_BLCD_DISPLAY_ON:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DISP_STAT
	push	DPL
	push	DPH
	mov	DPTR, #__LCD_DISP_STAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #4
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; set display bit
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_COR
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_DISP_LAS
; clear_expr
; Turn off display
; clear_expr
; clear_expr
; clear_expr
_BLCD_DISPLAY_OFF:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DISP_STAT
	push	DPL
	push	DPH
	mov	DPTR, #__LCD_DISP_STAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #4
	mov	R2, #0
	lcall	_CNOT
	push	_OPREG_0L
	push	_OPREG_0H
; clear display bit
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IAND
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_DISP_LAS
; clear_expr
; Turn on cursor
; clear_expr
; clear_expr
; clear_expr
_BLCD_CURSOR_ON:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DISP_STAT
	push	DPL
	push	DPH
	mov	DPTR, #__LCD_DISP_STAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #2
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; set cursor bit
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_COR
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_DISP_LAS
; clear_expr
; Turn off cursor
; clear_expr
; clear_expr
; clear_expr
_BLCD_CURSOR_OFF:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DISP_STAT
	push	DPL
	push	DPH
	mov	DPTR, #__LCD_DISP_STAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #2
	mov	R2, #0
	lcall	_CNOT
	push	_OPREG_0L
	push	_OPREG_0H
; clear cursor bit
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IAND
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_DISP_LAS
; clear_expr
; Turn on blink of cursor location
; clear_expr
; clear_expr
; clear_expr
_BLCD_BLINK_ON:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DISP_STAT
	push	DPL
	push	DPH
	mov	DPTR, #__LCD_DISP_STAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; set blink bit
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_COR
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_DISP_LAS
; clear_expr
; Turn off blink
; clear_expr
; clear_expr
; clear_expr
_BLCD_BLINK_OFF:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DISP_STAT
	push	DPL
	push	DPH
	mov	DPTR, #__LCD_DISP_STAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	lcall	_CNOT
	push	_OPREG_0L
	push	_OPREG_0H
; clear blink bit
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IAND
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_DISP_LAS
; clear_expr
; Now do a display status write
; clear_expr
; load current display status, set display control bit and strobe
; clear_expr
; clear_expr
; clear_expr
_BLCD_DISP_LAS:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	DPTR, #__LCD_DISP_STAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #8
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; set display control bit
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_COR
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_INS_WRITE
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
;	GO TO SPECIFIC LCD DD RAM ADDRESSES
; clear_expr
;
; clear_expr
; Used with care these apply to any resolution.
; clear_expr
;
; clear_expr
; set to 1st row addr=000H, 1st line (0,1)
; clear_expr
; clear_expr
; clear_expr
_BLCD_GOTO_LINE1:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #0
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_SET_DD_POS
; clear_expr
; set to 2nd line (0,2)
; clear_expr
; clear_expr
; clear_expr
_BLCD_GOTO_LINE2:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #64
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_SET_DD_POS
; clear_expr
; set to 2nd row addr=040H, 3rd line (0,3)
; clear_expr
; clear_expr
; clear_expr
_BLCD_GOTO_LINE3:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #20
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_SET_DD_POS
; clear_expr
; set to 4th line (0,4)
; clear_expr
; clear_expr
; clear_expr
_BLCD_GOTO_LINE4:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #84
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_SET_DD_POS
; clear_expr
; set the cursor position to (lcd_xpos,lcd_ypos)
; clear_expr
; clear_expr
; clear_expr
_BLCD_GOTO_XY:
; clear_expr
;	print "lcd_goto_xy"
; clear_expr
; clear_expr
_if36:
	mov	DPTR, #__LCD_YPOS
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #4
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else36
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #84
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
	ljmp	_end_if36
_else36:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_if37:
	mov	DPTR, #__LCD_YPOS
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #3
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else37
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #20
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
	ljmp	_end_if37
_else37:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_if38:
	mov	DPTR, #__LCD_YPOS
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #2
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else38
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #64
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
	ljmp	_end_if38
_else38:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	R0, #0
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
_end_if38:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_end_if37:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_end_if36:
; clear_expr
; clear_expr
; clear_expr
_if39:
	mov	DPTR, #__LCD_XPOS
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IGE
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__LCD_XPOS
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #20
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILE
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IAND
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else39
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	DPTR, #__LCD_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__LCD_XPOS
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IADD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ISUB
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
_else39:
; clear_expr
; clear_expr
; clear_expr
	ljmp	_BLCD_SET_DD_POS
; clear_expr
; set the DD RAM pointer to the contents of lcd_dat
; clear_expr
; clear_expr
; clear_expr
_BLCD_SET_DD_POS:
; clear_expr
; clear_expr
	mov	DPTR, #__LCD_DAT
	push	DPL
	push	DPH
	mov	DPTR, #__LCD_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #128
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; set DD RAM control bit
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_COR
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BLCD_INS_WRITE
; clear_expr
; get the DD RAM pointer to the contents in lcd_dat
; clear_expr
; clear_expr
; clear_expr
_BLCD_GET_DD_POS:
; clear_expr
; #ASM
; clear_expr


	push	IE
	clr	EX1
	CLR     P1.4	    				; set RS low for instr
	SETB    P1.5	    				; set RD/WR high for read
	MOV     P0, #0FFH				; make PO input
	lcall	_LCD_RD_STROBE
	mov	A, P0					; get data from LCD
	mov	DPTR, #__LCD_DAT
	movx	@DPTR, A				; store the data
	pop 	IE					; restore interrupts
; #ASM_END
; clear_expr
	ret
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
;	lcd_write_data	
; clear_expr
; write the data in LCD_DAT to the LCD, disable EX1 during the write
; clear_expr
; clear_expr
; clear_expr
_BLCD_WRITE_DATA:
; clear_expr
; #ASM
; clear_expr


	mov	DPTR, #__LCD_DAT			; point to data we want
	movx	A, @DPTR				; data in acc
	push	IE					; save IE
	clr 	EX1					; turn off EX1
	mov	P0, A					; move LCD_DAT to port0
; #ASM_END
; clear_expr
; clear_expr
_BLCD_DATA_WRITE:
; BASIC call here with PORT0 = data
; clear_expr
; #ASM
; clear_expr


_lcd_data_write:					; assy call here with PORT0 = data
	SETB    P1.4	    				; set RS high for data
	CLR     P1.5	    				; set RD/WR low for write
	ljmp	_LCD_STROBE
; #ASM_END
;-----------------------------------------------------------------------------
; clear_expr
;	LCD_READ_DATA
; clear_expr
; Reads data from the character generator (CG) or display data (DD) RAM.
; clear_expr
; The Address of the read must have been set by 1) a previous address set
; clear_expr
; instruction or 2) a cursor shift instruction (applies to DD RAM only).
; clear_expr
; A prior CG or DD write is not sufficient!
; clear_expr
; read data from the LCD into BASIC variable LCD_DAT
; clear_expr
; clear_expr
; clear_expr
_BLCD_READ_DATA:
; clear_expr
; #ASM
; clear_expr


	push	IE					; save IE
	clr 	EX1					; turn off EX1
	mov	P0, #0FFH				; make PO input
	SETB    P1.4	    				; set RS high for data
	SETB    P1.5	    				; set RD/WR high for read
	
	lcall	_LCD_RD_STROBE
	mov	A, P0					; get data from LCD
	mov	DPTR, #__LCD_DAT
	movx	@DPTR, A				; store the data
	pop 	IE					; restore interrupts
; #ASM_END
; clear_expr
	ret
; clear_expr
; instruction write
; clear_expr
; clear_expr
; clear_expr
_BLCD_INS_WRITE:
; call here with LCD_DAT = data
; clear_expr
; #ASM
; clear_expr


	mov	DPTR, #__LCD_DAT			; point to data we want
	movx	A, @DPTR				; data in acc
	push	IE					; save IE
	clr 	EX1					; turn off EX1
	mov	P0, A					; move LCD_DAT to port0
	CLR     P1.4	    				; set RS low for instr
	CLR     P1.5	    				; set RD/WR low for write
	ljmp	_LCD_STROBE
; #ASM_END
; clear_expr
; clear_expr
_BLCD_INS_WRNB:
; call here with LCD_DAT = data
; clear_expr
; "no busy flag version" of an 
; clear_expr
; instruction write
; clear_expr
; #ASM
; clear_expr


	mov	DPTR, #__LCD_DAT			; point to data we want
	movx	A, @DPTR				; data in acc
	push	IE					; save IE
	clr 	EX1					; turn off EX1
	mov	P0, A					; move LCD_DAT to port0
	CLR     P1.4	    				; set RS low for instr
	CLR     P1.5	    				; set RD/WR low for write
	ljmp	_LCD_STROBE_NB
; #ASM_END
; data read strobe instruction returns with data in LCD_DAT
; clear_expr
; clear_expr
; clear_expr
_BLCD_DATA_READ:
; clear_expr
; #ASM
; clear_expr


_lcd_data_read:						; assy call here
	SETB    P1.4	    				; set RS high for data
	SETB    P1.5	    				; set RD/WR high for read
; #ASM_END
; clear_expr
	ljmp	_BLCD_STROBE
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
;	LCD_STROBE
; clear_expr
; 
; clear_expr
; Strobe the data on PORT0 to the LCD interface chip.
; clear_expr
; This is the exit point for most LCD routines.
; clear_expr
; clear_expr
; clear_expr
_BLCD_STROBE:
; clear_expr
; #ASM
; clear_expr


_LCD_STROBE:
	CLR     P1.6	    				; clear enable
	SETB    P1.6	    				; strobe it
	CLR     P1.6	    				; clear enable
	SETB    P1.5	    				; set RD(H)/WR(L) high
;	LJMP	_LCD_BSY_CHK				; check busy flag
	mov	B, #40
	djnz	B, $
	pop 	IE					; restore interrupts
	ret
_LCD_STROBE_NB:						; longer 1.64 msec wait
	CLR     P1.6	    				; clear enable
	SETB    P1.6	    				; strobe it
	CLR     P1.6	    				; clear enable
	SETB    P1.5	    				; set RD(H)/WR(L) high
	; wait about 2 msec at 12 MHz
	; Use this when you can't use the busy flag (LCD init)
	mov	R0, #4
_LCD_STROBEL2:
	mov	B, #255
	DJNZ	B, $
	DJNZ	R0, _LCD_STROBEL2
	pop	IE					; restore interrupts
	ret
	
; #ASM_END
;-----------------------------------------------------------------------------
; clear_expr
;	_LCD_BSY_CHK
; clear_expr
; Note that if busy flag stays high execution will wait here forever.
; clear_expr
; This could happen if the LCD is unpowered or not connected.
; clear_expr
; #ASM
; clear_expr


_LCD_BSY_CHK:
	mov	P0, #0FFH				; make P0 input
	CLR	P1.4					; set R/S low
	SETB 	P1.5					; set RD/WR high
	SETB	P1.6					; strobe it w/ high enable
;	CLR	P2.0					; debug: watch with scope probe to time busy
	JB	P0.7, $					; wait while busy
	CLR	P1.6					; clear enable
;	SETB	P2.0					; drive pin back to normal high
	pop 	IE					; restore interrupts
	ret
; #ASM_END
;-----------------------------------------------------------------------------
; clear_expr
;	LCD_RD_STROBE
; clear_expr
; This is a strobe and delay used in reading data from the LCD
; clear_expr
; We don't pop IE here since we still have to store the read data after ret.
; clear_expr
; This differs from the write strobe routine which is complete once the strobe
; clear_expr
; cycle ends.  In a read, the strobe cycle gets the data on P0.
; clear_expr
; #ASM
; clear_expr


_LCD_RD_STROBE:
	CLR     P1.6	    				; clear enable
	SETB    P1.6	    				; strobe it
	CLR     P1.6	    				; clear enable
	; wait about 80 usec
	; this could also poll the busy flag, better for extended temp range
	mov	B,#40
	DJNZ	B,$
	ret
; #ASM_END
; clear_expr
; clear_expr
_BLCD_INC_END:
; protect against include in program body
; clear_expr
; #INCLUDE "rly_e.inc"
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
; RELAY DRIVER FOR USE WITH DPB2 REV E
; clear_expr
; it will not work with DPB2 REV D
; clear_expr
; (The rev level is on the silkscreen on your board).
; clear_expr
;
; clear_expr
; (C) Copyright 1994 Systronix, Inc All Rights Reserved
; clear_expr
;		Systronix, Inc. Salt Lake City, Utah, USA
; clear_expr
;		TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
; clear_expr
;
; clear_expr
; Owners of Systronix products are hereby entitled to use, modify, and copy
; clear_expr
; this sample program.  You may incorporate all or part of this program in 
; clear_expr
; your own commercial products provided they are not simply copies of 
; clear_expr
; Systronix products and do not compete directly with Systronix products.  
; clear_expr
; This program is provided by Systronix free of charge and may not be resold.
; clear_expr
;
; clear_expr
; This program is intended for those of you who are enjoying the benefits of
; clear_expr
; the new DPB2 REVE board from Systronix/Intellix.  This card is a very
; clear_expr
; easy to use development system for the Dallas DS5000/1/2 DS2250/1/2 and -T
; clear_expr
; suffix soft microcontrollers.  If you'd like more information, please call
; clear_expr
; or FAX us at the numbers above.
; clear_expr
;
; clear_expr
; REVISION HISTORY -----------------------------------------------------------
; clear_expr
;
; clear_expr
;	01/24/94	BAB	Start, derived from RELAY1.INC for DPB2 rev D
; clear_expr
;
; clear_expr
;
; clear_expr
; NOTES AND COMMENTS ---------------------------------------------------------
; clear_expr
;
; clear_expr
; Allegro UCN5800A
; clear_expr
;
; clear_expr
; The relay driver has 4 open collector outputs, addressed on the data bus
; clear_expr
; as P0.0-3.  Strobe the data with P1.1.
; clear_expr
; The data latch looks like a 373 family device: when the strobe is high,
; clear_expr
; data flows through transparently, and when strobe is low the data is held.
; clear_expr
;
; clear_expr
; On power up P1.1 is high, so to turn off the ports, drive P0 low and then
; clear_expr
; drive P1.1 low. The driver does have a power on clear.  We drive its OE(L) 
; clear_expr
; with a port pin P1.2 which powers up HIGH, disabling the driver until we 
; clear_expr
; deliberately enable it.
; clear_expr
;
; clear_expr
; We use relay 1 (data bit 0) to drive an inexpensive piezo buzzer, available
; clear_expr
; from Systronix to click and beep.  It clicks once per second in the 
; clear_expr
; metronome subroutine.
; clear_expr
;
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
; clear_expr
	ljmp	_BRELAY_INC_END
; clear_expr
; protect against include in program body
; UNSIGNED CHAR RELAY_STATUS ; one bit for each relay, bit=1 if ON
; clear_expr
; UNSIGNED CHAR RELAY_DAT ; relay driver bits numbered 0-3
; clear_expr
; UNSIGNED INT RELAY_NUMBER ; "user" relay number 1-4
; clear_expr
; clear_expr
; clear_expr
_BRELAY_INIT:
; clear_expr
; #ASM
; clear_expr


	setb	P1.2				; disable relay outputs
    mov     P0,#000H            ; shut off relay outputs
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
;    mov     P0,#0FFH            ; convert back to input
; #ASM_END
; clear_expr
	mov	DPTR, #__RELAY_STATUS
	push	DPL
	push	DPH
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
;
	pop	_OPREG_0H
	pop	_OPREG_0L
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BRELAY_SET_DAT:
; clear_expr
; clear_expr
_if40:
	mov	DPTR, #__RELAY_NUMBER
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else40
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__RELAY_DAT
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
	ljmp	_end_if40
_else40:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_if41:
	mov	DPTR, #__RELAY_NUMBER
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #2
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else41
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__RELAY_DAT
	push	DPL
	push	DPH
	mov	R0, #2
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
	ljmp	_end_if41
_else41:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_if42:
	mov	DPTR, #__RELAY_NUMBER
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #3
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else42
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__RELAY_DAT
	push	DPL
	push	DPH
	mov	R0, #4
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
	ljmp	_end_if42
_else42:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_if43:
	mov	DPTR, #__RELAY_NUMBER
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #4
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else43
; clear_expr
	mov	DPTR, #__RELAY_DAT
	push	DPL
	push	DPH
	mov	R0, #8
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
	ljmp	_end_if43
_else43:
; clear_expr
	mov	DPTR, #__RELAY_DAT
	push	DPL
	push	DPH
	mov	R0, #0
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
_end_if43:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_end_if42:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_end_if41:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_end_if40:
; clear_expr
; clear_expr
;	print "Turning on relay bit ", relay_dat
; clear_expr
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BRELAY_ENABLE:
; clear_expr
; #ASM
; clear_expr


	clr		P1.2	; drive low to turn on
; #ASM_END
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BRELAY_DISABLE:
; clear_expr
; #ASM
; clear_expr


	setb	P1.2	; drive high to turn off
; #ASM_END
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BRELAY_TURN_ON:
; clear_expr
; clear_expr
	lcall	_BRELAY_SET_DAT
; clear_expr
; clear_expr
	mov	DPTR, #__RELAY_STATUS
	push	DPL
	push	DPH
	mov	DPTR, #__RELAY_STATUS
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__RELAY_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_COR
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BRELAY_SET_STATUS
; clear_expr
; clear_expr
; clear_expr
_BRELAY_TURN_OFF:
; clear_expr
; clear_expr
	lcall	_BRELAY_SET_DAT
; clear_expr
; clear_expr
	mov	DPTR, #__RELAY_STATUS
	push	DPL
	push	DPH
	mov	DPTR, #__RELAY_STATUS
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__RELAY_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall	_CNOT
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IAND
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BRELAY_SET_STATUS
; clear_expr
; clear_expr
; clear_expr
_BRELAY_TOGGLE:
; clear_expr
; clear_expr
	lcall	_BRELAY_SET_DAT
; clear_expr
; clear_expr
	mov	DPTR, #__RELAY_STATUS
	push	DPL
	push	DPH
	mov	DPTR, #__RELAY_STATUS
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__RELAY_DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_CXOR
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	ljmp	_BRELAY_SET_STATUS
; clear_expr
; clear_expr
; clear_expr
_BRELAY_SET_STATUS:
; clear_expr
; #ASM
; clear_expr


    mov     DPTR,#__RELAY_STATUS    ; addr in DPTR
    movx    A,@DPTR                 ; RELAY_STATUS in Port 0
    mov     P0,A
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
;    mov     P0,#0FFH                ; convert back to input
; #ASM_END
; clear_expr
	lcall	_BRELAY_ENABLE
; clear_expr
; clear_expr
	ret
; clear_expr
; metronome each second
; clear_expr
; clear_expr
; clear_expr
_BMETRONOME_1:
; clear_expr
; #ASM
; clear_expr


    mov     DPTR,#__RELAY_STATUS    ; addr in DPTR
    movx    A,@DPTR                 ; RELAY_STATUS in Port 0
    mov     P0,A
	setb	P0.0			        ; set relay 1 to on
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
    mov     R0,#0FFH                ; one djnz = 2 cycles (~ 2 usec)
    djnz    R0,$                    ; tone duration
    clr     P0.0                    ; turn relay 1 off
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
; #ASM_END
; clear_expr
	ret
; clear_expr
; make the speaker beep
; clear_expr
; clear_expr
; clear_expr
_BBEEP_1:
; clear_expr
; #ASM
; clear_expr


    mov     DPTR,#__RELAY_STATUS    ; addr in DPTR
    movx    A,@DPTR                 ; RELAY_STATUS in Port 0
    mov     P0,A
	setb	P0.0			        ; set relay 1 to on
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
    ; set tone duration one, 1 djnz = 2 cycles (~ 2 usec)
    mov     R1,#02FH
beep_loop:
    mov     R0,#0FFH
    djnz    R0,$ 
    djnz    R1,beep_loop
    clr     P0.0                    ; turn relay 1 off
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
; #ASM_END
; clear_expr
	ret
; clear_expr
; flash backlight
; clear_expr
; clear_expr
; clear_expr
_BFLASH_2:
; clear_expr
; #ASM
; clear_expr


    mov     DPTR,#__RELAY_STATUS    ; addr in DPTR
    movx    A,@DPTR                 ; RELAY_STATUS in Port 0
    mov     P0,A
	setb	P0.1			        ; set relay 2 on
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
    mov     R0,#0FFH                ; one djnz = 2 cycles (~ 2 usec)
    djnz    R0,$                    ; tone duration
    mov     R0,#0FFH                ; one djnz = 2 cycles (~ 2 usec)
    djnz    R0,$                    ; tone duration
    clr     P0.0                    ; turn relay 2 off
    ; strobe in data, force P1.1 high, then low
    setb    P1.1
    clr     P1.1
; #ASM_END
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BRELAY_INC_END:
; protect against include in program body
; clear_expr
; #INCLUDE "adc_e.inc"
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
; ADC DRIVER INCLUDE FILE FOR USE WITH DPB2 REV E
; clear_expr
;
; clear_expr
; will not work with DPB2 REV D!
; clear_expr
;
; clear_expr
; (C) Copyright 1994 Systronix, Inc All Rights Reserved
; clear_expr
;		Systronix, Inc. Salt Lake City, Utah, USA
; clear_expr
;		TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
; clear_expr
;
; clear_expr
; Owners of Systronix products are hereby entitled to use, modify, and copy
; clear_expr
; this sample program.  You may incorporate all or part of this program in 
; clear_expr
; your own commercial products provided they are not simply copies of 
; clear_expr
; Systronix products and do not compete directly with Systronix products.  
; clear_expr
; This program is provided by Systronix free of charge and may not be resold.
; clear_expr
;
; clear_expr
; This program is intended for those of you who have the pleasure of using 
; clear_expr
; the new DPB2 REVE board from Systronix/Intellix.  This card is a very
; clear_expr
; easy to use development system for the Dallas DS5000/1/2 DS2250/1/2 and -T
; clear_expr
; suffix soft microcontrollers.  If you'd like more information, please call
; clear_expr
; or FAX us at the numbers above.
; clear_expr
;
; clear_expr
;
; clear_expr
; REVISION HISTORY -----------------------------------------------------------
; clear_expr
;
; clear_expr
;	03/02/94	BAB	Added new header, released in ZIP file
; clear_expr
;
; clear_expr
;
; clear_expr
; NOTES AND COMMENTS ---------------------------------------------------------
; clear_expr
;
; clear_expr
; TI TLC549 or 548 (we use the 549)  Same part, 549 is a little slower,
; clear_expr
; 40,000 conversions/sec max versus 45,500 for the 548.  Max I/O clock
; clear_expr
; rate on the 549 is 1.1 MHx, it is 2.048 MHz for the 548.
; clear_expr
;
; clear_expr
; ADC clock is P0.5		(was P1.2 on DPB2 REVD)
; clear_expr
; ADC Data is on P0.4	(was P1.0 on DPB2 REVD)
; clear_expr
; ADC CS is P1.0		(was P1.1 on DPB2 REVD)
; clear_expr
;
; clear_expr
; To start a conversion, drive CS (P1.0) low.  Wait at least 1.4 usec, then
; clear_expr
; Bit7 of the previous ADC conversion will appear on P1.0.  Cycle ADC clock
; clear_expr
; P0.5 and data bits 6-0 will appear on its falling edge.  Bit 7 wil reappear
; clear_expr
; if you keep clocking past bit 0. The ADC takes a new data sample starting
; clear_expr
; on the falling edge of the 4th I/O clock, and holds it on the 8th I/O clock 
; clear_expr
; falling edge.  You must take CS high after the 8th clock, or keep the I/O
; clear_expr
; clock low.  It is better to keep CS high.  If CS is low during the 
; clear_expr
; conversion cycle, any glitches on the CLK line could potentially cause
; clear_expr
; the I/O sequence to lose synchronization.  A high to low transition of
; clear_expr
; CS during the conversion will abort it and cause an ADC reset.  An aborted
; clear_expr
; conversion yields the result from the previous conversion, if you read
; clear_expr
; out the data.
; clear_expr
;
; clear_expr
; During the new conversion, drive CS (P1.0) high for at least 17 usec.  The 
; clear_expr
; ADC will convert using its internal clock.  Bring CS low again and the new
; clear_expr
; conversion D7 will appear on the data line.  
; clear_expr
; Clock the device 8 more times to complete the data transfer.  On the 8th
; clear_expr
; clock, D7 appears again - ignore it.  This also starts the next conversion
; clear_expr
; cycle.  Then bring CS high to allow the new conversion to complete.
; clear_expr
;
; clear_expr
;----------------------------------------------------------------------------
; clear_expr
; clear_expr
	ljmp	_BADC_INC_END
; clear_expr
; protect against include in program body
; UNSIGNED CHAR ADC_DAT
; clear_expr
; READ the serial ADC value into ADC_DAT
; clear_expr
; clear_expr
; clear_expr
_BADC_READ:
; clear_expr
; the assy code conversion loop
; clear_expr
; #ASM
; clear_expr


    ; init first...
	setb    P0.4                ; make sure P0.4 is input
	clr	    P0.5                ; ADC clock low
	setb    P1.0                ; CS high
	clr	A                       ; clear acc
	
    ; start access...
	clr     P1.0                ; CS low
	mov     B,#8                ; also provides 2usec delay after CS low
adc1:
	mov	    C,P0.4              ; Data bit to carry
	setb    P0.5                ; clock high
	RLC	    A                   ; rotate carry into acc
	clr     P0.5                ; clock low for next bit
	djnz    B,adc1              ; repeat
				
    ; start next hold cyle
	setb    P1.0                ; set CS high for next conversion
	mov	    DPTR,#__ADC_DAT     ; addr in DPTR
	movx    @DPTR,A             ; store acc in ADC_DAT
; #ASM_END
; new conversion takes at least 17 usec
; clear_expr
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_BADC_INC_END:
; protect against include in program body
; clear_expr
_INT_PFW:
					; all other interrupts locked out!
    IF ON_PWRFL
	lcall	_DS_USER_PWRFL		; call user BASIC routine, ret here
    ENDIF





    

_INT_PFW2:
	mov 	ACC, PCON	 	; check PFW flag PCON.5
	jb	ACC.5, _INT_PFW2 	; wait til it's clear

	pop	PSW  			; pushed at vector
	pop	ACC		
	pop	ACC			; waste calling stack

    	setb	F0			; Runtrap flags -
	mov	A, #0AAH		; These let us detect...
	mov	B, #055H		; ...a run trap at startup

	mov	DPTR, #_runtrap
	push	DPL
	push	DPH	       		; force _runtrap as ret address
	reti				; this will go to the pushed label

_SET_CBAUD_T1:
	anl	TCON, #3Fh	
    IF TARGET_8032
	anl	T2CON, #0CFh	
    ENDIF
	anl	TMOD, #2Fh	
	orl	TMOD, #20h	
	orl	PCON, #80h	
	mov	TH1, R0		
	mov	TL1, #0		
	setb	TR1		
	ret

;_%%DS5_WATCHDOG:


_DS5_WDOG_RST:
	mov	0C7H, #0AAH	; timed access keys
	mov	0C7H, #055H
	setb	IP.7		; reset watchdog
	ret
 

_DS5_WDOG_ON:
	lcall	_DS5_WDOG_RST	; clear WDOG timer to 0
	mov	0C7H, #0AAH	; timed access keys
	mov	0C7H, #055H
	orl	PCON, #004H	; enable watchdog PCON.2
	setb	_WDOG_FLAG	; set "wdog active" flag bit

				; now be sure timer0 is running
	ret


_DS5_WDOG_OFF:
	mov	0C7H, #0AAH	; timed access keys
	mov	0C7H, #055H
	anl	PCON, #0FBH	; disable watchdog PCON.2
	clr	_WDOG_FLAG	; clear "wdog active" flag bit
	ret

_CLEAR_UVAR:	; clear user variables (if any) in external data RAM
	mov	DPTR, #_udataend
	mov	R2, DPH
	mov	R0, DPL
	mov	DPTR, #_udatabeg
	sjmp	_CLEAR1

_CLEAR:
	mov	A, DPL		; add count to the starting address to get a ... 
	add	A, R0		; ... terminal address
	mov	R0, A
	mov	A, DPH
	addc	A, R2
	mov	R2, A
	sjmp	_CLEAR1

	
_CLEARIT:
	clr	A 		; this is the zero that we will write
	movx	@DPTR, A	; write the byte
	inc	DPTR		; point to next byte but don't clear it yet

_CLEAR1:
	mov	A, R0		; compare current count with terminal count
	xrl	A, DPL		; low bytes first
	jnz	_CLEARIT	;
	
	mov	A, R2		; compare the high bytes if the low bytes are the same
	xrl	A, DPH
	jnz	_CLEARIT
	ret    			; reached the terminus so we're done

_TIME_SET:
	mov	_RTC_SEC_LO, R0		; load the low byte of data from OPREG0
	mov	_RTC_SEC_HI, R2		; load the high byte of data from OPREG0
	ret	   			; done
		
;_%%INT_0B_13:			

  IF ONEX1
_INT13_DISPATCH:			; the ONEX1 handler entry point
	jnb	_ON_EX1, _INT13_DISX	; exit if onex1 instruction not active

  ;********************************
    IF SPRINT				; print#
      	jnb	_SPRT_FLAG, _INT13_SX	; continue if print# not in progress
    	setb	_ON_EX1_PND		; set pend flag for print# use
    	pop	psw			; ret (not reti) to print# in progress
    	ret				; this disables further onex1 interrupts and leaves
					; TCON.3 cleared by call to vector 13H
_INT13_SX:
    ENDIF
  ;********************************


  ;********************************
    IF (CPRINT * PRINT_COMPLETE)	; 6/30/92 to enable ONEX1 while serial I/O
	jnb	_CPRT_INP, _INT13_CX
    	setb	_ON_EX1_PND		; set pend flag for print use
    	pop	psw			; ret (not reti) to print in progress
    	ret				; this disables further onex1 interrupts and leaves
_INT13_CX:
    ENDIF
  ;********************************

    IF (CPRINT * PRINT_COMPLETE)	; ...still need this w/cprt_inp.
	jb	_CPRT_FLAG, $		; print in progress, finish it
    ENDIF				; cprt_inp can be clear but buff still
    					; outputting characters.  We shouldn't
					; care - we can add to those in the
					; buffer if we print in onex1???

	push	DPL			; onex1 instr active so proceed
	push	DPH
	mov	DPTR, #_INT_13_LOC	; get current handler addr
	clr	F0		; means this was NOT the ontime handler, is onex1 instead
	setb	_ON_EX1_INP		; set in progress flag
	clr	_ON_EX1_PND		; clear pend flag
	push	PSW			; to save the F0 flag

	sjmp	_INT_DISPATCH

_INT13_DISX:				; exit with no handler actions
	pop		PSW		; onex1 not active so return 
	reti				

  ENDIF					; endif onex1



  IF RTC

_INT0B_PND_DISP:			; pending ontime entry point
	push	DPL			; save dptr and...
	push	DPH			; ...fall through to rest of int0b

_INT_0B_DISPATCH:			; the RTC handler entry point
	mov	DPTR, #_INT_0B_LOC	; get current handler addr
	setb	F0			; means this was ontime handler
	push	PSW			; to save the F0 flag 

  ENDIF

_INT_DISPATCH:
	push	ACC
	push	B
	push	_R0
	push	_R1
	push	_R2
	push	_R3
	push	_R4
	push	_R5
	push	_R6
	push	_R7	  

	setb	_IDLE_END		; set the flag to terminate IDLE mode

	movx	A, @DPTR		; low byte
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR		; high byte
	mov	DPH, A	   		; load the DPTR with the address of the handler
	mov	DPL, _R0
	clr	A
	jmp	@A+DPTR			; go do the routine

_INT_RTC:

 	jnb	_CLOCK_BIT, _INT_RTC_XX		; real time clock not enabled so quit

	push	ACC				; save accumulator

	mov	TH0, _RTC_RELOAD		; reLOAD THE TIMER
	mov	A, _RTC_MILLI			; GET MILLISECOND COUNTER
	inc	A				; BUMP COUNTER
	cjne	A, #200, _INT_RTC_1		; jump if no need to inc seconds counters
	clr	A				; otherwise FORCE ACC TO BE ZERO
	inc	_RTC_SEC_LO			; INCREMENT LOW TIMER
	cjne	A, _RTC_SEC_LO, _INT_RTC_1	; CHECK LOW VALUE, if 0 it rolled over
	inc	_RTC_SEC_HI			; ...so incr TIMER HIGH byte

_INT_RTC_1:
	mov	_RTC_MILLI, A			; save new millisec value

 
	jnb	_ON_TIME, _INT_RTC_X		; ONTIME not executed so leave

	jb 	_ON_TIME_INP, _INT_RTC_X	; another ONTIME in progress?
						; ...if so, try again later

	jb 	_ON_TIME_PND, _INT_RTC_YES	; ONTIME previously compared?

						; see if time >= ontime value
	mov	A, _ONTIME_H	  	     	; check high byte
	cjne	A, _RTC_SEC_HI, _INT_RTC_NE  	; C set if rtc_h > ontime_h
						; if here, H were ==
	mov	A, _ONTIME_L 	   	     	; get low byte
	cjne	A, _RTC_SEC_LO, _INT_RTC_NE  	; C set if rtc_l > ontime_l
						; if here, both were ==
	sjmp	_INT_RTC_YES   			; ...so go do the ontime

_INT_RTC_NE:					; not ==, could be >
	jnc	_INT_RTC_X			; rtc not >= ontime so leave

_INT_RTC_YES:					; rtc >= ontime

 ;********************************
    IF SPRINT
	jb	_SPRT_FLAG, _INT_RTC_PX		; sprt in progress, try later
    ENDIF
  ;********************************

  ;********************************
    IF CPRINT
	jb	_CPRT_INP, _INT_RTC_PX		; cprt in progress, try later
    	IF PRINT_COMPLETE
	    jb	_CPRT_FLAG, _INT_RTC_PX		; complete the print first
	ENDIF
    ENDIF
  ;********************************

  ;********************************
    IF DS5000 
    	mov	A, MCON
	jb	ACC.2, _INT_RTC_PX		; if ECE2/PES set, leave
    ENDIF					; ...do ontime later

    IF (DS5000 EQ 2)
	jb	RPCTL.5, _INT_RTC_PX		; if EXBS set, leave
    ENDIF					; ...do ontime later
  ;********************************

	pop	ACC				; restore acc before dptr push
	setb	_ON_TIME_INP			; ontime now in progress 
	clr	_ON_TIME_PND			; ontime no longer waiting
	clr	_ON_TIME			; ontime no longer current
	push	DPL				; save current DPTR
	push	DPH
	mov	DPTR, #_INT_RTC_J
	push	DPL			 	; push label we want to go to
	push	DPH
	reti					; pop label->PC and enable RTC interrupts

_INT_RTC_J:					; jump and never return...
	ljmp	_INT_0B_DISPATCH		; ...jump to ontime dispatcher

_INT_RTC_PX:					; if here, exit w/ pnd flag
	setb	_ON_TIME_PND			; ontime waiting to be handled

_INT_RTC_X:					; if here, exit w/o pnd flag
	pop	ACC		       		; restore accumulator

_INT_RTC_XX:
 	pop	PSW		       		; restore PSW from vector push
	reti

_CLR_RTC:
	clr 	A
	mov 	_RTC_SEC_LO, A		; clear RTC time values
	mov 	_RTC_SEC_HI, A
	mov 	_RTC_MILLI, A
	mov 	_ONTIME_L, A		; clear ONTIME {time comparison value}
	mov 	_ONTIME_H, A
_CLR_RTC_FLAGS:
	clr 	_ON_TIME	      	; clear "ONTIME active" flag bit
	clr 	_ON_TIME_PND 		; clear "ONTIME pending" flag bit
	clr 	_ON_TIME_INP 		; clear "ONTIME in process" flag bit
 	ret

;_%%MSEC:

_MSEC_GET:

	mov 	ACC, _RTC_MILLI		; get number of 5 msec ticks
	mov 	B, #5			; 5 msec per tick
	mul	AB
	mov	_R0, ACC		; result LSB
	mov	_R2, B			; result MSB
	ret


_MSEC_SET:
	mov	_R1, #5
	mov	_R3, #0
	lcall	_UIDIV			; get ticks in opreg0
	mov	_RTC_MILLI, _R0		; save ticks 
	ret
_UIDIV:
	clr		C
	mov		A, R1			; test for zero divisor
	orl		A, R3
	jnz		_UIDIV6
	setb	C				; divisor is zero; set carry
	ljmp	_MATH_DIV0		; jump if div by zero
	ret

_UIDIV6:
	mov		R7, #0			; zero the partial remainder
	mov		R6, #0
	mov		R4, #0			; zero quotient registers
	mov		R5, #0
	mov		B, #16			; load loop count
	
_UIDIV1:
	lcall	_UIDIV4			; shift the dividend and return MSB in C
	mov		A, R6			; shift carry into LSB of partial remainder
	rlc		A
	mov		R6, A
	mov		A, R7
	rlc		A
	mov		R7, A
							; now test to see if R7:R6 >= R3:R1
	clr		C
	mov		A, R7			; subtract R3 from R7 to see if R3 < R7
	subb	A, R3			; A = R7 - R3, carry set if R7 < R3
	jc		_UIDIV3	
							; at this point R7 > R3 or R7 = R3
	jnz		_UIDIV2			; jump if R7 > R3
							; if R7 = R3, test for R6 >= R1
	clr		C
	mov		A, R6
	subb	A, R1			; A = R6 - R1, carry set if R6 < R1
	jc		_UIDIV3
	
_UIDIV2:					; subtract the divisor from the partial remainder
	clr		C
	mov		A, R6
	subb	A, R1			; A = R6 - R1
	mov		R6, A
	mov		A, R7
	subb	A, R3			; A = R7 - R3 - borrow
	mov		R7, A
	setb	C				; shift 1 into the quotient
	sjmp	$+3
	
_UIDIV3:					; can't subtract so shift a zero into the quotient
	clr		C
	lcall	_UIDIV5			; shift the carry bit into the quotient
	djnz	B, _UIDIV1		; test for completion

	mov		_OPREG_0L, R4	; Now we are really done, move the quotient ...
	mov		_OPREG_0H, R5	; ... to OPREG0.

	mov		_OPREG_1H, R7	; ... and the remainder to OPREG1
	mov		_OPREG_1L, R6
	clr		C				; clear the carry flag
	ret						; done
	
_UIDIV4:
	; shift the dividend one bit to the left and return the MSB in C
	clr		C
	mov		A, R0
	rlc		A
	mov		R0, A
	mov		A, R2
	rlc		A
	mov		R2, A
	ret

_UIDIV5:
	mov		A, R4		; shift quotient one bit left and C into MSB
	rlc		A
	mov		R4, A
	mov		A, R5
	rlc		A
	mov		R5, A
	ret
	
;_%%MATH_ERRS:

_MATH_OVER:			; overflow
	IF  ERR_MSG 
		mov		DPTR, #_mathover_msg
	ENDIF
		mov A, #OVERFLOW
		ljmp _ERR_HAND

_MATH_DIV0:			; div by zero
	IF  ERR_MSG 
		mov		DPTR, #_mathdiv0_msg
	ENDIF
		mov A, #ZERO_DIVIDE
		ljmp _ERR_HAND


_MATH_BAD:			; bad argument
	IF  ERR_MSG 
		mov		DPTR, #_mathbad_msg
	ENDIF
		mov A, #BAD_ARGUMENT
		ljmp _ERR_HAND


_CLOCK_START:
	anl	TMOD,#0F0H		;set up the mode
	setb	_CLOCK_BIT		;set clock active flag
	orl	IE, #82H		;enable et0 and ea
	setb	TR0			;turn on the timer
	ret

_ONTIME:

	mov	DPTR, #_INT_0B_LOC	; get the address of _INT_0B_LOC
	mov	A, R0  			; save low byte of handler address
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2	  		; save high byte of handler address
	movx	@DPTR, A
	orl	IE, #82H  		; enable timer 0 overflow interupt
	ret		   		; done

_INIT_PRINT:

	MOV	DPTR, #_OUTOTP		; TAIL OR OUTPUT POINTER
	MOV	A, #HIGH _OUTBUF	; GET MSB
	MOVX	@DPTR, A		; SAVE MSB
	INC	DPTR
	MOV	A, #LOW _OUTBUF
	MOVX	@DPTR, A		; SAVE LSB

	MOV	DPTR, #_OUTINP		; HEAD OR INPUT POINTER
	MOV	A, #HIGH _OUTBUF	; GET MSB
	MOVX	@DPTR, A		; SAVE MSB
	INC	DPTR
	MOV	A, #LOW _OUTBUF
	MOVX	@DPTR, A		; SAVE LSB

	MOV	_NULLCNT, #0		; SET NULL COUNTER to ZERO
	mov	_PHEAD, #1		; set print head to column 1
	clr	_CPRT_FLAG		; clear print in progress flag
	clr	_CPRT_INP		; print active flag
	RET


_PRTCOM:
	CLR	ES			; CLEAR ENABLE FOR SERIAL INTERRUPTS

	PUSH	DPL
	PUSH	DPH
		 
	MOV    	R0,A			; save the data byte
	MOV    	DPTR,#_OUTINP		; GET head POINTER address
	MOVX	A,@DPTR			; GET head ptr MSB
	MOV	R1,A			; save it 
	INC	DPTR			; bump the address
	MOVX	A,@DPTR			; GET head ptr LSB 

	MOV	DPL,A			; put head ptr in DPTR
	MOV	DPH,R1			;
	MOV	A,R0			; GET the DATA byte
	MOVX	@DPTR,A			; save it in the buffer at head ptr
	INC	DPTR			; incr head ptr to next location
	MOV	A,DPL			; SEE IF we're AT END OF BUFFER
	CJNE	A, # LOW _OUTBFE, _PRTCM1	; if not at end, jump

    IF _ALIGN EQ 0
	MOV	A,DPH 			; test the high byte
	CJNE	A, # HIGH _OUTBFE, _PRTCM1   	; if not at end, jump
    ENDIF
					; we are at end of buffer...
	MOV	DPTR,#_OUTBUF		; ...so make head = _OUTBUF [0]

_PRTCM1:
    IF _ALIGN EQ 0
	MOV	R0,DPL			; SAVE new head POINTER
	MOV	R1,DPH			; in R1:R0
	MOV	A,DPH
	MOV	DPTR,#_OUTINP		; get head ptr storage addr
	MOVX	@DPTR,A			; SAVE MSB of new head ptr 
	INC	DPTR			; bump the address
	MOV	A,R0			; 
	MOVX	@DPTR,A			; SAVE LSB of new head ptr
    
    ELSE
	MOV	R0,DPL			; SAVE new head POINTER bab 2/25/91
					; for prtcm2 compare
	MOV	A,DPL			; SAVE new head POINTER
	MOV	DPTR,#_OUTINP+1		; get head ptr storage addr
	MOVX	@DPTR,A			; SAVE LSB of new head ptr
    ENDIF


	mov	DPL, R0			; this mess added back in from
	mov	DPH, R1			; 2/10 version
    	inc	DPTR			; bab 2/25/91
	MOV	A,DPL			; SEE IF we're AT END OF BUFFER
	CJNE	A, # LOW _OUTBFE, _PRTCMF	; if not at end, jump

    IF _ALIGN EQ 0
	MOV	A,DPH 			; test the high byte
	CJNE	A, # HIGH _OUTBFE, _PRTCMF   	; if not at end, jump
    ENDIF
					; we are at end of buffer...
	MOV	DPTR,#_OUTBUF		; ...so make head = _OUTBUF [0]

_PRTCMF:
  
	mov	R0, DPL			; low byte of (inp ptr +1) in R0


	MOV	DPTR,#_OUTOTP		; GET OUTPUT POINTER
	INC	DPTR			; point to low byte

					; only test low byte of address since
					; a change must happen there as long
_PRTCM2:				; as buffer length is less than 256.
	MOVX	A,@DPTR			; get low byte of output ptr
	CJNE	A,_R0,_PRTCM3		; if inp ptr = out ptr, wait here
	SETB	ES			; INTERRUPT WINDOW
	NOP				
	NOP
	CLR	ES
	SJMP	_PRTCM2			; CONTINUE WAITING	 

_PRTCM3:
	jb	_CPRT_FLAG, _PRTCM4	; buffer to sbuf xfers already started
					; This is only place we set cprt_flag.
	setb	_CPRT_FLAG		; set the print in progress flag
	SETB	TI			; SET TRANS INT to start 1st xfer...
					; ...from buffer to serial port
					; cprt_flag is cleared in int23
					; if inp=out of outbuf pointers

_PRTCM4:
	POP	DPH
	POP	DPL
		
	SETB	ES			; ENABLE SERIAL INTERRUPTS

	RET
_INT23:
	jb	RI, _READ_INT		; jump if a receive interrupt

    IF UIO
	jnb	_UIO_OUT_FLAG, _INT23_UX	; leave if not user output
	lcall	_UIO_TI				; call user TI routine
	ljmp	_IN23ET0			; leave the int23 handler
_INT23_UX:
    ENDIF

    IF UPRINT
	jnb	_UPRT_FLAG, _INT23_UPX		; leave if not user output
	lcall	_PAT_TI				; call user print@ TI routine
	ljmp	_IN23ET0			; leave the int23 handler
_INT23_UPX:
    ENDIF



_PRINT_INT:
	clr	TI			; clear transmit INTERRUPT
	jnb	_CNTRLS_FLAG, _PRINT_I0	; INHIBIT OUTPUT IF SET
	ljmp	_IN23ET0

_PRINT_I0:
	push	ACC			; SAVE ACC
	push	DPL			; PUSH ALL USED REG'S PSW PUSHED BEFORE 
	push	DPH

	push	_R0
	push	_R1
	push	_R2
	push	_R3

    IF _ALIGN EQ 0
	mov     DPTR, #_OUTINP		; get the head pointer address
	movx	A, @DPTR		; get the head pointer MSB
	mov	R0, A		  	; and save it
    	inc	DPTR			; bump the address
	movx	A, @DPTR		; get the head pointer LSB

    ELSE

	mov     DPTR, #_OUTINP+1	; get the head pointer address
	movx	A, @DPTR		; get the head pointer LSB

    ENDIF
    
	mov	R2, A			; and save it

	mov     DPTR, #_OUTOTP		; get the tail pointer address
	movx	A, @DPTR		; get the tail pointer MSBB
	mov	R1, A			; and save it
	inc	DPTR			; bump the address
	movx	A, @DPTR	     	; get the tail pointer LSB
	mov	R3, A			; and save it

	cjne	A, _R2, _PRINT_I1    	; if low bytes not the same, jump
	
    IF _ALIGN EQ 0
	mov	A, R1			; get the tail's high byte
	cjne	A, _R0, _PRINT_I1	; if high bytes not the same, jump
    ENDIF

	clr	_CPRT_FLAG		; head == tail clr print in progress

	ljmp	_OVREXT			; and exit


_PRINT_I1:
	mov	DPL, _R3	   	; head != tail
	mov	DPH, _R1	 	; get the tail pointer into DPTR
	movx	A, @DPTR	     	; get the data from the tail
	mov	SBUF, A			; SBUF it

	inc	DPTR			; advance the tail pointer
	mov	A, DPL			; tail pointer == address of _OUTBFE?
	cjne	A, #LOW _OUTBFE, _PRINT_I2	; if not equal continue

    IF _ALIGN EQ 0
	mov	A, DPH             	; get the high byte
	cjne	A, #HIGH _OUTBFE, _PRINT_I2	; if not equal continue
    ENDIF

	mov	DPTR, #_OUTBUF		; make tail point to _OUTBUF[0]

_PRINT_I2:
    IF _ALIGN EQ 0
	mov	R0, DPL			; Save the tail pointer
	mov	A, DPH			; first the high byte
	mov	DPTR, #_OUTOTP		; get the tails location
	movx	@DPTR, A		; save the MSB
	inc	DPTR			; bump the address
	mov	A, R0			; get the low byte
	movx	@DPTR, A		; save it

    ELSE
	mov	A, DPL			; only save the low byte
	mov	DPTR, #_OUTOTP+1	; get the tail's location
	movx	@DPTR, A		; save the MSB
    ENDIF

	ljmp	_OVREXT			; and exit


_READ_INT:

    ;-------------------------------------------------------------------------
    ; If user input we better call the user handler, since we can't have
    ; both a user and console input routine at the same time.
    ;
	
    IF UIO
	jnb	_UIO_INP_FLAG, _READ_INT_UX	; leave if not user input
	lcall	_UIO_RI				; call user RI routine
	ljmp	_IN23ET0			; leave the int23 handler
_READ_INT_UX:
    ENDIF

	PUSH	ACC
	MOV	A, SBUF			; receive data to acc
        CLR	RI

	jb	_IDLE_END, _INCK00	; not idle so proceed 
	ljmp	_IN23ET			; leave if idle (note we cleared RI)

_INCK00:
	CJNE	A,#_CNTRLC,_INCK01	; SEE IF CONTROL C 
	JB	_CNTRLC_FLAG,_INCK01	; CONTROL C DISABLED
	LJMP   _CNTLC			; leave and don't come back

_INCK01:
	CJNE	A, #_CNTRLS,_INCK02	; SEE IF CONTROL S
	SETB	_CNTRLS_FLAG		; SET BIT FOR OTHERS
	SJMP	_IN23ET			; EXIT

_INCK02:
	CJNE	A,#_CNTRLQ, _INCK03	; IS IT A CONTROL Q
	JNB	_CNTRLS_FLAG, _IN23ET	; BIT ALREADY CLEAR CONT
	SETB	TI			; START INTERRUPT
	CLR	_CNTRLS_FLAG		; CLEAR BIT FOR OTHERS
	SJMP	_IN23ET			; EXIT

_INCK03:
	PUSH	DPL			; PUSH USED REG'S - PSW PUSHED already
	PUSH	DPH
	PUSH	_R0
	PUSH	_R1
	PUSH	_R2
	PUSH	_R3

	MOV	R2, A			; SAVE DATA
         
	;SEE IF BUFFER IS FULL

	MOV	DPTR, #_TALPTR+1     ; GET TAIL OR OUTPUT POINTER
	MOVX	A, @DPTR             ; AND SAVE
	MOV	R0, A                ; LSB of tail pointer in R0

	MOV	DPTR, #_FIFOBE       ; GET END OF BUFFER
	MOV	R3, DPL              ; AND SAVE LSB of FIFOBE address in R3

	MOV	DPTR, #_HEDPTR       ; GET HEAD OR INPUT POINTER
	MOVX	A, @DPTR 
	MOV	R1, A                ; AND SAVE MSB of head in R1
	INC	DPTR 
	MOVX	A, @DPTR             ; GET LSB of head in A

	MOV	DPL, A               ; RESTORE LSB of head pointer
	MOV	DPH, R1              ; RESTORE MSB of head
	INC	DPTR			; incr head pointer
	MOV	A, DPL               ; SEE IF AT END OF BUFFER
	CJNE	A, _R3,_INCK04       ; NOT AT END CONTINUE
	MOV	DPTR, #_FIFOBF       ; GET START OF BUFFER as new head ptr

_INCK04:


         
	MOV     A,R2                ; GET DATA from R2
	MOVX    @DPTR,A             ; AND STORE at new head pointer
        
	MOV     A,DPH               ; SAVE new head POINTER
	MOV     R1,DPL
	MOV     DPTR,#_HEDPTR       ; AT LOCATION
	MOVX    @DPTR,A             ; SAVE MSB
	MOV     A,R1
	INC     DPTR
	MOVX    @DPTR,A		; SAVE LSB of new head ptr


	CJNE	A,_R0,_OVREXT   ; if not same, proceed
				; if here old tail == new head
	mov	DPTR, #_TALPTR	; get tail ptr addr
	movx	A, @DPTR	; get old tail MSB
	mov	DPH, A		; 
	mov	DPL, R0		; old tail now in DPTR
	inc	DPTR		; new tail, may be at buffer end?
	mov	A, DPL		; lsb of new tail to ACC
	CJNE	A, _R3, _TAILSAVE	; tail <> end so save it
	MOV	DPTR, #_FIFOBF		; GET START OF BUFFER as new tail ptr

_TAILSAVE:
	MOV     A,DPH               ; MSB of new tail
	MOV     R1,DPL
	MOV     DPTR,#_TALPTR       ; tail pointer storage location
	MOVX    @DPTR,A             ; SAVE MSB
	MOV     A,R1
	INC     DPTR
	MOVX    @DPTR,A		; SAVE LSB of new tail ptr

_OVREXT:
	POP    _R3			; RESTORE ALL USED REG"S
	POP    _R2  
	POP	_R1
	POP	_R0
	POP	DPH
	POP	DPL

_IN23ET:
	POP	ACC		        

_IN23ET0:
	POP	PSW			;PUSHED at vector 
	RETI				;EXIT INTERRUPT HANDLER

_PRINT_ROM:


_PRR_1:
	clr	A
	movc	A, @A+DPTR		; get the byte to be printed (1)
	jz	_PRINT_ROM2	   	; if null terminator is present we're done (2)
	lcall	_PUTC			; put the character	(3)
	inc	DPTR			; point to the next character (1)
	sjmp	_PRR_1			; do another (2)


_PRINT_ROM2:
    IF (CPRINT * PRINT_COMPLETE)
	jb _CPRT_FLAG, $		; wait til buffer empty
    ENDIF
	ret	     			; done

_PRINT_DONE:
    IF (CPRINT * PRINT_COMPLETE)
    	jb _CPRT_FLAG, $		; wait til buffer empty
    ENDIF
	RET

_PUTC:
	lcall	_PRINT_HEAD		; position the print head counter

    IF SPRINT
	jnb _SPRT_FLAG, _PUTC_SX	; go elsewhere if not serial print
    	lcall   _PRTLB_COM      	; output the character to the serial printer
	ret		       		; exit
_PUTC_SX:
    ENDIF

    IF UIO
	jnb _UIO_OUT_FLAG, _PUTC_UX 	; go elsewhere if not user output
    	lcall   _UIO_OUT	      	; else call the user output driver
	ret		       		; exit
_PUTC_UX:
    ENDIF

    IF UPRINT
	jnb _UPRT_FLAG, _PUTC_UPX 	; go elsewhere if not user output
    	lcall   _PRINT_AT	      	; else call the print@ output driver
	ret		       		; exit
_PUTC_UPX:
    ENDIF



_CPUTC:					; console print
  IF CPRINT
    lcall   _PRTCOM         		; output to the output buffer
  ENDIF
	ret				; done

_PRINT_HEAD:
	mov	R1, #_PHEAD

    IF SPRINT
	jnb 	_SPRT_FLAG, _PHD_SX
	mov	R1, #_SPHEAD
_PHD_SX:
    ENDIF

    IF UIO
	jnb _UIO_OUT_FLAG, _PHD_UX 	; go elsewhere if not user output
	mov	R1, #_UPHEAD
_PHD_UX:
    ENDIF

    IF UPRINT
	jnb _UPRT_FLAG, _PHD_UPX 	; go elsewhere if not user output
	mov	R1, #_UPHEAD
	ret		       		; exit
_PHD_UPX:
    ENDIF


	cjne	A, #20H, _PHD2		; is it a printable character?

_PHD2:
	jc	_PHD3	  	    	; continue test if not printable
	inc	@R1		    	; printable so bump print head counter
	ret
	
_PHD3:
	cjne	A, #CR, _PHD4		; jump if not CR
	mov	@R1, #1			; is CR, so reset print head counter
	ret

_PHD4:
	cjne	A, #BS, _PHD5		; dec print head counter if a backspace
	dec	@R1			; is BS, so decrement the print head counter
	ret
	
_PHD5:
	cjne	A, #LF, _PHD6		; if not a LF return
	pop	ACC			; else is LF so waste the calling stack
	pop	ACC
	ljmp	_PUT_NEW_LINE_2		; then output newline and take care of NULLs

_PHD6:
	ret				; not printable not CR, BS, LF so return

_REP_CHAR:

  IF SPRINT
	jnb	 _SPRT_FLAG, _RC_SX	; leave if not printer output
_RC_S1:
	lcall	_PRTLB_COM		; call printer out routine
	djnz	R0, _RC_S1		; decrement count and loop 'til done
	ret
_RC_SX:
  ENDIF

    IF UIO
	jnb	_UIO_OUT_FLAG, _RC_UX	; leave if not user output
_RC_U1:
	lcall	_UIO_OUT		; call user out routine
	djnz	R0, _RC_U1		; decrement count and loop 'til done
	ret
_RC_UX:
    ENDIF

    IF UPRINT
	jnb	_UPRT_FLAG, _RC_UPX	; leave if not user output
_RC_UP1:
	lcall	_PRINT_AT		; call user print@ out routine
	djnz	R0, _RC_UP1		; decrement count and loop 'til done
	ret
_RC_UPX:
    ENDIF


_RC_2:
  IF CPRINT
  	push	_R0
	push	ACC
	lcall	_PRTCOM			; output the character to the console
	pop	ACC
	pop	_R0
	djnz	R0, _RC_2		; decrement count and loop 'til done
  ENDIF
	ret

_PUT_NEW_LINE:
	mov	A, #CR			; carriage return
	lcall	_PUTC			; output it

_PUT_NEW_LINE_2:
	mov	A, #LF			; line feed

  IF SPRINT
	jnb	_SPRT_FLAG, _PNL_SX	; serial printer option if flag set
	lcall	_PRTLB_COM		; output it to the serial port
	sjmp	_PNL_4
_PNL_SX:
  ENDIF


    IF UIO
	jnb	_UIO_OUT_FLAG, _PNL_UX	; leave if not user output
	lcall	_UIO_OUT		; call user out routine
	sjmp	_PNL_4
_PNL_UX:
    ENDIF

    IF UPRINT
	jnb	_UPRT_FLAG, _PNL_UPX	; leave if not user output
	lcall	_PRINT_AT		; call print@ out routine
	sjmp	_PNL_4
_PNL_UPX:
    ENDIF


  IF CPRINT
	lcall	_PRTCOM			; output it to the console
  ENDIF

_PNL_4:
	mov	A, _NULLCNT		; get the NULL count
	jz	$+7		    	; no NULLs if zero so exit
	mov	R0, A			; save the count
	clr	A		    	; this is the NULL
	lcall	_REP_CHAR		; output NULLs
	ret			    	; done
	
_CNTLC_WOB:
	CLR	EA			; Disable all interrupts incl ES & RTC

_CNTLC:

_CNTLC1:
	MOV	DPTR,#_CNTLC2
	PUSH	DPL
	PUSH	DPH
	RETI				; close serial interrupt, pop PC to the DPTR value  

_CNTLC2:
	clr	C
	orl	C, _ON_EX1_INP
	orl	C, _ON_EX1_PND
	jnc	_CNTLC3			; was onex1 pend or in progress?
	mov	DPTR, #_CNTLC3		; if here, onex1 was in progress
	push	DPL
	push	DPH
	reti				; close onex1 interrupt, pop PC to the DPTR value  

_CNTLC3:
    IF CPRINT				; only check if console print is present
    	jnb	_CPRT_FLAG, _NOCHAR  	;jump if print not in progress
    	jnb	TI, $			; else wait 'til TI asserts from last char
    ENDIF

_NOCHAR:

	mov	SP, _SPCLEAR		; restore stack pointer 
    IF RUN_TRAP_LOC			; run trap in BCI51 code

      IF (DS5000 + TARGET_8XC51F)
    	setb	F0			;
	mov	A, #0AAH		;
	mov	B, #055H		; To detect a run trap at startup
      ENDIF
	ljmp 	_runtrap

    ENDIF

 ;********************************
    IF DS5000
    	jnb	_WDOG_FLAG, _CNTLC_DSX	; if wdog not active jump
	clr	EA   	  		; disable all interrupts
	sjmp	$			; wait for watchdog to expire
_CNTLC_DSX:
    ENDIF
 ;********************************
   
					; no runtrap or wdog active so...
	ret				; RETurn to whatever CALLed this program
					; otherwise crash ungracefully if nothing called it

_PRINT_REST:	

    IF (CPRINT * PRINT_COMPLETE)
    	jb _CPRT_FLAG, $			; wait til buffer empty
    ENDIF
	clr	_CPRT_INP			; clear cprt in progress flag

	lcall	_INT_PEND			; check for pending interrupts

	ret

_INT_PEND:

    IF ONEX1
	jnb	_ON_EX1_PND, _ONEX1_PND_X	; no onex1 pend so jump past
	mov	DPTR, #_ONEX1_PND_X 	
	PUSH	DPL				; push reti return addr... 
	PUSH	DPH				; ...for reti from onex1
	push	PSW				; int13 expects a pushed psw
	ljmp	_INT13_DISPATCH			; handle pending onex1
_ONEX1_PND_X:					; will return here if handled
    ENDIF

    IF ONTIME
	jnb	_ON_TIME_PND, _ONTIME_PND_X	; no ontime pend so jump past
	setb	_ON_TIME_INP			; ontime now in progress 
	clr	_ON_TIME_PND			; ontime no longer pending
	clr	_ON_TIME			; ontime no longer active
	mov	DPTR, #_ONTIME_PND_X 	
	PUSH	DPL				; push return addr... 
	PUSH	DPH				; ...for ret from ontime
	push	PSW				; int0B expects a pushed psw
	ljmp	_INT0B_PND_DISP			; handle pending ontime
_ONTIME_PND_X:					; will return here if handled
    ENDIF

	ret

_CAND:
	mov		A, R0	; low byte of OPREG0
	anl		A, R1	; OPREG0L .AND. OPREG1L
	mov		R0, A	; save the result
	ret

_COR:
	mov		A, R0	; low byte of OPREG0
	orl		A, R1	; OPREG0L .OR. OPREG1L
	mov		R0, A	; save the result
	ret

_ONEX1:
	mov	DPTR, #_INT_13_LOC	; get the address of _INT_13_LOC
	mov	A, R0	    		; save low byte of handler address
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2	    		; save high byte of handler address
	movx	@DPTR, A
	setb	_ON_EX1	    		; flag that onex1 is active


  IF CPRINT
   	setb	IP.4			; set serial port int to high priority

	clr 	PX1			; set ex1 int to low priority


  ENDIF

  IF RTC
 	setb	PT0			; set RTC interrupt to high priority
  ENDIF

	orl 	IE, #84H 		; enable all interrupts and EX1 bit
	ret

_CLOCK_STOP:
	CLR		_CLOCK_BIT		; clr clock active flag

 ;********************************
 ;********************************
	
 	CLR		ET0			; stop timer 0
_CLOCK_STOPX:
	ret

_PRTLB_COM:

	mov	B, #SERIAL_MODE
	mov	R5, #8			; default data bits
	jnb	B.3, _DATA8		; jump if B.3=0, 8 data bits
	dec	R5				; B.3=1, we have 7 data bits
	clr	ACC.7			; clear 8th data bit for parity calc

_DATA8:
	mov	R4, A			; save data char 

	clr	ACC.0			; clear start bit
	clr	TR1			; stop timer if running
	mov	TL1, #0			; clear the timer to start from...
	mov	TH1, #0			; ...a known count of 0
					; after this, we'll add timer1 rollover count
					; to the reload value.
	LCALL	_PRTLB_T1LD		; LOAD AND START TIMER This is start bit

	mov	A, R4			; data char back in acc
					; start bit is now in progress

_PRTLB_COM_1:

	JNB    	TF1, $			; wait for start bit to finish
	RL	A	    		; compensate for upcoming RR which puts 1st
			    		; data bit back in place

_PLBCM0:				; 
	RR	A			; GET NEXT BIT (1 cycle) 
	LCALL	_PRTLB_T1LD		; LOAD UP COUNT AGAIN (16 cycles)
					; after counter start 
	JNB	TF1, $			; WAIT TIL TIMER READY (0-2 cycles)
	DJNZ	R5, _PLBCM0		; LOOP UNTIL DONE (2 cycles)
					; data bits now done
	clr 	C			; cycles=3
	orl	C, B.2			; cycles=5
	orl	C, B.1			; C set if any parity needed cycles=7
	jnc 	_NOPAR			; any parity?cycles=9

	mov	C, P			; get raw parity bit
	jb	B.2, _EVEN		; jump over cpl if even parity
	cpl	C			; cpl for odd parity
_EVEN:
	mov 	acc.0, C		; set parity bit
	LCALL	_PRTLB_T1LD		; LOAD UP COUNT AGAIN (parity bit)
	JNB	TF1, $			; WAIT TIL TIMER READY (0-2 cycles)

_NOPAR:					; 1st stop bit
	setb	acc.0
	LCALL	_PRTLB_T1LD		; LOAD UP COUNT AGAIN (1st stop bit)
	JNB	TF1, $			; WAIT TIL TIMER READY (0-2 cycles)


	jnb	B.0, _PLBCMX		; 2nd stop bit?
	LCALL	_PRTLB_T1LD		; LOAD UP COUNT AGAIN (2nd stop bit)
	JNB	TF1, $			; 2nd stop bit

	;
	; A single stop bit is done, so we could enable interrupts here
	; Note that B52 print# outputs 2 stop bits.
	;
	; bab/wsk 10/21/90 
	;
	; In future:
	;
	; add a discrete stop bit here and enable interrupts somehow, so that
	; we can handle a RTC interrupt and serial port int such as control-c
	;

_PLBCMX:
	mov 	A, R4			; data char back in acc in case of rep_char
	RET				; EXIT SUBROUTINE

_PRTLB_T1LD:

	push	acc			; save the byte to output

	MOV	A, _TREL1L		; timer 1 reload LSB (2) 

	anl	TCON, #3Fh		; stop timer 1 and clear timer 1 overflow flag 
	
	add	A, TL1			; cycles = 1
	mov 	TL1, A			; cycles = 2

	MOV	A, _TREL1H		; timer 1 reload MSB (2) [cycles=3]
	addc	A, TH1			; cycles = 4
	mov 	TH1, A			; cycles = 5
	
	pop	acc			; restore the data byte, cycles = 7

	rrc	A			; move lsb into C	*** add 1 cycle  cycles=8
					; ** Next instr is the bit transition! **
	MOV	LP, C			; OUTPUT THE DATA (2) [cycles=10]

	SETB	TR1			; START IT NOW (1) [cycles=11]
					; now the counter is running so the cycle width
					; of the bit cell is counter-timed, not 
					; instruction - timed.	
					; Due to TF1 test vagaries, the time is within
					; +/- 2 cycles, or is it +/- 1?
					; Better to be slightly fast than slow
					; for serial ports.
					;
	rlc	A			; restore acc and C as it was

	RET				; EXIT SUBROUTINE [cycles=0]

;_%%PAT:


_INIT_PAT:
	clr	_UPRT_FLAG		; clear print@ flag
	mov	_UPHEAD, #1		; initialize user print head to col 1
	ret




_PAT_TI:
	clr	TI			; clear it
	ret				; no action, return to int23 handler



_PRINT_AT:



	push	IE					; save IE
	clr	ES					; be sure serial interrupts are off
	clr 	EX1					; turn off EX1 also

	mov 	P0, A					; write char in acc to P0
	SETB	P1.4					; set R/S high for data
	CLR 	P1.5					; set WR low
	CLR	P1.6					; clear enable
	SETB	P1.6					; strobe it
	CLR	P1.6					; clear enable

_LCD_BSY:
	mov	P0, #0FFH				; make P0 input
	CLR	P1.4					; set R/S low
	SETB 	P1.5					; set RD/WR high
	SETB	P1.6					; strobe it w/ high enable
	JB	P0.7, $					; wait while busy
	CLR	P1.6					; clear enable

	pop 	IE					;
	
	ret



_STR_ASN:
	mov	DPL, R1		; address of source in DPTR
	mov	DPH, R3

  IF DS5000 EQ 0
	mov	P2, R2		; setup the output port
  ENDIF

_STR_ASN_1:
	clr	A
	movc	A, @A + DPTR	; get the byte from code space

  IF DS5000 GT 0
	push	DPL		; push source addr
	push	DPH
	mov	DPL, R0		; dest addr in DPTR
	mov	DPH, R2
	movx	@DPTR, A	; store the byte in external data space
  ELSE
	movx	@R0, A		; store the byte in external data space
  ENDIF
  
	jz	_STR_ASN_X	; if byte is NULL we're done
	djnz	R4, _STR_ASN_2	; decr remaining allocated size
				; if here, we ran out of dest space
	clr	A		; should have stored a null but didn't
  IF DS5000 GT 0
	movx	@DPTR, A	; store the byte in external data space
  ELSE
	movx	@R0, A		; store the null term over the last byte
  ENDIF

  IF DS5000 GT 0
  	dec	SP		; pop off the stored source addr
	dec	SP		; to keep the SP correct
  ENDIF
	ljmp	_ARRAY_ERR2 	; we're done, jump to err handler

_STR_ASN_2:
  IF DS5000 GT 0
	inc	DPTR		; increment the destination pointer
	mov	R0, DPL		; increment the source address
	mov	R2, DPH
	pop	DPH
	pop	DPL
	inc	DPTR
  ELSE
	inc	DPTR		; increment the source pointer
	mov	A, R0		; increment the destination address
	add	A, #1
	mov	R0, A	  	; save new value
	jnc	_STR_ASN_1	; no carry do next byte
	inc	P2		; propagate the carry
  ENDIF
	sjmp	_STR_ASN_1	; do the next byte

_STR_ASN_X:
  IF DS5000 GT 0
  	dec	SP		; pop off the stored source addr
	dec	SP		; to keep the SP correct
  ENDIF
	ret			; done
;_%%ARRAY_ERRS:

_ARRAY_ERR1:			; array index greater than array dimension
  IF  ERR_MSG 
	mov	DPTR, #_str_arr_ind
  ENDIF
	mov A, #ARRAY_INDEX	; the errval value
 	ljmp	_ERR_HAND

_ARRAY_ERR2:			; String exceeded allocated space, was truncated
  IF  ERR_MSG 
	mov	DPTR, #_str_trunc
  ENDIF
	mov A, #STRING_TRUNC	; the errval value
 	ljmp	_ERR_HAND
_PRINT:					; print from external memory

_PRINTC:			   	; console print routine begins here

_PRINT1:
	movx	A, @DPTR		; get the byte to be printed (1)
	jz	 _PRINT2		; if null terminator is present we're done (2)
	lcall	_PUTC			; put the character	(3)
	inc	 DPTR			; point to the next character (1)
	sjmp	_PRINT1			; do another (3)

_PRINT2:
    IF (CPRINT * PRINT_COMPLETE)
    	jb _CPRT_FLAG, $		; wait til buffer empty
    ENDIF
  ret					; done

_UILT:
	lcall	_UI_RELOP_TEST
	ljmp	_LT_COM

_RO_COM:
_NEQ_COM:
	cpl		F0				; compliment F0 so we can share _EQ_COM

_EQ_COM:
	mov		C, F0
	sjmp	_RO_COM_1
	
_GT_COM:
	cpl		C
	
_LT_COM:
	anl		C, /F0
	sjmp	_RO_COM_1


_GE_COM:
	cpl		C

_LE_COM:
	orl		C, F0				

_RO_COM_1:
	jc		_RO_COM_2			; carry == 1 then OPREG0 < OPREG1
	ljmp	_RET_ZERO			; 

_RO_COM_2:
	ljmp	_RET_65K			; 

_UI_RELOP_TEST:
	clr	F0
	mov	A, R2
	cjne	A, _OPREG_1H, _URT_X	; compare the high bytes: jump if not equal

_UC_RELOP_TEST:				; entry point for character compares
	clr	F0
	mov	A, R0			; high bytes equal compare low bytes
	cjne	A, _OPREG_1L, _URT_X	; compare the low bytes: jump if not equal
	setb	F0			; F0 == 1 then:  OPREG0 == OPREG1
					; carry == 1 then:  OPREG0 < OPREG1
_URT_X:					; else: OPREG0 > OPREG1
	ret				; done 
	
_RET_ZERO:
	clr		A				; the ZERO
	mov		R0, A			; put the ZERO in OPREG0
	mov		R2, A
	ret						; returns to the routine that called the compare
	
_RET_65K:
	mov		R0, #0FFh		; put the 65535 in OPREG0
	mov		R2, #0FFh
	ret						; returns to the routine that called the compare
	
_UIADD:
	setb	F0			; this means we're doing unsigned adds
	sjmp	_IADD_1		; now go do it

_IADD:
	clr		F0			; this means we're doing signed adds

_IADD_1:
	clr		C			; setup
	mov		A, R0		; add the low order bytes
	add		A, R1
	mov		R0, A		; save the result
	mov		A, R2		; add the high order bytes and propogate the carry
	addc	A, R3
	mov		R2, A		; save the result
	jbc		F0, _IADD_2	; skip next if we're doing unsigned adds
	mov		C, OV		; get overflow status of signed addition
	clr		OV

_IADD_2:
	jnc		_IADD_X
	ljmp	_MATH_OVER		

_IADD_X:
	ret

_CHR_GET:
	movx	A, @DPTR	; get the byte
	mov	R0, A		; put it in OPREG0
	mov	R2, #0		; clr the high byte
	ret			; done

_INEQ:
	lcall	_UI_RELOP_TEST		; unsigend test is faster than signed test
	ljmp	_NEQ_COM
	
_ILT:
	lcall	_SI_RELOP_TEST
	ljmp	_LT_COM

_SI_RELOP_TEST:
	clr		F0
	mov		A, R3				; get OPREG1 sign
	rlc		A
	mov		A, R2				; get OPREG0 sign
	lcall	_OP_SIGNS			; adjust for the jump table
	mov		DPTR, #_SRT_1		; get the address of the jump table
	jmp		@A+DPTR				; jump from jump table
	
_SRT_1:
	sjmp	_SRT_2				; both values are positive
	setb	C					; OPREG0 negative, OPREG1 positive
	ret
	ret							; OPREG0 positive, OPREG1 negative
	nop							; occupy space

_SRT_4:							; both values are negative
	mov		A, R2				; swap the OPREGs then compare as unsigned
	xch		A, R3				; R2 to R3
	mov		R2, A				; R3 to R2
	mov		A, R0				; swap low bytes
	xch		A, R1				; R0 to R1
	mov		R0, A				; R1 to R0
	lcall	_UI_RELOP_TEST		; do the compare
	jb		F0, $+4				; convert the result if OPREG0 != OPREG1
	cpl		C					;
	ret
	
_SRT_2:							; both values are positive
	lcall	_UI_RELOP_TEST		; do the compare
	ret
	
_OP_SIGNS:
	rlc	A					; one sign in ACC.0, the other in carrry
	rlc	A					; 0 - 3 (ACC.1 & ACC.0)
	rlc	A					; 0, 2, 4, 6 (ACC.2 and ACC.1)
	clr	C
	anl	A, #6				; clear all remaining bits
	ret							; done

_STEP_SI:
	clr		C
	inc		DPTR				; point to high byte
	movx	A, @DPTR			; get high byte
	rlc		A					; carry set if sign bit was set
	jc		_STEP_SIN
	ljmp	_ILE

_STEP_SIN:
	ljmp	_IGE

_IGE:
	lcall	_SI_RELOP_TEST
	ljmp	_GE_COM

_ILE:
	lcall	_SI_RELOP_TEST
	ljmp	_LE_COM

_TIME_GET:
	mov	A, _RTC_SEC_HI			; high byte into accumulator
	mov	R0, _RTC_SEC_LO			; low byte into OPREG0
	cjne	A, _RTC_SEC_HI, _TIME_GET	; validate, repeat if upper byte changed
	mov	R2, A				; save final value
	ret					; done

_UIEQ:
	lcall	_UI_RELOP_TEST
	ljmp	_EQ_COM

_UIGT:
	lcall	_UI_RELOP_TEST
	ljmp	_GT_COM

_IOR:
	mov		A, R0	; low byte of OPREG0
	orl		A, R1	; OPREG0L .OR. OPREG1L
	mov		R0, A	; save the result
	mov		A, R2	; high byte of OPREG0
	orl		A, R3	; OPREG0H .OR. OPREG1H
	mov		R2, A	; save the result
	ret

_IEQ:
	lcall	_SI_RELOP_TEST
	ljmp	_EQ_COM

_UISUB:
	setb	F0			; this means we're doing unsigned subtracts
	sjmp	_ISUB_1		; now go do it

_ISUB:
	clr		F0			; this means we're doing signed subtracts

_ISUB_1:
	clr		C
	mov		A, R0
	subb	A, R1		; subtract low bytes
	mov		R0, A		; save the result
	mov		A, R2		; subtract high bytes with borrow from first subtract
	subb	A, R3		;
	mov		R2, A		; save the result
	jbc		F0, _ISUB_2	; skip next if we're doing unsigned subtracts
	mov		C, OV		; get overflow status
	clr		OV

_ISUB_2:
	jnc		_ISUB_X
	ljmp	_MATH_OVER		

_ISUB_X:
	ret
		
_IGT:
	lcall	_SI_RELOP_TEST
	ljmp	_GT_COM

_RETI_BAS:

	pop	_R7
	pop	_R6
	pop	_R5
	pop	_R4
	pop	_R3
	pop	_R2
	pop	_R1
	pop	_R0
	pop	B
	pop	ACC

	pop	PSW	    		; get the F0 = ONTIME in progress flag
	jb F0, _RETI_ONTIME

_RETI_ONEX1:
	pop	DPH
	pop	DPL
	pop	PSW
	clr	_ON_EX1_INP		; not ontime, so was an onex1
	reti				; note is a reti for onex1

_RETI_ONTIME:
	pop	DPH
	pop	DPL
	pop	PSW
	clr _ON_TIME_INP		; clear ontime in process
	ret	  			; note not a reti for ontime
	
_PH0:
	setb	F0			; leading zeros supression bit
	sjmp	_PH1A

_PH1:
	clr    	F0			; print even zero digits

_PH1A:
	mov	DPH, R3			; point to destination address
	mov	DPL, R1
	
_PHX_1:
	mov	A, R2			; get the high byte
	swap	A			; exchange the nibbles to print high nibble
	lcall	_PHX_2			;
	mov	A, R2			; get the high byte again
	lcall	_PHX_2			;
	clr	F0			; must print all other nibbles even if zero
	mov	A, R0			; get the low byte
	swap	A			; exchange the nibbles to print high nibble
	lcall	_PHX_2			;
	mov	A, R0			; get the low byte again
	lcall	_PHX_2			;
	mov	A, #'H'			; hexadecimal indicator
	movx	@DPTR, A		; save it
	inc	DPTR
	clr	A			; null terminator
	movx	@DPTR, A		; save it
	ret

_PHX_2:
	anl	A, #0FH			; mask the upper nibble
	jnb	F0, $+7			; in zero suppression mode?
	jz	_PHX_3			; yes exit if zero
	clr	F0			; clear the zero suppression flag
	add	A, #90H			; 90H to 9FH
	da	A			; 90H to 99H, 00H to 05H + carry
	addc	A, #40H			; 0D0H to 0D9H +carry, 41H to 46H
	da	A			; 30H to 39H, 41 to 46H == '0' to '9', 'A' to 'F'
	movx	@DPTR, A		; save it
	inc	DPTR			; point to next location
	
_PHX_3:
	ret

_CHR_PUT:
	mov	A, R0		; get the byte in the accumulator
	movx	@DPTR, A	; put the byte
	ret			; done

;_%%DS1215:


_DS5_ECC_RD:
	push	IE			; save interrupt status
	anl	IE, #82H		; leave EA and ET0 for RTC

	lcall	_DS5_ECC_CLR		; reset ECC pointer
	lcall	_DS5_ECC_KEY		; apply key to ECC for use

	mov	B, #8			; byte count
	mov	DPTR, #_DS_HSEC		; first storage location

_DS5_ECC_RD1:
	lcall	_DS5_ECC_RB		; read an ECC byte to acc

	movx	@DPTR, A		; save acc value
	inc	DPTR			; next location
	djnz	B, _DS5_ECC_RD1		; do it 8 times
					; now we've read "raw" bcd ecc time

_DS5_ECC_RHR:				; now adj hours, set ampm, mode
	mov	DPTR, #_DS_HOUR		;
	movx	A, @DPTR		; get hours BCD
	mov	R0, A			; copy hrs BCD to R0
	mov	DPTR, #_DS_ECC_MODE	; MODE location
	jb	ACC.7, _DS5_ECC_RD12	; acc.7=1 is 12 hour mode
	mov	A, #24
	movx	@DPTR, A		; mode=24
	mov	DPTR, #_DS_AMPM
	mov	A, R0			; get BCD hrs again
	lcall	_BCD_TO_HEX		; hex hrs in acc
	cjne	A, #12, $+3		; c set if hrs<12, 0 if hrs>=12
	clr	A
	cpl	C
	mov	ACC.0, C   		; acc=1 if hrs>=12
	movx	@DPTR, A		; ampm = 1 if hrs>=12
	sjmp	_DS5_ECC_RHRX		; done with hours

_DS5_ECC_RD12:
	mov	A, #12
	movx	@DPTR, A       		; mode = 12
	mov	DPTR, #_DS_AMPM
	mov	A, R0			; get bcd hrs again
	mov	C, ACC.5		; A/P bit to C
	clr	A			; acc=0
	mov	ACC.0, C		; acc now = a/p bit
	movx	@DPTR, A       		; store ampm

	anl	_R0, #1FH		; mask off upper 3 bits in hrs reg
	mov	A, R0			; get masked BCD hrs again
	mov	DPTR, #_DS_HOUR		;
	movx	@DPTR, A       		; store bcd hrs w/o mode bits
_DS5_ECC_RHRX:

_DS5_ECC_RRUN:				; check run bit, set ecc_run variable
	mov	DPTR, #_DS_DAY		;
	movx	A, @DPTR		; get day BCD
	mov	C, ACC.5		; dallas /OSC bit 0 if running
	mov	R0, A			; copy bcd day into R0
	clr	A
	cpl	C
	mov	ACC.0, C		; A=1 if running (/osc = 0)
	xch	A, R0			; _RUN in R0, bcd day in acc
	anl	A, #7			; mask off osc bit from day
	movx	@DPTR, A       		; store day w/o osc bit
	xch	A, R0			; _RUN back in acc
	mov	DPTR, #_DS_ECC_RUN
	movx	@DPTR, A       		; store run value

_DS5_ECC_BH:				; convert bcd time to binary
	mov	B, #8			; byte count
	mov	DPTR, #_DS_HSEC		; first storage location
_DS5_ECC_BH1:
	movx	A, @DPTR		; get BCD value in acc
	lcall	_BCD_TO_HEX		; bcd in acc to binary in acc
	movx	@DPTR, A		; save acc value
	inc	DPTR			; next location
	djnz	B, _DS5_ECC_BH1		; do it 8 times

	pop	IE			; restore interrupts
	ret


_DS5_ECC_WR:

_DS5_ECC_HB:				; convert hex(binary) time to bcd
	mov	B, #8			; byte count
	mov	DPTR, #_DS_HSEC		; first storage location
_DS5_ECC_HB1:
	movx	A, @DPTR		; get BCD value in acc
	lcall	_HEX_TO_BCD		; binary in acc to hex in acc
	movx	@DPTR, A		; save acc value
	inc	DPTR			; next location
	djnz	B, _DS5_ECC_HB1		; do it 8 times, B is 0 when done

_DS5_ECC_WHR:				; now adj hours, set ampm, mode
	mov	DPTR, #_DS_ECC_MODE	;
	movx	A, @DPTR		; get 12/24 in acc
	cjne	A, #13, $+3		; c set if mode<13, 0 if >=13
	jnc	_DS5_ECC_WHR24		; jump if 24 hour mode
_DS5_ECC_WHR12:				; set up 12 hour mode, C=1
	mov	DPTR, #_DS_AMPM		;
	movx	A, @DPTR		; get 0/1 in acc, 0=AM, else=PM
	jz	_DS5_ECC_WHRA		; jump if AM
					; if here, is PM in 12-hour mode
	setb	B.5			; set PM bit
_DS5_ECC_WHRA:				; if here, AM, acc already clear
	mov	B.7, C			; set 12 hour mode bit
					; B now has mode bits set
_DS5_ECC_WHR24:				; if 24 hour mode, B is zero
	mov	DPTR, #_DS_HOUR		;
	movx	A, @DPTR		; get bcd hrs in acc
	orl	A, B			; 0 iff 24 hr, mode&ampm if 12 hr
	movx	@DPTR, A		; save adjusted bcd hrs
_DS5_ECC_WHRX:				; done with hours adj

_DS5_ECC_WRUN:				; check run bit, set ecc flag
	mov	DPTR, #_DS_ECC_RUN	;
	movx	A, @DPTR		; get 0/1 in acc, 0=stop, else=run
	setb	C			; C = 1
	jz	_DS5_ECC_WSTP		; jump if acc=0 for stop
	clr	C			; else C=0 if run
_DS5_ECC_WSTP:				; here C=1 if stop
	mov	DPTR, #_DS_DAY		;
	movx	A, @DPTR		; bcd day in acc
	mov	ACC.5, C		; set if stop
	movx	@DPTR, A		; save adjusted bcd day
	

_DS5_ECC_WR1:				; ...now go do the ecc write
	push	IE			; save interrupt status
	anl	IE, #82H		; leave EA and ET0 for RTC

	lcall	_DS5_ECC_CLR		; reset ECC pointer
	lcall	_DS5_ECC_KEY		; apply key to ECC for use

	mov	B, #8			; byte count
	mov	DPTR, #_DS_HSEC		; first storage location

_DS5_ECC_WR2:				; 
	movx	A, @DPTR		; bcd data in acc
	lcall	_DS5_ECC_WB		; write acc byte to an ECC byte
	inc	DPTR			; next location
	djnz	B, _DS5_ECC_WR2		; do it 8 times

	lcall	_DS5_ECC_RD		; update ecc variables
	pop	IE			; restore interrupts
	ret



_BCD_TO_HEX:
	push	B

	mov 	R0, A			; copy acc
	anl	A, #0F0H 		; clear low nibble
	swap	A			; high nibble now in low place
	mov 	B, #10			; mul old high nibble by 10
	mul	AB			; old high nib * 10 in acc
	mov	B,A			; partial result to B
	xch	A, R0			; old byte back in acc
	anl	A, #00FH 		; mask off old high nibble
	add	A, B			; add old low nibble to acc

	pop	B
	ret




_HEX_TO_BCD:
	push	B

	mov	B, #10
	div	AB		; acc = acc /10, B = acc rem 10
	swap	A
	add	A,B

	pop	B
	ret



_DS5_ECC_CLR:
	mov	B, #09H
_DS5_ECC_CLR1:
	lcall	_DS5_ECC_RB		; read an ECC byte
	djnz	B, _DS5_ECC_CLR1	; do 9 of them
	ret



_DS5_ECC_RB:
	push	DPL
	push	DPH
	push	B
	push	MCON
	orl	MCON, #04H		; set ECE2 bit

	mov	DPH, #0
	mov	DPL, #04H		; set bit 2 of addr 
	mov 	B, #08H			; bit count

_DS5_ECC_RB1:
	push	ACC
	movx	A, @DPTR		; get bit
	rlc	A			; move bit to carry
	pop	ACC			; get byte value so far
	rrc	A			; move bit into acc
	djnz	B, _DS5_ECC_RB1		; loop for 8 bits

	pop	MCON			; restore MCON, ECE2 off
	pop	B
	pop	DPH
	pop	DPL
	ret
	



_DS5_ECC_KEY:
	mov 	B, #04H
	mov	A, #0C5H

_DS5_ECC_KEY1:
	lcall	_DS5_ECC_WB		; write a byte
	xrl	A, #0FFH		; exor it
	lcall	_DS5_ECC_WB		; write a byte
	swap	A			; change pattern
	djnz	B, _DS5_ECC_KEY1	; write total of 4x2 = 8 bytes
	ret




_DS5_ECC_WB:

	push	DPL
	push	DPH
	push	B
	push	MCON
	orl	MCON, #04H		; set ECE2 bit

	mov	DPH, #0
	mov 	B, #08H			; bit count

_DS5_ECC_WB1:
	push	ACC			; save data byte in acc
	anl	A, #1			; acc.0 is the data bit, others=0
	mov	DPL, A			; now DPL is the address & data
	movx	A, @DPTR		; output data/addr via DPL on P0
	pop	ACC			; get back data byte
	rr	A			; next data bit in position
	djnz	B, _DS5_ECC_WB1		; do for 8 bits

	pop	MCON
	pop	B
	pop	DPH
	pop	DPL
	ret

_UCTOA:
	mov	DPL, R1		; point to the destination
	mov	DPH, R3
	mov	R2,	 #0		; insure 0 for msb for BTOA
	lcall	_BTOA	; do the conversion.
	ret

_BTOA:
	clr	C
	mov	A, R0		; is the value zero?
	orl	A, R2
	jnz	_BTOA_1		; jump if it isn't
	
	push	ACC		; save it
	mov	R4, #1		; set the counter
	sjmp	_BTOA_3

_BTOA_1:
	mov	R4, #0		; zero the counter

_BTOA_2:
	mov	R1, #0Ah	; divisor
	lcall	_NDIV		; divide by 10
	push	_R1		; save the result
	inc	R4		; count it
	mov	A, R0		; are we done
	orl	A, R2
	jnz	_BTOA_2

_BTOA_3:
	mov	R1, #'0'	; the ASCII bias (30h)
	
_BTOA_4:
	pop	ACC		; get the ms digit
	add	A, R1		; convert to ASCII
	movx	@DPTR, A	; save it
	inc	DPTR
	djnz	R4, _BTOA_4	; are we done?
	
	clr	A		; the null terminator
	movx	@DPTR, A	; save it
_BTOA_OUT:
	ret

_NDIV:
	mov		R7, _R2			; move dividend into R7:R6
	mov		R6, _R0
	

	mov		R3, _R1			; store nibble divisor
	mov		R0, #_R7		; point to MS byte of dividend and eventual result
	mov		R1, #_R2		; R1 now a pointer to R2 so we can use nibble XCHD
	mov		A, R7			; get MS byte of dividend
	mov		B, R3			; put nibble divisor in B
	div		AB				; do the first division
	mov		R2, B			; move remainder to R2 so we can use XCHD in loop
	mov		R7, A			; MS byte now done, store in dividend/result
	dec		R0				; bump pointer to next MS byte
	
	mov		A, @R0			; get next byte of dividend in ACC
	xchd	A, @R1			; put remainder stored in R2 in LOW nibble of ACC
	swap	A				; mow remainder is in high nibble of ACC and next
							; MS nibble of dividendis in LOW nibble
	mov		B, R3			; divide again by divisor nibble
	div		AB
	mov		R2, B			; save remainder in R2
	swap	A				; put nibble result in high nibble and store in 
	xch		A, @R0			; DIVIDEND/RESULT while retrieving original
							; dividend byte (low nibble)
	swap	A				; LS nibble of dividend to hi nibble of ACC
	xchd	A, @R1			; remainder to low nibble of ACC
	swap	A				; swap remainder to high nibble for next divide
	mov		B, R3			; divide again by divisor nibble
	div		AB
	mov		R2, B			; save remainder in R2
	xchd	A, @R0			; store lo nibble result this byte in DIVIDEND/RESULT
	

	mov		R0, _R6			; return the results in OPREG0
	mov		R2, _R7
	mov		R1, B			; and the remainder from last divide in OPREG1
	ret
	
_ITOA:
	mov	DPL, R1		; point to the destination
	mov	DPH, R3

	mov	A, R2			; get the MSByte
	jnb	ACC.7, _ITOA_1		; test to see if the number is negative
	lcall	_I_TWOS_COMP_0		; do two's complement (in coerce.src)
	mov	A, #'-'			; minus sign
	movx	@DPTR, A		; save the sign
	inc	DPTR			; advance the pointer

_ITOA_1:
	lcall	_BTOA			; do the conversion
	ret

_I_TWOS_COMP_0:
	clr		A			; setup
	clr		C
	subb	A, R0		; convert LSByte
	mov		R0, A		; save it
	clr		A			; setup
	subb	A, R2		; convert MSByte
	mov		R2, A		; save it
	clr		C
	ret					; done

_CNOT:
	mov		A, R0	; low byte of OPREG0
	cpl		A		; .NOT. OPREG0L
	mov		R0, A	; save the result
	ret

_IAND:
	mov		A, R0	; low byte of OPREG0
	anl		A, R1	; OPREG0L .AND. OPREG1L
	mov		R0, A	; save the result
	mov		A, R2	; high byte of OPREG0
	anl		A, R3	; OPREG0H .AND. OPREG1H
	mov		R2, A	; save the result
	ret

_CXOR:
	mov		A, R0	; low byte of OPREG0
	xrl		A, R1	; OPREG0L .XOR. OPREG1L
	mov		R0, A	; save the result
	ret

_end_module:		;end of this compiled module
	clr	_ON_TIME		;clear ONTIME flag
	lcall	_PRINT_DONE		;wait until print buffer empty
_END_AND_HALT:

	sjmp	$	

_ISTACK_CHECK:
	mov	A, #SPUSE		; max stack space we will use
	clr	C			; don't want to subtract the C
    IF ONEX1
    	jnb	_ON_EX1_INP, _CHK_ONEX1X	; not in handler -> jump
    	subb	A, #SPUSE_ONEX1		; we are, don't count its stack use
_CHK_ONEX1X:
    ENDIF

    IF ONTIME
    	jnb	_ON_TIME_INP, _CHK_ONTIMEX	; not in handler -> jump
    	subb	A, #SPUSE_ONTIME	; we are, don't count its stack use
_CHK_ONTIMEX:
    ENDIF
	mov	B, A			; save adjusted usage in B reg

	mov	A, SP
	cjne	A, _SPCLEAR, _ISTK_CHK2	; C set if SP < SPCLEAR

_ISTK_CHK2:
	jc	_ISTK_CHK_ERR		; SP < SPCLEAR is error, else...
					; ...SP >= SPCLEAR, so it's OK
	mov	A, #SPMAX		; SP upper limit (7FH or FFH)
	cpl	A			; now 00H for '32 or 80H for '31
	add	A, SP			; add current value
					; overflow not possible yet
	jc	_ISTK_CHK_ERR		; if overflowed, error
	add	A, B			; add most we'll need
	jc	_ISTK_CHK_ERR		; if overflowed, error
_ISTK_CHK_X:
	ret				; else OK so return

_ISTK_CHK_ERR:
	mov	SP, _SPCLEAR		; clear SP so we don't crash
	ljmp	_ISTACK_ERR2		; handle the error

_ISTACK_ERR2:			; Istack over or underflow 
	IF  ERR_MSG 
		mov		DPTR, #_istk_err_msg
	ENDIF
		mov A, #ISTACK_ERR		; the errval value
	 	ljmp	_ERR_HAND
_ERR_PRINT:

  IF CONSOLE_TIMER EQ 1
_ERR_PRINT2:	
  ENDIF
	push DPL			; save ptr to specific err msg
	push DPH
 	lcall _PUT_NEW_LINE
	mov DPTR, #_com_msg1
	lcall _PRINT_ROM		; output it
  IF PROGLINE
	lcall _ERR_LINE_PRT		; output failing line number 
  ENDIF
	pop DPH				; get ptr to specific err msg
	pop DPL
	lcall _PRINT_ROM		; output specific err msg
 	lcall _PUT_NEW_LINE



  IF CONSOLE_TIMER EQ 1
  ENDIF

_ERR_PRINTX:
	ret
_ERR_LINE_PRT:
  IF PROGLINE
	mov DPTR, #_com_msg2
	lcall _PRINT_ROM		; output '(LINE '
	mov DPTR, #_ERRLINE
	lcall _INT_GET			; errline in opreg0
	mov DPTR, #_pbuffer
	mov R1, DPL
	mov R3, DPH
	lcall _BTOA			; opreg0 convert to ascii
	mov DPTR, #_pbuffer
	lcall _PRINT 			; output line number
	mov DPTR, #_com_msg3
	lcall _PRINT_ROM		; output '): '
	ret
  ENDIF
_INT_GET:
	movx	A, @DPTR	; get the low byte
	mov	R0, A		; put it in OPREG0
	inc	DPTR
	movx	A, @DPTR	; get the high byte
	mov	R2, A		; put it in OPREG0
	ret			; done

_INT_PUT:
	mov	A, R0		; get the low byte in the accumulator
	movx	@DPTR, A	; put the byte
 	inc	DPTR		; point to high byte
	mov	A, R2		; get the high byte in the accumulator
	movx	@DPTR, A	; put the byte
	ret			; done

_ERR_HAND:
    IF CHECK_MATH EQ 0
				; if not math checking, we ignore math errors
	cjne A, #40, $+3  	; was it a math error (C set iff val <40)?
	jnc $+3			; no, so proceed to handle it
	ret			; yes, do nothing and return 
    ENDIF
	push ACC		; push errval to save it
    IF PROGLINE
	push _R0		; push any math error value
	push _R2
	push ACC		; push errval to save it (again)
	push DPL		; save specific error message ptr
	push DPH
	mov DPTR, #_BASLINE	; update errline value
	lcall _INT_GET		; current line # in opreg0 (acc gets wasted)
	mov DPTR, #_ERRLINE
	lcall _INT_PUT		; save it in errline location
	pop DPH			; retrieve specific err msg ptr
	pop DPL
	pop ACC			; errval back in acc
    ENDIF

    IF ERR_MSG			; print message to console?
    	IF CHECK_MATH EQ 0
					; if not math checking, we ignore math errors
		cjne A, #40, $+3  	; was it a math error (C set iff val <40)?
		jc _ERR_HAND_MSGX  	; yes, jump past print
	ENDIF
	lcall _ERR_PRINT
	jb _CPRT_FLAG, $ 	; finish any printing
_ERR_HAND_MSGX:
    ENDIF

    IF PROGLINE
	pop _R2	 		; pop math error value back
	pop _R0	 		; in case we return
    ENDIF

	pop ACC			; pop errval back
	
  	mov DPTR, #_ERRVAL 	; update ERRVAL regardless of onerr
	movx @DPTR, A	   	; store ERRVAL

    IF ONERR				; save errval and jump to onerr code
  	jnb _ON_ERR, _ERR_ONERRX	; jump ahead if onerr inactive
	    IF CHECK_MATH EQ 0
					; if not math checking, we ignore math errors
 	   	cjne A, #40, $+3 	; was it a math error (C set iff val <40)?
	    	jc _ERR_ONERRX	 	; yes, jump past dispatcher
	    ENDIF
    	ljmp _ONERR_DISPATCH	; else jump to onerr handler, never to return
_ERR_ONERRX:
	ENDIF

	;
	; If here, onerr not active, run trap may be
	;

  IF (RUN_TRAP_LOC + RUN_TRAP_B52) EQ 0	; no run trap? so return or hang
	;
	; No run trap, so we can either hang or stagger on by returning
	; We test for certain errors on which to allow return
	;
	cjne A, #STRING_TRUNC, $+4	; was the error a string truncation?
	ret		; yes, return
    IF CHECK_MATH EQ 0
    	; if not math checking, we allow return on these errors
    	cjne A, #40, $+3		; was it a math error (C set iff val <40)?
    	jnc $+3				; no, jump to next test
    	ret				; yes, math error, so return
    ENDIF
    	cjne A, #MEM_ACC_B52, _ERR_HANG	; B52 istack or mtop conflict?
    	ret				; yes, return to whatever called it
_ERR_HANG:
	; Close any open interrupts
	;
	jnb _ON_EX1_INP, _ERR_HANG_2	; was onex1 in progress?
	jnb _ON_EX1_PND, _ERR_HANG_2	; was onex1 pending?
	mov DPTR, #_ERR_HANG_2	 	; if here, onex1 was in progress
	PUSH   DPL
	PUSH   DPH
	RETI   				; exit onex1 interrupt, pop PC to the DPTR value  
_ERR_HANG_2:
	clr	EA			; disable all interrupts
	sjmp 	$		 	; stay here forever or until wdog timeout
  ENDIF

  	;
  	; If here, one of the run traps is active
	; Close any open interrupts
	;
	clr	EA
	jnb _ON_EX1_INP, _ERR_HAND_2	; was onex1 in progress?
	jnb _ON_EX1_PND, _ERR_HAND_2	; was onex1 pending?
	mov DPTR, #_ERR_HAND_2		; if here, onex1 was in progress
	PUSH   DPL
	PUSH   DPH
	RETI   			; exit onex1 interrupt, pop PC to the DPTR value  

	;
	; Compiler only allows one of the run trap options active
	; If B52, local runtrap is placed differently than non-B52 case
	;
_ERR_HAND_2:
    IF (RUN_TRAP_LOC + RUN_TRAP_B52)
      IF (DS5000 + TARGET_8XC51F)
    	setb	F0		;
	mov	A, #0AAH	;
	mov	B, #055H	; This helps us detect a run trap at startup
      ENDIF
        IF RUN_TRAP_LOC		; ONERR not active, run trap in BCI51 code
     	mov SP, _SPCLEAR	; reset stack pointer
	ljmp _runtrap
	ELSE
     	ljmp _RET_B52		; return to B52, B52 assumed to run trap there
	ENDIF
    ENDIF

	clr	EA     		; disable all interrupts
    				; we can be here only due to runaway code since
				; run trap inactive was handled earlier, this
	sjmp $		 	; is here just as a precaution.

;_%%DALLAS_MSG:

	IF ERR_MSG

	ENDIF

_str0:	db	'LCD init',0
_str1:	db	'DPB2E DS5000/DS2250 family serial output test:',0
_str2:	db	'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+',0
_str3:	db	'DPB2E serial printer test:',0
_str4:	db	'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+',0
_str5:	db	'*  SYSTRONIX DPB2  *',0
_str6:	db	'THE FINEST UNIVERSAL',0
_str7:	db	' DALLAS DEVELOPMENT ',0
_str8:	db	'  SYSTEM AVAILABLE! ',0
_str9:	db	'ADC=        EXT=    ',0
_str10:	db	'KEY:        REL=    ',0
_str11:	db	'From SYSTRONIX: Universal DALLAS Development Board DPB2 revision E',0
_str12:	db	'Use any DS5000, DS2250, DS2251 or DS2252 Soft Microcontroller',0
_str13:	db	'1 Serial I/O port, 1 printer port, 4 Relay drivers, 8-bit ADC, Keypad and LCD Interfaces',0
_str14:	db	'NEW in revision E: four rugged digital inputs, ADC attenuator for larger input range,',0
_str15:	db	'Extensive ground plane for low emitted and received RF noise and static,',0
_str16:	db	'Convenient 8x2 header for all power and I/O connections, relay output enable, and more.',0
_str17:	db	'Plus POWERFUL, EASY-TO-USE BASIC development software!',0
_str18:	db	'Enclosures, keypads, LCDs and other accessories are also available.',0
_str19:	db	' ',0
_str20:	db	' ',0
_str21:	db	'>',0
_str22:	db	' ',0
_str23:	db	'0',0
_str24:	db	'-',0
_str25:	db	'0',0
_str26:	db	'-',0
_str27:	db	'  ',0
_str28:	db	'0',0
_str29:	db	':',0
_str30:	db	'0',0
_str31:	db	':',0
_str32:	db	'0',0
_str33:	db	' ',0
_str34:	db	'/',0
_str35:	db	'00',0
_str36:	db	'0',0
;_%%MATH_MSG:

	IF ERR_MSG
_mathdiv0_msg:	db	'Divide by Zero',0
_mathover_msg:	db	'Math Overflow',0
_mathunder_msg:	db	'Math Underflow',0
_mathbad_msg:	db	'Math Argument Bad',0
	ENDIF

;_%%ARRAY_MSG:
	IF (ERR_MSG)
_str_arr_ind:	db	'Array Index Too Big',0
_str_trunc:		db	'String Truncated',0
	ENDIF

;_%%DS5ECC_STR:

_DS5_DAY_TAB:	DB 'SunMonTueWedThuFriSat',0


_DS5_MON_TAB:	DB 'JanFebMarAprMayJunJulAugSepOctNovDec',0

;_%%ISTACK_MSG:

	IF ERR_MSG
_istk_b52_msg:	db	'Istack/B52 Conflict',0
_istk_err_msg:	db	'Istack Error',0
	ENDIF

;_%%RELOC_MSG:

	IF ERR_MSG
_RELOC_MSG:	db	'Vector relocation FAILED',0
	ENDIF

;_%%COM_MSG:

	IF ERR_MSG
_com_msg1: db 'ERROR ',0
_com_msg2: db '(Line ',0
_com_msg3: db '): ',0

_bad_start: db 'STARTUP/RESET',0
	ENDIF


_cdataend:	; code space ends here
	org		24576		;data segment org 6000H


_databeg:	;data variable clear starts here

_udatabeg:	; user data clear starts here

_fnstep11:	ds	2
_fnlimit11:	ds	2
_fnstep8:	ds	2
_fnlimit8:	ds	2
_fnstep6:	ds	2
_fnlimit6:	ds	2
_fnstep4:	ds	2
_fnlimit4:	ds	2
_fnstep2:	ds	2
_fnlimit2:	ds	2
__ADC_DAT:	ds	1
__RELAY_NUMBER:	ds	2
__RELAY_DAT:	ds	1
__RELAY_STATUS:	ds	1
__LCD_EM_STAT:	ds	1
__LCD_DISP_STAT:	ds	1
__LCD_YPOS:	ds	2
__LCD_XPOS:	ds	2
__LCD_DAT:	ds	1
__KEY_RAW:	ds	1
__KEY_DAT:	ds	1
__EXTINP:	ds	1
__START_TIME:	ds	2
__START_MSEC:	ds	2
__STR_LEN:	ds	2
__J:	ds	2
__I:	ds	2
__START_POS:	ds	2
__LCD_STR$:	ds	181
__X:	ds	2
__DELAY_TIME:	ds	2

_udataend:	; user data clear stops just prior to here

;_%%INT0B_DATA:

_INT_0B_LOC:	DS	2	; address of user's ONTIME routine (L:H)

;_%%INT23_DATA:
_FIFOBF:	DS	_FIFOLN	; GET and INT23 Buffer (number of 
				; typeahead keys we can remember)
_FIFOBE:	DS	1	; End of FIFOBF, MUST BE 1 FOR 1ST INC
_TALPTR:	DS	2	; Tail Pointer for input to _FIFOBF MSB:LSB
_HEDPTR:	DS	2	; Head Pointer for output from _FIFOBF

;_%%INPUT_DATA:

_INPBUF:	DS	_INPLEN	; Storage for the INPUT routine.
_INPBFE:	DS	2	; End of above Buffer, USED FOR NULL
_INPPTR:	DS	2	; Input Pointer for INPBUF

;_%%PRINT_DATA:

_OUTINP:	DS	2	; In Pointer
_OUTOTP:	DS	2	; Out Pointer



	IF _ALIGN

    IF (_ALIGN * (($ AND 0FF80h) NE (($ + _OUTLEN) AND 0FF80h)))
   	ORG	$ + (_OUTLEN - ($ + _OUTLEN) AND 007Fh)
    ENDIF

    	ENDIF

_OUTBUF:	DS	_OUTLEN	; Storage for OUTPUT buffer
_OUTBFE:	DS	1	; End of above Buffer

;_%%INT13_DATA:

_INT_13_LOC:	DS	2	; address of user's ONEX1 routine (L:H)

_pbuffer:	ds	8
;_%%DS1215_DATA:


_DS_HSEC:	DS	1
_DS_SEC:	DS	1
_DS_MIN:	DS	1
_DS_HOUR:	DS	1

_DS_DAY:	DS	1
_DS_DATE:	DS	1
_DS_MONTH:	DS	1
_DS_YEAR:	DS	1

_DS_AMPM:	DS	1			; iff 12 hr mode: 1=PM, 0=AM
_DS_ECC_MODE:	DS	1			; 12/24, 0 = 24 hr, non-0 = 12 hr
_DS_ECC_RUN:	DS	1			; 0 = run, non-0 = halt clock
_DS_AMPM$:	DS	3			; am/pm text string, 2 + null
_DS_DAY$:	DS	4			; day text string, 3 + null
_DS_MONTH$:	DS	4			; month text string, 3 + null

;_%%LINENUM_DATA:

_BASLINE:	DS	2	; address of current BASIC line number (stored L:H)
_ERRLINE:	DS	2	; address of BASIC line number with error (stored L:H)

;_%%ERRVAL_DATA:
	IF (BASIC52 + BEBASIC)
						; ERRVAL already assigned via EQUATE 
	ELSE
_ERRVAL:		DS	1	; Location of the Error value
	ENDIF

_dataend:	; data variable clear ends here

; End of assembly file
	END  _START_LOC
