;-----------------------------------------------------------------------------
; ADC DRIVER INCLUDE FILE FOR USE WITH DPB2 REV E
;
; will not work with DPB2 REV D!
;
; (C) Copyright 1994 Systronix, Inc All Rights Reserved
;		Systronix, Inc. Salt Lake City, Utah, USA
;		TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
;
; Owners of Systronix products are hereby entitled to use, modify, and copy
; this sample program.  You may incorporate all or part of this program in 
; your own commercial products provided they are not simply copies of 
; Systronix products and do not compete directly with Systronix products.  
; This program is provided by Systronix free of charge and may not be resold.
;
; This program is intended for those of you who have the pleasure of using 
; the new DPB2 REVE board from Systronix/Intellix.  This card is a very
; easy to use development system for the Dallas DS5000/1/2 DS2250/1/2 and -T
; suffix soft microcontrollers.  If you'd like more information, please call
; or FAX us at the numbers above.
;
;
; REVISION HISTORY -----------------------------------------------------------
;
;	03/02/94	BAB	Added new header, released in ZIP file
;
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
; TI TLC549 or 548 (we use the 549)  Same part, 549 is a little slower,
; 40,000 conversions/sec max versus 45,500 for the 548.  Max I/O clock
; rate on the 549 is 1.1 MHx, it is 2.048 MHz for the 548.
;
; ADC clock is P0.5		(was P1.2 on DPB2 REVD)
; ADC Data is on P0.4	(was P1.0 on DPB2 REVD)
; ADC CS is P1.0		(was P1.1 on DPB2 REVD)
;
; To start a conversion, drive CS (P1.0) low.  Wait at least 1.4 usec, then
; Bit7 of the previous ADC conversion will appear on P1.0.  Cycle ADC clock
; P0.5 and data bits 6-0 will appear on its falling edge.  Bit 7 wil reappear
; if you keep clocking past bit 0. The ADC takes a new data sample starting
; on the falling edge of the 4th I/O clock, and holds it on the 8th I/O clock 
; falling edge.  You must take CS high after the 8th clock, or keep the I/O
; clock low.  It is better to keep CS high.  If CS is low during the 
; conversion cycle, any glitches on the CLK line could potentially cause
; the I/O sequence to lose synchronization.  A high to low transition of
; CS during the conversion will abort it and cause an ADC reset.  An aborted
; conversion yields the result from the previous conversion, if you read
; out the data.
;
; During the new conversion, drive CS (P1.0) high for at least 17 usec.  The 
; ADC will convert using its internal clock.  Bring CS low again and the new
; conversion D7 will appear on the data line.  
; Clock the device 8 more times to complete the data transfer.  On the 8th
; clock, D7 appears again - ignore it.  This also starts the next conversion
; cycle.  Then bring CS high to allow the new conversion to complete.
;
;----------------------------------------------------------------------------

    goto adc_inc_end            ; protect against include in program body

    unsigned char ADC_DAT

REM READ the serial ADC value into ADC_DAT
adc_read:
    REM the assy code conversion loop
#ASM
    ; init first...
	setb    P0.4                ; make sure P0.4 is input
	clr	    P0.5                ; ADC clock low
	setb    P1.0                ; CS high

	clr	A                       ; clear acc
	
    ; start access...
	clr     P1.0                ; CS low
	mov     B,#8                ; also provides 2usec delay after CS low

adc1:
	mov	    C,P0.4              ; Data bit to carry
	setb    P0.5                ; clock high
	RLC	    A                   ; rotate carry into acc
	clr     P0.5                ; clock low for next bit
	djnz    B,adc1              ; repeat
				
    ; start next hold cyle
	setb    P1.0                ; set CS high for next conversion
	mov	    DPTR,#__ADC_DAT     ; addr in DPTR
	movx    @DPTR,A             ; store acc in ADC_DAT
#ASM_END
	; new conversion takes at least 17 usec
    return

adc_inc_end:                    ; protect against include in program body
